/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.script;

import io.xpipe.app.core.AppNames;
import io.xpipe.app.core.AppResources;
import io.xpipe.app.process.ShellDialects;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.ext.base.script.PredefinedScriptGroup;
import io.xpipe.ext.base.script.ScriptStore;
import io.xpipe.ext.base.script.SimpleScriptStore;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import lombok.Generated;

public enum PredefinedScriptStore {
    APT_UPDATE("Apt upgrade", () -> ((SimpleScriptStore.SimpleScriptStoreBuilder)((SimpleScriptStore.SimpleScriptStoreBuilder)((SimpleScriptStore.SimpleScriptStoreBuilder)((SimpleScriptStore.SimpleScriptStoreBuilder)((SimpleScriptStore.SimpleScriptStoreBuilder)SimpleScriptStore.builder().group(PredefinedScriptGroup.MANAGEMENT.getEntry())).minimumDialect(ShellDialects.SH)).commands(PredefinedScriptStore.file("apt_upgrade.sh"))).shellScript(true)).runnableScript(true)).build()),
    REMOVE_CR("CRLF to LF", () -> ((SimpleScriptStore.SimpleScriptStoreBuilder)((SimpleScriptStore.SimpleScriptStoreBuilder)((SimpleScriptStore.SimpleScriptStoreBuilder)((SimpleScriptStore.SimpleScriptStoreBuilder)((SimpleScriptStore.SimpleScriptStoreBuilder)SimpleScriptStore.builder().group(PredefinedScriptGroup.FILES.getEntry())).minimumDialect(ShellDialects.SH)).commands(PredefinedScriptStore.file("crlf_to_lf.sh"))).fileScript(true)).shellScript(true)).build()),
    DIFF("Diff", () -> ((SimpleScriptStore.SimpleScriptStoreBuilder)((SimpleScriptStore.SimpleScriptStoreBuilder)((SimpleScriptStore.SimpleScriptStoreBuilder)((SimpleScriptStore.SimpleScriptStoreBuilder)SimpleScriptStore.builder().group(PredefinedScriptGroup.FILES.getEntry())).minimumDialect(ShellDialects.SH)).commands(PredefinedScriptStore.file("diff.sh"))).fileScript(true)).build()),
    GIT_CONFIG("Git Config", () -> ((SimpleScriptStore.SimpleScriptStoreBuilder)((SimpleScriptStore.SimpleScriptStoreBuilder)((SimpleScriptStore.SimpleScriptStoreBuilder)((SimpleScriptStore.SimpleScriptStoreBuilder)SimpleScriptStore.builder().group(PredefinedScriptGroup.MANAGEMENT.getEntry())).minimumDialect(null)).commands(PredefinedScriptStore.file("git_config.sh"))).runnableScript(true)).build()),
    SYSTEM_HEALTH_STATUS("System health status", () -> ((SimpleScriptStore.SimpleScriptStoreBuilder)((SimpleScriptStore.SimpleScriptStoreBuilder)((SimpleScriptStore.SimpleScriptStoreBuilder)((SimpleScriptStore.SimpleScriptStoreBuilder)SimpleScriptStore.builder().group(PredefinedScriptGroup.MANAGEMENT.getEntry())).minimumDialect(ShellDialects.SH)).commands(PredefinedScriptStore.file("system_health.sh"))).initScript(true)).build());

    private final String name;
    private final Supplier<ScriptStore> scriptStore;
    private final UUID uuid;
    private DataStoreEntryRef<ScriptStore> entry;

    private PredefinedScriptStore(String name, Supplier<ScriptStore> scriptStore) {
        this.name = name;
        this.scriptStore = scriptStore;
        this.uuid = UUID.nameUUIDFromBytes(name.getBytes(StandardCharsets.UTF_8));
    }

    public static String file(String name) {
        AtomicReference string = new AtomicReference();
        AppResources.with((String)AppNames.extModuleName((String)"base"), (String)("scripts/" + name), var1 -> string.set(Files.readString(var1)));
        return (String)string.get();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Supplier<ScriptStore> getScriptStore() {
        return this.scriptStore;
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public DataStoreEntryRef<ScriptStore> getEntry() {
        return this.entry;
    }

    @Generated
    public void setEntry(DataStoreEntryRef<ScriptStore> entry) {
        this.entry = entry;
    }
}

