/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.identity.ssh;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.util.LicenseProvider;
import io.xpipe.core.FilePath;
import io.xpipe.core.KeyValue;
import io.xpipe.core.OsType;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

@JsonTypeName(value="yubikeyPiv")
@JsonDeserialize(builder=YubikeyPivStrategyBuilder.class)
public final class YubikeyPivStrategy
implements SshIdentityStrategy {
    private String getFile() {
        OsType.Local local = OsType.ofLocal();
        Objects.requireNonNull(local);
        OsType.Local local2 = local;
        int n = 0;
        String file = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{OsType.Linux.class, OsType.MacOs.class, OsType.Windows.class}, (OsType.Local)local2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                OsType.Linux ignored = (OsType.Linux)local2;
                yield "/usr/local/lib/libykcs11.so";
            }
            case 1 -> {
                OsType.MacOs ignored = (OsType.MacOs)local2;
                yield "/usr/local/lib/libykcs11.dylib";
            }
            case 2 -> {
                OsType.Windows ignored = (OsType.Windows)local2;
                String x64 = "C:\\Program Files\\Yubico\\Yubico PIV Tool\\bin\\libykcs11.dll";
                if (Files.exists(Path.of(x64, new String[0]), new LinkOption[0])) {
                    yield x64;
                }
                String x86 = "C:\\Program Files (x86)\\Yubico\\Yubico PIV Tool\\bin\\libykcs11.dll";
                if (Files.exists(Path.of(x86, new String[0]), new LinkOption[0])) {
                    yield x86;
                }
                yield x64;
            }
        };
        return file;
    }

    @Override
    public void prepareParent(ShellControl parent) throws Exception {
        parent.requireLicensedFeature(LicenseProvider.get().getFeature("pkcs11Identity"));
        String file = this.getFile();
        if (!parent.getShellDialect().createFileExistsCommand(parent, file).executeAndCheck()) {
            throw (IOException)ErrorEventFactory.expected((Throwable)new IOException("Yubikey PKCS11 library at " + file + " not found"));
        }
    }

    @Override
    public void buildCommand(CommandBuilder builder) {
        builder.setup(sc -> {
            String file = this.getFile();
            FilePath dir = FilePath.of((String)file).getParent();
            if (sc.getOsType() == OsType.WINDOWS) {
                builder.addToPath(dir, true);
            } else {
                builder.addToEnvironmentPath("LD_LIBRARY_PATH", dir, true);
            }
        });
    }

    @Override
    public List<KeyValue> configOptions() {
        return List.of(new KeyValue("IdentitiesOnly", "no"), new KeyValue("PKCS11Provider", "\"" + this.getFile() + "\""), new KeyValue("IdentityFile", "none"), new KeyValue("IdentityAgent", "none"));
    }

    @Generated
    public static YubikeyPivStrategyBuilder builder() {
        return new YubikeyPivStrategyBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof YubikeyPivStrategy;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "YubikeyPivStrategy()";
    }

    @Generated
    public YubikeyPivStrategy() {
    }

    @JsonTypeName(value="yubikeyPiv")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class YubikeyPivStrategyBuilder {
        @Generated
        YubikeyPivStrategyBuilder() {
        }

        @Generated
        public YubikeyPivStrategy build() {
            return new YubikeyPivStrategy();
        }

        @Generated
        public String toString() {
            return "YubikeyPivStrategy.YubikeyPivStrategyBuilder()";
        }
    }
}

