/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.identity.ssh;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.xpipe.app.ext.ValidationException;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.LocalShell;
import io.xpipe.app.process.OsFileSystem;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.secret.SecretNoneStrategy;
import io.xpipe.app.secret.SecretRetrievalStrategy;
import io.xpipe.core.FilePath;
import io.xpipe.core.KeyValue;
import io.xpipe.core.OsType;
import io.xpipe.ext.base.identity.ssh.CustomAgentStrategy;
import io.xpipe.ext.base.identity.ssh.CustomPkcs11LibraryStrategy;
import io.xpipe.ext.base.identity.ssh.GpgAgentStrategy;
import io.xpipe.ext.base.identity.ssh.InPlaceKeyStrategy;
import io.xpipe.ext.base.identity.ssh.KeyFileStrategy;
import io.xpipe.ext.base.identity.ssh.NoIdentityStrategy;
import io.xpipe.ext.base.identity.ssh.OpenSshAgentStrategy;
import io.xpipe.ext.base.identity.ssh.OtherExternalAgentStrategy;
import io.xpipe.ext.base.identity.ssh.PageantStrategy;
import io.xpipe.ext.base.identity.ssh.YubikeyPivStrategy;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=NoIdentityStrategy.class), @JsonSubTypes.Type(value=KeyFileStrategy.class), @JsonSubTypes.Type(value=InPlaceKeyStrategy.class), @JsonSubTypes.Type(value=OpenSshAgentStrategy.class), @JsonSubTypes.Type(value=PageantStrategy.class), @JsonSubTypes.Type(value=CustomAgentStrategy.class), @JsonSubTypes.Type(value=GpgAgentStrategy.class), @JsonSubTypes.Type(value=YubikeyPivStrategy.class), @JsonSubTypes.Type(value=CustomPkcs11LibraryStrategy.class), @JsonSubTypes.Type(value=OtherExternalAgentStrategy.class)})
public interface SshIdentityStrategy {
    public static List<Class<?>> getSubclasses() {
        ArrayList l = new ArrayList();
        l.add(NoIdentityStrategy.class);
        l.add(KeyFileStrategy.class);
        l.add(InPlaceKeyStrategy.class);
        l.add(OpenSshAgentStrategy.class);
        if (OsType.ofLocal() != OsType.WINDOWS) {
            l.add(CustomAgentStrategy.class);
        }
        if (GpgAgentStrategy.isSupported()) {
            l.add(GpgAgentStrategy.class);
        }
        if (PageantStrategy.isSupported()) {
            l.add(PageantStrategy.class);
        }
        l.add(YubikeyPivStrategy.class);
        l.add(CustomPkcs11LibraryStrategy.class);
        l.add(OtherExternalAgentStrategy.class);
        return l;
    }

    public static Optional<FilePath> getPublicKeyPath(String publicKey) {
        if (publicKey == null || publicKey.isBlank()) {
            return Optional.empty();
        }
        boolean isFile = OsFileSystem.ofLocal().isProbableFilePath(publicKey);
        if (isFile && Files.exists(Paths.get(publicKey, new String[0]), new LinkOption[0])) {
            return Optional.ofNullable(FilePath.parse((String)publicKey));
        }
        try {
            FilePath base = LocalShell.getShell().getSystemTemporaryDirectory().join(new String[]{"key.pub"});
            FilePath file = LocalShell.getShell().view().writeTextFileDeterministic(base, publicKey.strip() + "\n");
            if (OsType.ofLocal() != OsType.WINDOWS) {
                LocalShell.getShell().command(CommandBuilder.of().add(new String[]{"chmod", "400"}).addFile(file)).executeAndCheck();
            }
            return Optional.of(file);
        }
        catch (Exception e) {
            ErrorEventFactory.fromThrowable((Throwable)e).handle();
            return Optional.empty();
        }
    }

    default public void checkComplete() throws ValidationException {
    }

    public void prepareParent(ShellControl var1) throws Exception;

    public void buildCommand(CommandBuilder var1);

    public List<KeyValue> configOptions();

    default public SecretRetrievalStrategy getAskpassStrategy() {
        return new SecretNoneStrategy();
    }
}

