/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.identity.ssh;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.comp.base.TextAreaComp;
import io.xpipe.app.core.AppSystemInfo;
import io.xpipe.app.ext.ValidationException;
import io.xpipe.app.platform.OptionsBuilder;
import io.xpipe.app.platform.OptionsChoiceBuilder;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.secret.SecretRetrievalStrategy;
import io.xpipe.app.secret.SecretStrategyChoiceConfig;
import io.xpipe.app.util.LocalFileTracker;
import io.xpipe.app.util.Validators;
import io.xpipe.core.FilePath;
import io.xpipe.core.InPlaceSecretValue;
import io.xpipe.core.KeyValue;
import io.xpipe.core.OsType;
import io.xpipe.core.SecretValue;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategyChoiceConfig;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import lombok.Generated;

@JsonTypeName(value="inPlaceKey")
@JsonDeserialize(builder=InPlaceKeyStrategyBuilder.class)
public final class InPlaceKeyStrategy
implements SshIdentityStrategy {
    private final SecretValue key;
    private final SecretRetrievalStrategy password;

    public static OptionsBuilder createOptions(Property<InPlaceKeyStrategy> p, SshIdentityStrategyChoiceConfig config) {
        SimpleStringProperty key = new SimpleStringProperty(((InPlaceKeyStrategy)p.getValue()).getKey() != null ? ((InPlaceKeyStrategy)p.getValue()).getKey().getSecretValue() : null);
        SimpleObjectProperty keyPasswordProperty = new SimpleObjectProperty(p.getValue() != null ? ((InPlaceKeyStrategy)p.getValue()).getPassword() : null);
        OptionsBuilder passwordChoice = OptionsChoiceBuilder.builder().allowNull(false).property((Property)keyPasswordProperty).customConfiguration((Object)SecretStrategyChoiceConfig.builder().allowNone(true).build()).available(SecretRetrievalStrategy.getSubclasses()).build().build();
        return new OptionsBuilder().nameAndDescription("inPlaceKeyText").addComp(new TextAreaComp((Property)key).apply(struc -> struc.getTextArea().setPromptText("-----BEGIN ... PRIVATE KEY-----\n\n-----END ... PRIVATE KEY-----\n")), (Property)key).nonNull().name("keyPassword").description("sshConfigHost.identityPassphraseDescription").sub(passwordChoice, (Property)keyPasswordProperty).nonNull().bind(() -> new InPlaceKeyStrategy((SecretValue)(key.get() != null ? InPlaceSecretValue.of((String)key.get()) : null), (SecretRetrievalStrategy)keyPasswordProperty.get()), new Property[]{p});
    }

    @Override
    public void checkComplete() throws ValidationException {
        Validators.nonNull((Object)this.key);
        Validators.nonNull((Object)this.password);
    }

    @Override
    public synchronized void prepareParent(ShellControl parent) throws Exception {
        if (this.key == null) {
            return;
        }
        FilePath file = this.getTargetFilePath();
        if (parent.view().fileExists(file)) {
            return;
        }
        parent.view().touch(file);
        if (parent.getOsType() != OsType.WINDOWS) {
            parent.command(CommandBuilder.of().add(new String[]{"chmod", "600"}).addFile(file)).execute();
        }
        byte[] bytes = (this.key.getSecretValue().lines().collect(Collectors.joining("\n")) + "\n").getBytes(StandardCharsets.UTF_8);
        parent.view().writeRawFile(file, bytes);
        if (parent.getOsType() != OsType.WINDOWS) {
            parent.command(CommandBuilder.of().add(new String[]{"chmod", "400"}).addFile(file)).execute();
        }
        LocalFileTracker.deleteOnExit((Path)file.asLocalPath());
    }

    @Override
    public void buildCommand(CommandBuilder builder) {
    }

    @Override
    public List<KeyValue> configOptions() {
        return List.of(new KeyValue("IdentitiesOnly", "yes"), new KeyValue("IdentityAgent", "none"), new KeyValue("IdentityFile", "\"" + String.valueOf(this.getTargetFilePath()) + "\""), new KeyValue("PKCS11Provider", "none"));
    }

    @Override
    public SecretRetrievalStrategy getAskpassStrategy() {
        return this.password;
    }

    private FilePath getTargetFilePath() {
        Path temp = AppSystemInfo.ofCurrent().getTemp().resolve("xpipe-" + Math.abs(this.hashCode()) + ".key");
        return FilePath.of((Path)temp);
    }

    @Generated
    public static InPlaceKeyStrategyBuilder builder() {
        return new InPlaceKeyStrategyBuilder();
    }

    @Generated
    public SecretValue getKey() {
        return this.key;
    }

    @Generated
    public SecretRetrievalStrategy getPassword() {
        return this.password;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InPlaceKeyStrategy)) {
            return false;
        }
        InPlaceKeyStrategy other = (InPlaceKeyStrategy)o;
        SecretValue this$key = this.getKey();
        SecretValue other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        SecretRetrievalStrategy this$password = this.getPassword();
        SecretRetrievalStrategy other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SecretValue $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        SecretRetrievalStrategy $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InPlaceKeyStrategy(key=" + String.valueOf(this.getKey()) + ", password=" + String.valueOf(this.getPassword()) + ")";
    }

    @Generated
    public InPlaceKeyStrategy(SecretValue key, SecretRetrievalStrategy password) {
        this.key = key;
        this.password = password;
    }

    @JsonTypeName(value="inPlaceKey")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class InPlaceKeyStrategyBuilder {
        @Generated
        private SecretValue key;
        @Generated
        private SecretRetrievalStrategy password;

        @Generated
        InPlaceKeyStrategyBuilder() {
        }

        @Generated
        public InPlaceKeyStrategyBuilder key(SecretValue key) {
            this.key = key;
            return this;
        }

        @Generated
        public InPlaceKeyStrategyBuilder password(SecretRetrievalStrategy password) {
            this.password = password;
            return this;
        }

        @Generated
        public InPlaceKeyStrategy build() {
            return new InPlaceKeyStrategy(this.key, this.password);
        }

        @Generated
        public String toString() {
            return "InPlaceKeyStrategy.InPlaceKeyStrategyBuilder(key=" + String.valueOf(this.key) + ", password=" + String.valueOf(this.password) + ")";
        }
    }
}

