/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.identity;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.InternalCacheDataStore;
import io.xpipe.app.ext.UserScopeStore;
import io.xpipe.app.ext.ValidatableStore;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.prefs.AppPrefs;
import io.xpipe.app.pwman.PasswordManager;
import io.xpipe.app.secret.SecretQuery;
import io.xpipe.app.secret.SecretQueryResult;
import io.xpipe.app.secret.SecretQueryState;
import io.xpipe.app.secret.SecretRetrievalStrategy;
import io.xpipe.app.util.Validators;
import io.xpipe.core.FailableSupplier;
import io.xpipe.ext.base.identity.IdentityStore;
import io.xpipe.ext.base.identity.UsernameStrategy;
import io.xpipe.ext.base.identity.ssh.NoIdentityStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import lombok.Generated;

@JsonTypeName(value="passwordManagerIdentity")
@JsonDeserialize(builder=PasswordManagerIdentityStoreBuilderImpl.class)
public final class PasswordManagerIdentityStore
extends IdentityStore
implements InternalCacheDataStore,
ValidatableStore,
UserScopeStore {
    private final String key;
    private final boolean perUser;

    private boolean checkOutdatedOrRefresh() {
        Instant now;
        Instant instant = (Instant)this.getCache("lastQueried", Instant.class, null);
        return instant == null || Duration.between(instant, now = Instant.now()).toSeconds() >= 15L;
    }

    private PasswordManager.CredentialResult retrieveCredentials() {
        PasswordManager.CredentialResult credential;
        if (!this.checkOutdatedOrRefresh() && (credential = (PasswordManager.CredentialResult)this.getCache("credential", PasswordManager.CredentialResult.class, null)) != null) {
            return credential;
        }
        if (AppPrefs.get() == null || AppPrefs.get().passwordManager().getValue() == null) {
            return null;
        }
        PasswordManager.CredentialResult r = ((PasswordManager)AppPrefs.get().passwordManager().getValue()).retrieveCredentials(this.key);
        if (r == null) {
            throw (UnsupportedOperationException)ErrorEventFactory.expected((Throwable)new UnsupportedOperationException("Credentials were requested but not supplied"));
        }
        if (r.getUsername() == null) {
            throw (UnsupportedOperationException)ErrorEventFactory.expected((Throwable)new UnsupportedOperationException("Identity " + this.key + " does not provide a username"));
        }
        if (r.getPassword() == null) {
            throw (UnsupportedOperationException)ErrorEventFactory.expected((Throwable)new UnsupportedOperationException("Identity " + this.key + " does not provide a password"));
        }
        this.setCache("lastQueried", Instant.now());
        this.setCache("credential", r);
        return r;
    }

    @Override
    public UsernameStrategy getUsername() {
        return new UsernameStrategy.Dynamic((FailableSupplier<String>)((FailableSupplier)() -> {
            PasswordManager.CredentialResult r = this.retrieveCredentials();
            return r.getUsername();
        }));
    }

    @Override
    public SecretRetrievalStrategy getPassword() {
        return new SecretRetrievalStrategy(this){
            final /* synthetic */ PasswordManagerIdentityStore this$0;
            {
                PasswordManagerIdentityStore passwordManagerIdentityStore = this$0;
                Objects.requireNonNull(passwordManagerIdentityStore);
                this.this$0 = passwordManagerIdentityStore;
            }

            public SecretQuery query() {
                return new SecretQuery(this){
                    final /* synthetic */ 1 this$1;
                    {
                        1 v0 = this$1;
                        Objects.requireNonNull(v0);
                        this.this$1 = v0;
                    }

                    public SecretQueryResult query(String prompt) {
                        PasswordManager.CredentialResult r = this.this$1.this$0.retrieveCredentials();
                        return new SecretQueryResult(r.getPassword(), SecretQueryState.NORMAL);
                    }

                    public Duration cacheDuration() {
                        return null;
                    }

                    public boolean retryOnFail() {
                        return false;
                    }

                    public boolean requiresUserInteraction() {
                        return false;
                    }
                };
            }
        };
    }

    @Override
    public SshIdentityStrategy getSshIdentity() {
        return new NoIdentityStrategy();
    }

    @Override
    public void checkComplete() throws Throwable {
        Validators.nonNull((Object)this.key);
    }

    public void validate() {
        this.retrieveCredentials();
    }

    @Generated
    protected PasswordManagerIdentityStore(PasswordManagerIdentityStoreBuilder<?, ?> b) {
        super(b);
        this.key = b.key;
        this.perUser = b.perUser;
    }

    @Generated
    public static PasswordManagerIdentityStoreBuilder<?, ?> builder() {
        return new PasswordManagerIdentityStoreBuilderImpl();
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public boolean isPerUser() {
        return this.perUser;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PasswordManagerIdentityStore)) {
            return false;
        }
        PasswordManagerIdentityStore other = (PasswordManagerIdentityStore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isPerUser() != other.isPerUser()) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PasswordManagerIdentityStore;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isPerUser() ? 79 : 97);
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "PasswordManagerIdentityStore(super=" + super.toString() + ", key=" + this.getKey() + ", perUser=" + this.isPerUser() + ")";
    }

    @Generated
    public static abstract class PasswordManagerIdentityStoreBuilder<C extends PasswordManagerIdentityStore, B extends PasswordManagerIdentityStoreBuilder<C, B>>
    extends IdentityStore.IdentityStoreBuilder<C, B> {
        @Generated
        private String key;
        @Generated
        private boolean perUser;

        @Generated
        public B key(String key) {
            this.key = key;
            return (B)this.self();
        }

        @Generated
        public B perUser(boolean perUser) {
            this.perUser = perUser;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "PasswordManagerIdentityStore.PasswordManagerIdentityStoreBuilder(super=" + super.toString() + ", key=" + this.key + ", perUser=" + this.perUser + ")";
        }
    }

    @JsonTypeName(value="passwordManagerIdentity")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class PasswordManagerIdentityStoreBuilderImpl
    extends PasswordManagerIdentityStoreBuilder<PasswordManagerIdentityStore, PasswordManagerIdentityStoreBuilderImpl> {
        @Generated
        private PasswordManagerIdentityStoreBuilderImpl() {
        }

        @Override
        @Generated
        protected PasswordManagerIdentityStoreBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PasswordManagerIdentityStore build() {
            return new PasswordManagerIdentityStore(this);
        }
    }
}

