/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.rdp;

import io.xpipe.app.core.AppI18n;
import io.xpipe.app.core.AppInstallation;
import io.xpipe.app.ext.SelfReferentialStore;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.platform.ClipboardHelper;
import io.xpipe.app.prefs.AppPrefs;
import io.xpipe.app.process.ShellDialect;
import io.xpipe.app.process.ShellDialects;
import io.xpipe.app.rdp.ExternalRdpClient;
import io.xpipe.app.rdp.RdpLaunchConfig;
import io.xpipe.app.secret.SecretManager;
import io.xpipe.app.secret.SecretPromptStrategy;
import io.xpipe.app.secret.SecretRetrievalStrategy;
import io.xpipe.app.util.AsktextAlert;
import io.xpipe.app.util.RdpConfig;
import io.xpipe.core.SecretValue;
import io.xpipe.ext.base.desktop.DesktopApplicationStore;
import io.xpipe.ext.base.desktop.DesktopBaseStore;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;

public abstract class a
implements SelfReferentialStore,
DesktopBaseStore {
    protected abstract SecretRetrievalStrategy getPassword();

    protected void launchConfig(RdpConfig rdpConfig, boolean bl, boolean bl2) {
        Object object;
        ExternalRdpClient externalRdpClient = bl ? ExternalRdpClient.getApplicationLauncher() : (ExternalRdpClient)AppPrefs.get().rdpClientType().getValue();
        if (externalRdpClient == null) {
            throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException("No external RDP client has been configured in the settings."));
        }
        Optional<Optional> optional = rdpConfig.get("username");
        if (optional.isEmpty() && ((Optional)(object = AsktextAlert.query((String)AppI18n.get((String)"rdpAskpassUser", (Object[])new Object[]{this.getDisplayName()}), null))).isPresent()) {
            optional = RdpConfig.TypedValue.string((String)((String)((Optional)object).get()));
            rdpConfig = rdpConfig.overlay(Map.of("username", optional));
            optional = Optional.of(optional);
        }
        if (optional.isEmpty()) {
            return;
        }
        object = this.getPassword() != null ? this.getPassword() : new SecretPromptStrategy();
        optional = bl2 ? SecretManager.retrieve((SecretRetrievalStrategy)object, (String)AppI18n.get((String)"rdpAskpassPassword", (Object[])new Object[]{optional.map(RdpConfig.TypedValue::getValue).orElseThrow()}), (UUID)this.getSelfEntry().getUuid(), (int)0, (boolean)true) : null;
        externalRdpClient.launch(new RdpLaunchConfig(this.getDisplayName(), rdpConfig, this.getSelfEntry().getUuid(), (SecretValue)optional));
        if (bl2 && !externalRdpClient.supportsPasswordPassing()) {
            ClipboardHelper.copyPassword(optional);
        }
    }

    public void runDesktopApplication(String string, DesktopApplicationStore desktopApplicationStore) {
        string = this.createLaunchAppConfig(string, desktopApplicationStore.getPath().replaceAll("/", "\\\\"), desktopApplicationStore.getArguments(), this.retrieveConfig());
        this.launchConfig((RdpConfig)string, true, true);
    }

    public ShellDialect getUsedDesktopDialect() {
        return ShellDialects.CMD;
    }

    protected abstract RdpConfig retrieveConfig();

    protected abstract String getDisplayName();

    protected RdpConfig createLaunchConnectionConfig(RdpConfig rdpConfig) {
        rdpConfig = rdpConfig.overlay(Map.of());
        return rdpConfig;
    }

    protected RdpConfig createLaunchAppConfig(String string, String string2, String string3, RdpConfig rdpConfig) {
        rdpConfig = rdpConfig.overlay(Map.of("remoteapplicationmode", new RdpConfig.TypedValue("i", "1"), "remoteapplicationname", new RdpConfig.TypedValue("s", string), "remoteapplicationprogram", new RdpConfig.TypedValue("s", string2), "remoteapplicationicon", new RdpConfig.TypedValue("s", AppInstallation.ofCurrent().getLogoPath().toString())));
        if (string3 != null && !string3.isBlank()) {
            rdpConfig = rdpConfig.overlay(Map.of("remoteapplicationcmdline", new RdpConfig.TypedValue("s", string3)));
        }
        return rdpConfig;
    }

    @Generated
    protected a(a<?, ?> a2) {
    }

    @Generated
    public String toString() {
        return "RdpBaseStore()";
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof a)) {
            return false;
        }
        return ((a)(object = (a)object)).canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object object) {
        return object instanceof a;
    }

    @Generated
    public int hashCode() {
        return 1;
    }

    @Generated
    public static abstract class a<C extends a, B extends a<C, B>> {
        @Generated
        protected B $fillValuesFrom(C c2) {
            a.$fillValuesFromInstanceIntoBuilder(c2, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(a a2, a<?, ?> a3) {
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "RdpBaseStore.RdpBaseStoreBuilder()";
        }
    }
}

