/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.proxmox;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.FixedChildStore;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.CommandControl;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.LicensedFeature;
import io.xpipe.app.util.Validators;
import io.xpipe.core.FailableFunction;
import io.xpipe.core.JacksonMapper;
import io.xpipe.core.OsType;
import io.xpipe.ext.proc.proxmox.f;
import io.xpipe.ext.proc.proxmox.h;
import io.xpipe.ext.proc.proxmox.q;
import io.xpipe.ext.proc.ssh.s;
import io.xpipe.ext.proc.vm.d;
import io.xpipe.ext.proc.vm.e;
import io.xpipe.ext.proc.vm.h;
import java.util.Optional;
import lombok.Generated;

@JsonTypeName(value="proxmoxVm")
@JsonDeserialize(builder=b.class)
public final class o
extends e<q>
implements io.xpipe.ext.proc.proxmox.a {
    private final DataStoreEntryRef<h> install;
    private final int vmid;
    private final String name;

    public final CommandControl monitorCommand() {
        return ((ShellStore)((h)this.getInstall().getStore()).getHost().getStore()).getOrStartSession().command(commandBuilder -> commandBuilder.add(new String[]{"qm", "monitor", "" + this.getVmid()})).elevated(f.bG());
    }

    public final FixedChildStore merge(FixedChildStore fixedChildStore) {
        fixedChildStore = (o)fixedChildStore;
        return ((a)((e.a)this.toBuilder().name(fixedChildStore.name)).identity(this.identity != null ? this.identity : fixedChildStore.identity)).build();
    }

    @Override
    public final void checkComplete() {
        super.checkComplete();
        Validators.nonNull(this.install);
        Validators.isType(this.install, h.class);
        this.install.checkComplete();
    }

    @Override
    public final DataStoreEntryRef<ShellStore> getHypervisorHost() {
        if (this.install != null) {
            return ((h)this.install.getStore()).getHost();
        }
        return null;
    }

    @Override
    public final FailableFunction<CommandBuilder, Boolean, Exception> guestExecPredicate(ShellControl shellControl) {
        return commandBuilder -> {
            if (((Optional)(shellControl = shellControl.command(commandBuilder = commandBuilder.add(0, new String[]{"qm", "guest", "exec", "" + this.vmid, "--"})).elevated(f.bG()).readStdoutIfPossible())).isEmpty()) {
                return Boolean.FALSE;
            }
            shellControl = JacksonMapper.getDefault().readTree((String)((Optional)shellControl).get());
            if (!shellControl.isObject() || !shellControl.has("exitcode")) {
                return Boolean.FALSE;
            }
            int n2 = shellControl.required("exitcode").asInt();
            return n2 == 0;
        };
    }

    @Override
    public final Class<q> getStateClass() {
        return q.class;
    }

    @Override
    public final void prepareGuestShell(ShellControl shellControl) {
        Optional<LicensedFeature> optional = ((h)this.getInstall().getStore()).checkLicenseRequirement();
        if (optional.isPresent()) {
            shellControl.requireLicensedFeature(optional.get());
        }
    }

    @Override
    public final void updateGuestState(ShellControl shellControl) {
        this.refreshVmState(shellControl);
        if (!((q)this.getState()).getRunning().booleanValue()) {
            return;
        }
        h.a a2 = ((q)this.getState()).toBuilder();
        if (this.getCustomIp() == null || !this.getCustomIp().use()) {
            f.a(shellControl, this.vmid);
            Optional<String> optional = f.b(shellControl, this.vmid);
            if (optional.isEmpty()) {
                this.setState(((q.a)((Object)((q.a)((Object)a2.ip(null))).reachable(Boolean.FALSE))).build());
                throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException("Unable to determine external IP address for vmid " + this.vmid + " via network-get-interfaces"));
            }
            a2.ip(optional.get());
            this.setState(((q.a)a2).build());
        }
        boolean bl = s.a(shellControl, this.getEffectiveIp(), this.getPort() != null ? this.getPort() : 22);
        a2.reachable(bl);
        if (!bl) {
            OsType.Any any = this.guestExecPredicate(shellControl);
            any = io.xpipe.ext.proc.util.e.a(any);
            a2.reachable(d.a(this, shellControl, any));
        }
        this.setState(((q.a)a2).build());
    }

    private void refreshVmState(ShellControl object) {
        Object object2 = (q)this.getState();
        object2 = ((q)((Object)object2)).toBuilder();
        object = f.c(object, this.vmid);
        ((h.a)((Object)object2)).stateString((String)object);
        boolean bl = "running".equals(object);
        ((h.a)((Object)object2)).running(bl);
        this.setState(((q.a)((Object)object2)).build());
    }

    public final void start() {
        ((h)this.getInstall().getStore()).checkLicenseOrThrow();
        ShellControl shellControl = ((ShellStore)((h)this.getInstall().getStore()).getHost().getStore()).getOrStartSession();
        String string = shellControl.command(CommandBuilder.of().add(new String[]{"qm", "status", "" + this.getVmid()})).elevated(f.bG()).readStdoutOrThrow();
        shellControl.command(CommandBuilder.of().add(new String[]{"qm", string.contains("paused") || string.contains("suspended") ? "resume" : "start", "" + this.getVmid()})).elevated(f.bG()).execute();
        this.refreshVmState(shellControl);
    }

    public final void stop() {
        ((h)this.getInstall().getStore()).checkLicenseOrThrow();
        ShellControl shellControl = ((ShellStore)((h)this.getInstall().getStore()).getHost().getStore()).getOrStartSession();
        shellControl.command(CommandBuilder.of().add(new String[]{"qm", "stop", "" + this.getVmid()})).elevated(f.bG()).execute();
        this.refreshVmState(shellControl);
    }

    public final void pause() {
        ((h)this.getInstall().getStore()).checkLicenseOrThrow();
        ShellControl shellControl = ((ShellStore)((h)this.getInstall().getStore()).getHost().getStore()).getOrStartSession();
        shellControl.command(CommandBuilder.of().add(new String[]{"qm", "suspend", "" + this.getVmid()})).elevated(f.bG()).execute();
        this.refreshVmState(shellControl);
    }

    @Override
    public final int getVmid() {
        return this.vmid;
    }

    @Generated
    protected o(a<?, ?> a2) {
        super(a2);
        this.install = a2.install;
        this.vmid = a2.vmid;
        this.name = a2.name;
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final a<?, ?> toBuilder() {
        return new b().$fillValuesFrom(this);
    }

    @Generated
    public final DataStoreEntryRef<h> getInstall() {
        return this.install;
    }

    @Generated
    public final String getName() {
        return this.name;
    }

    @Override
    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof o)) {
            return false;
        }
        Object object2 = (o)object;
        if (!((o)object2).canEqual(this)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getVmid() != ((o)object2).getVmid()) {
            return false;
        }
        object = this.getInstall();
        DataStoreEntryRef<h> dataStoreEntryRef = ((o)object2).getInstall();
        if (object == null ? dataStoreEntryRef != null : !object.equals(dataStoreEntryRef)) {
            return false;
        }
        object = this.getName();
        object2 = ((o)object2).getName();
        return !(object == null ? object2 != null : !object.equals(object2));
    }

    @Override
    @Generated
    protected final boolean canEqual(Object object) {
        return object instanceof o;
    }

    @Override
    @Generated
    public final int hashCode() {
        int n2 = super.hashCode();
        n2 = n2 * 59 + this.getVmid();
        Object object = this.getInstall();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getName();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        return n2;
    }

    @Override
    @Generated
    public final String toString() {
        return "ProxmoxVmStore(super=" + super.toString() + ", install=" + String.valueOf(this.getInstall()) + ", vmid=" + this.getVmid() + ", name=" + this.getName() + ")";
    }

    @Generated
    public static abstract class a<C extends o, B extends a<C, B>>
    extends e.a<q, C, B> {
        @Generated
        private DataStoreEntryRef<h> install;
        @Generated
        private int vmid;
        @Generated
        private String name;

        @Override
        @Generated
        protected B $fillValuesFrom(C c2) {
            super.$fillValuesFrom(c2);
            a.$fillValuesFromInstanceIntoBuilder(c2, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(o o2, a<?, ?> a2) {
            a2.install(o2.install);
            a2.vmid(o2.vmid);
            a2.name(o2.name);
        }

        @Generated
        public B install(DataStoreEntryRef<h> dataStoreEntryRef) {
            this.install = dataStoreEntryRef;
            return (B)this.self();
        }

        @Generated
        public B vmid(int n2) {
            this.vmid = n2;
            return (B)this.self();
        }

        @Generated
        public B name(String string) {
            this.name = string;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ProxmoxVmStore.ProxmoxVmStoreBuilder(super=" + super.toString() + ", install=" + String.valueOf(this.install) + ", vmid=" + this.vmid + ", name=" + this.name + ")";
        }
    }

    @JsonTypeName(value="proxmoxVm")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<o, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final o build() {
            return new o(this);
        }
    }
}

