/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.system.podman;

import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.CommandControl;
import io.xpipe.app.process.CommandView;
import io.xpipe.app.process.CommandViewBase;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialects;
import io.xpipe.app.process.ShellOpenFunction;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;

public class PodmanCommandView
extends CommandViewBase {
    public PodmanCommandView(ShellControl shellControl) {
        super(shellControl);
    }

    private static String formatErrorMessage(String s) {
        return s;
    }

    private static <T extends Throwable> T convertException(T s) {
        return (T)ErrorEventFactory.expectedIfContains(s, (String[])new String[]{"Error: unable to connect to Podman.", "no connection could be made because the target machine actively refused it.", "unable to connect to Podman socket", "no such container", "OCI runtime attempted to invoke a command that was not found"});
    }

    public PodmanCommandView start() throws Exception {
        this.shellControl.start();
        return this;
    }

    protected CommandControl build(Consumer<CommandBuilder> builder) {
        CommandBuilder cmd = CommandBuilder.of().add(new String[]{"podman"});
        builder.accept(cmd);
        return this.shellControl.command(cmd).withErrorFormatter(PodmanCommandView::formatErrorMessage).withExceptionConverter(PodmanCommandView::convertException);
    }

    public boolean isSupported() throws Exception {
        return this.shellControl.command("podman --help").withErrorFormatter(PodmanCommandView::formatErrorMessage).withExceptionConverter(PodmanCommandView::convertException).executeAndCheck();
    }

    public String version() throws Exception {
        return this.build(commandBuilder -> commandBuilder.add(new String[]{"version"})).readStdoutOrThrow();
    }

    public boolean isDaemonRunning() throws Exception {
        return this.build(commandBuilder -> commandBuilder.add(new String[]{"version"})).executeAndCheck();
    }

    public Container container() {
        return new Container(this);
    }

    public class Container
    extends CommandView {
        final /* synthetic */ PodmanCommandView this$0;

        public Container(PodmanCommandView this$0) {
            PodmanCommandView podmanCommandView = this$0;
            Objects.requireNonNull(podmanCommandView);
            this.this$0 = podmanCommandView;
        }

        public String queryState(String container) throws Exception {
            return this.build(commandBuilder -> commandBuilder.add(new String[]{"ls", "-a", "-f", "name=\"^" + container + "$\"", "--format=\"{{.Status}}\""})).readStdoutOrThrow();
        }

        protected CommandControl build(Consumer<CommandBuilder> builder) {
            return this.this$0.build(b -> {
                b.add(new String[]{"container"});
                builder.accept((CommandBuilder)b);
            });
        }

        protected ShellControl getShellControl() {
            return this.this$0.getShellControl();
        }

        public Container start() throws Exception {
            this.this$0.shellControl.start();
            return this;
        }

        public List<ContainerEntry> listContainersAndStates() throws Exception {
            if (!this.this$0.isDaemonRunning()) {
                throw new IllegalStateException("Podman daemon is not running");
            }
            try (CommandControl c = this.build(commandBuilder -> commandBuilder.add(new String[]{"ls -a --format=\"{{.Names}};{{.Image}};{{.Status}}\""})).start();){
                String output = c.readStdoutOrThrow();
                List<ContainerEntry> list = output.lines().filter(s -> s.split(";").length == 3).map(s -> new ContainerEntry(s.split(";")[0], s.split(";")[1], s.split(";")[2])).toList();
                return list;
            }
        }

        public ShellControl exec(String container) {
            ShellControl sub = this.this$0.shellControl.subShell();
            sub.setDumbOpen(this.createOpenFunction(container, false));
            sub.setTerminalOpen(this.createOpenFunction(container, true));
            return sub.withExceptionConverter(PodmanCommandView::convertException);
        }

        private ShellOpenFunction createOpenFunction(final String containerName, final boolean terminal) {
            return new ShellOpenFunction(){
                final /* synthetic */ Container this$1;
                {
                    Container container = this$1;
                    Objects.requireNonNull(container);
                    this.this$1 = container;
                }

                public CommandBuilder prepareWithoutInitCommand() {
                    return this.this$1.execCommand(terminal).addQuoted(containerName).add(new String[]{ShellDialects.SH.getLaunchCommand().loginCommand()});
                }

                public CommandBuilder prepareWithInitCommand(@NonNull String command) {
                    if (command == null) {
                        throw new NullPointerException("command is marked non-null but is null");
                    }
                    return this.this$1.execCommand(terminal).addQuoted(containerName).add(new String[]{command});
                }
            };
        }

        public CommandBuilder execCommand(boolean terminal) {
            return CommandBuilder.of().add(new String[]{"podman", "container", "exec", terminal ? "-it" : "-i"});
        }

        public void start(String container) throws Exception {
            this.build(commandBuilder -> commandBuilder.add(new String[]{"start"}).addQuoted(container)).execute();
        }

        public void stop(String container) throws Exception {
            this.build(commandBuilder -> commandBuilder.add(new String[]{"stop"}).addQuoted(container)).execute();
        }

        public String port(String container) throws Exception {
            return this.build(commandBuilder -> commandBuilder.add(new String[]{"port"}).addQuoted(container)).readStdoutOrThrow();
        }

        public String inspect(String container) throws Exception {
            return this.build(commandBuilder -> commandBuilder.add(new String[]{"inspect"}).addQuoted(container)).readStdoutOrThrow();
        }

        public CommandControl attach(String container) {
            return this.build(commandBuilder -> commandBuilder.add(new String[]{"attach"}).addQuoted(container));
        }

        public CommandControl logs(String container) {
            return this.build(commandBuilder -> commandBuilder.add(new String[]{"logs"}).add(new String[]{"-f"}).addQuoted(container));
        }

        public static final class ContainerEntry {
            private final String name;
            private final String image;
            private final String status;

            @Generated
            public ContainerEntry(String name, String image, String status) {
                this.name = name;
                this.image = image;
                this.status = status;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public String getImage() {
                return this.image;
            }

            @Generated
            public String getStatus() {
                return this.status;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ContainerEntry)) {
                    return false;
                }
                ContainerEntry other = (ContainerEntry)o;
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$image = this.getImage();
                String other$image = other.getImage();
                if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
                    return false;
                }
                String this$status = this.getStatus();
                String other$status = other.getStatus();
                return !(this$status == null ? other$status != null : !this$status.equals(other$status));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                String $image = this.getImage();
                result = result * 59 + ($image == null ? 43 : $image.hashCode());
                String $status = this.getStatus();
                result = result * 59 + ($status == null ? 43 : $status.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "PodmanCommandView.Container.ContainerEntry(name=" + this.getName() + ", image=" + this.getImage() + ", status=" + this.getStatus() + ")";
            }
        }
    }
}

