/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.system.podman;

import io.xpipe.app.comp.Comp;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreProvider;
import io.xpipe.app.ext.DataStoreUsageCategory;
import io.xpipe.app.hub.comp.StoreEntryComp;
import io.xpipe.app.hub.comp.StoreEntryWrapper;
import io.xpipe.app.hub.comp.StoreSection;
import io.xpipe.app.hub.comp.StoreToggleComp;
import io.xpipe.app.hub.comp.SystemStateComp;
import io.xpipe.app.platform.BindingsHelper;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.ext.system.podman.PodmanCmdStore;
import java.util.List;
import javafx.beans.value.ObservableValue;

public class PodmanCmdStoreProvider
implements DataStoreProvider {
    public DocumentationLink getHelpLink() {
        return DocumentationLink.PODMAN;
    }

    public StoreEntryComp customEntryComp(StoreSection sec, boolean preferLarge) {
        StoreToggleComp nonRunning = StoreToggleComp.childrenToggle(null, (boolean)true, (StoreSection)sec, s -> ((PodmanCmdStore.State)s.getState()).isShowNonRunning(), (s, aBoolean) -> s.setState(((PodmanCmdStore.State.StateBuilder)((Object)((Object)((PodmanCmdStore.State)s.getState()).toBuilder().showNonRunning((boolean)aBoolean)))).build()));
        return StoreEntryComp.create((StoreSection)sec, (Comp)nonRunning, (boolean)preferLarge);
    }

    public Comp<?> stateDisplay(StoreEntryWrapper w) {
        return new SystemStateComp(BindingsHelper.map((ObservableValue)w.getPersistentState(), o -> {
            PodmanCmdStore.State state = (PodmanCmdStore.State)((Object)((Object)o));
            if (state.isRunning()) {
                return SystemStateComp.State.SUCCESS;
            }
            return SystemStateComp.State.FAILURE;
        }));
    }

    public DataStoreUsageCategory getUsageCategory() {
        return DataStoreUsageCategory.GROUP;
    }

    public DataStoreEntry getDisplayParent(DataStoreEntry store) {
        PodmanCmdStore s = (PodmanCmdStore)store.getStore().asNeeded();
        return s.getHost().get();
    }

    public ObservableValue<String> informationString(StoreSection section) {
        return BindingsHelper.map((ObservableValue)section.getWrapper().getPersistentState(), o -> {
            PodmanCmdStore.State state = (PodmanCmdStore.State)((Object)((Object)o));
            if (!state.isRunning()) {
                return "Connection failed";
            }
            return (state.getServerName() != null ? state.getServerName() : "Podman") + " v" + state.getVersion();
        });
    }

    public String getDisplayIconFileName(DataStore store) {
        return "system:podman_icon.svg";
    }

    public String getId() {
        return "podmanCmd";
    }

    public List<Class<?>> getStoreClasses() {
        return List.of(PodmanCmdStore.class);
    }
}

