/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.system.lxd;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.ext.FixedChildStore;
import io.xpipe.app.ext.FixedHierarchyStore;
import io.xpipe.app.ext.SelfReferentialStore;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.ext.StatefulDataStore;
import io.xpipe.app.process.CommandSupport;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.Validators;
import io.xpipe.ext.system.lxd.LxdCommandView;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

@JsonTypeName(value="lxdCmd")
@JsonDeserialize(builder=LxdCmdStoreBuilderImpl.class)
public final class LxdCmdStore
implements FixedHierarchyStore,
StatefulDataStore<State>,
SelfReferentialStore {
    private final DataStoreEntryRef<ShellStore> host;

    public LxdCmdStore(DataStoreEntryRef<ShellStore> host) {
        this.host = host;
    }

    public void checkComplete() throws Throwable {
        Validators.nonNull(this.host);
        Validators.isType(this.host, ShellStore.class);
        this.host.checkComplete();
    }

    private void updateState(LxdCommandView view) throws Exception {
        String out = view.version();
        Pattern namePattern = Pattern.compile("Server version:\\s+(.+)");
        Matcher nameMatcher = namePattern.matcher(out);
        String v = nameMatcher.find() ? nameMatcher.group(1) : null;
        boolean reachable = v != null && !"unreachable".equals(v);
        this.setState(((State.StateBuilder)((Object)((State.StateBuilder)((Object)((State)this.getState()).toBuilder().serverVersion(reachable ? v : null))).reachable(reachable))).build());
    }

    public List<? extends DataStoreEntryRef<? extends FixedChildStore>> listChildren() throws Exception {
        ShellControl sc = ((ShellStore)this.getHost().getStore()).getOrStartSession();
        LxdCommandView view = new LxdCommandView(sc);
        CommandSupport.isSupported(() -> view.isSupported(), (String)"LXD CLI client (lxc)", (DataStoreEntry)this.host.get());
        this.updateState(view);
        return view.listContainers((DataStoreEntryRef<LxdCmdStore>)this.getSelfEntry().ref());
    }

    @Generated
    protected LxdCmdStore(LxdCmdStoreBuilder<?, ?> b) {
        this.host = b.host;
    }

    @Generated
    public static LxdCmdStoreBuilder<?, ?> builder() {
        return new LxdCmdStoreBuilderImpl();
    }

    @Generated
    public DataStoreEntryRef<ShellStore> getHost() {
        return this.host;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LxdCmdStore)) {
            return false;
        }
        LxdCmdStore other = (LxdCmdStore)o;
        DataStoreEntryRef<ShellStore> this$host = this.getHost();
        DataStoreEntryRef<ShellStore> other$host = other.getHost();
        return !(this$host == null ? other$host != null : !this$host.equals(other$host));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DataStoreEntryRef<ShellStore> $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LxdCmdStore(host=" + String.valueOf(this.getHost()) + ")";
    }

    @JsonDeserialize(builder=StateBuilderImpl.class)
    public static final class State
    extends DataStoreState {
        private final String serverVersion;
        private final boolean reachable;
        private final boolean showNonRunning;

        @Generated
        protected State(StateBuilder<?, ?> b) {
            super(b);
            this.serverVersion = b.serverVersion;
            this.reachable = b.reachable;
            this.showNonRunning = b.showNonRunning;
        }

        @Generated
        public static StateBuilder<?, ?> builder() {
            return new StateBuilderImpl();
        }

        @Generated
        public StateBuilder<?, ?> toBuilder() {
            return new StateBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public String getServerVersion() {
            return this.serverVersion;
        }

        @Generated
        public boolean isReachable() {
            return this.reachable;
        }

        @Generated
        public boolean isShowNonRunning() {
            return this.showNonRunning;
        }

        @Generated
        public String toString() {
            return "LxdCmdStore.State(serverVersion=" + this.getServerVersion() + ", reachable=" + this.isReachable() + ", showNonRunning=" + this.isShowNonRunning() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof State)) {
                return false;
            }
            State other = (State)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.isReachable() != other.isReachable()) {
                return false;
            }
            if (this.isShowNonRunning() != other.isShowNonRunning()) {
                return false;
            }
            String this$serverVersion = this.getServerVersion();
            String other$serverVersion = other.getServerVersion();
            return !(this$serverVersion == null ? other$serverVersion != null : !this$serverVersion.equals(other$serverVersion));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof State;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + (this.isReachable() ? 79 : 97);
            result = result * 59 + (this.isShowNonRunning() ? 79 : 97);
            String $serverVersion = this.getServerVersion();
            result = result * 59 + ($serverVersion == null ? 43 : $serverVersion.hashCode());
            return result;
        }

        @Generated
        public static abstract class StateBuilder<C extends State, B extends StateBuilder<C, B>>
        extends DataStoreState.DataStoreStateBuilder<C, B> {
            @Generated
            private String serverVersion;
            @Generated
            private boolean reachable;
            @Generated
            private boolean showNonRunning;

            @Generated
            protected B $fillValuesFrom(C instance) {
                super.$fillValuesFrom(instance);
                StateBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return (B)this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(State instance, StateBuilder<?, ?> b) {
                b.serverVersion(instance.serverVersion);
                b.reachable(instance.reachable);
                b.showNonRunning(instance.showNonRunning);
            }

            @Generated
            public B serverVersion(String serverVersion) {
                this.serverVersion = serverVersion;
                return (B)this.self();
            }

            @Generated
            public B reachable(boolean reachable) {
                this.reachable = reachable;
                return (B)this.self();
            }

            @Generated
            public B showNonRunning(boolean showNonRunning) {
                this.showNonRunning = showNonRunning;
                return (B)this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "LxdCmdStore.State.StateBuilder(super=" + super.toString() + ", serverVersion=" + this.serverVersion + ", reachable=" + this.reachable + ", showNonRunning=" + this.showNonRunning + ")";
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class StateBuilderImpl
        extends StateBuilder<State, StateBuilderImpl> {
            @Generated
            private StateBuilderImpl() {
            }

            @Override
            @Generated
            protected StateBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public State build() {
                return new State(this);
            }
        }
    }

    @Generated
    public static abstract class LxdCmdStoreBuilder<C extends LxdCmdStore, B extends LxdCmdStoreBuilder<C, B>> {
        @Generated
        private DataStoreEntryRef<ShellStore> host;

        @Generated
        public B host(DataStoreEntryRef<ShellStore> host) {
            this.host = host;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "LxdCmdStore.LxdCmdStoreBuilder(host=" + String.valueOf(this.host) + ")";
        }
    }

    @JsonTypeName(value="lxdCmd")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class LxdCmdStoreBuilderImpl
    extends LxdCmdStoreBuilder<LxdCmdStore, LxdCmdStoreBuilderImpl> {
        @Generated
        private LxdCmdStoreBuilderImpl() {
        }

        @Override
        @Generated
        protected LxdCmdStoreBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LxdCmdStore build() {
            return new LxdCmdStore(this);
        }
    }
}

