/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.service;

import io.xpipe.app.comp.Comp;
import io.xpipe.app.comp.base.TextFieldComp;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.util.OptionsBuilder;
import io.xpipe.ext.base.service.ServiceProtocolType;
import java.util.LinkedHashMap;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TextField;

public class ServiceProtocolTypeHelper {
    private static OptionsBuilder custom(Property<ServiceProtocolType.Custom> p) {
        SimpleBooleanProperty firstFocus = new SimpleBooleanProperty(false);
        SimpleStringProperty path = new SimpleStringProperty(p.getValue() != null ? ((ServiceProtocolType.Custom)p.getValue()).getCommandTemplate() : null);
        Comp comp = new TextFieldComp((Property)path).apply(struc -> {
            ((TextField)struc.get()).focusedProperty().addListener((observable, oldValue, newValue) -> {
                if (!firstFocus.get()) {
                    ((TextField)struc.get()).getParent().requestFocus();
                    firstFocus.set(true);
                }
            });
            ((TextField)struc.get()).setPromptText("mycommand open localhost:$PORT");
        });
        return new OptionsBuilder().nameAndDescription("serviceCommand").addComp(comp, (Property)path).bind(() -> new ServiceProtocolType.Custom(path.get()), new Property[]{p});
    }

    private static OptionsBuilder http(Property<ServiceProtocolType.Http> p) {
        SimpleStringProperty path = new SimpleStringProperty(p.getValue() != null ? ((ServiceProtocolType.Http)p.getValue()).getPath() : null);
        return new OptionsBuilder().nameAndDescription("servicePath").addString((Property)path).bind(() -> new ServiceProtocolType.Http(path.get()), new Property[]{p});
    }

    private static OptionsBuilder https(Property<ServiceProtocolType.Https> p) {
        SimpleStringProperty path = new SimpleStringProperty(p.getValue() != null ? ((ServiceProtocolType.Https)p.getValue()).getPath() : null);
        return new OptionsBuilder().nameAndDescription("servicePath").addString((Property)path).bind(() -> new ServiceProtocolType.Https(path.get()), new Property[]{p});
    }

    public static OptionsBuilder choice(Property<ServiceProtocolType> serviceProtocolType) {
        ServiceProtocolType.Custom c;
        ServiceProtocolType.Https h;
        ServiceProtocolType.Http h2;
        ServiceProtocolType ex = (ServiceProtocolType)serviceProtocolType.getValue();
        SimpleObjectProperty http = new SimpleObjectProperty(ex instanceof ServiceProtocolType.Http ? (h2 = (ServiceProtocolType.Http)ex) : null);
        SimpleObjectProperty https = new SimpleObjectProperty(ex instanceof ServiceProtocolType.Https ? (h = (ServiceProtocolType.Https)ex) : null);
        SimpleObjectProperty custom = new SimpleObjectProperty(ex instanceof ServiceProtocolType.Custom ? (c = (ServiceProtocolType.Custom)ex) : null);
        SimpleIntegerProperty selected = new SimpleIntegerProperty(ex instanceof ServiceProtocolType.Undefined ? 0 : (ex instanceof ServiceProtocolType.Http ? 1 : (ex instanceof ServiceProtocolType.Https ? 2 : (ex instanceof ServiceProtocolType.Custom ? 3 : -1))));
        LinkedHashMap<ObservableValue, OptionsBuilder> available = new LinkedHashMap<ObservableValue, OptionsBuilder>();
        available.put(AppI18n.observable((String)"undefined", (Object[])new Object[0]), new OptionsBuilder());
        available.put(AppI18n.observable((String)"http", (Object[])new Object[0]), ServiceProtocolTypeHelper.http((Property<ServiceProtocolType.Http>)http));
        available.put(AppI18n.observable((String)"https", (Object[])new Object[0]), ServiceProtocolTypeHelper.https((Property<ServiceProtocolType.Https>)https));
        available.put(AppI18n.observable((String)"custom", (Object[])new Object[0]), ServiceProtocolTypeHelper.custom((Property<ServiceProtocolType.Custom>)custom));
        return new OptionsBuilder().nameAndDescription("serviceProtocolType").choice((IntegerProperty)selected, available).bindChoice(() -> switch (selected.get()) {
            case 0 -> new SimpleObjectProperty((Object)new ServiceProtocolType.Undefined());
            case 1 -> http;
            case 2 -> https;
            case 3 -> custom;
            default -> new SimpleObjectProperty();
        }, serviceProtocolType);
    }
}

