/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.service;

import io.xpipe.app.comp.Comp;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreCreationCategory;
import io.xpipe.app.ext.GuiDialog;
import io.xpipe.app.ext.NetworkTunnelStore;
import io.xpipe.app.hub.comp.StoreCategoryWrapper;
import io.xpipe.app.hub.comp.StoreChoiceComp;
import io.xpipe.app.hub.comp.StoreViewState;
import io.xpipe.app.storage.DataStoreCategory;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.OptionsBuilder;
import io.xpipe.ext.base.service.AbstractServiceStore;
import io.xpipe.ext.base.service.AbstractServiceStoreProvider;
import io.xpipe.ext.base.service.CustomServiceStore;
import io.xpipe.ext.base.service.ServiceProtocolType;
import io.xpipe.ext.base.service.ServiceProtocolTypeHelper;
import java.util.List;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;

public class CustomServiceStoreProvider
extends AbstractServiceStoreProvider {
    public int getOrderPriority() {
        return -1;
    }

    public DataStoreCreationCategory getCreationCategory() {
        return DataStoreCreationCategory.SERVICE;
    }

    public GuiDialog guiDialog(DataStoreEntry entry, Property<DataStore> store) {
        CustomServiceStore st = (CustomServiceStore)((DataStore)store.getValue()).asNeeded();
        SimpleObjectProperty host = new SimpleObjectProperty(st.getHost());
        SimpleObjectProperty localPort = new SimpleObjectProperty((Object)st.getLocalPort());
        SimpleObjectProperty remotePort = new SimpleObjectProperty((Object)st.getRemotePort());
        SimpleObjectProperty serviceProtocolType = new SimpleObjectProperty((Object)st.getServiceProtocolType());
        OptionsBuilder q = new OptionsBuilder().nameAndDescription("serviceHost").addComp((Comp)StoreChoiceComp.other((Property)host, NetworkTunnelStore.class, n -> ((NetworkTunnelStore)n.getStore()).isLocallyTunnelable(), (StoreCategoryWrapper)StoreViewState.get().getAllConnectionsCategory()), (Property)host).nonNull().nameAndDescription("serviceRemotePort").addInteger((Property)remotePort).nonNull().sub(ServiceProtocolTypeHelper.choice((Property<ServiceProtocolType>)serviceProtocolType), (Property)serviceProtocolType).nonNull().nameAndDescription("serviceLocalPort").addInteger((Property)localPort).bind(() -> ((CustomServiceStore.CustomServiceStoreBuilder)((CustomServiceStore.CustomServiceStoreBuilder)((CustomServiceStore.CustomServiceStoreBuilder)((AbstractServiceStore.AbstractServiceStoreBuilder)CustomServiceStore.builder().host((DataStoreEntryRef<NetworkTunnelStore>)((DataStoreEntryRef)host.get()))).localPort((Integer)localPort.get())).remotePort((Integer)remotePort.get())).serviceProtocolType((ServiceProtocolType)serviceProtocolType.get())).build(), new Property[]{store});
        return q.buildDialog();
    }

    public DataStore defaultStore(DataStoreCategory category) {
        return CustomServiceStore.builder().build();
    }

    public String getId() {
        return "customService";
    }

    public List<Class<?>> getStoreClasses() {
        return List.of(CustomServiceStore.class);
    }
}

