/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.script;

import io.xpipe.app.comp.Comp;
import io.xpipe.app.comp.base.IntegratedTextAreaComp;
import io.xpipe.app.comp.base.ListSelectorComp;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreCreationCategory;
import io.xpipe.app.ext.DataStoreProvider;
import io.xpipe.app.ext.EnabledParentStoreProvider;
import io.xpipe.app.ext.GuiDialog;
import io.xpipe.app.ext.ShellDialectChoiceComp;
import io.xpipe.app.hub.comp.StoreChoiceComp;
import io.xpipe.app.hub.comp.StoreEntryWrapper;
import io.xpipe.app.hub.comp.StoreListChoiceComp;
import io.xpipe.app.hub.comp.StoreSection;
import io.xpipe.app.hub.comp.StoreViewState;
import io.xpipe.app.hub.comp.SystemStateComp;
import io.xpipe.app.process.OsFileSystem;
import io.xpipe.app.process.ShellDialect;
import io.xpipe.app.process.ShellDialects;
import io.xpipe.app.storage.DataStoreCategory;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.DataStoreFormatter;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.app.util.OptionsBuilder;
import io.xpipe.app.util.Validator;
import io.xpipe.core.OsType;
import io.xpipe.ext.base.script.ScriptGroupStore;
import io.xpipe.ext.base.script.ScriptStore;
import io.xpipe.ext.base.script.SimpleScriptStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Stream;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ListProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;

public class SimpleScriptStoreProvider
implements EnabledParentStoreProvider,
DataStoreProvider {
    public DocumentationLink getHelpLink() {
        return DocumentationLink.SCRIPTING;
    }

    public boolean canMoveCategories() {
        return false;
    }

    public boolean showProviderChoice() {
        return false;
    }

    public boolean shouldShowScan() {
        return false;
    }

    public Comp<?> stateDisplay(StoreEntryWrapper w) {
        return new SystemStateComp((ObservableValue)new SimpleObjectProperty((Object)SystemStateComp.State.SUCCESS));
    }

    public DataStoreCreationCategory getCreationCategory() {
        return DataStoreCreationCategory.SCRIPT;
    }

    public DataStoreEntry getDisplayParent(DataStoreEntry store) {
        SimpleScriptStore st = (SimpleScriptStore)store.getStore().asNeeded();
        return st.getGroup().get();
    }

    public GuiDialog guiDialog(DataStoreEntry entry, Property<DataStore> store) {
        SimpleScriptStore st = (SimpleScriptStore)((DataStore)store.getValue()).asNeeded();
        SimpleObjectProperty group = new SimpleObjectProperty(st.getGroup());
        SimpleObjectProperty dialect = new SimpleObjectProperty((Object)st.getMinimumDialect());
        SimpleListProperty others = new SimpleListProperty(FXCollections.observableArrayList(new ArrayList<DataStoreEntryRef<ScriptStore>>(st.getEffectiveScripts())));
        SimpleObjectProperty commandProp = new SimpleObjectProperty((Object)st.getCommands());
        List<ShellDialect> availableDialects = List.of(ShellDialects.SH, ShellDialects.BASH, ShellDialects.ZSH, ShellDialects.FISH, ShellDialects.CMD, ShellDialects.POWERSHELL, ShellDialects.POWERSHELL_CORE);
        ShellDialectChoiceComp choice = new ShellDialectChoiceComp(availableDialects, (Property)dialect, ShellDialectChoiceComp.NullHandling.NULL_IS_ALL);
        List<Integer> vals = List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3));
        ArrayList<Integer> selectedStart = new ArrayList<Integer>();
        if (st.isInitScript()) {
            selectedStart.add(0);
        }
        if (st.isRunnableScript()) {
            selectedStart.add(1);
        }
        if (st.isFileScript()) {
            selectedStart.add(2);
        }
        if (st.isShellScript()) {
            selectedStart.add(3);
        }
        Function<Integer, String> name = new Function<Integer, String>(this){

            @Override
            public String apply(Integer integer) {
                if (integer == 0) {
                    return AppI18n.get((String)"initScript", (Object[])new Object[0]);
                }
                if (integer == 1) {
                    return AppI18n.get((String)"runnableScript", (Object[])new Object[0]);
                }
                if (integer == 2) {
                    return AppI18n.get((String)"fileScript", (Object[])new Object[0]);
                }
                if (integer == 3) {
                    return AppI18n.get((String)"shellScript", (Object[])new Object[0]);
                }
                return "?";
            }
        };
        SimpleListProperty selectedExecTypes = new SimpleListProperty(FXCollections.observableList(selectedStart));
        ListSelectorComp selectorComp = new ListSelectorComp(FXCollections.observableList(vals), (Function)name, (ListProperty)selectedExecTypes, v -> false, () -> false);
        return new OptionsBuilder().name("minimumShellDialect").description("minimumShellDialectDescription").longDescription(DocumentationLink.SCRIPTING_COMPATIBILITY).addComp((Comp)choice, (Property)dialect).name("scriptContents").description("scriptContentsDescription").longDescription(DocumentationLink.SCRIPTING_EDITING).addComp((Comp)new IntegratedTextAreaComp((Property)commandProp, false, "commands", (ObservableValue)Bindings.createStringBinding(() -> SimpleScriptStoreProvider.lambda$guiDialog$2((Property)dialect), (Observable[])new Observable[0])), (Property)commandProp).nameAndDescription("executionType").longDescription(DocumentationLink.SCRIPTING_TYPES).addComp((Comp)selectorComp, (Property)selectedExecTypes).check(validator -> Validator.nonEmpty((Validator)validator, (ObservableValue)AppI18n.observable((String)"executionType", (Object[])new Object[0]), (ReadOnlyListProperty)selectedExecTypes)).name("snippets").description("snippetsDescription").longDescription(DocumentationLink.SCRIPTING_DEPENDENCIES).addComp((Comp)new StoreListChoiceComp((ListProperty)others, ScriptStore.class, scriptStore -> !scriptStore.get().equals((Object)entry) && !others.contains(scriptStore), StoreViewState.get().getAllScriptsCategory()), (Property)others).name("scriptGroup").description("scriptGroupDescription").longDescription(DocumentationLink.SCRIPTING_GROUPS).addComp((Comp)new StoreChoiceComp(StoreChoiceComp.Mode.OTHER, null, (Property)group, ScriptGroupStore.class, null, StoreViewState.get().getAllScriptsCategory()), (Property)group).nonNull().bind(() -> SimpleScriptStoreProvider.lambda$guiDialog$5(group, (Property)dialect, others, st, (Property)commandProp, selectedExecTypes), new Property[]{store}).buildDialog();
    }

    public String summaryString(StoreEntryWrapper wrapper) {
        SimpleScriptStore st = (SimpleScriptStore)wrapper.getEntry().getStore().asNeeded();
        if (!st.isShellScript()) {
            return null;
        }
        String name = ((String)wrapper.getName().getValue()).toLowerCase(Locale.ROOT).replaceAll(" ", "_");
        if (st.getMinimumDialect() == null) {
            return OsFileSystem.of((OsType)OsType.LINUX).makeFileSystemCompatible(name) + ".sh";
        }
        OsType.Windows os = st.getMinimumDialect() == ShellDialects.CMD || ShellDialects.isPowershell((ShellDialect)st.getMinimumDialect()) ? OsType.WINDOWS : OsType.LINUX;
        return OsFileSystem.of((OsType)os).makeFileSystemCompatible(name) + "." + st.getMinimumDialect().getScriptFileEnding();
    }

    public ObservableValue<String> informationString(StoreSection section) {
        SimpleScriptStore st = (SimpleScriptStore)section.getWrapper().getEntry().getStore().asNeeded();
        String init = st.isInitScript() ? AppI18n.get((String)"init", (Object[])new Object[0]) : null;
        String file = st.isFileScript() ? AppI18n.get((String)"fileBrowser", (Object[])new Object[0]) : null;
        String shell = st.isShellScript() ? AppI18n.get((String)"shell", (Object[])new Object[0]) : null;
        String runnable = st.isRunnableScript() ? AppI18n.get((String)"hub", (Object[])new Object[0]) : null;
        String type = st.getMinimumDialect() != null ? st.getMinimumDialect().getDisplayName() + " " + AppI18n.get((String)"script", (Object[])new Object[0]) : AppI18n.get((String)"genericScript", (Object[])new Object[0]);
        Object suffix = String.join((CharSequence)" / ", Stream.of(init, shell, file, runnable).filter(s -> s != null).toList());
        suffix = !((String)suffix).isEmpty() ? "(" + (String)suffix + ")" : null;
        return new SimpleStringProperty(DataStoreFormatter.join((String[])new String[]{type, suffix}));
    }

    public String getDisplayIconFileName(DataStore store) {
        if (store == null) {
            return "proc:shellEnvironment_icon.svg";
        }
        SimpleScriptStore st = (SimpleScriptStore)store.asNeeded();
        return ShellDialectChoiceComp.getImageName((ShellDialect)st.getMinimumDialect());
    }

    public DataStore defaultStore(DataStoreCategory category) {
        return ((SimpleScriptStore.SimpleScriptStoreBuilder)SimpleScriptStore.builder().scripts(List.of())).build();
    }

    public String getId() {
        return "script";
    }

    public List<Class<?>> getStoreClasses() {
        return List.of(SimpleScriptStore.class);
    }

    private static /* synthetic */ SimpleScriptStore lambda$guiDialog$5(SimpleObjectProperty group, Property dialect, SimpleListProperty others, SimpleScriptStore st, Property commandProp, SimpleListProperty selectedExecTypes) {
        return ((SimpleScriptStore.SimpleScriptStoreBuilder)((SimpleScriptStore.SimpleScriptStoreBuilder)((SimpleScriptStore.SimpleScriptStoreBuilder)((SimpleScriptStore.SimpleScriptStoreBuilder)((SimpleScriptStore.SimpleScriptStoreBuilder)((SimpleScriptStore.SimpleScriptStoreBuilder)((SimpleScriptStore.SimpleScriptStoreBuilder)((ScriptStore.ScriptStoreBuilder)((SimpleScriptStore.SimpleScriptStoreBuilder)SimpleScriptStore.builder().group((DataStoreEntryRef<ScriptGroupStore>)((DataStoreEntryRef)group.get()))).minimumDialect((ShellDialect)dialect.getValue())).scripts(new ArrayList(others.get()))).description(st.getDescription())).commands((String)commandProp.getValue())).initScript(selectedExecTypes.contains((Object)0))).runnableScript(selectedExecTypes.contains((Object)1))).fileScript(selectedExecTypes.contains((Object)2))).shellScript(selectedExecTypes.contains((Object)3))).build();
    }

    private static /* synthetic */ String lambda$guiDialog$2(Property dialect) throws Exception {
        return dialect.getValue() != null ? ((ShellDialect)dialect.getValue()).getScriptFileEnding() : "sh";
    }
}

