/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.script;

import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.ext.EnabledStoreState;
import io.xpipe.app.ext.StatefulDataStore;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.OsFileSystem;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialect;
import io.xpipe.app.process.ShellTerminalInitCommand;
import io.xpipe.app.process.SystemState;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.ShellTemp;
import io.xpipe.core.FilePath;
import io.xpipe.core.OsType;
import io.xpipe.ext.base.script.ScriptStore;
import io.xpipe.ext.base.script.SimpleScriptStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;

public class ScriptStoreSetup {
    public static void controlWithDefaultScripts(ShellControl pc) {
        ScriptStoreSetup.controlWithScripts(pc, ScriptStoreSetup.getEnabledScripts());
    }

    public static void controlWithScripts(ShellControl pc, List<DataStoreEntryRef<ScriptStore>> enabledScripts) {
        try {
            StatefulDataStore sds;
            DataStoreState state;
            Object t;
            Optional source;
            ShellDialect dialect = pc.getShellDialect();
            if (dialect == null && (source = pc.getSourceStore()).isPresent() && (t = source.get()) instanceof StatefulDataStore && (state = (sds = (StatefulDataStore)t).getState()) instanceof SystemState) {
                SystemState systemState = (SystemState)state;
                dialect = systemState.getShellDialect();
            }
            ShellDialect finalDialect = dialect;
            List<DataStoreEntryRef> initFlattened = ScriptStoreSetup.flatten(enabledScripts).stream().filter(store -> ((SimpleScriptStore)store.getStore()).isInitScript()).filter(store -> finalDialect == null || ((SimpleScriptStore)store.getStore()).isCompatible(finalDialect)).toList();
            final List<DataStoreEntryRef> bringFlattened = ScriptStoreSetup.flatten(enabledScripts).stream().filter(store -> ((SimpleScriptStore)store.getStore()).isShellScript()).filter(store -> finalDialect == null || ((SimpleScriptStore)store.getStore()).isCompatible(finalDialect)).toList();
            if (initFlattened.isEmpty() && bringFlattened.isEmpty()) {
                return;
            }
            initFlattened.forEach(s -> pc.withInitSnippet(new ShellTerminalInitCommand((DataStoreEntryRef)s){
                final /* synthetic */ DataStoreEntryRef val$s;
                {
                    this.val$s = dataStoreEntryRef;
                }

                public Optional<String> terminalContent(ShellControl shellControl) {
                    return Optional.ofNullable(((SimpleScriptStore)this.val$s.getStore()).assembleScriptChain(shellControl));
                }

                public boolean canPotentiallyRunInDialect(ShellDialect dialect) {
                    return ((SimpleScriptStore)this.val$s.getStore()).isCompatible(dialect);
                }
            }));
            if (!bringFlattened.isEmpty()) {
                pc.withInitSnippet(new ShellTerminalInitCommand(){
                    String dir;

                    public Optional<String> terminalContent(ShellControl shellControl) throws Exception {
                        if (this.dir == null) {
                            this.dir = ScriptStoreSetup.initScriptsDirectory(shellControl, bringFlattened);
                        }
                        if (this.dir == null) {
                            return Optional.empty();
                        }
                        return Optional.ofNullable(shellControl.getShellDialect().addToPathVariableCommand(List.of(this.dir), true));
                    }

                    public boolean canPotentiallyRunInDialect(ShellDialect dialect) {
                        return true;
                    }
                });
            }
        }
        catch (StackOverflowError t) {
            throw (RuntimeException)ErrorEventFactory.expected((Throwable)new RuntimeException("Unable to set up scripts. Is there a circular script dependency?", t));
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to set up scripts", t);
        }
    }

    private static String initScriptsDirectory(ShellControl proc, List<DataStoreEntryRef<SimpleScriptStore>> refs) throws Exception {
        if (refs.isEmpty()) {
            return null;
        }
        List<DataStoreEntryRef> applicable = refs.stream().filter(simpleScriptStore -> ((SimpleScriptStore)simpleScriptStore.getStore()).isCompatible(proc.getShellDialect())).toList();
        if (applicable.isEmpty()) {
            return null;
        }
        int hash = refs.stream().mapToInt(value -> value.get().getName().hashCode() + ((SimpleScriptStore)value.getStore()).hashCode()).sum();
        String targetDir = ShellTemp.createUserSpecificTempDataDirectory((ShellControl)proc, (String)"scripts").join(new String[]{proc.getShellDialect().getId()}).toString();
        FilePath hashFile = FilePath.of((String[])new String[]{targetDir, "hash"});
        ShellDialect d = proc.getShellDialect();
        if (d.createFileExistsCommand(proc, hashFile.toString()).executeAndCheck()) {
            String read = d.getFileReadCommand(proc, hashFile.toString()).readStdoutOrThrow();
            try {
                int readHash = Integer.parseInt(read);
                if (hash == readHash) {
                    return targetDir;
                }
            }
            catch (NumberFormatException e) {
                ErrorEventFactory.fromThrowable((Throwable)e).expected().omit().handle();
            }
        }
        if (d.directoryExists(proc, targetDir).executeAndCheck()) {
            d.deleteFileOrDirectory(proc, targetDir).execute();
        }
        proc.executeSimpleCommand(d.getMkdirsCommand(targetDir));
        for (DataStoreEntryRef<SimpleScriptStore> scriptStore : refs) {
            String content = d.prepareScriptContent(proc, ((SimpleScriptStore)scriptStore.getStore()).getCommands());
            String fileName = OsFileSystem.of((OsType)proc.getOsType()).makeFileSystemCompatible(scriptStore.get().getName().toLowerCase(Locale.ROOT).replaceAll(" ", "_"));
            FilePath scriptFile = FilePath.of((String[])new String[]{targetDir, fileName + "." + d.getScriptFileEnding()});
            proc.view().writeScriptFile(scriptFile, content);
        }
        proc.view().writeTextFile(hashFile, String.valueOf(hash));
        return targetDir;
    }

    public static List<DataStoreEntryRef<ScriptStore>> getEnabledScripts() {
        return DataStorage.get().getStoreEntries().stream().filter(dataStoreEntry -> {
            ScriptStore scriptStore;
            DataStore patt0$temp;
            return dataStoreEntry.getValidity().isUsable() && (patt0$temp = dataStoreEntry.getStore()) instanceof ScriptStore && ((EnabledStoreState)(scriptStore = (ScriptStore)patt0$temp).getState()).isEnabled();
        }).map(DataStoreEntry::ref).toList();
    }

    public static List<DataStoreEntryRef<SimpleScriptStore>> flatten(List<DataStoreEntryRef<ScriptStore>> scripts) {
        LinkedHashSet seen = new LinkedHashSet();
        scripts.stream().filter(scriptStoreDataStoreEntryRef -> scriptStoreDataStoreEntryRef.get().getValidity().isUsable()).forEach(scriptStoreDataStoreEntryRef -> ((ScriptStore)scriptStoreDataStoreEntryRef.getStore()).queryFlattenedScripts(seen));
        HashMap dependencies = new HashMap();
        seen.forEach(ref -> {
            HashSet<DataStoreEntryRef<SimpleScriptStore>> f = new HashSet<DataStoreEntryRef<SimpleScriptStore>>(((SimpleScriptStore)ref.getStore()).queryFlattenedScripts());
            f.remove(ref);
            dependencies.put(ref, f);
        });
        ArrayList<DataStoreEntryRef<SimpleScriptStore>> sorted = new ArrayList<DataStoreEntryRef<SimpleScriptStore>>(seen);
        sorted.sort((o1, o2) -> {
            if (((Set)dependencies.get(o1)).contains(o2)) {
                return 1;
            }
            if (((Set)dependencies.get(o2)).contains(o1)) {
                return -1;
            }
            return 0;
        });
        return sorted;
    }
}

