/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.script;

import io.xpipe.app.ext.DataStore;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.ext.base.script.ScriptGroupStore;
import io.xpipe.ext.base.script.ScriptStore;
import io.xpipe.ext.base.script.ScriptStoreSetup;
import io.xpipe.ext.base.script.SimpleScriptStore;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.Generated;

public final class ScriptHierarchy {
    private final DataStoreEntryRef<? extends ScriptStore> base;
    private final List<ScriptHierarchy> children;

    public static ScriptHierarchy buildEnabledHierarchy(Predicate<DataStoreEntryRef<SimpleScriptStore>> include) {
        HashSet<DataStoreEntryRef<ScriptStore>> all = new HashSet<DataStoreEntryRef<ScriptStore>>(ScriptStoreSetup.getEnabledScripts());
        for (DataStoreEntryRef<ScriptStore> dataStoreEntryRef : new HashSet<DataStoreEntryRef<ScriptStore>>(all)) {
            DataStore dataStore = dataStoreEntryRef.getStore();
            if (!(dataStore instanceof ScriptGroupStore)) continue;
            ScriptGroupStore groupStore = (ScriptGroupStore)dataStore;
            all.addAll(groupStore.getEffectiveScripts());
        }
        Iterator<DataStoreEntryRef<ScriptStore>> iterator = new HashSet<DataStoreEntryRef<ScriptStore>>(all).iterator();
        while (iterator.hasNext()) {
            Optional parent;
            DataStoreEntryRef dataStoreEntryRef;
            DataStoreEntryRef current = dataStoreEntryRef = iterator.next();
            while ((parent = DataStorage.get().getDefaultDisplayParent(current.get())).isPresent()) {
                DataStoreEntryRef next = ((DataStoreEntry)parent.get()).ref();
                all.add((DataStoreEntryRef<ScriptStore>)next);
                current = next;
            }
        }
        List<DataStoreEntryRef> top = all.stream().filter(ref -> {
            Optional parent = DataStorage.get().getDefaultDisplayParent(ref.get());
            return parent.isEmpty();
        }).toList();
        List<ScriptHierarchy> list = top.stream().map(ref -> ScriptHierarchy.buildHierarchy((DataStoreEntryRef<ScriptStore>)ref, check -> {
            if (!(check.getStore() instanceof SimpleScriptStore)) {
                return true;
            }
            if (!include.test(check.asNeeded())) {
                return false;
            }
            return all.contains(check);
        })).map(hierarchy -> ScriptHierarchy.condenseHierarchy(hierarchy)).filter(hierarchy -> hierarchy.show()).sorted(Comparator.comparing(scriptHierarchy -> scriptHierarchy.getBase().get().getName().toLowerCase())).toList();
        return ScriptHierarchy.condenseHierarchy(new ScriptHierarchy(null, list));
    }

    private static ScriptHierarchy buildHierarchy(DataStoreEntryRef<ScriptStore> ref, Predicate<DataStoreEntryRef<ScriptStore>> include) {
        DataStore dataStore = ref.getStore();
        if (dataStore instanceof ScriptGroupStore) {
            ScriptGroupStore groupStore = (ScriptGroupStore)dataStore;
            List<ScriptHierarchy> children = groupStore.getImmediateChildrenScripts().stream().filter(include).map(c -> ScriptHierarchy.buildHierarchy((DataStoreEntryRef<ScriptStore>)c, include)).filter(hierarchy -> hierarchy.show()).sorted(Comparator.comparing(scriptHierarchy -> scriptHierarchy.getBase().get().getName().toLowerCase())).toList();
            return new ScriptHierarchy(ref, children);
        }
        return new ScriptHierarchy(ref, List.of());
    }

    public static ScriptHierarchy condenseHierarchy(ScriptHierarchy hierarchy) {
        List<ScriptHierarchy> children = hierarchy.getChildren().stream().map(c -> ScriptHierarchy.condenseHierarchy(c)).toList();
        if (children.size() == 1 && !children.getFirst().isLeaf()) {
            List<ScriptHierarchy> nestedChildren = children.getFirst().getChildren();
            return new ScriptHierarchy(hierarchy.getBase(), nestedChildren);
        }
        return new ScriptHierarchy(hierarchy.getBase(), children);
    }

    public boolean show() {
        return this.isLeaf() || !this.isEmptyBranch();
    }

    public boolean isEmptyBranch() {
        return (this.base == null || this.base.getStore() instanceof ScriptGroupStore) && this.children.isEmpty();
    }

    public boolean isLeaf() {
        return this.base != null && this.base.getStore() instanceof SimpleScriptStore && this.children.isEmpty();
    }

    public DataStoreEntryRef<SimpleScriptStore> getLeafBase() {
        return this.base.asNeeded();
    }

    @Generated
    public ScriptHierarchy(DataStoreEntryRef<? extends ScriptStore> base, List<ScriptHierarchy> children) {
        this.base = base;
        this.children = children;
    }

    @Generated
    public DataStoreEntryRef<? extends ScriptStore> getBase() {
        return this.base;
    }

    @Generated
    public List<ScriptHierarchy> getChildren() {
        return this.children;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScriptHierarchy)) {
            return false;
        }
        ScriptHierarchy other = (ScriptHierarchy)o;
        DataStoreEntryRef<? extends ScriptStore> this$base = this.getBase();
        DataStoreEntryRef<? extends ScriptStore> other$base = other.getBase();
        if (this$base == null ? other$base != null : !this$base.equals(other$base)) {
            return false;
        }
        List<ScriptHierarchy> this$children = this.getChildren();
        List<ScriptHierarchy> other$children = other.getChildren();
        return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DataStoreEntryRef<? extends ScriptStore> $base = this.getBase();
        result = result * 59 + ($base == null ? 43 : $base.hashCode());
        List<ScriptHierarchy> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ScriptHierarchy(base=" + String.valueOf(this.getBase()) + ", children=" + String.valueOf(this.getChildren()) + ")";
    }
}

