/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.identity;

import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreCreationCategory;
import io.xpipe.app.ext.GuiDialog;
import io.xpipe.app.prefs.AppPrefs;
import io.xpipe.app.prefs.PasswordManagerTestComp;
import io.xpipe.app.storage.DataStorageUserHandler;
import io.xpipe.app.storage.DataStoreCategory;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.util.OptionsBuilder;
import io.xpipe.ext.base.identity.IdentityStoreProvider;
import io.xpipe.ext.base.identity.PasswordManagerIdentityStore;
import java.util.List;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class PasswordManagerIdentityStoreProvider
extends IdentityStoreProvider {
    @Override
    public DataStoreCreationCategory getCreationCategory() {
        return AppPrefs.get().passwordManager().getValue() != null ? DataStoreCreationCategory.IDENTITY : null;
    }

    public GuiDialog guiDialog(DataStoreEntry entry, Property<DataStore> store) {
        PasswordManagerIdentityStore st = (PasswordManagerIdentityStore)store.getValue();
        SimpleStringProperty key = new SimpleStringProperty(st.getKey());
        SimpleBooleanProperty perUser = new SimpleBooleanProperty(st.isPerUser());
        PasswordManagerTestComp comp = new PasswordManagerTestComp((StringProperty)key, false);
        return new OptionsBuilder().nameAndDescription("passwordManagerKey").addComp(comp.hgrow(), (Property)key).nonNull().nameAndDescription(DataStorageUserHandler.getInstance().getActiveUser() != null ? "identityPerUser" : "identityPerUserDisabled").addToggle((Property)perUser).hide(DataStorageUserHandler.getInstance().getActiveUser() == null).bind(() -> ((PasswordManagerIdentityStore.PasswordManagerIdentityStoreBuilder)PasswordManagerIdentityStore.builder().key(key.get())).build(), new Property[]{store}).buildDialog();
    }

    public DataStore defaultStore(DataStoreCategory category) {
        return ((PasswordManagerIdentityStore.PasswordManagerIdentityStoreBuilder)PasswordManagerIdentityStore.builder().key(null)).build();
    }

    public String getId() {
        return "passwordManagerIdentity";
    }

    public List<Class<?>> getStoreClasses() {
        return List.of(PasswordManagerIdentityStore.class);
    }
}

