/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.identity;

import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.GuiDialog;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreCategory;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.app.util.EncryptedValue;
import io.xpipe.app.util.OptionsBuilder;
import io.xpipe.app.util.OptionsChoiceBuilder;
import io.xpipe.app.util.SecretRetrievalStrategy;
import io.xpipe.app.util.SecretRetrievalStrategyHelper;
import io.xpipe.ext.base.identity.IdentityStoreProvider;
import io.xpipe.ext.base.identity.LocalIdentityStore;
import io.xpipe.ext.base.identity.ssh.NoneStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategyChoiceConfig;
import java.util.List;
import java.util.UUID;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;

public class LocalIdentityStoreProvider
extends IdentityStoreProvider {
    public UUID getTargetCategory(DataStore store, UUID target) {
        DataStoreCategory cat = (DataStoreCategory)DataStorage.get().getStoreCategoryIfPresent(target).orElseThrow();
        boolean inLocal = DataStorage.get().getCategoryParentHierarchy(cat).stream().anyMatch(dataStoreCategory -> dataStoreCategory.getUuid() == DataStorage.LOCAL_IDENTITIES_CATEGORY_UUID);
        return inLocal ? target : DataStorage.LOCAL_IDENTITIES_CATEGORY_UUID;
    }

    public GuiDialog guiDialog(DataStoreEntry entry, Property<DataStore> store) {
        LocalIdentityStore st = (LocalIdentityStore)store.getValue();
        SimpleStringProperty user = new SimpleStringProperty(st.getUsername().get());
        SimpleObjectProperty pass = new SimpleObjectProperty((Object)st.getPassword());
        SimpleObjectProperty identity = new SimpleObjectProperty((Object)st.getSshIdentity());
        SshIdentityStrategyChoiceConfig sshIdentityChoiceConfig = SshIdentityStrategyChoiceConfig.builder().allowAgentForward(true).proxy((Property<DataStoreEntryRef<ShellStore>>)new ReadOnlyObjectWrapper((Object)DataStorage.get().local().ref())).allowKeyFileSync(false).perUserKeyFileCheck(() -> false).build();
        return new OptionsBuilder().nameAndDescription("username").addString((Property)user).name("passwordAuthentication").description("passwordAuthenticationDescription").sub(SecretRetrievalStrategyHelper.comp((Property)pass, (boolean)true), (Property)pass).name("keyAuthentication").description("keyAuthenticationDescription").longDescription(DocumentationLink.SSH_KEYS).sub(OptionsChoiceBuilder.builder().allowNull(false).property((Property)identity).customConfiguration((Object)sshIdentityChoiceConfig).available(SshIdentityStrategy.getSubclasses()).build().build(), (Property)identity).bind(() -> ((LocalIdentityStore.LocalIdentityStoreBuilder)((LocalIdentityStore.LocalIdentityStoreBuilder)((LocalIdentityStore.LocalIdentityStoreBuilder)LocalIdentityStore.builder().username(user.get())).password((EncryptedValue<SecretRetrievalStrategy>)(st.getEncryptedPassword() != null ? st.getEncryptedPassword().withValue((Object)((SecretRetrievalStrategy)pass.get())) : EncryptedValue.of((Object)((SecretRetrievalStrategy)pass.get()))))).sshIdentity((EncryptedValue<SshIdentityStrategy>)(st.getEncryptedSshIdentity() != null ? st.getEncryptedSshIdentity().withValue((Object)((SshIdentityStrategy)identity.get())) : EncryptedValue.of((Object)((SshIdentityStrategy)identity.get()))))).build(), new Property[]{store}).buildDialog();
    }

    public DataStore defaultStore(DataStoreCategory category) {
        return ((LocalIdentityStore.LocalIdentityStoreBuilder)((LocalIdentityStore.LocalIdentityStoreBuilder)LocalIdentityStore.builder().password((EncryptedValue<SecretRetrievalStrategy>)EncryptedValue.of((Object)new SecretRetrievalStrategy.None()))).sshIdentity((EncryptedValue<SshIdentityStrategy>)EncryptedValue.of((Object)new NoneStrategy()))).build();
    }

    public String getId() {
        return "localIdentity";
    }

    public List<Class<?>> getStoreClasses() {
        return List.of(LocalIdentityStore.class);
    }
}

