/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.identity;

import io.xpipe.app.comp.Comp;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.app.util.EncryptedValue;
import io.xpipe.app.util.OptionsBuilder;
import io.xpipe.app.util.OptionsChoiceBuilder;
import io.xpipe.app.util.SecretRetrievalStrategy;
import io.xpipe.app.util.SecretRetrievalStrategyHelper;
import io.xpipe.ext.base.identity.IdentitySelectComp;
import io.xpipe.ext.base.identity.IdentityStore;
import io.xpipe.ext.base.identity.IdentityValue;
import io.xpipe.ext.base.identity.LocalIdentityStore;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategyChoiceConfig;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import lombok.Generated;

public final class IdentityChoiceBuilder {
    private final Property<DataStoreEntryRef<ShellStore>> host;
    private final ObjectProperty<IdentityValue> identity;
    private final boolean allowCustomUserInput;
    private final boolean requireUserInput;
    private final boolean requirePassword;
    private final boolean keyInput;
    private final boolean allowAgentForward;
    private final String userChoiceTranslationKey;
    private final String passwordChoiceTranslationKey;

    public static OptionsBuilder ssh(Property<DataStoreEntryRef<ShellStore>> host, ObjectProperty<IdentityValue> identity, boolean requireUser) {
        IdentityChoiceBuilder i = new IdentityChoiceBuilder(host, identity, true, requireUser, true, true, true, "identityChoice", "passwordAuthentication");
        return i.build();
    }

    public static OptionsBuilder container(ObjectProperty<IdentityValue> identity) {
        IdentityChoiceBuilder i = new IdentityChoiceBuilder(null, identity, true, false, false, false, false, "customUsername", "customUsernamePassword");
        return i.build();
    }

    public OptionsBuilder build() {
        DataStoreEntryRef<IdentityStore> dataStoreEntryRef;
        IdentityValue.InPlace inPlace;
        IdentityValue.InPlace inPlace2;
        IdentityValue.InPlace inPlace3;
        IdentityValue existing = (IdentityValue)this.identity.getValue();
        SimpleStringProperty user = new SimpleStringProperty(existing instanceof IdentityValue.InPlace && (inPlace3 = (IdentityValue.InPlace)existing).unwrap() != null ? inPlace3.unwrap().getUsername().get() : null);
        SimpleObjectProperty pass = new SimpleObjectProperty(existing instanceof IdentityValue.InPlace && (inPlace2 = (IdentityValue.InPlace)existing).unwrap() != null ? inPlace2.unwrap().getPassword() : null);
        SimpleObjectProperty identityStrategy = new SimpleObjectProperty(existing instanceof IdentityValue.InPlace && (inPlace = (IdentityValue.InPlace)existing).unwrap() != null ? inPlace.unwrap().getSshIdentity() : null);
        if (existing instanceof IdentityValue.Ref) {
            IdentityValue.Ref r = (IdentityValue.Ref)existing;
            dataStoreEntryRef = r.getRef();
        } else {
            dataStoreEntryRef = null;
        }
        SimpleObjectProperty ref = new SimpleObjectProperty(dataStoreEntryRef);
        BooleanBinding inPlaceSelected = ref.isNull();
        BooleanBinding refSelected = ref.isNotNull();
        OptionsBuilder options = new OptionsBuilder().nameAndDescription(this.userChoiceTranslationKey).addComp((Comp)new IdentitySelectComp((ObjectProperty<DataStoreEntryRef<IdentityStore>>)ref, (Property<String>)user, (ObservableValue<SecretRetrievalStrategy>)pass, (ObservableValue<SshIdentityStrategy>)identityStrategy, this.allowCustomUserInput), (Property)user).nonNullIf((ObservableValue)inPlaceSelected.and((ObservableBooleanValue)new SimpleBooleanProperty(this.requireUserInput))).nameAndDescription(this.passwordChoiceTranslationKey).sub(SecretRetrievalStrategyHelper.comp((Property)pass, (boolean)true), (Property)pass).nonNullIf((ObservableValue)inPlaceSelected.and((ObservableBooleanValue)new SimpleBooleanProperty(this.requirePassword))).hide((ObservableValue)refSelected).addProperty((Property)ref);
        SshIdentityStrategyChoiceConfig sshIdentityChoiceConfig = SshIdentityStrategyChoiceConfig.builder().allowAgentForward(this.allowAgentForward).proxy((Property<DataStoreEntryRef<ShellStore>>)(this.host != null ? this.host : new ReadOnlyObjectWrapper((Object)DataStorage.get().local().ref()))).allowKeyFileSync(true).perUserKeyFileCheck(() -> false).build();
        if (this.keyInput) {
            options.name("keyAuthentication").description("keyAuthenticationDescription").longDescription(DocumentationLink.SSH_KEYS).sub(OptionsChoiceBuilder.builder().allowNull(false).property((Property)identityStrategy).customConfiguration((Object)sshIdentityChoiceConfig).available(SshIdentityStrategy.getSubclasses()).build().build(), (Property)identityStrategy).nonNullIf((ObservableValue)inPlaceSelected).disable((ObservableValue)refSelected).hide((ObservableValue)refSelected);
        }
        options.bind(() -> {
            EncryptedValue.CurrentKey i;
            if (ref.get() != null) {
                return IdentityValue.Ref.builder().ref((DataStoreEntryRef<IdentityStore>)((DataStoreEntryRef)ref.get())).build();
            }
            String u = user.get();
            EncryptedValue.CurrentKey p = EncryptedValue.CurrentKey.of((Object)((SecretRetrievalStrategy)pass.get()));
            EncryptedValue.CurrentKey currentKey = i = this.keyInput ? EncryptedValue.CurrentKey.of((Object)((SshIdentityStrategy)identityStrategy.get())) : null;
            if (u == null && p == null && i == null) {
                return null;
            }
            return IdentityValue.InPlace.builder().identityStore((LocalIdentityStore)((LocalIdentityStore.LocalIdentityStoreBuilder)((LocalIdentityStore.LocalIdentityStoreBuilder)((LocalIdentityStore.LocalIdentityStoreBuilder)LocalIdentityStore.builder().username(u)).password((EncryptedValue<SecretRetrievalStrategy>)p)).sshIdentity((EncryptedValue<SshIdentityStrategy>)i)).build()).build();
        }, new Property[]{this.identity});
        return options;
    }

    @Generated
    public static IdentityChoiceBuilderBuilder builder() {
        return new IdentityChoiceBuilderBuilder();
    }

    @Generated
    public Property<DataStoreEntryRef<ShellStore>> getHost() {
        return this.host;
    }

    @Generated
    public ObjectProperty<IdentityValue> getIdentity() {
        return this.identity;
    }

    @Generated
    public boolean isAllowCustomUserInput() {
        return this.allowCustomUserInput;
    }

    @Generated
    public boolean isRequireUserInput() {
        return this.requireUserInput;
    }

    @Generated
    public boolean isRequirePassword() {
        return this.requirePassword;
    }

    @Generated
    public boolean isKeyInput() {
        return this.keyInput;
    }

    @Generated
    public boolean isAllowAgentForward() {
        return this.allowAgentForward;
    }

    @Generated
    public String getUserChoiceTranslationKey() {
        return this.userChoiceTranslationKey;
    }

    @Generated
    public String getPasswordChoiceTranslationKey() {
        return this.passwordChoiceTranslationKey;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IdentityChoiceBuilder)) {
            return false;
        }
        IdentityChoiceBuilder other = (IdentityChoiceBuilder)o;
        if (this.isAllowCustomUserInput() != other.isAllowCustomUserInput()) {
            return false;
        }
        if (this.isRequireUserInput() != other.isRequireUserInput()) {
            return false;
        }
        if (this.isRequirePassword() != other.isRequirePassword()) {
            return false;
        }
        if (this.isKeyInput() != other.isKeyInput()) {
            return false;
        }
        if (this.isAllowAgentForward() != other.isAllowAgentForward()) {
            return false;
        }
        Property<DataStoreEntryRef<ShellStore>> this$host = this.getHost();
        Property<DataStoreEntryRef<ShellStore>> other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        ObjectProperty<IdentityValue> this$identity = this.getIdentity();
        ObjectProperty<IdentityValue> other$identity = other.getIdentity();
        if (this$identity == null ? other$identity != null : !this$identity.equals(other$identity)) {
            return false;
        }
        String this$userChoiceTranslationKey = this.getUserChoiceTranslationKey();
        String other$userChoiceTranslationKey = other.getUserChoiceTranslationKey();
        if (this$userChoiceTranslationKey == null ? other$userChoiceTranslationKey != null : !this$userChoiceTranslationKey.equals(other$userChoiceTranslationKey)) {
            return false;
        }
        String this$passwordChoiceTranslationKey = this.getPasswordChoiceTranslationKey();
        String other$passwordChoiceTranslationKey = other.getPasswordChoiceTranslationKey();
        return !(this$passwordChoiceTranslationKey == null ? other$passwordChoiceTranslationKey != null : !this$passwordChoiceTranslationKey.equals(other$passwordChoiceTranslationKey));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAllowCustomUserInput() ? 79 : 97);
        result = result * 59 + (this.isRequireUserInput() ? 79 : 97);
        result = result * 59 + (this.isRequirePassword() ? 79 : 97);
        result = result * 59 + (this.isKeyInput() ? 79 : 97);
        result = result * 59 + (this.isAllowAgentForward() ? 79 : 97);
        Property<DataStoreEntryRef<ShellStore>> $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        ObjectProperty<IdentityValue> $identity = this.getIdentity();
        result = result * 59 + ($identity == null ? 43 : $identity.hashCode());
        String $userChoiceTranslationKey = this.getUserChoiceTranslationKey();
        result = result * 59 + ($userChoiceTranslationKey == null ? 43 : $userChoiceTranslationKey.hashCode());
        String $passwordChoiceTranslationKey = this.getPasswordChoiceTranslationKey();
        result = result * 59 + ($passwordChoiceTranslationKey == null ? 43 : $passwordChoiceTranslationKey.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "IdentityChoiceBuilder(host=" + String.valueOf(this.getHost()) + ", identity=" + String.valueOf(this.getIdentity()) + ", allowCustomUserInput=" + this.isAllowCustomUserInput() + ", requireUserInput=" + this.isRequireUserInput() + ", requirePassword=" + this.isRequirePassword() + ", keyInput=" + this.isKeyInput() + ", allowAgentForward=" + this.isAllowAgentForward() + ", userChoiceTranslationKey=" + this.getUserChoiceTranslationKey() + ", passwordChoiceTranslationKey=" + this.getPasswordChoiceTranslationKey() + ")";
    }

    @Generated
    public IdentityChoiceBuilder(Property<DataStoreEntryRef<ShellStore>> host, ObjectProperty<IdentityValue> identity, boolean allowCustomUserInput, boolean requireUserInput, boolean requirePassword, boolean keyInput, boolean allowAgentForward, String userChoiceTranslationKey, String passwordChoiceTranslationKey) {
        this.host = host;
        this.identity = identity;
        this.allowCustomUserInput = allowCustomUserInput;
        this.requireUserInput = requireUserInput;
        this.requirePassword = requirePassword;
        this.keyInput = keyInput;
        this.allowAgentForward = allowAgentForward;
        this.userChoiceTranslationKey = userChoiceTranslationKey;
        this.passwordChoiceTranslationKey = passwordChoiceTranslationKey;
    }

    @Generated
    public static class IdentityChoiceBuilderBuilder {
        @Generated
        private Property<DataStoreEntryRef<ShellStore>> host;
        @Generated
        private ObjectProperty<IdentityValue> identity;
        @Generated
        private boolean allowCustomUserInput;
        @Generated
        private boolean requireUserInput;
        @Generated
        private boolean requirePassword;
        @Generated
        private boolean keyInput;
        @Generated
        private boolean allowAgentForward;
        @Generated
        private String userChoiceTranslationKey;
        @Generated
        private String passwordChoiceTranslationKey;

        @Generated
        IdentityChoiceBuilderBuilder() {
        }

        @Generated
        public IdentityChoiceBuilderBuilder host(Property<DataStoreEntryRef<ShellStore>> host) {
            this.host = host;
            return this;
        }

        @Generated
        public IdentityChoiceBuilderBuilder identity(ObjectProperty<IdentityValue> identity) {
            this.identity = identity;
            return this;
        }

        @Generated
        public IdentityChoiceBuilderBuilder allowCustomUserInput(boolean allowCustomUserInput) {
            this.allowCustomUserInput = allowCustomUserInput;
            return this;
        }

        @Generated
        public IdentityChoiceBuilderBuilder requireUserInput(boolean requireUserInput) {
            this.requireUserInput = requireUserInput;
            return this;
        }

        @Generated
        public IdentityChoiceBuilderBuilder requirePassword(boolean requirePassword) {
            this.requirePassword = requirePassword;
            return this;
        }

        @Generated
        public IdentityChoiceBuilderBuilder keyInput(boolean keyInput) {
            this.keyInput = keyInput;
            return this;
        }

        @Generated
        public IdentityChoiceBuilderBuilder allowAgentForward(boolean allowAgentForward) {
            this.allowAgentForward = allowAgentForward;
            return this;
        }

        @Generated
        public IdentityChoiceBuilderBuilder userChoiceTranslationKey(String userChoiceTranslationKey) {
            this.userChoiceTranslationKey = userChoiceTranslationKey;
            return this;
        }

        @Generated
        public IdentityChoiceBuilderBuilder passwordChoiceTranslationKey(String passwordChoiceTranslationKey) {
            this.passwordChoiceTranslationKey = passwordChoiceTranslationKey;
            return this;
        }

        @Generated
        public IdentityChoiceBuilder build() {
            return new IdentityChoiceBuilder(this.host, this.identity, this.allowCustomUserInput, this.requireUserInput, this.requirePassword, this.keyInput, this.allowAgentForward, this.userChoiceTranslationKey, this.passwordChoiceTranslationKey);
        }

        @Generated
        public String toString() {
            return "IdentityChoiceBuilder.IdentityChoiceBuilderBuilder(host=" + String.valueOf(this.host) + ", identity=" + String.valueOf(this.identity) + ", allowCustomUserInput=" + this.allowCustomUserInput + ", requireUserInput=" + this.requireUserInput + ", requirePassword=" + this.requirePassword + ", keyInput=" + this.keyInput + ", allowAgentForward=" + this.allowAgentForward + ", userChoiceTranslationKey=" + this.userChoiceTranslationKey + ", passwordChoiceTranslationKey=" + this.passwordChoiceTranslationKey + ")";
        }
    }
}

