/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.user;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.xpipe.app.comp.Comp;
import io.xpipe.app.core.AppCache;
import io.xpipe.app.core.AppRestart;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.prefs.AppPrefs;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStorageUserHandler;
import io.xpipe.app.util.EncryptionToken;
import io.xpipe.app.util.LicenseProvider;
import io.xpipe.core.InPlaceSecretValue;
import io.xpipe.core.JacksonMapper;
import io.xpipe.ext.proc.user.a;
import io.xpipe.ext.proc.user.c;
import io.xpipe.ext.proc.user.f;
import io.xpipe.ext.proc.user.h;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import lombok.Generated;

public final class e
implements DataStorageUserHandler {
    private Path cn;
    private a eS;
    private List<a> eT;
    private boolean eU;

    public static e de() {
        return (e)DataStorageUserHandler.getInstance();
    }

    public final int getUserCount() {
        if (this.eS != null) {
            return this.eT.size();
        }
        return 0;
    }

    public final void init() {
        this.cn = DataStorage.getStorageDirectory();
        Path path = this.cn.resolve("users.json");
        boolean bl = Files.exists(path, new LinkOption[0]);
        Object object = AppPrefs.get().getLockCrypt();
        if (object.get() != null && !((String)object.get()).isBlank()) {
            EncryptionToken encryptionToken = EncryptionToken.builder().token((String)object.get()).build();
            this.eT = new ArrayList<a>();
            this.eT.add(new a("legacy", c.a.builder().encryptedToken(encryptionToken).build()));
            f.dj().f(false);
            return;
        }
        if (!bl) {
            this.eT = new ArrayList<a>();
            f.dj().f(false);
            return;
        }
        try {
            Object object2 = JacksonMapper.getDefault();
            object = new TypeReference<ArrayList<a>>(){};
            object2 = (ArrayList)object2.readValue(path.toFile(), (TypeReference)object);
            this.eT = object2 != null ? (List)object2.stream().filter(a2 -> a2 != null).collect(Collectors.toCollection(ArrayList::new)) : new ArrayList<a>();
        }
        catch (IOException iOException) {
            throw new IOException("Unable to read vault users file " + String.valueOf(path), iOException);
        }
        f.dj().f(false);
    }

    public final void save() {
        if (!this.eU) {
            return;
        }
        Object object = this.cn.resolve("users.json");
        if (this.eT.size() == 0 && !Files.exists((Path)object, new LinkOption[0])) {
            return;
        }
        ObjectMapper objectMapper = JacksonMapper.getDefault();
        try {
            Files.createDirectories(object.getParent(), new FileAttribute[0]);
            objectMapper.writeValue(object.toFile(), this.eT);
            this.eU = false;
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            ErrorEventFactory.fromThrowable((Throwable)iOException).handle();
            return;
        }
    }

    public final void login() {
        if (this.eT.size() == 0) {
            return;
        }
        if (this.eT.size() > 1 && !LicenseProvider.get().getFeature("team").isSupported()) {
            return;
        }
        String string = this.eT.size() == 1 ? this.eT.getFirst().getName() : (String)AppCache.getNonNull((String)"lastUser", String.class, () -> null);
        h.d(string, this.eT.size() > 1);
    }

    public final SecretKey getEncryptionKey() {
        if (this.eT.size() == 0) {
            return null;
        }
        if (this.eS == null) {
            return null;
        }
        SecretKey secretKey = this.eS.getAuthMethod().getEncryptionKey();
        return secretKey;
    }

    public final Comp<?> createOverview() {
        Comp<?> comp = f.dj().dk();
        return comp;
    }

    public final String getActiveUser() {
        if (this.eS != null) {
            return this.eS.getName();
        }
        return null;
    }

    public final void a(a a2) {
        this.eT.remove(a2);
        this.eU = true;
        this.eS = null;
        if (a2.getName().equals("legacy")) {
            AppPrefs.get().getLockCrypt().set(null);
        }
        DataStorage.get().forceRewrite();
        AppRestart.restart();
    }

    public final boolean df() {
        return this.eT.size() == 1 && this.eT.getFirst().getName().equals("legacy");
    }

    public final boolean a(String string, InPlaceSecretValue inPlaceSecretValue) {
        c c2;
        Optional<a> optional = this.eT.stream().filter(a2 -> a2.getName().equals(string)).findFirst();
        if (optional.isEmpty()) {
            return false;
        }
        if (inPlaceSecretValue == null) {
            return false;
        }
        boolean bl = string.equals("legacy");
        if (bl && (c2 = optional.get().getAuthMethod()) instanceof c.a && ((c.a)(c2 = (c.a)c2)).unlockLegacy(inPlaceSecretValue)) {
            this.eS = optional.get();
            AppCache.update((String)"lastUser", (Object)this.eS.getName());
            return true;
        }
        c c3 = optional.get().getAuthMethod();
        if (c3 instanceof c.a && ((c.a)(c3 = (c.a)c3)).unlock(inPlaceSecretValue)) {
            this.eS = optional.get();
            AppCache.update((String)"lastUser", (Object)this.eS.getName());
            return true;
        }
        return false;
    }

    public final void b(String string, InPlaceSecretValue object) {
        if (string == null || string.isBlank() || object == null || object.getSecret().length == 0) {
            return;
        }
        if (this.eT.stream().anyMatch(a2 -> a2.getName().equalsIgnoreCase(string))) {
            return;
        }
        object = new a(string, c.a.ofPassword(object));
        this.eT.add((a)object);
        this.eU = true;
        if (this.eS == null) {
            this.eS = object;
        }
        f.dj().f(true);
        AppCache.update((String)"lastUser", (Object)string);
        this.save();
        if (this.eT.size() == 1 && AppPrefs.get().encryptAllVaultData().get()) {
            DataStorage.get().forceRewrite();
        }
        if (this.eT.size() == 2 && AppPrefs.get().encryptAllVaultData().get()) {
            DataStorage.get().forceRewrite();
        }
    }

    public final void a(InPlaceSecretValue object) {
        if (this.eS == null) {
            return;
        }
        if (object == null) {
            return;
        }
        object = c.a.ofPassword(object);
        this.eS.setAuthMethod((c)object);
        this.eU = true;
        EncryptionToken.invalidateUserToken();
        if (DataStorage.get() != null) {
            DataStorage.get().forceRewrite();
        }
    }

    @Generated
    public final a dg() {
        return this.eS;
    }

    @Generated
    public final List<a> dh() {
        return this.eT;
    }
}

