/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.ssh;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.HostAddress;
import io.xpipe.app.ext.SelfReferentialStore;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ShellStoreState;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.SecretRetrievalStrategy;
import io.xpipe.app.util.Validators;
import io.xpipe.core.KeyValue;
import io.xpipe.ext.base.identity.IdentityValue;
import io.xpipe.ext.base.identity.UsernameStrategy;
import io.xpipe.ext.base.identity.ssh.NoneStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.proc.ssh.b;
import io.xpipe.ext.proc.ssh.d;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

@JsonTypeName(value="sshConfigString")
@JsonDeserialize(builder=b.class)
public final class k
extends io.xpipe.ext.proc.ssh.b<ShellStoreState>
implements SelfReferentialStore {
    private final DataStoreEntryRef<ShellStore> gateway;
    private final String content;
    private final IdentityValue identity;
    private final Boolean dontInteractWithSystem;
    private final Boolean jumpServer;

    public final Class<ShellStoreState> getStateClass() {
        return ShellStoreState.class;
    }

    @Override
    public final d toConfigHost() {
        Object object;
        Object object2 = this.getConfig().cb();
        List<KeyValue> list = ((d)object2).cd().cn();
        Object object3 = object = ((d)object2).ce().size() > 1 ? ((d)object2).ce().getFirst() : ((d)object2).cd();
        if (this.isGatewayTunnelSessionActive()) {
            object = ((d.a)object).cn();
            object.removeIf(keyValue -> keyValue.getKey().equals("Port"));
            object.add(new KeyValue("Port", "" + this.getEffectivePort()));
            object.removeIf(keyValue -> keyValue.getKey().equals("HostName"));
            object.add(new KeyValue("HostName", this.getEffectiveHostName()));
        }
        if (((d)object2).ce().size() > 1) {
            return object2;
        }
        object = this.distinctConfigHostName();
        object2 = new d.a((String)object, list);
        return new d((d.a)object2);
    }

    @Override
    protected final boolean dontInteractWithSystem() {
        if (this.dontInteractWithSystem != null) {
            return this.dontInteractWithSystem;
        }
        return false;
    }

    @Override
    protected final boolean hasX11Forward() {
        return this.getHostEntry().aF("ForwardX11") || this.getHostEntry().aF("ForwardX11Trusted");
    }

    @Override
    public final SecretRetrievalStrategy getPassword() {
        SecretRetrievalStrategy secretRetrievalStrategy = this.getIdentity().unwrap().getPassword();
        if (secretRetrievalStrategy != null) {
            return secretRetrievalStrategy;
        }
        return new SecretRetrievalStrategy.None();
    }

    @Override
    public final DataStoreEntryRef<ShellStore> getGateway() {
        return this.gateway;
    }

    @Override
    public final HostAddress getHostAddress() {
        return HostAddress.of((String)this.getHostEntry().l("Hostname", this.getHostEntry().l("HostName", "localhost")));
    }

    @Override
    public final UsernameStrategy getUser() {
        String string = this.getHostEntry().l("User", null);
        if (string != null) {
            return new UsernameStrategy.Fixed(string);
        }
        if (this.identity != null) {
            return this.identity.unwrap().getUsername();
        }
        return new UsernameStrategy.None();
    }

    @Override
    public final int getPort() {
        String string = this.getHostEntry().l("Port", "22");
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 22;
        }
    }

    @Override
    protected final CommandBuilder buildBaseCommand() {
        Object object = this.getConfigEntryName();
        object = (String)(this.identity.unwrap().getUsername().hasUser() ? this.identity.unwrap().getUsername().retrieveUsername() + "@" : "") + (String)object;
        object = CommandBuilder.of().addQuoted((String)object);
        return object;
    }

    @Override
    public final boolean isJumpServer() {
        return this.jumpServer != null && this.jumpServer != false;
    }

    @Override
    protected final Optional<d> buildBaseConfig() {
        return Optional.of(((io.xpipe.ext.proc.ssh.b)this).toConfigHost());
    }

    @Override
    protected final SshIdentityStrategy getIdentityStrategy() {
        SshIdentityStrategy sshIdentityStrategy = d.a(this.getHostEntry());
        if (sshIdentityStrategy.isPresent()) {
            return sshIdentityStrategy.get();
        }
        sshIdentityStrategy = this.identity.unwrap().getSshIdentity();
        if (sshIdentityStrategy != null) {
            return sshIdentityStrategy;
        }
        return new NoneStrategy();
    }

    @Override
    protected final boolean hasTunnels() {
        return this.getHostEntry().aG("LocalForward") || this.getHostEntry().aG("RemoteForward") || this.getHostEntry().aG("DynamicForward");
    }

    public final boolean isPerUser() {
        return this.identity.isPerUser();
    }

    private d getConfig() {
        try {
            return d.aC(this.content);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).handle();
            return new d(List.of(), List.of());
        }
    }

    private d.a getHostEntry() {
        return this.getConfig().ce().getFirst();
    }

    public final String getConfigEntryName() {
        d d2 = this.getConfig();
        if (d2.ce().size() > 1) {
            return this.getConfig().ce().getFirst().cm();
        }
        return this.distinctConfigHostName();
    }

    public final void checkComplete() {
        Validators.nonNull(this.gateway);
        Validators.isType(this.gateway, ShellStore.class);
        Validators.nonNull((Object)this.identity);
        this.identity.checkComplete();
        this.identity.checkCompletePassword();
        this.identity.checkCompleteSshIdentity();
        Validators.nonNull((Object)this.content);
        d.aC(this.content);
        this.checkValidGatewayChain();
    }

    @Generated
    protected k(a<?, ?> a2) {
        super(a2);
        this.gateway = a2.gateway;
        this.content = a2.content;
        this.identity = a2.identity;
        this.dontInteractWithSystem = a2.dontInteractWithSystem;
        this.jumpServer = a2.jumpServer;
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final a<?, ?> toBuilder() {
        return new b().$fillValuesFrom(this);
    }

    @Generated
    public final String getContent() {
        return this.content;
    }

    @Generated
    public final IdentityValue getIdentity() {
        return this.identity;
    }

    @Generated
    public final Boolean getDontInteractWithSystem() {
        return this.dontInteractWithSystem;
    }

    @Generated
    public final Boolean getJumpServer() {
        return this.jumpServer;
    }

    @Override
    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof k)) {
            return false;
        }
        k k2 = (k)object;
        if (!k2.canEqual(this)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        object = this.getDontInteractWithSystem();
        Object object2 = k2.getDontInteractWithSystem();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getJumpServer();
        object2 = k2.getJumpServer();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = ((io.xpipe.ext.proc.ssh.b)this).getGateway();
        object2 = ((io.xpipe.ext.proc.ssh.b)k2).getGateway();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getContent();
        object2 = k2.getContent();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getIdentity();
        k2 = k2.getIdentity();
        return !(object == null ? k2 != null : !object.equals(k2));
    }

    @Override
    @Generated
    protected final boolean canEqual(Object object) {
        return object instanceof k;
    }

    @Override
    @Generated
    public final int hashCode() {
        int n2 = super.hashCode();
        Object object = this.getDontInteractWithSystem();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getJumpServer();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = ((io.xpipe.ext.proc.ssh.b)this).getGateway();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getContent();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getIdentity();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        return n2;
    }

    @Override
    @Generated
    public final String toString() {
        return "SshConfigStringStore(super=" + super.toString() + ", gateway=" + String.valueOf(((io.xpipe.ext.proc.ssh.b)this).getGateway()) + ", content=" + this.getContent() + ", identity=" + String.valueOf(this.getIdentity()) + ", dontInteractWithSystem=" + this.getDontInteractWithSystem() + ", jumpServer=" + this.getJumpServer() + ")";
    }

    @Generated
    public static abstract class a<C extends k, B extends a<C, B>>
    extends b.a<ShellStoreState, C, B> {
        @Generated
        private DataStoreEntryRef<ShellStore> gateway;
        @Generated
        private String content;
        @Generated
        private IdentityValue identity;
        @Generated
        private Boolean dontInteractWithSystem;
        @Generated
        private Boolean jumpServer;

        @Override
        @Generated
        protected B $fillValuesFrom(C c2) {
            super.$fillValuesFrom(c2);
            a.$fillValuesFromInstanceIntoBuilder(c2, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(k k2, a<?, ?> a2) {
            a2.gateway(k2.gateway);
            a2.content(k2.content);
            a2.identity(k2.identity);
            a2.dontInteractWithSystem(k2.dontInteractWithSystem);
            a2.jumpServer(k2.jumpServer);
        }

        @Generated
        public B gateway(DataStoreEntryRef<ShellStore> dataStoreEntryRef) {
            this.gateway = dataStoreEntryRef;
            return (B)this.self();
        }

        @Generated
        public B content(String string) {
            this.content = string;
            return (B)this.self();
        }

        @Generated
        public B identity(IdentityValue identityValue) {
            this.identity = identityValue;
            return (B)this.self();
        }

        @Generated
        public B dontInteractWithSystem(Boolean bl) {
            this.dontInteractWithSystem = bl;
            return (B)this.self();
        }

        @Generated
        public B jumpServer(Boolean bl) {
            this.jumpServer = bl;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SshConfigStringStore.SshConfigStringStoreBuilder(super=" + super.toString() + ", gateway=" + String.valueOf(this.gateway) + ", content=" + this.content + ", identity=" + String.valueOf(this.identity) + ", dontInteractWithSystem=" + this.dontInteractWithSystem + ", jumpServer=" + this.jumpServer + ")";
        }
    }

    @JsonTypeName(value="sshConfigString")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<k, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final k build() {
            return new k(this);
        }
    }
}

