/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.ssh;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.FixedChildStore;
import io.xpipe.app.ext.HostAddress;
import io.xpipe.app.ext.InternalCacheDataStore;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ShellStoreState;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.SecretRetrievalStrategy;
import io.xpipe.app.util.Validators;
import io.xpipe.core.FilePath;
import io.xpipe.ext.base.identity.IdentityValue;
import io.xpipe.ext.base.identity.UsernameStrategy;
import io.xpipe.ext.base.identity.ssh.NoneStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.proc.ssh.b;
import io.xpipe.ext.proc.ssh.d;
import io.xpipe.ext.proc.ssh.h;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import lombok.Generated;

@JsonTypeName(value="sshConfigHost")
@JsonDeserialize(builder=b.class)
public final class f
extends io.xpipe.ext.proc.ssh.b<ShellStoreState>
implements FixedChildStore,
InternalCacheDataStore {
    private final DataStoreEntryRef<h> config;
    private final d.a hostEntry;
    private final IdentityValue identity;
    private final Boolean dontInteractWithSystem;
    private final Boolean forwardX11;
    private final Boolean jumpServer;

    public final Class<ShellStoreState> getStateClass() {
        return ShellStoreState.class;
    }

    public final boolean isPerUser() {
        return this.identity.isPerUser();
    }

    public final void checkComplete() {
        Validators.nonNull((Object)this.identity);
        this.identity.checkComplete();
        this.identity.checkCompletePassword();
        this.identity.checkCompleteSshIdentity();
        Validators.nonNull(this.config);
        Validators.isType(this.config, h.class);
        this.config.checkComplete();
        Validators.nonNull((Object)this.hostEntry);
        this.checkValidGatewayChain();
    }

    public final OptionalInt getFixedId() {
        return OptionalInt.of(Objects.hash(this.hostEntry.cm()));
    }

    public final FixedChildStore merge(FixedChildStore fixedChildStore) {
        fixedChildStore = (f)fixedChildStore.asNeeded();
        return ((a)((a)((a)((a)((a)((a)f.builder().config(this.config)).hostEntry(fixedChildStore.hostEntry)).identity(this.identity != null ? this.identity : fixedChildStore.identity)).dontInteractWithSystem(this.dontInteractWithSystem != null ? this.dontInteractWithSystem : fixedChildStore.dontInteractWithSystem)).forwardX11(this.forwardX11 != null ? this.forwardX11 : fixedChildStore.forwardX11)).jumpServer(this.jumpServer != null ? this.jumpServer : fixedChildStore.jumpServer)).build();
    }

    @Override
    public final d toConfigHost() {
        return new d(new d.a(this.hostEntry.cm(), List.of()));
    }

    @Override
    protected final boolean dontInteractWithSystem() {
        if (this.dontInteractWithSystem != null) {
            return this.dontInteractWithSystem;
        }
        return false;
    }

    @Override
    protected final boolean hasX11Forward() {
        if (this.hostEntry == null) {
            return false;
        }
        return this.hostEntry.aF("ForwardX11") || this.hostEntry.aF("ForwardX11Trusted");
    }

    @Override
    public final SecretRetrievalStrategy getPassword() {
        SecretRetrievalStrategy secretRetrievalStrategy = this.identity.unwrap().getPassword();
        if (secretRetrievalStrategy != null) {
            return secretRetrievalStrategy;
        }
        return new SecretRetrievalStrategy.None();
    }

    @Override
    public final DataStoreEntryRef<ShellStore> getGateway() {
        Object object = this.hostEntry.l("ProxyJump", null);
        if (object == null) {
            return DataStorage.get().local().ref();
        }
        object = DataStorage.get().getStoreChildren(this.config.get()).stream().filter(dataStoreEntry -> dataStoreEntry.getValidity().isUsable()).filter(arg_0 -> f.lambda$getGateway$1((String)object, arg_0)).findFirst();
        return ((Optional)object).orElse((DataStoreEntry)DataStorage.get().local()).ref();
    }

    @Override
    public final HostAddress getHostAddress() {
        return HostAddress.of((String)this.hostEntry.l("Hostname", this.hostEntry.l("HostName", "localhost")));
    }

    @Override
    public final UsernameStrategy getUser() {
        String string = this.hostEntry.l("User", null);
        if (string != null) {
            return new UsernameStrategy.Fixed(string);
        }
        if (this.identity != null) {
            return this.identity.unwrap().getUsername();
        }
        return new UsernameStrategy.None();
    }

    @Override
    public final int getPort() {
        String string = this.getHostEntry().l("Port", "22");
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 22;
        }
    }

    @Override
    protected final CommandBuilder buildBaseCommand() {
        String string = (String)(this.identity.unwrap().getUsername().hasUser() ? this.identity.unwrap().getUsername().retrieveUsername() + "@" : "") + this.hostEntry.cm();
        string = CommandBuilder.of().addQuoted(string);
        string.add(shellControl -> {
            FilePath filePath = ((h)this.config.getStore()).getConfigFile() != null ? ((h)this.config.getStore()).getConfigFile().toAbsoluteFilePath(shellControl) : null;
            boolean bl = filePath == null || filePath.equals((Object)d.u(shellControl)) || filePath.equals((Object)d.v(shellControl));
            if (!bl) {
                return CommandBuilder.of().add(d.a(shellControl, filePath)).buildFull(shellControl);
            }
            return null;
        });
        return string;
    }

    @Override
    public final boolean isJumpServer() {
        return this.jumpServer != null && this.jumpServer != false;
    }

    @Override
    protected final SshIdentityStrategy getIdentityStrategy() {
        SshIdentityStrategy sshIdentityStrategy = d.a(this.getHostEntry());
        if (sshIdentityStrategy.isPresent()) {
            return sshIdentityStrategy.get();
        }
        sshIdentityStrategy = this.identity.unwrap().getSshIdentity();
        if (sshIdentityStrategy != null) {
            return sshIdentityStrategy;
        }
        return new NoneStrategy();
    }

    @Override
    protected final boolean hasTunnels() {
        if (this.hostEntry == null) {
            return false;
        }
        return this.hostEntry.aG("LocalForward") || this.hostEntry.aG("RemoteForward") || this.hostEntry.aG("DynamicForward");
    }

    @Generated
    protected f(a<?, ?> a2) {
        super(a2);
        this.config = a2.config;
        this.hostEntry = a2.hostEntry;
        this.identity = a2.identity;
        this.dontInteractWithSystem = a2.dontInteractWithSystem;
        this.forwardX11 = a2.forwardX11;
        this.jumpServer = a2.jumpServer;
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final a<?, ?> toBuilder() {
        return new b().$fillValuesFrom(this);
    }

    @Generated
    public final DataStoreEntryRef<h> getConfig() {
        return this.config;
    }

    @Generated
    public final d.a getHostEntry() {
        return this.hostEntry;
    }

    @Generated
    public final IdentityValue getIdentity() {
        return this.identity;
    }

    @Generated
    public final Boolean getDontInteractWithSystem() {
        return this.dontInteractWithSystem;
    }

    @Generated
    public final Boolean getForwardX11() {
        return this.forwardX11;
    }

    @Generated
    public final Boolean getJumpServer() {
        return this.jumpServer;
    }

    @Override
    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof f)) {
            return false;
        }
        f f2 = (f)object;
        if (!f2.canEqual(this)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        object = this.getDontInteractWithSystem();
        Object object2 = f2.getDontInteractWithSystem();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getForwardX11();
        object2 = f2.getForwardX11();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getJumpServer();
        object2 = f2.getJumpServer();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getConfig();
        object2 = f2.getConfig();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getHostEntry();
        object2 = f2.getHostEntry();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getIdentity();
        f2 = f2.getIdentity();
        return !(object == null ? f2 != null : !object.equals(f2));
    }

    @Override
    @Generated
    protected final boolean canEqual(Object object) {
        return object instanceof f;
    }

    @Override
    @Generated
    public final int hashCode() {
        int n2 = super.hashCode();
        Object object = this.getDontInteractWithSystem();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getForwardX11();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getJumpServer();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getConfig();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getHostEntry();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getIdentity();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        return n2;
    }

    @Override
    @Generated
    public final String toString() {
        return "SshConfigFileHostStore(super=" + super.toString() + ", config=" + String.valueOf(this.getConfig()) + ", hostEntry=" + String.valueOf(this.getHostEntry()) + ", identity=" + String.valueOf(this.getIdentity()) + ", dontInteractWithSystem=" + this.getDontInteractWithSystem() + ", forwardX11=" + this.getForwardX11() + ", jumpServer=" + this.getJumpServer() + ")";
    }

    private static /* synthetic */ boolean lambda$getGateway$1(String string, DataStoreEntry object) {
        object = (f)object.getStore().asNeeded();
        return object.getHostEntry().cm().equals(string);
    }

    @Generated
    public static abstract class a<C extends f, B extends a<C, B>>
    extends b.a<ShellStoreState, C, B> {
        @Generated
        private DataStoreEntryRef<h> config;
        @Generated
        private d.a hostEntry;
        @Generated
        private IdentityValue identity;
        @Generated
        private Boolean dontInteractWithSystem;
        @Generated
        private Boolean forwardX11;
        @Generated
        private Boolean jumpServer;

        @Override
        @Generated
        protected B $fillValuesFrom(C c2) {
            super.$fillValuesFrom(c2);
            a.$fillValuesFromInstanceIntoBuilder(c2, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(f f2, a<?, ?> a2) {
            a2.config(f2.config);
            a2.hostEntry(f2.hostEntry);
            a2.identity(f2.identity);
            a2.dontInteractWithSystem(f2.dontInteractWithSystem);
            a2.forwardX11(f2.forwardX11);
            a2.jumpServer(f2.jumpServer);
        }

        @Generated
        public B config(DataStoreEntryRef<h> dataStoreEntryRef) {
            this.config = dataStoreEntryRef;
            return (B)this.self();
        }

        @Generated
        public B hostEntry(d.a a2) {
            this.hostEntry = a2;
            return (B)this.self();
        }

        @Generated
        public B identity(IdentityValue identityValue) {
            this.identity = identityValue;
            return (B)this.self();
        }

        @Generated
        public B dontInteractWithSystem(Boolean bl) {
            this.dontInteractWithSystem = bl;
            return (B)this.self();
        }

        @Generated
        public B forwardX11(Boolean bl) {
            this.forwardX11 = bl;
            return (B)this.self();
        }

        @Generated
        public B jumpServer(Boolean bl) {
            this.jumpServer = bl;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SshConfigFileHostStore.SshConfigFileHostStoreBuilder(super=" + super.toString() + ", config=" + String.valueOf(this.config) + ", hostEntry=" + String.valueOf(this.hostEntry) + ", identity=" + String.valueOf(this.identity) + ", dontInteractWithSystem=" + this.dontInteractWithSystem + ", forwardX11=" + this.forwardX11 + ", jumpServer=" + this.jumpServer + ")";
        }
    }

    @JsonTypeName(value="sshConfigHost")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<f, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final f build() {
            return new f(this);
        }
    }
}

