/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc;

import io.xpipe.app.core.AppProperties;
import io.xpipe.app.core.mode.OperationMode;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.ShellSession;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.issue.TrackEvent;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.CommandConfiguration;
import io.xpipe.app.process.CountDown;
import io.xpipe.app.process.ElevationFunction;
import io.xpipe.app.process.ElevationHandler;
import io.xpipe.app.process.LocalProcessInputStream;
import io.xpipe.app.process.LocalProcessOutputStream;
import io.xpipe.app.process.ParentSystemAccess;
import io.xpipe.app.process.SecretReference;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialect;
import io.xpipe.app.process.ShellDialects;
import io.xpipe.app.process.ShellOpenFunction;
import io.xpipe.app.process.ShellSecurityPolicy;
import io.xpipe.app.process.ShellTerminalInitCommand;
import io.xpipe.app.process.ShellTtyState;
import io.xpipe.app.process.ShellView;
import io.xpipe.app.process.SudoCache;
import io.xpipe.app.process.TerminalInitFunction;
import io.xpipe.app.process.TerminalInitScriptConfig;
import io.xpipe.app.process.WorkingDirectoryFunction;
import io.xpipe.app.terminal.TerminalLauncher;
import io.xpipe.app.util.LicenseProvider;
import io.xpipe.app.util.LicensedFeature;
import io.xpipe.app.util.SecretManager;
import io.xpipe.app.util.SecretQuery;
import io.xpipe.app.util.ShellTemp;
import io.xpipe.core.FailableConsumer;
import io.xpipe.core.FilePath;
import io.xpipe.core.OsType;
import io.xpipe.ext.proc.b;
import io.xpipe.ext.proc.i;
import io.xpipe.ext.proc.j;
import io.xpipe.ext.proc.k;
import io.xpipe.ext.proc.l;
import io.xpipe.ext.proc.util.d;
import io.xpipe.ext.proc.util.e;
import io.xpipe.ext.proc.util.f;
import io.xpipe.ext.proc.util.g;
import io.xpipe.ext.proc.util.h;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import lombok.NonNull;

public class m
extends j {
    protected final ShellControl ax;
    private final boolean ay;
    @NonNull
    protected ShellOpenFunction az = ShellOpenFunction.unsupported();
    @NonNull
    protected ShellOpenFunction aA = ShellOpenFunction.unsupported();
    protected ElevationFunction d = ElevationFunction.none();
    protected ParentSystemAccess aB = ParentSystemAccess.none();
    protected ShellDialect aC;
    protected ShellSecurityPolicy aD;
    protected Boolean aE;

    public m(ShellControl shellControl) {
        this.ax = shellControl;
        this.ay = !shellControl.isRunning(false);
        this.ak = new ElevationHandler(){
            private /* synthetic */ ShellControl aF;
            private /* synthetic */ m aG;
            {
                this.aF = shellControl;
                this.aG = m2;
            }

            public final boolean handleRequest(UUID uUID, CountDown countDown, boolean bl, boolean bl2) {
                if (this.aG.getParentSystemAccess().supportsSameUsers()) {
                    return this.aG.getParent().getElevationHandler().handleRequest(uUID, countDown, bl, bl2);
                }
                SecretReference secretReference = this.getSecretRef();
                uUID = SecretManager.expectAskpass((UUID)uUID, (UUID)secretReference.getSecretId(), List.of(SecretQuery.confirmElevationIfNeeded((SecretQuery)SecretQuery.prompt((boolean)true), (boolean)bl)), (SecretQuery)SecretQuery.prompt((boolean)false), List.of(), List.of(), (CountDown)countDown, (boolean)bl2);
                uUID.preAdvance(3);
                return true;
            }

            public final SecretReference getSecretRef() {
                if (this.aG.getParentSystemAccess().supportsSameUsers()) {
                    return this.aF.getElevationHandler().getSecretRef();
                }
                UUID uUID = this.aG.getSourceStoreId().orElse(UUID.randomUUID());
                return new SecretReference(uUID, 3);
            }
        };
    }

    public void setDumbOpen(@NonNull ShellOpenFunction shellOpenFunction) {
        if (shellOpenFunction == null) {
            throw new NullPointerException("openFunction is marked non-null but is null");
        }
        this.az = shellOpenFunction;
    }

    public void setTerminalOpen(@NonNull ShellOpenFunction shellOpenFunction) {
        if (shellOpenFunction == null) {
            throw new NullPointerException("openFunction is marked non-null but is null");
        }
        this.aA = shellOpenFunction;
    }

    public Optional<ShellControl> getParentControl() {
        return Optional.of(this.ax);
    }

    public SudoCache getSudoCache() {
        if (this.aq == null) {
            this.aq = new h(this);
        }
        return this.aq;
    }

    public void closeStdout() {
        this.ax.closeStdout();
    }

    public List<UUID> getExitUuids() {
        ArrayList<UUID> arrayList = this.ax.getExitUuids();
        arrayList = new ArrayList<UUID>(arrayList);
        if (this.X != null) {
            arrayList.add(this.X);
        }
        return arrayList;
    }

    public ParentSystemAccess getParentSystemAccess() {
        return this.aB;
    }

    public ParentSystemAccess getLocalSystemAccess() {
        return ParentSystemAccess.combine((ParentSystemAccess)this.getParent().getLocalSystemAccess(), (ParentSystemAccess)this.getParentSystemAccess());
    }

    public boolean isLocal() {
        return this.getLocalSystemAccess().isIdentity();
    }

    public ReentrantLock getLock() {
        return this.ax.getLock();
    }

    public ShellDialect getOriginalShellDialect() {
        if (this.aC != null) {
            return this.aC;
        }
        return this.getShellDialect();
    }

    public void setOriginalShellDialect(ShellDialect shellDialect) {
        this.aC = shellDialect;
    }

    public ShellControl start() {
        try {
            try {
                this.ax.getLock().lock();
                this.J();
            }
            finally {
                this.ax.getLock().unlock();
            }
            return this;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throw throwable;
        }
    }

    public LocalProcessInputStream getStdout() {
        return this.ax.getStdout();
    }

    public LocalProcessOutputStream getStdin() {
        return this.ax.getStdin();
    }

    public LocalProcessInputStream getStderr() {
        return this.ax.getStderr();
    }

    public void checkLicenseOrThrow() {
        this.ax.checkLicenseOrThrow();
        if (this.getLocalSystemAccess().isIdentity()) {
            return;
        }
        Object object = this.H() != null ? this.H() : this.B();
        if (object != null) {
            LicenseProvider.get().getFeature(object.getLicenseFeatureId()).throwIfUnsupported();
        }
        if ((object = this.getOsName() != null ? this.getOsName() : this.E()) != null) {
            LicenseProvider.get().checkOsNameOrThrow((String)object);
        }
        for (LicensedFeature licensedFeature : this.ad) {
            licensedFeature.throwIfUnsupported();
        }
    }

    public String prepareIntermediateTerminalOpen(TerminalInitFunction terminalInitFunction, TerminalInitScriptConfig object, WorkingDirectoryFunction workingDirectoryFunction) {
        try {
            boolean bl;
            Optional optional;
            Object object2;
            boolean bl2;
            ShellDialect shellDialect;
            this.ax.getLock().lock();
            ShellDialect shellDialect2 = shellDialect = this.getShellDialect() != null ? this.getShellDialect() : this.B();
            if (workingDirectoryFunction.isSpecified() || this.aa.stream().anyMatch(shellTerminalInitCommand -> shellDialect == null || shellTerminalInitCommand.canPotentiallyRunInDialect(shellDialect))) {
                m m2 = this;
                boolean bl3 = m2.a(m2);
                if (bl3) {
                    workingDirectoryFunction = WorkingDirectoryFunction.none();
                    this.aa.clear();
                }
            }
            if (bl2 = this.a(terminalInitFunction, (TerminalInitScriptConfig)object, workingDirectoryFunction, this)) {
                this.checkLicenseOrThrow();
                object2 = this.a(workingDirectoryFunction);
            } else {
                DataStore dataStore;
                object2 = this;
                optional = ((j)object2).getSourceStore();
                if (!optional.isEmpty() && (dataStore = optional.get()) instanceof ShellStore) {
                    optional = (ShellStore)dataStore;
                    dataStore = ((j)object2).B();
                    if (!(dataStore != null && !dataStore.getDumbMode().supportsAnyPossibleInteraction() || (object2 = ((j)object2).C()) != null && object2 != ShellTtyState.NONE)) {
                        optional.getOrStartSession();
                    }
                }
                optional = this.getActiveReplacementBackgroundSession().orElse(this);
                object2 = this.a((m)((Object)optional), terminalInitFunction, (TerminalInitScriptConfig)object, workingDirectoryFunction);
            }
            optional = this.getParent().getActiveReplacementBackgroundSession();
            terminalInitFunction = optional.orElse(this.getParent());
            boolean bl4 = optional.isPresent();
            if (!bl4) {
                ((j)this).exitAndWait();
            }
            terminalInitFunction.start();
            object2 = object2 != null ? this.aA.prepareWithInitCommand((String)object2).buildFull((ShellControl)terminalInitFunction) : this.aA.prepareWithoutInitCommand().buildFull((ShellControl)terminalInitFunction);
            boolean bl5 = this.d.apply((ShellControl)terminalInitFunction);
            boolean bl6 = bl = this.user != null && !this.user.equals(terminalInitFunction.view().user());
            if (bl5 || bl) {
                TerminalInitFunction terminalInitFunction2 = terminalInitFunction;
                object2 = terminalInitFunction.getShellDialect().getAskpass().elevateTerminalCommandWithPreparedAskpass((ShellControl)terminalInitFunction2, terminalInitFunction2.getElevationHandler(), (String)object2, this.d.getPrefix() != null ? "[" + this.d.getPrefix() + "]" : null, this.user);
            }
            TrackEvent.withDebug((String)"Preparing for terminal open").tag("terminalCommand", object2).handle();
            object = terminalInitFunction.prepareIntermediateTerminalOpen(TerminalInitFunction.fixed((String)object2), object, WorkingDirectoryFunction.none());
            if (!bl4) {
                terminalInitFunction.close();
            }
            terminalInitFunction = object;
            return terminalInitFunction;
        }
        finally {
            this.ax.getLock().unlock();
        }
    }

    public ShellControl withSecurityPolicy(ShellSecurityPolicy shellSecurityPolicy) {
        this.aD = shellSecurityPolicy;
        return this;
    }

    public ShellSecurityPolicy getEffectiveSecurityPolicy() {
        if (!this.aB.supportsAnyAccess()) {
            if (this.aD != null) {
                return this.aD;
            }
            return new g(true);
        }
        return this.getParent().getEffectiveSecurityPolicy();
    }

    public String buildElevatedCommand(CommandConfiguration commandConfiguration, String string, UUID uUID, CountDown countDown, String string2) {
        m m2 = this;
        return this.getShellDialect().getAskpass().elevateDumbCommand((ShellControl)this, uUID, m2.a(m2.ak), countDown, string, string2, commandConfiguration);
    }

    public void restart() {
        try {
            this.ax.getLock().lock();
            this.close();
            this.ax.restart();
            this.start();
            return;
        }
        finally {
            this.ax.getLock().unlock();
        }
    }

    public ShellControl elevated(ElevationFunction elevationFunction) {
        this.d = elevationFunction;
        return this;
    }

    public Optional<ShellControl> getActiveReplacementBackgroundSession() {
        DataStore dataStore;
        ShellStore shellStore = this.getSourceStore();
        if (shellStore.isEmpty() || !((dataStore = shellStore.get()) instanceof ShellStore)) {
            return Optional.empty();
        }
        shellStore = (ShellStore)dataStore;
        dataStore = this.B();
        if (dataStore != null && !dataStore.getDumbMode().supportsAnyPossibleInteraction()) {
            return Optional.empty();
        }
        dataStore = this.C();
        if (dataStore != null && dataStore != ShellTtyState.NONE) {
            return Optional.empty();
        }
        dataStore = (ShellSession)shellStore.getSession();
        if (dataStore == null) {
            return Optional.empty();
        }
        boolean bl = shellStore.checkSessionAlive();
        if (bl) {
            return Optional.of(dataStore.getShellControl());
        }
        return Optional.empty();
    }

    @Override
    public ShellView view() {
        ParentSystemAccess parentSystemAccess;
        if (this.ap == null && (parentSystemAccess = this.getLocalSystemAccess()).isIdentity()) {
            this.ap = new io.xpipe.ext.proc.f(this);
        }
        return super.view();
    }

    @Override
    public void setNonInteractive() {
        this.ax.setNonInteractive();
        super.setNonInteractive();
    }

    @Override
    public void exitAndWait() {
        try {
            this.ax.getLock().lock();
            this.refreshRunningState();
            if (!this.running) {
                this.resetData();
                return;
            }
            TrackEvent.withInfo((String)"Exiting sub shell ...").tag("type", (Object)this.getShellDialect().getId()).tag("command", (Object)this.C).tag("id", (Object)this.X).handle();
            this.af.accept(this);
            this.aj = true;
            if (!this.isAnyStreamClosed()) {
                this.getShellDialect().getDumbMode().prepareDumbExit((ShellControl)this);
                if (this.isRunning(true)) {
                    long l2 = System.currentTimeMillis() + (long)(OperationMode.isInShutdown() ? 1000 : 10000);
                    boolean bl = false;
                    if (this.getParent().getTtyState().isHasSeparateStreams()) {
                        bl = f.a((InputStream)this.ax.getStderr(), this.ax.getCharset(), this.getExitUuids().stream().map(uUID -> uUID.toString()).toList(), null, l2, false).isEmpty();
                    }
                    boolean bl2 = bl = bl || f.a((InputStream)this.ax.getStdout(), this.ax.getCharset(), this.getExitUuids().stream().map(uUID -> uUID.toString()).toList(), null, l2, true).isEmpty();
                    if (this.isRunning(true) && bl) {
                        throw (IOException)ErrorEventFactory.expected((Throwable)new IOException("Wait for shell exit timed out as the process did not exit in time"));
                    }
                }
            }
            TrackEvent.info((String)"Exit complete");
            this.resetData();
            return;
        }
        finally {
            this.ax.getLock().unlock();
        }
    }

    public void resetData() {
        this.running = false;
        this.X = null;
        this.ai = false;
        this.aj = false;
        this.aE = null;
        this.ax.setSubShellActive(false);
    }

    public void refreshRunningState() {
        this.ax.refreshRunningState();
        if (!this.ax.isRunning(false)) {
            this.running = false;
        }
    }

    public void closeStdin() {
        this.ax.closeStdin();
    }

    public boolean isAnyStreamClosed() {
        return this.ax.isAnyStreamClosed();
    }

    public void close() {
        try {
            this.ax.getLock().lock();
            TrackEvent.withTrace((String)"Closing sub shell ...").tag("manageParent", (Object)this.ay).handle();
            ((j)this).exitAndWait();
            if (this.ay) {
                this.ax.close();
            }
            return;
        }
        catch (Exception exception) {
            this.kill();
            throw exception;
        }
        finally {
            this.ax.getLock().unlock();
        }
    }

    public void shutdown() {
        this.close();
        this.ax.shutdown();
    }

    public void kill() {
        try {
            this.ax.getLock().lock();
            boolean bl = this.running;
            TrackEvent.withTrace((String)"Killing sub shell").tag("command", (Object)this.C).handle();
            this.resetData();
            if (bl) {
                this.ag.run();
            }
            this.ax.kill();
            return;
        }
        finally {
            this.ax.getLock().unlock();
        }
    }

    public void killExternal() {
        this.ax.killExternal();
    }

    private String a(m m2, TerminalInitFunction terminalInitFunction, TerminalInitScriptConfig terminalInitScriptConfig, WorkingDirectoryFunction workingDirectoryFunction) {
        try {
            boolean bl;
            m2.start();
            m2.checkLicenseOrThrow();
            if ((workingDirectoryFunction.isSpecified() || this.aa.stream().anyMatch(shellTerminalInitCommand -> shellTerminalInitCommand.canPotentiallyRunInDialect(m2.getShellDialect()))) && (bl = this.a(m2))) {
                workingDirectoryFunction = WorkingDirectoryFunction.none();
                this.aa.clear();
            }
            if (this.a(terminalInitFunction, terminalInitScriptConfig, workingDirectoryFunction, m2)) {
                return m2.a(workingDirectoryFunction);
            }
            if (!m2.getShellDialect().getDumbMode().supportsAnyPossibleInteraction()) {
                return null;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(m2.getOriginalShellDialect().prepareTerminalEnvironmentCommands());
            arrayList.add(m2.getShellDialect().getSetEnvironmentVariableCommand("XPIPE_SESSION", AppProperties.get().getSessionId().toString()));
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            for (ShellTerminalInitCommand bl2 : this.aa) {
                Optional optional;
                if (!bl2.canPotentiallyRunInDialect(m2.getOriginalShellDialect()) || !(optional = bl2.terminalContent((ShellControl)m2)).isPresent()) continue;
                arrayList2.add((String)optional.get());
            }
            String string = terminalInitFunction.isSpecified() ? terminalInitFunction.apply((ShellControl)m2) : null;
            String string2 = string == null && terminalInitScriptConfig.getTerminalSpecificCommands().isSpecified() ? terminalInitScriptConfig.getTerminalSpecificCommands().apply((ShellControl)m2) : null;
            if (string2 != null) {
                arrayList2.add(string2);
            }
            if (string != null) {
                arrayList2.add(string);
            }
            boolean bl2 = m2.d(string);
            terminalInitFunction = TerminalLauncher.constructTerminalInitFile((ShellDialect)m2.getOriginalShellDialect(), (ShellControl)m2, (WorkingDirectoryFunction)workingDirectoryFunction, arrayList, arrayList2, (TerminalInitScriptConfig)terminalInitScriptConfig, (boolean)bl2);
            return m2.getOriginalShellDialect().terminalInitCommand((ShellControl)m2, terminalInitFunction.toString(), bl2);
        }
        catch (Exception exception) {
            this.kill();
            throw exception;
        }
    }

    private boolean a(m m2) {
        if (this.aE != null) {
            return this.aE;
        }
        if (!m2.isRunning(false)) {
            return false;
        }
        if (!this.getEffectiveSecurityPolicy().permitTempScriptCreation()) {
            return true;
        }
        if (m2.getOsType() == OsType.LINUX) {
            FilePath filePath = m2.getSystemTemporaryDirectory().join(new String[]{"xpipe-test"});
            boolean bl = m2.command(CommandBuilder.of().add(new String[]{"touch"}).addFile(filePath).add(new String[]{"&&", "rm", "-f"}).addFile(filePath)).executeAndCheck();
            if (!bl) {
                this.aE = Boolean.TRUE;
                return true;
            }
        }
        this.aE = Boolean.FALSE;
        return false;
    }

    private String a(WorkingDirectoryFunction workingDirectoryFunction) {
        if (!workingDirectoryFunction.isSpecified()) {
            return null;
        }
        workingDirectoryFunction = workingDirectoryFunction.apply((ShellControl)this);
        return this.getOriginalShellDialect().getLaunchCommand().inlineCdCommand(workingDirectoryFunction.toString());
    }

    protected boolean a(TerminalInitFunction object, TerminalInitScriptConfig object2, WorkingDirectoryFunction workingDirectoryFunction, ShellControl shellControl) {
        try {
            boolean bl;
            if (object.isSpecified() || object2.getTerminalSpecificCommands().isSpecified()) {
                return false;
            }
            if (this.aC != null && !this.aC.getDumbMode().supportsAnyPossibleInteraction()) {
                return true;
            }
            object = this.B();
            if (object == ShellDialects.NO_INTERACTION) {
                object = null;
            }
            if (object != null && !object.getDumbMode().supportsAnyPossibleInteraction()) {
                return true;
            }
            object2 = this.C();
            if (object2 != null && object2 != ShellTtyState.NONE) {
                return true;
            }
            object2 = this.A();
            if (object2 == null || !((Boolean)object2).booleanValue()) {
                return false;
            }
            if (!shellControl.isRunning(false) && this.d.isSpecified() && this.osType != OsType.WINDOWS && SecretManager.get((SecretReference)this.getElevationHandler().getSecretRef()).isEmpty()) {
                return false;
            }
            object2 = this.E();
            if (object == null || object2 == null) {
                return false;
            }
            if (this.ac && !this.getLocalSystemAccess().isIdentity()) {
                LicenseProvider.get().checkOsNameOrThrow((String)object2);
            }
            if (bl = workingDirectoryFunction.isSpecified() && !workingDirectoryFunction.isFixed()) {
                return false;
            }
            if (workingDirectoryFunction.isSpecified() && workingDirectoryFunction.isFixed() && this.getOriginalShellDialect().getLaunchCommand().inlineCdCommand(workingDirectoryFunction.apply((ShellControl)this).toString()) == null) {
                return false;
            }
            bl = !this.getEffectiveSecurityPolicy().permitTempScriptCreation();
            if (bl) {
                return true;
            }
            List<ShellTerminalInitCommand> list = this.aa.stream().filter(shellTerminalInitCommand -> this.al == null || shellTerminalInitCommand.canPotentiallyRunInDialect(this.al)).toList();
            boolean bl2 = list.size() > 0;
            return !bl2;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
    }

    protected void J() {
        if (!this.isRunning(true)) {
            this.resetData();
        }
        if (this.running) {
            return;
        }
        if (this.ai) {
            return;
        }
        if (this.ax.isRunning(true) && this.isAnyStreamClosed()) {
            throw new IllegalStateException("Stdin is closed");
        }
        this.ax.start();
        try {
            this.o();
            k.b(this);
            return;
        }
        catch (Throwable throwable) {
            this.kill();
            this.ah.accept(throwable);
            throw this.Z.convert(throwable);
        }
        finally {
            SecretManager.completeRequest((UUID)this.getUuid());
        }
    }

    public void o() {
        boolean bl;
        ShellDialect object6;
        CommandBuilder commandBuilder = null;
        Object object2 = this.B();
        if (object2 == ShellDialects.NO_INTERACTION) {
            object2 = null;
        }
        if ((object6 = (object2 = this.aC != null ? this.aC : object2) != null ? object2.getDumbMode().getSwitchDialect() : null) != null) {
            TrackEvent.withTrace((String)("Switching to " + object6.getDisplayName())).handle();
            m m2 = this;
            commandBuilder = object2.getDumbMode().prepareInlineDumbCommand((ShellControl)m2, m2.az);
            this.aC = object2;
        }
        if (commandBuilder == null) {
            commandBuilder = this.az.prepareWithoutInitCommand();
        }
        if (commandBuilder == null) {
            throw new IllegalStateException("Invalid command");
        }
        object2 = commandBuilder.buildFull(this.ax);
        if (((String)object2).isBlank()) {
            throw new IllegalStateException("Invalid command");
        }
        CountDown countDown = commandBuilder.getCountDown();
        this.X = commandBuilder.getUuid();
        boolean bl2 = this.d.apply(this.ax);
        boolean bl3 = bl = this.user != null && !this.user.equals(this.ax.view().user());
        if (bl2 || bl) {
            object2 = this.ax.buildElevatedCommand((CommandConfiguration)new l((String)object2, null), this.d.getPrefix() != null ? "[" + this.d.getPrefix() + "]" : null, this.X, countDown, this.user);
        }
        this.C = object2;
        TrackEvent.withInfo((String)"Starting sub shell ...").tag("manageParent", (Object)this.ay).tag("command", (Object)this.C).tag("elevated", (Object)bl2).handle();
        bl2 = this.ax.getShellDialect().requiresScript((String)object2);
        Object object3 = new b(UUID.randomUUID(), this.X, UUID.randomUUID(), this.X, (String)object2, null, this.getParent().getTtyState().isHasSeparateStreams(), bl2);
        TrackEvent.withTrace((String)"Executing sub shell command...").tag("command", object2).handle();
        object2 = ((l)object3).fullCommand(this.ax);
        this.ax.setSubShellActive(true);
        this.ax.writeLine((String)object2);
        Object object = object2;
        b b2 = object3;
        object2 = countDown;
        object3 = this;
        long l2 = System.currentTimeMillis() + 5000L;
        f.a((InputStream)((m)object3).ax.getStdout(), ((m)object3).ax.getCharset(), List.of(b2.a().toString()), (String)object, l2, false);
        if (((m)object3).getParent().getTtyState().isHasSeparateStreams()) {
            f.a((InputStream)((m)object3).ax.getStderr(), ((m)object3).ax.getCharset(), List.of(b2.c().toString()), (String)object, l2, true);
        }
        ((i)object3).running = true;
        object2.start(25000L);
        ((j)object3).ai = true;
        Object object4 = object3;
        object2 = new d((ShellControl)object4, ((m)object4).ax.getCharset(), (String)object, ((i)object3).X.toString(), (CountDown)object2, ((m)object3).aC);
        ((d)object2).dw();
        ((j)object3).al = ((d)object2).dH();
        if (((j)object3).ac) {
            LicenseProvider.get().getFeature(((j)object3).H().getLicenseFeatureId()).throwIfUnsupported();
        }
        if (((j)object3).H().getDumbMode().getSwitchDialect() != null) {
            ((m)object3).aC = ((j)object3).H();
            ((m)object3).restart();
            return;
        }
        if (!((j)object3).H().getDumbMode().supportsAnyPossibleInteraction()) {
            for (FailableConsumer failableConsumer : ((j)object3).ab) {
                failableConsumer.accept(object3);
            }
            return;
        }
        if (((m)object3).getStdin().isClosed()) {
            throw new IllegalStateException();
        }
        ((j)object3).al.getDumbMode().prepareInlineShellSwitch((ShellControl)object3);
        ((d)object2).dx();
        ((j)object3).ao = ((d)object2).dr();
        object2 = object3;
        TrackEvent.TrackEventBuilder trackEventBuilder = TrackEvent.withInfo((String)"Detected shell environment...").tag("shellType", (Object)((j)object2).getShellDialect().getId()).tag("ttyState", (Object)((j)object2).getTtyState());
        if (((i)object2).Y == null) {
            ((i)object2).Y = ((j)object2).getShellDialect().determineCharset((ShellControl)object2);
        }
        if (((j)object2).osType == null) {
            ((j)object2).osType = e.I((ShellControl)object2);
        }
        ((j)object2).getShellDialect().getDumbMode().prepareDumbInit((ShellControl)object2);
        if (((j)object2).ae == null) {
            ((j)object2).ae = e.J((ShellControl)object2);
        }
        ShellTemp.checkTempDirectory((ShellControl)object2);
        if (((j)object2).osName == null) {
            ((j)object2).osName = e.K((ShellControl)object2);
        }
        trackEventBuilder.tag("charset", (Object)((i)object2).Y.name()).tag("osType", (Object)((j)object2).osType.getName()).tag("temp", (Object)((j)object2).ae).handle();
        if (((j)object2).ac && !((m)object2).getLocalSystemAccess().isIdentity()) {
            LicenseProvider.get().checkOsNameOrThrow(((j)object2).osName);
        }
        ((m)object3).K();
        ((j)object3).ai = false;
    }

    protected void K() {
        FilePath filePath;
        m m2 = this;
        m2.writeLine(m2.H().getSetEnvironmentVariableCommand("XPIPE_SESSION", AppProperties.get().getSessionId().toString()));
        if (this.am.isSpecified() && (filePath = this.am.apply((ShellControl)this)) != null) {
            ((j)this).view().cd(filePath.toString());
        }
        for (FailableConsumer failableConsumer : this.ab) {
            failableConsumer.accept((Object)this);
        }
        this.L();
    }

    protected void L() {
        Object object = UUID.randomUUID();
        long l2 = System.currentTimeMillis() + 10000L;
        if (this.getTtyState().isHasSeparateStreams()) {
            m m2 = this;
            m2.writeLine(" " + m2.getShellDialect().getEchoCommand(((UUID)object).toString(), false) + this.getShellDialect().getConcatenationOperator() + this.getShellDialect().getEchoCommand(((UUID)object).toString(), true));
            f.a((InputStream)this.getStdout(), this.getCharset(), List.of(((UUID)object).toString()), null, l2, false);
            object = f.a((InputStream)this.getStderr(), this.getCharset(), List.of(((UUID)object).toString()), null, l2, true);
            if (((Optional)object).isPresent() && !((String)((Optional)object).get()).isBlank()) {
                TrackEvent.withWarn((String)((String)((Optional)object).get())).handle();
            }
            return;
        }
        m m3 = this;
        m3.writeLine(" " + m3.getShellDialect().getEchoCommand(((UUID)object).toString(), false));
        f.a((InputStream)this.getStdout(), this.getCharset(), List.of(((UUID)object).toString()), null, l2, false);
    }

    @Generated
    public ShellControl getParent() {
        return this.ax;
    }

    @Generated
    public void setParentSystemAccess(ParentSystemAccess parentSystemAccess) {
        this.aB = parentSystemAccess;
    }
}

