/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.k8s;

import io.xpipe.app.ext.ContainerStoreState;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.CommandControl;
import io.xpipe.app.process.ElevationFunction;
import io.xpipe.app.process.ProcessOutputException;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialects;
import io.xpipe.app.process.ShellOpenFunction;
import io.xpipe.app.storage.ContextualFileReference;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.CommandSupport;
import io.xpipe.app.util.CommandView;
import io.xpipe.app.util.CommandViewBase;
import io.xpipe.core.FilePath;
import io.xpipe.core.OsType;
import io.xpipe.ext.proc.k8s.e;
import io.xpipe.ext.proc.k8s.j;
import io.xpipe.ext.proc.k8s.l;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import lombok.NonNull;

public class i
extends CommandViewBase {
    public i(ShellControl shellControl) {
        super(shellControl);
    }

    private static <T extends Throwable> T b(T t2) {
        return (T)ErrorEventFactory.expectedIfContains(t2, (String[])new String[]{"You must be logged in to the server", "connect: connection refused", "Error from server (Forbidden)", "Error from server (NotFound)", "A connection attempt failed because the connected party did not properly respond after a period of time", "No connection could be made because the target machine actively refused it", "OCI runtime exec failed", "no such host", "Timeout occurred"});
    }

    public i bF() {
        this.shellControl.start();
        return this;
    }

    protected ElevationFunction bG() {
        return new ElevationFunction(){

            public final String getPrefix() {
                return "kubectl";
            }

            public final boolean isSpecified() {
                return true;
            }

            public final boolean apply(ShellControl shellControl) {
                if (shellControl.getOsType() == OsType.WINDOWS) {
                    return false;
                }
                CommandBuilder commandBuilder = CommandBuilder.of().add(new String[]{"kubectl", "config", "current-context"});
                return !shellControl.command(commandBuilder).withExceptionConverter(i::b).executeAndCheck();
            }
        };
    }

    protected CommandControl build(Consumer<CommandBuilder> consumer) {
        CommandBuilder commandBuilder = CommandBuilder.of().add(new String[]{"kubectl"});
        consumer.accept(commandBuilder);
        return this.shellControl.command(commandBuilder).withExceptionConverter(i::b).elevated(this.bG());
    }

    public boolean N() {
        boolean bl = this.shellControl.command("kubectl --help").withExceptionConverter(i::b).executeAndCheck();
        boolean bl2 = this.bH();
        return bl && bl2;
    }

    public boolean bH() {
        Boolean bl = CommandSupport.findProgram((ShellControl)this.shellControl, (String)"kubectl").map(filePath -> !filePath.startsWith("/mnt")).orElse(Boolean.TRUE);
        return bl;
    }

    public String X() {
        String string = this.shellControl.command("kubectl version --client=true").withExceptionConverter(i::b).readStdoutOrThrow();
        Object object = Pattern.compile("GitVersion:\"(.+?)\"");
        if (((Matcher)(object = ((Pattern)object).matcher(string))).find()) {
            return "kubectl " + ((Matcher)object).group(1);
        }
        object = Pattern.compile("Client Version: (.+)");
        if (((Matcher)(object = ((Pattern)object).matcher(string))).find()) {
            return "kubectl " + ((Matcher)object).group(1);
        }
        return null;
    }

    public String c(FilePath filePath) {
        Object object = CommandBuilder.of().add(new String[]{"kubectl"});
        if (filePath != null) {
            object.add(new String[]{"--kubeconfig"}).addFile(filePath);
        }
        object.add(new String[]{"config", "current-context"});
        filePath = this.shellControl.command(object).withExceptionConverter(i::b).elevated(this.bG()).start();
        try {
            object = filePath.readStdoutOrThrow();
            String string = object;
            return string;
        }
        finally {
            if (filePath != null) {
                filePath.close();
            }
        }
    }

    public List<String> bI() {
        try (CommandControl commandControl = this.shellControl.command("kubectl config get-contexts -o name").withExceptionConverter(i::b).elevated(this.bG()).start();){
            String string2 = commandControl.readStdoutOrThrow();
            List<String> list = string2.lines().filter(string -> !string.isEmpty()).toList();
            return list;
        }
    }

    public List<String> bJ() {
        try (CommandControl commandControl = this.shellControl.command("kubectl config view --minify -o jsonpath=\"{..namespace}\"").withExceptionConverter(i::b).elevated(this.bG()).start();){
            Object object = commandControl.readStdoutOrThrow();
            if (((String)object).isEmpty()) {
                List<String> list = List.of();
                return list;
            }
            String[] stringArray = ((String)object).split("\\s+");
            object = Arrays.asList(stringArray);
            return object;
        }
    }

    public a a(ContextualFileReference contextualFileReference, String string, String string2) {
        return new a(this, contextualFileReference, string, string2);
    }

    public /* synthetic */ CommandView start() {
        return this.bF();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class a
    extends CommandView {
        private final ContextualFileReference dn;
        private final String do;
        private final String dp;
        private /* synthetic */ i dq;

        public a(i i2, ContextualFileReference contextualFileReference, String string, String string2) {
            this.dq = i2;
            this.dn = contextualFileReference;
            this.do = string;
            this.dp = string2;
        }

        public String bK() {
            String string = this.build(commandBuilder -> commandBuilder.add(new String[]{"config", "view", "--minify", "-o", "jsonpath=\"{.clusters[].name}\""})).readStdoutOrThrow();
            return string;
        }

        protected CommandControl build(Consumer<CommandBuilder> consumer) {
            return this.dq.build(commandBuilder -> {
                this.y((CommandBuilder)commandBuilder);
                consumer.accept((CommandBuilder)commandBuilder);
            });
        }

        protected ShellControl getShellControl() {
            return this.dq.getShellControl();
        }

        public a bL() {
            this.dq.shellControl.start();
            return this;
        }

        protected void y(CommandBuilder commandBuilder) {
            CommandBuilder commandBuilder2 = CommandBuilder.of();
            commandBuilder2.add(new String[]{"--context"}).addQuoted(this.do);
            if (this.dp != null) {
                commandBuilder2.add(new String[]{"--namespace"}).addQuoted(this.dp);
            }
            if (this.dn != null) {
                commandBuilder2.add(new String[]{"--kubeconfig"}).addFile(arg_0 -> ((ContextualFileReference)this.dn).toAbsoluteFilePath(arg_0));
            }
            commandBuilder.add(1, commandBuilder2);
        }

        public String al(String string) {
            string = this.build(commandBuilder -> commandBuilder.add(new String[]{"describe", "pod"}).addQuoted(string));
            return string.readStdoutOrThrow();
        }

        public String am(String string) {
            string = this.build(commandBuilder -> commandBuilder.add(new String[]{"get", "pod"}).addQuoted(string).add(new String[]{"-o", "yaml"}));
            return string.readStdoutOrThrow();
        }

        public void an(String string) {
            string = this.dq.shellControl.view().writeTextFileDeterministic(this.dq.shellControl.getSystemTemporaryDirectory().join(new String[]{"pod.yml"}), string);
            this.build(arg_0 -> a.a((FilePath)string, arg_0)).execute();
        }

        public boolean bM() {
            Object object;
            try {
                object = this.build(commandBuilder -> commandBuilder.add(new String[]{"get", "nodes", "-o=json", "--request-timeout", "5s"}));
                object = object.readStdoutOrThrow();
            }
            catch (ProcessOutputException processOutputException) {
                ProcessOutputException processOutputException2 = processOutputException;
                if (processOutputException.getOutput().contains("nodes is forbidden")) {
                    return false;
                }
                throw processOutputException2;
            }
            return !((String)object).contains("minikube") && !((String)object).contains("rancher") && !((String)object).contains("Rancher") && !((String)object).contains("k3s") && !((String)object).contains("k3d") && !((String)object).contains("K0s") && !((String)object).contains("kubeadm") && !((String)object).contains("microk8s") && !((String)object).contains("MicroK8s");
        }

        public List<DataStoreEntryRef<l>> b(DataStoreEntryRef<e> object) {
            CommandControl commandControl = this.build(commandBuilder -> commandBuilder.add(new String[]{"get", "pods", "-o=\"custom-columns=NAMESPACE:.metadata.namespace,NAME:.metadata.name,STATUS:.status.phase\""}));
            commandControl = commandControl.start();
            try {
                String string2 = commandControl.readStdoutOrThrow();
                object = string2.lines().skip(1L).map(string -> string.split("\\s+")).map(stringArray -> {
                    object = new l((DataStoreEntryRef<e>)object, stringArray[1]);
                    DataStoreEntry dataStoreEntry = DataStoreEntry.createNew((String)object.getPodName(), (DataStore)object);
                    object = ((l.c.a)((Object)((Object)((l.c.a)((Object)((Object)((l.c)object.getState()).toBuilder().podState(stringArray[2])))).running("Running".equals(stringArray[2]))))).build();
                    dataStoreEntry.setStorePersistentState((DataStoreState)object);
                    return dataStoreEntry.ref();
                }).toList();
                return object;
            }
            finally {
                if (commandControl != null) {
                    commandControl.close();
                }
            }
        }

        public List<DataStoreEntryRef<j>> a(DataStoreEntryRef<l> object) {
            Object object2 = this.build(commandBuilder -> commandBuilder.add(new String[]{"get", "pods", ((l)object.getStore()).getPodName(), "-o"}).addQuoted("jsonpath={.status.phase}"));
            object2 = object2.readStdoutOrThrow();
            object2 = ((l.c.a)((Object)((l.c.a)((Object)((l.c)((l)object.getStore()).getState()).toBuilder().podState((String)object2))).running("Running".equals(object2)))).build();
            ((l)object.getStore()).setState((DataStoreState)object2);
            object2 = this.build(commandBuilder -> commandBuilder.add(new String[]{"get", "pods"}).addQuoted(((l)object.getStore()).getPodName()).add(new String[]{"--output"}).addQuoted("custom-columns=Namespace:.metadata.namespace,Containers:.spec.containers[*].name,Status:.status.phase,Image:.spec.containers[*].image"));
            object2 = object2.start();
            try {
                String string2 = object2.readStdoutOrThrow();
                object = string2.lines().skip(1L).map(string -> string.split("\\s+")).flatMap(stringArray -> {
                    List<String> list = Arrays.stream(stringArray[1].split(",")).toList();
                    List<String> list2 = Arrays.stream(stringArray[3].split(",")).toList();
                    return IntStream.range(0, list.size()).mapToObj(n2 -> {
                        object = new j((DataStoreEntryRef<l>)object, (String)list.get(n2));
                        list = DataStoreEntry.createNew((String)object.getContainerName(), (DataStore)object);
                        stringArray = ((ContainerStoreState.ContainerStoreStateBuilder)((ContainerStoreState)object.getState()).toBuilder().containerState(stringArray[2]).running(Boolean.valueOf("Running".equals(stringArray[2])))).imageName((String)list2.get(Math.min(n2, list2.size() - 1))).build();
                        object.setState((DataStoreState)stringArray);
                        list.setStorePersistentState((DataStoreState)stringArray);
                        return list.ref();
                    });
                }).toList();
                return object;
            }
            finally {
                if (object2 != null) {
                    object2.close();
                }
            }
        }

        public ShellControl i(String string, String string2) {
            ShellControl shellControl = this.dq.shellControl.subShell();
            shellControl.setDumbOpen((ShellOpenFunction)this.a(string, string2, false));
            shellControl.setTerminalOpen((ShellOpenFunction)this.a(string, string2, true));
            return shellControl.withExceptionConverter(i::b).elevated(this.dq.bG());
        }

        private 1 a(String string, String string2, boolean bl) {
            return new ShellOpenFunction(){
                private /* synthetic */ String dr;
                private /* synthetic */ String ds;
                private /* synthetic */ boolean aI;
                private /* synthetic */ a dt;
                {
                    this.dr = string;
                    this.ds = string2;
                    this.aI = bl;
                    this.dt = a2;
                }

                public final CommandBuilder prepareWithoutInitCommand() {
                    return this.dt.b(this.dr, this.ds, this.aI).add(new String[]{"--"}).add(new String[]{ShellDialects.SH.getLaunchCommand().loginCommand()});
                }

                public final CommandBuilder prepareWithInitCommand(@NonNull String string) {
                    if (string == null) {
                        throw new NullPointerException("command is marked non-null but is null");
                    }
                    return this.dt.b(this.dr, this.ds, this.aI).add(new String[]{"--"}).add(new String[]{string});
                }
            };
        }

        public CommandBuilder b(String string, String string2, boolean bl) {
            string = CommandBuilder.of().add(new String[]{"kubectl", "exec", "-i"}).addIf(bl, new String[]{"-t"}).addQuoted(string).add(new String[]{"--container"}).addQuoted(string2);
            this.y((CommandBuilder)string);
            return string;
        }

        public /* synthetic */ CommandView start() {
            return this.bL();
        }

        private static /* synthetic */ void a(FilePath filePath, CommandBuilder commandBuilder) {
            commandBuilder.add(new String[]{"apply", "-f"}).addFile(filePath);
        }
    }
}

