/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.system.lxd;

import io.xpipe.app.comp.Comp;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreProvider;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.ext.DataStoreUsageCategory;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.hub.comp.StoreEntryComp;
import io.xpipe.app.hub.comp.StoreEntryWrapper;
import io.xpipe.app.hub.comp.StoreSection;
import io.xpipe.app.hub.comp.StoreToggleComp;
import io.xpipe.app.hub.comp.SystemStateComp;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreCategory;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.BindingsHelper;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.ext.system.lxd.LxdCmdStore;
import java.util.List;
import javafx.beans.value.ObservableValue;

public class LxdCmdStoreProvider
implements DataStoreProvider {
    public DocumentationLink getHelpLink() {
        return DocumentationLink.LXC;
    }

    public StoreEntryComp customEntryComp(StoreSection sec, boolean preferLarge) {
        StoreToggleComp nonRunning = StoreToggleComp.childrenToggle(null, (boolean)true, (StoreSection)sec, s -> ((LxdCmdStore.State)s.getState()).isShowNonRunning(), (s, aBoolean) -> {
            DataStoreState state = ((LxdCmdStore.State.StateBuilder)((Object)((Object)((LxdCmdStore.State)s.getState()).toBuilder().showNonRunning((boolean)aBoolean)))).build();
            s.setState(state);
        });
        return StoreEntryComp.create((StoreSection)sec, (Comp)nonRunning, (boolean)preferLarge);
    }

    public Comp<?> stateDisplay(StoreEntryWrapper w) {
        return new SystemStateComp(BindingsHelper.map((ObservableValue)w.getPersistentState(), o -> {
            LxdCmdStore.State state = (LxdCmdStore.State)((Object)((Object)o));
            if (state.isReachable()) {
                return SystemStateComp.State.SUCCESS;
            }
            return SystemStateComp.State.FAILURE;
        }));
    }

    public DataStoreUsageCategory getUsageCategory() {
        return DataStoreUsageCategory.GROUP;
    }

    public DataStoreEntry getDisplayParent(DataStoreEntry store) {
        LxdCmdStore s = (LxdCmdStore)store.getStore().asNeeded();
        return s.getHost().get();
    }

    public ObservableValue<String> informationString(StoreSection section) {
        return BindingsHelper.map((ObservableValue)section.getWrapper().getPersistentState(), o -> {
            LxdCmdStore.State state = (LxdCmdStore.State)((Object)((Object)o));
            return state.isReachable() ? "lxd v" + state.getServerVersion() : "Connection failed";
        });
    }

    public String getDisplayIconFileName(DataStore store) {
        return "system:lxd_icon.svg";
    }

    public DataStore defaultStore(DataStoreCategory category) {
        return new LxdCmdStore((DataStoreEntryRef<ShellStore>)DataStorage.get().local().ref());
    }

    public String getId() {
        return "lxdCmd";
    }

    public List<Class<?>> getStoreClasses() {
        return List.of(LxdCmdStore.class);
    }
}

