/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.bun;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.util.ProgramParametersConfigurator;
import com.intellij.execution.wsl.WslPath;
import com.intellij.javascript.bun.BunBundle;
import com.intellij.javascript.bun.BunDebugAdapter;
import com.intellij.javascript.bun.runConfiguration.attach.BunAttachConfiguration;
import com.intellij.javascript.bun.runConfiguration.run.BunRunConfiguration;
import com.intellij.javascript.bun.runConfiguration.run.BunRunConfigurationOptions;
import com.intellij.javascript.bun.settings.BunSettingsService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.dap.DapLaunchArgumentsProvider;
import com.intellij.platform.dap.DapStartRequest;
import com.intellij.platform.dap.DebugAdapterId;
import com.intellij.platform.dap.LaunchRequestArguments;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007H\u0002J#\u0010\u0010\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007H\u0002\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\b\u0003\u0010\u0001\u00a8\u0006\u0011"}, d2={"Lcom/intellij/javascript/bun/BunDapLaunchArgumentsProvider;", "Lcom/intellij/platform/dap/DapLaunchArgumentsProvider;", "<init>", "()V", "isApplicable", "", "executorId", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "getLaunchArguments", "Lcom/intellij/platform/dap/LaunchRequestArguments;", "project", "Lcom/intellij/openapi/project/Project;", "convertFromWslPathIfNeeded", "path", "isRunningOnWsl", "intellij.javascript.bun"})
@SourceDebugExtension(value={"SMAP\nBunDapLaunchArgumentsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BunDapLaunchArgumentsProvider.kt\ncom/intellij/javascript/bun/BunDapLaunchArgumentsProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1#2:96\n*E\n"})
public final class BunDapLaunchArgumentsProvider
implements DapLaunchArgumentsProvider {
    public boolean isApplicable(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return profile instanceof BunRunConfiguration || profile instanceof BunAttachConfiguration;
    }

    @NotNull
    public LaunchRequestArguments getLaunchArguments(@NotNull Project project, @NotNull RunProfile profile) {
        LaunchRequestArguments launchRequestArguments;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        RunProfile runProfile = profile;
        if (runProfile instanceof BunRunConfiguration) {
            Object expandedArgs;
            Map map;
            String string;
            String string2 = ((BunSettingsService.BunSettingsState)BunSettingsService.Companion.getService(project).getState()).getBunPath();
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                string = FileUtil.toSystemDependentName((String)it);
            } else {
                string = null;
            }
            String bunRuntimePath = string;
            String programPath = ((Object)((BunRunConfiguration)profile).getProgramPath$intellij_javascript_bun()).toString();
            if (this.isRunningOnWsl(programPath)) {
                throw new ExecutionException(BunBundle.message("bun.run.configuration.error.wsl.not.supported", new Object[0]));
            }
            String transport = !SystemInfo.isWindows || WslPath.Companion.isWslUncPath(programPath) ? "native" : "tcp";
            String targetWorkingDirectory = this.convertFromWslPathIfNeeded(((BunRunConfiguration)profile).getWorkingDirectory());
            String targetProgramPath = this.convertFromWslPathIfNeeded(programPath);
            BunRunConfigurationOptions options = ((BunRunConfiguration)profile).getOptions();
            EnvironmentVariablesData envVariables = ((BunRunConfiguration)profile).getEnvVariables$intellij_javascript_bun();
            Map $this$getLaunchArguments_u24lambda_u241 = map = MapsKt.createMapBuilder();
            boolean bl = false;
            $this$getLaunchArguments_u24lambda_u241.put("runtime", bunRuntimePath);
            $this$getLaunchArguments_u24lambda_u241.put("program", targetProgramPath);
            CharSequence charSequence = options.getApplicationParameters();
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                List list = ProgramParametersConfigurator.expandMacrosAndParseParameters((String)options.getApplicationParameters());
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"expandMacrosAndParseParameters(...)");
                expandedArgs = list;
                $this$getLaunchArguments_u24lambda_u241.put("args", expandedArgs);
            }
            if (!((expandedArgs = (CharSequence)options.getRuntimeParameters()) == null || StringsKt.isBlank((CharSequence)expandedArgs))) {
                List list = ProgramParametersConfigurator.expandMacrosAndParseParameters((String)options.getRuntimeParameters());
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"expandMacrosAndParseParameters(...)");
                List expandedRuntimeArgs = list;
                $this$getLaunchArguments_u24lambda_u241.put("runtimeArgs", expandedRuntimeArgs);
            }
            $this$getLaunchArguments_u24lambda_u241.put("cwd", targetWorkingDirectory);
            $this$getLaunchArguments_u24lambda_u241.put("stopOnEntry", options.getStopOnEntry());
            $this$getLaunchArguments_u24lambda_u241.put("transport", transport);
            Map map2 = envVariables.getEnvs();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getEnvs(...)");
            if (!map2.isEmpty()) {
                $this$getLaunchArguments_u24lambda_u241.put("env", envVariables.getEnvs());
            }
            Map arguments = MapsKt.build((Map)map);
            launchRequestArguments = new LaunchRequestArguments((DebugAdapterId)BunDebugAdapter.INSTANCE, DapStartRequest.Launch, arguments);
        } else if (runProfile instanceof BunAttachConfiguration) {
            launchRequestArguments = new LaunchRequestArguments((DebugAdapterId)BunDebugAdapter.INSTANCE, DapStartRequest.Launch, MapsKt.mapOf((Pair)TuplesKt.to((Object)"url", (Object)((BunAttachConfiguration)profile).getUrl())));
        } else {
            throw new IllegalArgumentException("Unsupported Run Configuration: " + profile);
        }
        return launchRequestArguments;
    }

    private final String convertFromWslPathIfNeeded(String path) {
        String string;
        if (this.isRunningOnWsl(path)) {
            WslPath wslPath = WslPath.Companion.parseWindowsUncPath(path);
            string = wslPath != null ? wslPath.getLinuxPath() : null;
        } else {
            string = path;
        }
        return string;
    }

    private final boolean isRunningOnWsl(String path) {
        return path != null && WslPath.Companion.isWslUncPath(path);
    }
}

