/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.lang.expr.service.tcb;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.angular2.entities.Angular2DirectiveProperty;
import org.angular2.lang.expr.service.tcb.Context;
import org.angular2.lang.expr.service.tcb.EventParamType;
import org.angular2.lang.expr.service.tcb.Expression;
import org.angular2.lang.expr.service.tcb.Identifier;
import org.angular2.lang.expr.service.tcb.ParsedEventType;
import org.angular2.lang.expr.service.tcb.Scope;
import org.angular2.lang.expr.service.tcb.TcbKt;
import org.angular2.lang.expr.service.tcb.TcbOp;
import org.angular2.lang.expr.service.tcb.TmplAstBoundEvent;
import org.angular2.lang.expr.service.tcb.TmplAstDirectiveContainer;
import org.angular2.lang.expr.service.tcb.TmplDirectiveMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lorg/angular2/lang/expr/service/tcb/TcbDirectiveOutputsOp;", "Lorg/angular2/lang/expr/service/tcb/TcbOp;", "tcb", "Lorg/angular2/lang/expr/service/tcb/Context;", "scope", "Lorg/angular2/lang/expr/service/tcb/Scope;", "node", "Lorg/angular2/lang/expr/service/tcb/TmplAstDirectiveContainer;", "Lorg/angular2/lang/expr/service/tcb/TmplAstElement|TmplAstTemplate;", "dir", "Lorg/angular2/lang/expr/service/tcb/TmplDirectiveMetadata;", "<init>", "(Lorg/angular2/lang/expr/service/tcb/Context;Lorg/angular2/lang/expr/service/tcb/Scope;Lorg/angular2/lang/expr/service/tcb/TmplAstDirectiveContainer;Lorg/angular2/lang/expr/service/tcb/TmplDirectiveMetadata;)V", "optional", "", "getOptional", "()Z", "execute", "Lorg/angular2/lang/expr/service/tcb/Identifier;", "intellij.angular"})
final class TcbDirectiveOutputsOp
extends TcbOp {
    @NotNull
    private final Context tcb;
    @NotNull
    private final Scope scope;
    @NotNull
    private final TmplAstDirectiveContainer node;
    @NotNull
    private final TmplDirectiveMetadata dir;

    public TcbDirectiveOutputsOp(@NotNull Context tcb, @NotNull Scope scope, @NotNull TmplAstDirectiveContainer node, @NotNull TmplDirectiveMetadata dir) {
        Intrinsics.checkNotNullParameter((Object)tcb, (String)"tcb");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        this.tcb = tcb;
        this.scope = scope;
        this.node = node;
        this.dir = dir;
    }

    @Override
    public boolean getOptional() {
        return false;
    }

    @Override
    @Nullable
    public Identifier execute() {
        Ref.ObjectRef dirId = new Ref.ObjectRef();
        Map<String, Angular2DirectiveProperty> outputs = this.dir.getOutputs();
        for (TmplAstBoundEvent output : this.node.getOutputs().values()) {
            Expression handler;
            if (output.getType() == ParsedEventType.Animation || !outputs.containsKey(output.getName())) continue;
            if (this.tcb.getEnv().getConfig().getCheckTypeOfOutputEvents() && StringsKt.endsWith$default((String)output.getName(), (String)"Change", (boolean)false, (int)2, null)) {
                String inputName = StringsKt.removeSuffix((String)output.getName(), (CharSequence)"Change");
                TcbKt.access$checkSplitTwoWayBinding(inputName, output, this.node.getInputs(), this.tcb);
            }
            Angular2DirectiveProperty angular2DirectiveProperty = outputs.get(output.getName());
            Intrinsics.checkNotNull((Object)angular2DirectiveProperty);
            String field = angular2DirectiveProperty.getFieldName();
            if (dirId.element == null) {
                dirId.element = this.scope.resolve(this.node, this.dir);
            }
            Expression outputField = new Expression((Function1<? super Expression.ExpressionBuilder, Unit>)((Function1)arg_0 -> TcbDirectiveOutputsOp.execute$lambda$0(dirId, field, output, arg_0)));
            if (this.tcb.getEnv().getConfig().getCheckTypeOfOutputEvents()) {
                handler = TcbKt.access$tcbCreateEventHandler(output, this.tcb, this.scope, (Object)EventParamType.Infer);
                this.scope.addStatement((Function1<? super Expression.ExpressionBuilder, Unit>)((Function1)arg_0 -> TcbDirectiveOutputsOp.execute$lambda$1(outputField, handler, arg_0)));
                continue;
            }
            this.scope.addStatement(outputField);
            handler = TcbKt.access$tcbCreateEventHandler(output, this.tcb, this.scope, (Object)EventParamType.Any);
            this.scope.addStatement(handler);
        }
        return null;
    }

    private static final Unit execute$lambda$0(Ref.ObjectRef $dirId, String $field, TmplAstBoundEvent $output, Expression.ExpressionBuilder $this$Expression) {
        Intrinsics.checkNotNullParameter((Object)$this$Expression, (String)"$this$Expression");
        Expression.ExpressionBuilder.append$default($this$Expression.append((Identifier)$dirId.element), "[\"" + $field + "\"]", $output.getKeySpan(), false, null, false, false, false, null, null, 508, null);
        return Unit.INSTANCE;
    }

    private static final Unit execute$lambda$1(Expression $outputField, Expression $handler, Expression.ExpressionBuilder $this$addStatement) {
        Intrinsics.checkNotNullParameter((Object)$this$addStatement, (String)"$this$addStatement");
        $this$addStatement.append($outputField).append(".subscribe(").append($handler).append(");");
        return Unit.INSTANCE;
    }
}

