/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.util;

import com.intellij.concurrency.ThreadContext;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramBuilderFactory;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.state.DiagramLayoutSnapshot;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.ui.ClientProperty;
import com.intellij.uml.utils.DiagramBundle;
import java.awt.Component;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagramUpdateService {
    @NotNull
    private static final DiagramUpdateService INSTANCE = new DiagramUpdateService();

    @NotNull
    public static DiagramUpdateService getInstance() {
        DiagramUpdateService diagramUpdateService = INSTANCE;
        if (diagramUpdateService == null) {
            DiagramUpdateService.$$$reportNull$$$0(0);
        }
        return diagramUpdateService;
    }

    private DiagramUpdateService() {
    }

    @NotNull
    public DiagramBuilder.DiagramUpdateQueryParams requestDataModelRefreshPreservingLayout(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramUpdateService.$$$reportNull$$$0(1);
        }
        DiagramLayoutSnapshot snapshot = (DiagramLayoutSnapshot)builder.getGraphBuilder().getActionExecutor().computeReadAction(() -> DiagramLayoutSnapshot.Factory.getInstance().makeSnapshot(builder));
        DiagramBuilder.DiagramUpdateQueryParams diagramUpdateQueryParams = this.requestDataModelRefreshPreservingLayout(builder, snapshot, false);
        if (diagramUpdateQueryParams == null) {
            DiagramUpdateService.$$$reportNull$$$0(2);
        }
        return diagramUpdateQueryParams;
    }

    @NotNull
    public DiagramBuilder.DiagramUpdateQueryParams requestDataModelRefreshPreservingLayout(@NotNull DiagramBuilder builder, @NotNull DiagramLayoutSnapshot layoutSnapshot, boolean nodePresentationUpdate) {
        if (builder == null) {
            DiagramUpdateService.$$$reportNull$$$0(3);
        }
        if (layoutSnapshot == null) {
            DiagramUpdateService.$$$reportNull$$$0(4);
        }
        MyDiagramUpdateQueryParams params = new MyDiagramUpdateQueryParams(builder, builder.queryUpdate(), layoutSnapshot).withPresentationUpdate();
        if (DiagramUpdateService.isJourneyViewComponent(builder.getView())) {
            DiagramBuilder.DiagramUpdateQueryParams diagramUpdateQueryParams = params.withNodePresentationsUpdate(false);
            if (diagramUpdateQueryParams == null) {
                DiagramUpdateService.$$$reportNull$$$0(5);
            }
            return diagramUpdateQueryParams;
        }
        params = params.withRelayout();
        DiagramBuilder.DiagramUpdateQueryParams diagramUpdateQueryParams = nodePresentationUpdate ? params.withNodePresentationsUpdate(true) : params.withDataReload();
        if (diagramUpdateQueryParams == null) {
            DiagramUpdateService.$$$reportNull$$$0(6);
        }
        return diagramUpdateQueryParams;
    }

    private static boolean isJourneyViewComponent(@NotNull Graph2DView view) {
        if (view == null) {
            DiagramUpdateService.$$$reportNull$$$0(7);
        }
        return view.getJComponent() != null && ClientProperty.isTrue((Component)view.getJComponent(), (Object)"Journey-View-Component-Key");
    }

    @NotNull
    public CompletableFuture<Void> refreshDataModelUnderProgressAsync(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramUpdateService.$$$reportNull$$$0(8);
        }
        CompletableFuture<Void> completableFuture = Futures.runAsyncProgressInBackground(builder.getProject(), DiagramBundle.message("diagram.build.progress.building.data.model", new Object[0]), true, PerformInBackgroundOption.ALWAYS_BACKGROUND, indicator -> builder.getDataModel().refreshDataModelAsync((ProgressIndicator)indicator));
        if (completableFuture == null) {
            DiagramUpdateService.$$$reportNull$$$0(9);
        }
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<Void> updateNodePresentations(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramUpdateService.$$$reportNull$$$0(10);
        }
        CompletableFuture<Void> completableFuture = Futures.runAsyncProgressInBackground(builder.getProject(), DiagramBundle.message("progress.title.updating.node.presentations", new Object[0]), true, PerformInBackgroundOption.ALWAYS_BACKGROUND, indicator -> builder.getDataModel().updateNodePresentations((ProgressIndicator)indicator));
        if (completableFuture == null) {
            DiagramUpdateService.$$$reportNull$$$0(11);
        }
        return completableFuture;
    }

    @NotNull
    private static CompletableFuture<Void> updateModelBuilderIfNeededAsync(@NotNull DiagramBuilder builder, @NotNull DiagramBuilder.DiagramUpdateQueryParams params) {
        DiagramBuilder modelBuilder;
        if (builder == null) {
            DiagramUpdateService.$$$reportNull$$$0(12);
        }
        if (params == null) {
            DiagramUpdateService.$$$reportNull$$$0(13);
        }
        if ((modelBuilder = DiagramBuilderFactory.getInstance().getModelBuilder(builder)) != builder) {
            CompletableFuture<Void> completableFuture = modelBuilder.queryUpdate(params).runAsync();
            if (completableFuture == null) {
                DiagramUpdateService.$$$reportNull$$$0(14);
            }
            return completableFuture;
        }
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        if (completableFuture == null) {
            DiagramUpdateService.$$$reportNull$$$0(15);
        }
        return completableFuture;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 7, 8, 10, 12, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/util/DiagramUpdateService";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutSnapshot";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/util/DiagramUpdateService";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "requestDataModelRefreshPreservingLayout";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshDataModelUnderProgressAsync";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "updateNodePresentations";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "updateModelBuilderIfNeededAsync";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "requestDataModelRefreshPreservingLayout";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isJourneyViewComponent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "refreshDataModelUnderProgressAsync";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateNodePresentations";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateModelBuilderIfNeededAsync";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 7, 8, 10, 12, 13 -> new IllegalArgumentException(string);
        };
    }

    private static final class MyDiagramUpdateQueryParams
    implements DiagramBuilder.DiagramUpdateQueryParams {
        @NotNull
        private final DiagramBuilder myBuilder;
        @NotNull
        private final DiagramBuilder.DiagramUpdateQueryParams myDelegate;
        @NotNull
        private final DiagramLayoutSnapshot myLayoutSnapshot;

        private MyDiagramUpdateQueryParams(@NotNull DiagramBuilder builder, @NotNull DiagramBuilder.DiagramUpdateQueryParams delegate, @NotNull DiagramLayoutSnapshot layoutSnapshot) {
            if (builder == null) {
                MyDiagramUpdateQueryParams.$$$reportNull$$$0(0);
            }
            if (delegate == null) {
                MyDiagramUpdateQueryParams.$$$reportNull$$$0(1);
            }
            if (layoutSnapshot == null) {
                MyDiagramUpdateQueryParams.$$$reportNull$$$0(2);
            }
            this.myBuilder = builder;
            this.myDelegate = delegate;
            this.myLayoutSnapshot = layoutSnapshot;
        }

        @Override
        @NotNull
        public MyDiagramUpdateQueryParams withDataReload() {
            this.myDelegate.withDataReload();
            MyDiagramUpdateQueryParams myDiagramUpdateQueryParams = this;
            if (myDiagramUpdateQueryParams == null) {
                MyDiagramUpdateQueryParams.$$$reportNull$$$0(3);
            }
            return myDiagramUpdateQueryParams;
        }

        @Override
        @NotNull
        public MyDiagramUpdateQueryParams withRelayout() {
            this.myDelegate.withRelayout();
            MyDiagramUpdateQueryParams myDiagramUpdateQueryParams = this;
            if (myDiagramUpdateQueryParams == null) {
                MyDiagramUpdateQueryParams.$$$reportNull$$$0(4);
            }
            return myDiagramUpdateQueryParams;
        }

        @Override
        @NotNull
        public MyDiagramUpdateQueryParams withRelayout(@NotNull Layouter layouter) {
            if (layouter == null) {
                MyDiagramUpdateQueryParams.$$$reportNull$$$0(5);
            }
            this.myDelegate.withRelayout(layouter);
            MyDiagramUpdateQueryParams myDiagramUpdateQueryParams = this;
            if (myDiagramUpdateQueryParams == null) {
                MyDiagramUpdateQueryParams.$$$reportNull$$$0(6);
            }
            return myDiagramUpdateQueryParams;
        }

        @Override
        @NotNull
        public MyDiagramUpdateQueryParams withPresentationUpdate() {
            this.myDelegate.withPresentationUpdate();
            MyDiagramUpdateQueryParams myDiagramUpdateQueryParams = this;
            if (myDiagramUpdateQueryParams == null) {
                MyDiagramUpdateQueryParams.$$$reportNull$$$0(7);
            }
            return myDiagramUpdateQueryParams;
        }

        @Override
        @NotNull
        public DiagramBuilder.DiagramUpdateQueryParams withNodePresentationsUpdate(boolean updateNodePresentations) {
            this.myDelegate.withNodePresentationsUpdate(updateNodePresentations);
            MyDiagramUpdateQueryParams myDiagramUpdateQueryParams = this;
            if (myDiagramUpdateQueryParams == null) {
                MyDiagramUpdateQueryParams.$$$reportNull$$$0(8);
            }
            return myDiagramUpdateQueryParams;
        }

        @Override
        @NotNull
        public MyDiagramUpdateQueryParams withAllNodeSizeUpdate() {
            this.myDelegate.withAllNodeSizeUpdate();
            MyDiagramUpdateQueryParams myDiagramUpdateQueryParams = this;
            if (myDiagramUpdateQueryParams == null) {
                MyDiagramUpdateQueryParams.$$$reportNull$$$0(9);
            }
            return myDiagramUpdateQueryParams;
        }

        @Override
        @NotNull
        public MyDiagramUpdateQueryParams withNodeSizeUpdate(DiagramNode<?> ... nodesForSizeUpdate) {
            if (nodesForSizeUpdate == null) {
                MyDiagramUpdateQueryParams.$$$reportNull$$$0(10);
            }
            this.myDelegate.withNodeSizeUpdate(nodesForSizeUpdate);
            MyDiagramUpdateQueryParams myDiagramUpdateQueryParams = this;
            if (myDiagramUpdateQueryParams == null) {
                MyDiagramUpdateQueryParams.$$$reportNull$$$0(11);
            }
            return myDiagramUpdateQueryParams;
        }

        @Override
        public void run() {
            this.myBuilder.getDataModel().refreshDataModel();
            this.myDelegate.run();
            this.myLayoutSnapshot.restoreLayoutingNewNodesAsync(this.myBuilder);
        }

        @Override
        @NotNull
        public CompletableFuture<Void> runAsync() {
            if (this.doUpdateNodePresentations()) {
                CompletionStage completionStage = ((CompletableFuture)((CompletableFuture)DiagramUpdateService.getInstance().updateNodePresentations(this.myBuilder).thenComposeAsync(ThreadContext.captureThreadContext(__ -> this.myDelegate.runAsync()))).thenComposeAsync(ThreadContext.captureThreadContext(__ -> DiagramUpdateService.updateModelBuilderIfNeededAsync(this.myBuilder, this)))).whenComplete(Futures.logIfFailed(DiagramUpdateService.class));
                if (completionStage == null) {
                    MyDiagramUpdateQueryParams.$$$reportNull$$$0(12);
                }
                return completionStage;
            }
            CompletionStage completionStage = ((CompletableFuture)((CompletableFuture)((CompletableFuture)DiagramUpdateService.getInstance().refreshDataModelUnderProgressAsync(this.myBuilder).thenComposeAsync(ThreadContext.captureThreadContext(__ -> this.myDelegate.runAsync()))).thenComposeAsync(ThreadContext.captureThreadContext(__ -> this.myLayoutSnapshot.restoreLayoutingNewNodesAsync(this.myBuilder)))).thenComposeAsync(ThreadContext.captureThreadContext(__ -> DiagramUpdateService.updateModelBuilderIfNeededAsync(this.myBuilder, this)))).whenComplete(Futures.logIfFailed(DiagramUpdateService.class));
            if (completionStage == null) {
                MyDiagramUpdateQueryParams.$$$reportNull$$$0(13);
            }
            return completionStage;
        }

        @Override
        @NotNull
        public DiagramBuilder.DiagramUpdateQueryParams endQuery() {
            DiagramBuilder.DiagramUpdateQueryParams diagramUpdateQueryParams = this.myDelegate.endQuery();
            if (diagramUpdateQueryParams == null) {
                MyDiagramUpdateQueryParams.$$$reportNull$$$0(14);
            }
            return diagramUpdateQueryParams;
        }

        @Override
        public boolean doReloadData() {
            return this.myDelegate.doReloadData();
        }

        @Override
        public boolean doPresentationUpdate() {
            return this.myDelegate.doPresentationUpdate();
        }

        @Override
        public boolean doUpdateNodePresentations() {
            return this.myDelegate.doUpdateNodePresentations();
        }

        @Override
        @NotNull
        public Collection<DiagramNode<?>> getNodesForSizeUpdate() {
            Collection<DiagramNode<?>> collection = this.myDelegate.getNodesForSizeUpdate();
            if (collection == null) {
                MyDiagramUpdateQueryParams.$$$reportNull$$$0(15);
            }
            return collection;
        }

        @Override
        @Nullable
        public Layouter getLayouter() {
            return this.myDelegate.getLayouter();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 6, 7, 8, 9, 11, 12, 13, 14, 15 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "layoutSnapshot";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diagram/util/DiagramUpdateService$MyDiagramUpdateQueryParams";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "layouter";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodesForSizeUpdate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diagram/util/DiagramUpdateService$MyDiagramUpdateQueryParams";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withDataReload";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withRelayout";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withPresentationUpdate";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withNodePresentationsUpdate";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withAllNodeSizeUpdate";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withNodeSizeUpdate";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runAsync";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "endQuery";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodesForSizeUpdate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "withRelayout";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "withNodeSizeUpdate";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 6, 7, 8, 9, 11, 12, 13, 14, 15 -> new IllegalStateException(string);
            };
        }
    }
}

