/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.presentation;

import com.intellij.application.options.CodeStyle;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.DiagramNoteEdge;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationships;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.diagram.presentation.EdgeInfo;
import com.intellij.diagram.presentation.SimpleElement;
import com.intellij.diagram.settings.DiagramConfiguration;
import com.intellij.diagram.settings.DiagramLayout;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.geom.YPoint;
import com.intellij.openapi.graph.layout.EdgeLayout;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.CollectionFactory;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import net.jcip.annotations.Immutable;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class DiagramState
implements FileEditorState {
    @NotNull
    private static final Logger LOG = Logger.getInstance(DiagramState.class);
    @Nullable
    private final String myVisibility;
    @Nullable
    private final String myScope;
    @NotNull
    private final Set<DiagramCategory> myEnabledCategories;
    private final double myZoom;
    @NotNull
    private final Point2D myLocation;
    private final boolean myIsEdgeCreationMode;
    private final boolean myDoShowDependencies;
    @NotNull
    private final GraphSettings myViewSettings;
    @Nullable
    private final String myOriginalFQN;
    @Nullable
    private final String myProviderID;
    @NotNull
    private final Set<String> myFqns;
    @NotNull
    private final Set<String> mySelectedNodes;
    @NotNull
    private final Map<String, String> myNotes;
    @NotNull
    private final Map<String, Couple<Double>> myNodesCoord;
    @NotNull
    private final Map<String, Couple<Double>> myNotesCoord;
    @NotNull
    private final Map<Trinity<String, String, String>, EdgeInfo> myEdgesCoord;
    @NotNull
    private final Map<String, EdgeInfo> myNoteEdgesCoord;
    @NotNull
    private static final Map<DiagramBuilder, CachedValue<DiagramState>> OUR_STATES_CACHE = CollectionFactory.createConcurrentWeakIdentityMap();
    @NotNull
    @NonNls
    private static final String NODES = "nodes";
    @NotNull
    @NonNls
    private static final String SETTINGS = "settings";
    @NotNull
    @NonNls
    private static final String EDGES = "edges";
    @NotNull
    @NonNls
    private static final String SELECTED_NODES = "SelectedNodes";
    @NotNull
    @NonNls
    private static final String LAYOUT = "layout";
    @NotNull
    @NonNls
    private static final String ZOOM = "zoom";
    @NotNull
    @NonNls
    private static final String SHOW_DEPENDENCIES = "showDependencies";
    @NotNull
    @NonNls
    private static final String EDGE = "edge";
    @NotNull
    @NonNls
    private static final String X = "x";
    @NotNull
    @NonNls
    private static final String Y = "y";
    @NotNull
    @NonNls
    private static final String NOTES = "notes";
    @NotNull
    @NonNls
    private static final String NOTE = "note";
    @NotNull
    @NonNls
    private static final String VALUE = "value";
    @NotNull
    @NonNls
    private static final String SOURCE = "source";
    @NotNull
    @NonNls
    private static final String TARGET = "target";
    @NotNull
    @NonNls
    private static final String RELATIONSHIP = "relationship";
    @NotNull
    @NonNls
    private static final String POINT = "point";
    @NotNull
    @NonNls
    private static final String NODE = "node";
    @NotNull
    @NonNls
    private static final String CATEGORIES = "Categories";
    @NotNull
    @NonNls
    private static final String CATEGORY = "Category";
    @NotNull
    @NonNls
    private static final String ORIGINAL_ELEMENT = "OriginalElement";
    @NotNull
    @NonNls
    private static final String ID = "ID";
    @NotNull
    @NonNls
    private static final String SCOPE = "SCOPE";
    @NotNull
    @NonNls
    private static final String VISIBILITY = "VISIBILITY";

    /*
     * WARNING - void declaration
     */
    private DiagramState(@Nullable String visibility, @Nullable String scope, @Nullable String originalFQN, @Nullable String providerID, @NotNull Set<DiagramCategory> enabledCategories, double zoom, @NotNull Point2D location, boolean isEdgeCreationMode, boolean doShowDependencies, @NotNull GraphSettings viewSettings, @NotNull Set<String> fqns, @NotNull Set<String> selectedNodes, @NotNull Map<String, String> notes, @NotNull Map<String, Couple<Double>> nodesCoord, @NotNull Map<Trinity<String, String, String>, EdgeInfo> edgesCoord, @NotNull Map<String, Couple<Double>> notesCoord, @NotNull Map<String, EdgeInfo> map) {
        void noteEdgesCoord;
        if (enabledCategories == null) {
            DiagramState.$$$reportNull$$$0(0);
        }
        if (location == null) {
            DiagramState.$$$reportNull$$$0(1);
        }
        if (viewSettings == null) {
            DiagramState.$$$reportNull$$$0(2);
        }
        if (fqns == null) {
            DiagramState.$$$reportNull$$$0(3);
        }
        if (selectedNodes == null) {
            DiagramState.$$$reportNull$$$0(4);
        }
        if (notes == null) {
            DiagramState.$$$reportNull$$$0(5);
        }
        if (nodesCoord == null) {
            DiagramState.$$$reportNull$$$0(6);
        }
        if (edgesCoord == null) {
            DiagramState.$$$reportNull$$$0(7);
        }
        if (notesCoord == null) {
            DiagramState.$$$reportNull$$$0(8);
        }
        if (map == null) {
            DiagramState.$$$reportNull$$$0(9);
        }
        this.myVisibility = visibility;
        this.myScope = scope;
        this.myOriginalFQN = originalFQN;
        this.myProviderID = providerID;
        this.myEnabledCategories = enabledCategories;
        this.myZoom = zoom;
        this.myLocation = location;
        this.myIsEdgeCreationMode = isEdgeCreationMode;
        this.myDoShowDependencies = doShowDependencies;
        this.myViewSettings = viewSettings;
        this.myFqns = fqns;
        this.mySelectedNodes = selectedNodes;
        this.myNotes = notes;
        this.myNodesCoord = nodesCoord;
        this.myEdgesCoord = edgesCoord;
        this.myNotesCoord = notesCoord;
        this.myNoteEdgesCoord = noteEdgesCoord;
    }

    @Deprecated(forRemoval=true)
    public DiagramState(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramState.$$$reportNull$$$0(10);
        }
        DiagramDataModel<?> dataModel = builder.getDataModel();
        DiagramProvider<?> umlProvider = builder.getProvider();
        DiagramVfsResolver<?> resolver = umlProvider.getVfsResolver();
        DiagramScopeManager<?> scopeManager = dataModel.getScopeManager();
        DiagramNodeContentManager nodeContentManager = dataModel.getNodeContentManager();
        NamedScope scope = scopeManager == null ? null : scopeManager.getCurrentScope();
        VisibilityLevel level = dataModel.getVisibilityManager().getCurrentVisibilityLevel();
        LinkedHashSet<String> fqns = new LinkedHashSet<String>();
        HashSet<String> selectedNodes = new HashSet<String>();
        HashMap<String, String> notes = new HashMap<String, String>();
        HashMap<String, Couple<Double>> nodesCoord = new HashMap<String, Couple<Double>>();
        HashMap<Trinity<String, String, String>, EdgeInfo> edgesCoord = new HashMap<Trinity<String, String, String>, EdgeInfo>();
        HashMap<String, Couple<Double>> notesCoord = new HashMap<String, Couple<Double>>();
        HashMap<String, EdgeInfo> noteEdgesCoord = new HashMap<String, EdgeInfo>();
        builder.getGraphBuilder().getActionExecutor().runGraphActionAsync(() -> {
            YPoint point;
            Node n;
            String fqn;
            for (DiagramNode diagramNode : new ArrayList(dataModel.getNodes())) {
                fqn = diagramNode.getQualifiedName();
                if (fqn == null) continue;
                fqns.add(fqn);
                n = builder.getNode(diagramNode);
                if (n == null) continue;
                point = builder.getGraph().getLocation(n);
                nodesCoord.put(fqn, Couple.of((Object)point.getX(), (Object)point.getY()));
                if (!builder.getGraph().isSelected(n)) continue;
                selectedNodes.add(fqn);
            }
            for (DiagramNoteNode diagramNoteNode : new ArrayList<DiagramNoteNode>(dataModel.getNotes().values())) {
                fqn = diagramNoteNode.getIdentifyingElement().getQualifiedName();
                if (fqn == null || !fqns.contains(fqn) || (n = builder.getNode(diagramNoteNode)) == null) continue;
                point = builder.getGraph().getLocation(n);
                notesCoord.put(fqn, Couple.of((Object)point.getX(), (Object)point.getY()));
                notes.put(fqn, diagramNoteNode.getTooltip());
            }
            for (DiagramEdge diagramEdge : new ArrayList(builder.getEdgeObjects())) {
                Edge edge = builder.getEdge(diagramEdge);
                EdgeLayout edgeLayout = builder.getGraph().getEdgeLayout(edge);
                if (edgeLayout == null) continue;
                EdgeInfo info = new EdgeInfo(diagramEdge, builder);
                if (diagramEdge instanceof DiagramNoteEdge) {
                    noteEdgesCoord.put(info.getSrc(), info);
                    continue;
                }
                edgesCoord.put(new Trinity((Object)info.getSrc(), (Object)info.getTrg(), (Object)diagramEdge.getRelationship().toString()), info);
            }
        });
        this.myVisibility = level == null ? null : level.getName();
        this.myScope = scope == null ? null : scope.getScopeId();
        this.myOriginalFQN = resolver.getQualifiedName(dataModel.getOriginalElement());
        this.myProviderID = umlProvider.getID();
        this.myEnabledCategories = new TreeSet<DiagramCategory>(Arrays.asList(nodeContentManager.getEnabledCategories()));
        this.myZoom = builder.getGraphBuilder().getZoom();
        this.myLocation = builder.getView().getCenter();
        this.myIsEdgeCreationMode = builder.doAllowEdgeCreation();
        this.myDoShowDependencies = builder.getDataModel().isShowDependencies();
        this.myViewSettings = builder.getPresentationModel().getSettings().copy();
        this.myFqns = fqns;
        this.mySelectedNodes = selectedNodes;
        this.myNotes = notes;
        this.myNodesCoord = nodesCoord;
        this.myEdgesCoord = edgesCoord;
        this.myNotesCoord = notesCoord;
        this.myNoteEdgesCoord = noteEdgesCoord;
    }

    @NotNull
    public static DiagramState empty(@Nullable DiagramProvider<?> provider) {
        return new DiagramState(null, DiagramConfiguration.getInstance().getDefaultScope(), null, provider != null ? provider.getID() : null, new TreeSet<DiagramCategory>(), 1.0, new Point(0, 0), false, false, new GraphSettings(), new LinkedHashSet<String>(), new HashSet<String>(), new HashMap<String, String>(), new HashMap<String, Couple<Double>>(), new HashMap<Trinity<String, String, String>, EdgeInfo>(), new HashMap<String, Couple<Double>>(), new HashMap<String, EdgeInfo>());
    }

    @NotNull
    public static DiagramState makeBuilderSnapshot(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramState.$$$reportNull$$$0(11);
        }
        DiagramState diagramState = (DiagramState)OUR_STATES_CACHE.computeIfAbsent(builder, __ -> CachedValuesManager.getManager((Project)builder.getProject()).createCachedValue(() -> CachedValueProvider.Result.create((Object)new DiagramState(builder), (Object[])new Object[]{builder.getPresentationModel().getModificationTrackerOfGraphUpdates(), builder.getPresentationModel().getModificationTrackerOfViewUpdates()}))).getValue();
        if (diagramState == null) {
            DiagramState.$$$reportNull$$$0(12);
        }
        return diagramState;
    }

    public static void invalidateSnapshotsFor(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramState.$$$reportNull$$$0(13);
        }
        OUR_STATES_CACHE.remove(builder);
    }

    @Deprecated(forRemoval=true)
    public void copyFrom(@NotNull DiagramState state) {
        if (state == null) {
            DiagramState.$$$reportNull$$$0(14);
        }
    }

    @Deprecated(forRemoval=true)
    public void setOriginalFQN(String originalFQN) {
    }

    @Deprecated(forRemoval=true)
    public void setCurrentVisibility(String currentVisibility) {
    }

    public boolean canBeMergedWith(@NotNull FileEditorState otherState, @NotNull FileEditorStateLevel level) {
        if (otherState == null) {
            DiagramState.$$$reportNull$$$0(15);
        }
        if (level == null) {
            DiagramState.$$$reportNull$$$0(16);
        }
        return false;
    }

    @Nullable
    public String getProviderID() {
        return this.myProviderID;
    }

    @Nullable
    public EdgeInfo getEdgeInfo(@Nullable String src, @Nullable String trg, @NotNull String relationshipName) {
        if (relationshipName == null) {
            DiagramState.$$$reportNull$$$0(17);
        }
        return this.myEdgesCoord.get(new Trinity((Object)src, (Object)trg, (Object)relationshipName));
    }

    @Nullable
    public EdgeInfo getNoteEdgeCoord(@Nullable String fqn) {
        return this.myNoteEdgesCoord.get(fqn);
    }

    public @NotNull Map<String, @Nls String> getNotes() {
        Map<String, String> map = Collections.unmodifiableMap(this.myNotes);
        if (map == null) {
            DiagramState.$$$reportNull$$$0(18);
        }
        return map;
    }

    @NotNull
    public Map<String, Couple<Double>> getNotesCoord() {
        Map<String, Couple<Double>> map = Collections.unmodifiableMap(this.myNotesCoord);
        if (map == null) {
            DiagramState.$$$reportNull$$$0(19);
        }
        return map;
    }

    public boolean isEdgeCreationMode() {
        return this.myIsEdgeCreationMode;
    }

    public boolean isShowDependencies() {
        return this.myDoShowDependencies;
    }

    @NotNull
    public GraphSettings getViewSettings() {
        GraphSettings graphSettings = this.myViewSettings;
        if (graphSettings == null) {
            DiagramState.$$$reportNull$$$0(20);
        }
        return graphSettings;
    }

    @Deprecated(forRemoval=true)
    public boolean isCategoryEnabled(@NotNull DiagramCategory category) {
        DiagramProvider provider;
        if (category == null) {
            DiagramState.$$$reportNull$$$0(21);
        }
        return (provider = DiagramProvider.findByID(this.myProviderID)) != null && provider.getNodeContentManager().isCategoryEnabled(category);
    }

    @Deprecated(forRemoval=true)
    public void setCategoryEnabled(@NotNull DiagramCategory category, boolean enabled) {
        DiagramProvider provider;
        if (category == null) {
            DiagramState.$$$reportNull$$$0(22);
        }
        if ((provider = DiagramProvider.findByID(this.myProviderID)) != null) {
            provider.getNodeContentManager().setCategoryEnabled(category, enabled);
        }
    }

    @Deprecated(forRemoval=true)
    public DiagramCategory @NotNull [] getEnabledCategories() {
        DiagramProvider provider = DiagramProvider.findByID(this.myProviderID);
        DiagramCategory[] diagramCategoryArray = provider != null ? provider.getNodeContentManager().getEnabledCategories() : DiagramCategory.EMPTY_ARRAY;
        if (diagramCategoryArray == null) {
            DiagramState.$$$reportNull$$$0(23);
        }
        return diagramCategoryArray;
    }

    public double getZoom() {
        return this.myZoom;
    }

    public String @NotNull [] getFQNs() {
        String[] stringArray = ArrayUtilRt.toStringArray(this.myFqns);
        if (stringArray == null) {
            DiagramState.$$$reportNull$$$0(24);
        }
        return stringArray;
    }

    @NotNull
    public String getNodeX(@NotNull String fqn) {
        Couple<Double> coord;
        if (fqn == null) {
            DiagramState.$$$reportNull$$$0(25);
        }
        String string = (coord = this.myNodesCoord.get(fqn)) == null ? "" : String.valueOf(coord.getFirst());
        if (string == null) {
            DiagramState.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public String getNodeY(@NotNull String fqn) {
        Couple<Double> coord;
        if (fqn == null) {
            DiagramState.$$$reportNull$$$0(27);
        }
        String string = (coord = this.myNodesCoord.get(fqn)) == null ? "" : String.valueOf(coord.getSecond());
        if (string == null) {
            DiagramState.$$$reportNull$$$0(28);
        }
        return string;
    }

    public String @NotNull [] getSelectedNodes() {
        String[] stringArray = ArrayUtilRt.toStringArray(this.mySelectedNodes);
        if (stringArray == null) {
            DiagramState.$$$reportNull$$$0(29);
        }
        return stringArray;
    }

    @NotNull
    public Point2D getCenter() {
        Point2D point2D = this.myLocation;
        if (point2D == null) {
            DiagramState.$$$reportNull$$$0(30);
        }
        return point2D;
    }

    public EdgeInfo @NotNull [] getEdgeInfos() {
        EdgeInfo[] edgeInfoArray = this.myEdgesCoord.values().toArray(new EdgeInfo[0]);
        if (edgeInfoArray == null) {
            DiagramState.$$$reportNull$$$0(31);
        }
        return edgeInfoArray;
    }

    @Nullable
    public String getOriginalFQN() {
        return this.myOriginalFQN;
    }

    @Nullable
    public String getCurrentVisibility() {
        return this.myVisibility;
    }

    @Nullable
    public String getCurrentScope() {
        return this.myScope;
    }

    @Deprecated(forRemoval=true)
    public void update(@NotNull DiagramBuilder builder, boolean updateCategories) {
        if (builder == null) {
            DiagramState.$$$reportNull$$$0(32);
        }
    }

    private boolean isEmpty() {
        return this.myNodesCoord.isEmpty() && this.myEdgesCoord.isEmpty();
    }

    public void restoreTo(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramState.$$$reportNull$$$0(33);
        }
        if (this.myProviderID != null && !builder.getProvider().getID().equals(this.myProviderID)) {
            if (!this.isEmpty()) {
                LOG.error("Can not apply state to the builder of another provider");
            }
            return;
        }
        builder.getGraphBuilder().getActionExecutor().runGraphActionAsync(() -> {
            Object originalElement;
            DiagramDataModel<?> dataModel = builder.getDataModel();
            DiagramVfsResolver<?> resolver = builder.getProvider().getVfsResolver();
            HashMap fqn2nodeCache = new HashMap();
            HashMap<Object, String> element2fqnCache = new HashMap<Object, String>();
            DiagramVisibilityManager visibilityManager = dataModel.getVisibilityManager();
            String visibility = this.getCurrentVisibility();
            Arrays.stream(visibilityManager.getVisibilityLevels()).filter(it -> it.getName().equals(visibility)).findFirst().ifPresent(it -> visibilityManager.setCurrentVisibilityLevel((VisibilityLevel)it));
            DiagramScopeManager<?> scopeManager = dataModel.getScopeManager();
            if (scopeManager != null) {
                scopeManager.setCurrentScope(this.getCurrentScope());
            }
            DiagramNodeContentManager nodeContentManager = dataModel.getNodeContentManager();
            for (DiagramCategory diagramCategory : nodeContentManager.getContentCategories()) {
                nodeContentManager.setCategoryEnabled(diagramCategory, this.myEnabledCategories.contains(diagramCategory));
            }
            builder.setAllowEdgeCreation(this.myIsEdgeCreationMode);
            dataModel.setShowDependencies(this.isShowDependencies());
            builder.getPresentationModel().getSettings().setFrom(this.myViewSettings);
            Object t = originalElement = this.myOriginalFQN != null ? (Object)resolver.resolveElementByFQN(this.myOriginalFQN, builder.getProject()) : null;
            if (originalElement != null) {
                dataModel.rebuild(originalElement);
                for (DiagramNode<?> node : dataModel.getNodes()) {
                    fqn2nodeCache.put(DiagramState.getElementFqn(resolver, element2fqnCache, node), node);
                }
            }
            Project project = builder.getProject();
            for (String string : this.getFQNs()) {
                DiagramNode cachedNode = (DiagramNode)fqn2nodeCache.get(string);
                Object dataElement = cachedNode != null ? cachedNode.getIdentifyingElement() : resolver.resolveElementByFQN(string, project);
                DiagramNode<?> newNode = dataModel.addElement(dataElement);
                if (newNode == null) continue;
                fqn2nodeCache.put(string, newNode);
            }
            for (Map.Entry entry : this.getNotes().entrySet()) {
                DiagramNode node = (DiagramNode)fqn2nodeCache.get(entry.getKey());
                if (node == null) continue;
                dataModel.addNote(node, (String)entry.getValue());
            }
            dataModel.refreshDataModel();
            this.removeElementsNotPresentInThisState(dataModel, resolver, element2fqnCache);
            dataModel.refreshDataModel();
            builder.queryUpdate().withDataReload().withPresentationUpdate().run();
            builder.getGraph().unselectNodes();
            for (String string : this.getSelectedNodes()) {
                Node node;
                DiagramNode umlNode = (DiagramNode)fqn2nodeCache.get(string);
                if (umlNode == null || (node = builder.getNode(umlNode)) == null) continue;
                builder.getGraph().setSelected(node, true);
            }
            Futures.runInEdtAsync(() -> {
                builder.getGraphBuilder().setZoom(this.getZoom());
                builder.getView().setCenter(this.getCenter().getX(), this.getCenter().getY());
            });
            this.restorePositionsOnlyTo(builder);
        });
    }

    private void removeElementsNotPresentInThisState(@NotNull DiagramDataModel dataModel, @NotNull DiagramVfsResolver resolver, @NotNull Map<Object, String> element2fqnCache) {
        if (dataModel == null) {
            DiagramState.$$$reportNull$$$0(34);
        }
        if (resolver == null) {
            DiagramState.$$$reportNull$$$0(35);
        }
        if (element2fqnCache == null) {
            DiagramState.$$$reportNull$$$0(36);
        }
        Set<String> allowedFqns = Set.of(this.getFQNs());
        HashSet<Trinity<String, String, String>> allowedEdges = new HashSet<Trinity<String, String, String>>(this.myEdgesCoord.keySet());
        for (DiagramNode diagramNode : new ArrayList(dataModel.getNodes())) {
            String fqn = DiagramState.getElementFqn(resolver, element2fqnCache, diagramNode);
            if (fqn != null && allowedFqns.contains(fqn)) continue;
            dataModel.removeNode(diagramNode);
        }
        for (DiagramNoteNode diagramNoteNode : new ArrayList<DiagramNoteNode>(dataModel.getNotes().values())) {
            Object owner = diagramNoteNode.getIdentifyingElement();
            if (this.getNotes().containsKey(DiagramState.getElementFqn(resolver, element2fqnCache, (DiagramNode)owner))) continue;
            dataModel.removeNote(diagramNoteNode);
        }
        for (DiagramEdge diagramEdge : new ArrayList(dataModel.getEdges())) {
            String relationship;
            String targetFqn;
            String sourceFqn = DiagramState.getElementFqn(resolver, element2fqnCache, diagramEdge.getSource());
            if (allowedEdges.contains(Trinity.create((Object)sourceFqn, (Object)(targetFqn = DiagramState.getElementFqn(resolver, element2fqnCache, diagramEdge.getTarget())), (Object)(relationship = diagramEdge.getRelationship().toString())))) continue;
            dataModel.removeEdge(diagramEdge);
        }
    }

    private static String getElementFqn(@NotNull DiagramVfsResolver resolver, @NotNull Map<Object, String> element2FqnCache, @NotNull DiagramNode node) {
        if (resolver == null) {
            DiagramState.$$$reportNull$$$0(37);
        }
        if (element2FqnCache == null) {
            DiagramState.$$$reportNull$$$0(38);
        }
        if (node == null) {
            DiagramState.$$$reportNull$$$0(39);
        }
        Object element = node.getIdentifyingElement();
        return element2FqnCache.computeIfAbsent(element, it -> resolver.getQualifiedName(it));
    }

    public void restorePositionsOnlyTo(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramState.$$$reportNull$$$0(40);
        }
        DiagramVfsResolver<?> resolver = builder.getProvider().getVfsResolver();
        Graph2D graph = builder.getGraph();
        HashMap<DiagramNode, String> fqnCache = new HashMap<DiagramNode, String>();
        HashSet<String> fqns = new HashSet<String>();
        for (DiagramNode<?> node : builder.getNodeObjects()) {
            String fqn;
            if (node instanceof DiagramNoteNode) {
                fqn = resolver.getQualifiedName(((DiagramNoteNode)node).getIdentifyingElement().getIdentifyingElement());
                try {
                    Couple<Double> pair = this.getNotesCoord().get(fqn);
                    graph.setLocation(builder.getNode(node), (Double)pair.first, (Double)pair.second);
                }
                catch (Exception pair) {}
                continue;
            }
            fqn = resolver.getQualifiedName(node.getIdentifyingElement());
            if (fqn == null) continue;
            if (fqns.contains(fqn)) {
                LOG.warn("Several nodes with same fully-qualified names have been detected, can not restore coordinates: " + fqn);
                builder.relayout();
                return;
            }
            fqns.add(fqn);
            fqnCache.put(node, fqn);
            try {
                double x = Double.parseDouble(this.getNodeX(fqn));
                double y = Double.parseDouble(this.getNodeY(fqn));
                graph.setLocation(builder.getNode(node), x, y);
            }
            catch (Exception exception) {}
        }
        this.updateEdges(builder, builder.getGraph(), fqnCache, false);
        builder.getGraph().updateViews();
    }

    public void updateEdges(@NotNull DiagramBuilder builder, @NotNull Graph2D graph, @NotNull Map<DiagramNode, String> fqnCache, boolean clear) {
        if (builder == null) {
            DiagramState.$$$reportNull$$$0(41);
        }
        if (graph == null) {
            DiagramState.$$$reportNull$$$0(42);
        }
        if (fqnCache == null) {
            DiagramState.$$$reportNull$$$0(43);
        }
        for (DiagramEdge<?> umlEdge : builder.getEdgeObjects()) {
            EdgeInfo info = umlEdge instanceof DiagramNoteEdge ? this.getNoteEdgeCoord(fqnCache.get(umlEdge.getSource())) : this.getEdgeInfo(fqnCache.get(umlEdge.getSource()), fqnCache.get(umlEdge.getTarget()), umlEdge.getRelationship().toString());
            Edge edge = builder.getEdge(umlEdge);
            if (info != null && edge != null && info.getPoints().size() > 1) {
                List<Couple<Double>> points = info.getPoints();
                EdgeLayout edgeLayout = graph.getEdgeLayout(edge);
                if (edgeLayout == null) continue;
                edgeLayout.clearPoints();
                YPoint srcP = GraphManager.getGraphManager().createYPoint((Double)points.get(0).getFirst(), (Double)points.get(0).getSecond());
                YPoint trgP = GraphManager.getGraphManager().createYPoint((Double)points.get(points.size() - 1).getFirst(), (Double)points.get(points.size() - 1).getSecond());
                edgeLayout.setSourcePoint(srcP);
                edgeLayout.setTargetPoint(trgP);
                for (int i = 1; i < points.size() - 1; ++i) {
                    edgeLayout.addPoint((Double)points.get(i).getFirst(), (Double)points.get(i).getSecond());
                }
                continue;
            }
            if (!clear || edge == null) continue;
            graph.getEdgeLayout(edge).clearPoints();
        }
    }

    public boolean saveTo(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            DiagramState.$$$reportNull$$$0(44);
        }
        if (project == null) {
            DiagramState.$$$reportNull$$$0(45);
        }
        Document xml = new Document(new Element("Diagram"));
        this.write(xml.getRootElement());
        return DiagramState.writeXml(file, project, xml);
    }

    public void write(@NotNull Element root) {
        if (root == null) {
            DiagramState.$$$reportNull$$$0(46);
        }
        DiagramState state = this;
        Element id = new Element(ID);
        id.setText(state.getProviderID());
        root.addContent(id);
        Element originalFQN = new Element(ORIGINAL_ELEMENT);
        originalFQN.setText(state.getOriginalFQN());
        root.addContent(originalFQN);
        Element fqns = new Element(NODES);
        for (String fqn : state.getFQNs()) {
            SimpleElement simpleElement = new SimpleElement(NODE, X, state.getNodeX(fqn), Y, state.getNodeY(fqn));
            simpleElement.setText(fqn);
            fqns.addContent((Element)simpleElement);
        }
        root.addContent(fqns);
        Element notesNode = new Element(NOTES);
        Map<String, Couple<Double>> notesCoord = state.getNotesCoord();
        Map<String, String> notes = state.getNotes();
        for (String string : notes.keySet()) {
            Couple<Double> pair = notesCoord.get(string);
            if (pair == null) continue;
            SimpleElement note = new SimpleElement(NOTE, X, String.valueOf(pair.first), Y, String.valueOf(pair.second));
            Element node = new Element(NODE);
            node.setText(string);
            note.addContent(node);
            Element value = new Element(VALUE);
            value.setText(StringUtil.escapeStringCharacters((String)notes.get(string)));
            note.addContent(value);
            Element edge = new Element(EDGE);
            EdgeInfo noteEdgeCoord = state.getNoteEdgeCoord(string);
            if (noteEdgeCoord != null) {
                for (Couple<Double> p : noteEdgeCoord.getPoints()) {
                    edge.addContent((Element)new SimpleElement(POINT, X, ((Double)p.getFirst()).toString(), Y, ((Double)p.getSecond()).toString()));
                }
            }
            note.addContent(edge);
            notesNode.addContent((Element)note);
        }
        root.addContent(notesNode);
        Element edges = new Element(EDGES);
        for (EdgeInfo edgeInfo : state.getEdgeInfos()) {
            String src = edgeInfo.getSrc();
            String trg = edgeInfo.getTrg();
            if (src == null || trg == null) continue;
            String relationshipName = edgeInfo.getRelationshipName();
            SimpleElement edge = relationshipName != null ? new SimpleElement(EDGE, SOURCE, src, TARGET, trg, RELATIONSHIP, relationshipName) : new SimpleElement(EDGE, SOURCE, src, TARGET, trg);
            for (Couple<Double> p : edgeInfo.getPoints()) {
                edge.addContent(new SimpleElement(POINT, X, ((Double)p.getFirst()).toString(), Y, ((Double)p.getSecond()).toString()));
            }
            edges.addContent((Element)edge);
        }
        root.addContent(edges);
        SimpleElement simpleElement = new SimpleElement(SETTINGS, LAYOUT, DiagramLayout.from(state.getViewSettings().getCurrentLayouter()).getPresentableName(), ZOOM, String.valueOf(state.getZoom()), SHOW_DEPENDENCIES, String.valueOf(state.isShowDependencies()), X, String.valueOf(state.getCenter().getX()), Y, String.valueOf(state.getCenter().getY()));
        root.addContent((Element)simpleElement);
        Element selectedNodes = new Element(SELECTED_NODES);
        for (String fqn : state.getSelectedNodes()) {
            Element child = new Element(NODE);
            child.setText(fqn);
            selectedNodes.addContent(child);
        }
        root.addContent(selectedNodes);
        Element categories = new Element(CATEGORIES);
        for (DiagramCategory category : this.myEnabledCategories) {
            Element cat = new Element(CATEGORY);
            cat.setText(category.getName());
            categories.addContent(cat);
        }
        root.addContent(categories);
        if (state.getCurrentScope() != null) {
            Element scope = new Element(SCOPE);
            scope.setText(state.getCurrentScope());
            root.addContent(scope);
        }
        if (state.getCurrentVisibility() != null) {
            Element visibility = new Element(VISIBILITY);
            visibility.setText(state.getCurrentVisibility());
            root.addContent(visibility);
        }
    }

    @NotNull
    public static DiagramState read(@NotNull InputStream stream) throws IOException, JDOMException {
        if (stream == null) {
            DiagramState.$$$reportNull$$$0(47);
        }
        return DiagramState.read(new SAXBuilder().build(stream).getRootElement());
    }

    @NotNull
    public static DiagramState read(@Nullable Element root) {
        Element rawScope;
        Element rawVisibility;
        Element rawCategories;
        Element edges;
        Element rawSelectedNodes;
        Element rawNotes;
        Element nodes;
        Element rawOriginalFQN;
        if (root == null) {
            return DiagramState.empty(null);
        }
        String visibility = null;
        String scope = null;
        String originalFQN = null;
        String providerID = null;
        TreeSet<DiagramCategory> enabledCategories = new TreeSet<DiagramCategory>();
        double zoom = 1.0;
        Point location = new Point(0, 0);
        boolean doShowDependencies = false;
        LinkedHashSet<String> fqns = new LinkedHashSet<String>();
        HashSet<String> selectedNodes = new HashSet<String>();
        HashMap<String, String> notes = new HashMap<String, String>();
        HashMap<String, Couple<Double>> nodesCoord = new HashMap<String, Couple<Double>>();
        HashMap<Trinity<String, String, String>, EdgeInfo> edgesCoord = new HashMap<Trinity<String, String, String>, EdgeInfo>();
        HashMap<String, Couple<Double>> notesCoord = new HashMap<String, Couple<Double>>();
        HashMap<String, EdgeInfo> noteEdgesCoord = new HashMap<String, EdgeInfo>();
        DiagramProvider provider = null;
        Element rawProviderId = root.getChild(ID);
        if (rawProviderId != null) {
            String id = rawProviderId.getText();
            DiagramProvider diagramProvider = provider = id == null ? null : DiagramProvider.findByID(id);
            if (provider != null) {
                providerID = provider.getID();
            }
        }
        if ((rawOriginalFQN = root.getChild(ORIGINAL_ELEMENT)) != null) {
            originalFQN = rawOriginalFQN.getText();
        }
        if ((nodes = root.getChild(NODES)) != null) {
            for (Element e : nodes.getChildren()) {
                String fqn;
                if (e == null || (fqn = e.getText()) == null) continue;
                fqns.add(fqn);
                try {
                    double x = Double.parseDouble(Objects.requireNonNull(e.getAttributeValue(X)));
                    double y = Double.parseDouble(Objects.requireNonNull(e.getAttributeValue(Y)));
                    nodesCoord.put(fqn, Couple.of((Object)x, (Object)y));
                }
                catch (Exception x) {}
            }
        }
        if ((rawNotes = root.getChild(NOTES)) != null) {
            for (Element e : rawNotes.getChildren()) {
                if (e == null) continue;
                String value = e.getChild(VALUE) == null ? null : StringUtil.unescapeStringCharacters((String)Objects.requireNonNull(e.getChild(VALUE)).getValue());
                String fqn = e.getChild(NODE) == null ? null : Objects.requireNonNull(e.getChild(NODE)).getValue();
                Attribute x = e.getAttribute(X);
                Attribute y = e.getAttribute(Y);
                if (value == null || fqn == null || x == null || y == null) continue;
                notes.put(fqn, value);
                notesCoord.put(fqn, Couple.of((Object)DiagramState.getDouble(x, 0.0), (Object)DiagramState.getDouble(y, 0.0)));
                Element points = e.getChild(EDGE);
                if (points == null) continue;
                ArrayList<Couple<Double>> coords = new ArrayList<Couple<Double>>();
                for (Element child : points.getChildren()) {
                    if (child == null) continue;
                    try {
                        coords.add((Couple<Double>)Couple.of((Object)Double.parseDouble(Objects.requireNonNull(child.getAttributeValue(X))), (Object)Double.parseDouble(Objects.requireNonNull(child.getAttributeValue(Y)))));
                    }
                    catch (Exception exception) {}
                }
                noteEdgesCoord.put(fqn, new EdgeInfo(fqn, null, DiagramRelationships.NOTE.toString(), coords));
            }
        }
        Element settings = root.getChild(SETTINGS);
        GraphSettings viewSettings = new GraphSettings();
        if (settings != null) {
            viewSettings.setCurrentLayouter(DiagramLayout.fromString(settings.getAttributeValue(LAYOUT)).getPredefinedLayouter(viewSettings));
            zoom = DiagramState.getDouble(Objects.requireNonNull(settings.getAttribute(ZOOM)), 1.0);
            Attribute showDependenciesAttribute = settings.getAttribute(SHOW_DEPENDENCIES);
            doShowDependencies = showDependenciesAttribute != null ? Boolean.parseBoolean(showDependenciesAttribute.getValue()) : false;
            Point p = new Point();
            p.setLocation(DiagramState.getDouble(Objects.requireNonNull(settings.getAttribute(X)), 0.0), DiagramState.getDouble(Objects.requireNonNull(settings.getAttribute(Y)), 0.0));
            location = p;
        }
        if ((rawSelectedNodes = root.getChild(SELECTED_NODES)) != null) {
            ArrayList<String> selNodes = new ArrayList<String>();
            for (Element child : rawSelectedNodes.getChildren()) {
                String fqn;
                if (child == null || (fqn = child.getText()) == null) continue;
                selNodes.add(fqn);
            }
            selectedNodes.addAll(selNodes);
        }
        if ((edges = root.getChild(EDGES)) != null) {
            for (Element e : edges.getChildren()) {
                if (e == null) continue;
                String src = e.getAttributeValue(SOURCE);
                String trg = e.getAttributeValue(TARGET);
                String relationshipName = e.getAttributeValue(RELATIONSHIP);
                if (src == null || trg == null) continue;
                ArrayList<Couple<Double>> points = new ArrayList<Couple<Double>>();
                for (Element point : e.getChildren()) {
                    if (point == null) continue;
                    try {
                        double x = Double.parseDouble(Objects.requireNonNull(point.getAttributeValue(X)));
                        double y = Double.parseDouble(Objects.requireNonNull(point.getAttributeValue(Y)));
                        points.add((Couple<Double>)Couple.of((Object)x, (Object)y));
                    }
                    catch (Exception exception) {}
                }
                if (points.size() <= 1) continue;
                edgesCoord.put((Trinity<String, String, String>)Trinity.create((Object)src, (Object)trg, (Object)relationshipName), new EdgeInfo(src, trg, relationshipName, points));
            }
        }
        if ((rawCategories = root.getChild(CATEGORIES)) != null && provider != null) {
            ArrayList<String> names = new ArrayList<String>();
            for (Element child : rawCategories.getChildren(CATEGORY)) {
                if (child == null) continue;
                names.add(child.getText());
            }
            TreeSet<DiagramCategory> cats = new TreeSet<DiagramCategory>();
            for (DiagramCategory category : provider.getAllContentCategories()) {
                if (!names.contains(category.getName())) continue;
                cats.add(category);
            }
            enabledCategories.addAll(cats);
        }
        if ((rawVisibility = root.getChild(VISIBILITY)) != null) {
            visibility = rawVisibility.getText();
        }
        if ((rawScope = root.getChild(SCOPE)) != null) {
            scope = rawScope.getText();
        }
        return new DiagramState(visibility, scope, originalFQN, providerID, enabledCategories, zoom, location, false, doShowDependencies, viewSettings, fqns, selectedNodes, notes, nodesCoord, edgesCoord, notesCoord, noteEdgesCoord);
    }

    private static double getDouble(@NotNull Attribute attr, double defaultValue) {
        if (attr == null) {
            DiagramState.$$$reportNull$$$0(48);
        }
        try {
            return Double.parseDouble(attr.getValue());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static boolean writeXml(@NotNull VirtualFile to, @NotNull Project project, @NotNull Document xml) {
        if (to == null) {
            DiagramState.$$$reportNull$$$0(49);
        }
        if (project == null) {
            DiagramState.$$$reportNull$$$0(50);
        }
        if (xml == null) {
            DiagramState.$$$reportNull$$$0(51);
        }
        return (Boolean)WriteAction.computeAndWait(() -> {
            ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(Collections.singletonList(to));
            if (status.hasReadonlyFiles()) {
                return false;
            }
            try (OutputStream os = to.getOutputStream(null);){
                JDOMUtil.write((Parent)xml, (OutputStream)os, (String)CodeStyle.getSettings((Project)project).getLineSeparator());
            }
            catch (Exception e1) {
                LOG.error((Throwable)e1);
                return false;
            }
            return true;
        });
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiagramState that = (DiagramState)o;
        if (this.myIsEdgeCreationMode != that.myIsEdgeCreationMode) {
            return false;
        }
        if (Double.compare(that.myZoom, this.myZoom) != 0) {
            return false;
        }
        if (!Objects.equals(this.myScope, that.myScope)) {
            return false;
        }
        if (!Objects.equals(this.myVisibility, that.myVisibility)) {
            return false;
        }
        if (!Objects.equals(this.myViewSettings, that.myViewSettings)) {
            return false;
        }
        if (!this.myEdgesCoord.equals(that.myEdgesCoord)) {
            return false;
        }
        if (!this.myEnabledCategories.equals(that.myEnabledCategories)) {
            return false;
        }
        if (!this.myFqns.equals(that.myFqns)) {
            return false;
        }
        if (!this.myLocation.equals(that.myLocation)) {
            return false;
        }
        if (!this.myNodesCoord.equals(that.myNodesCoord)) {
            return false;
        }
        if (!this.myNoteEdgesCoord.equals(that.myNoteEdgesCoord)) {
            return false;
        }
        if (!this.myNotes.equals(that.myNotes)) {
            return false;
        }
        if (!this.myNotesCoord.equals(that.myNotesCoord)) {
            return false;
        }
        if (!Objects.equals(this.myProviderID, that.myProviderID)) {
            return false;
        }
        return this.mySelectedNodes.equals(that.mySelectedNodes);
    }

    public boolean equalsIgnoreCoordinates(@Nullable DiagramState that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (!this.myEnabledCategories.equals(that.myEnabledCategories)) {
            return false;
        }
        if (!this.myFqns.equals(that.myFqns)) {
            return false;
        }
        if (!this.myNotes.equals(that.myNotes)) {
            return false;
        }
        if (!Objects.equals(this.myProviderID, that.myProviderID)) {
            return false;
        }
        if (!Objects.equals(this.myViewSettings, that.myViewSettings)) {
            return false;
        }
        return this.mySelectedNodes.equals(that.mySelectedNodes);
    }

    public int hashCode() {
        int result = this.myEnabledCategories.hashCode();
        result = 31 * result + (this.myIsEdgeCreationMode ? 1 : 0);
        result = 31 * result + this.myViewSettings.hashCode();
        result = 31 * result + this.myFqns.hashCode();
        result = 31 * result + this.myNodesCoord.hashCode();
        result = 31 * result + this.myEdgesCoord.hashCode();
        result = 31 * result + this.mySelectedNodes.hashCode();
        result = 31 * result + this.myNotes.hashCode();
        result = 31 * result + this.myNotesCoord.hashCode();
        result = 31 * result + this.myNoteEdgesCoord.hashCode();
        result = 31 * result + Double.hashCode(this.myZoom);
        result = 31 * result + this.myLocation.hashCode();
        String id = this.myProviderID;
        result = 31 * result + (id == null ? 0 : id.hashCode());
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 18, 19, 20, 23, 24, 26, 28, 29, 30, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enabledCategories";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqns";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedNodes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = NOTES;
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesCoord";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgesCoord";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notesCoord";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "noteEdgesCoord";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 32: 
            case 33: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/presentation/DiagramState";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherState";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relationshipName";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataModel";
                break;
            }
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2fqnCache";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2FqnCache";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = NODE;
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqnCache";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 45: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/presentation/DiagramState";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "makeBuilderSnapshot";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotes";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotesCoord";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewSettings";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledCategories";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQNs";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeX";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeY";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodes";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getCenter";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "makeBuilderSnapshot";
                break;
            }
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "invalidateSnapshotsFor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "canBeMergedWith";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeInfo";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isCategoryEnabled";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setCategoryEnabled";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getNodeX";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getNodeY";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "restoreTo";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "removeElementsNotPresentInThisState";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getElementFqn";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "restorePositionsOnlyTo";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "updateEdges";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "saveTo";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getDouble";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "writeXml";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 18, 19, 20, 23, 24, 26, 28, 29, 30, 31 -> new IllegalStateException(string);
        };
    }
}

