/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.steps.reference;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.plugins.cucumber.psi.GherkinElementTypes;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;
import org.jetbrains.plugins.cucumber.steps.reference.CucumberStepReference;

@NotNullByDefault
public final class CucumberStepReferenceProvider
extends PsiReferenceProvider {
    private static final TokenSet TEXT_AND_PARAM_SET = TokenSet.create((IElementType[])new IElementType[]{GherkinTokenTypes.TEXT, GherkinTokenTypes.STEP_PARAMETER_TEXT, GherkinTokenTypes.STEP_PARAMETER_BRACE, GherkinElementTypes.STEP_PARAMETER});
    private static final TokenSet TEXT_PARAM_AND_WHITE_SPACE_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{TEXT_AND_PARAM_SET, TokenSet.WHITE_SPACE});

    public PsiReference[] getReferencesByElement(PsiElement element, ProcessingContext context) {
        ASTNode textNode;
        if (element instanceof GherkinStep && (textNode = element.getNode().findChildByType(TEXT_AND_PARAM_SET)) != null) {
            int end;
            int start = textNode.getTextRange().getStartOffset();
            int endBeforeSpace = end = textNode.getTextRange().getEndOffset();
            for (textNode = textNode.getTreeNext(); textNode != null && TEXT_PARAM_AND_WHITE_SPACE_SET.contains(textNode.getElementType()); textNode = textNode.getTreeNext()) {
                endBeforeSpace = textNode.getElementType() == TokenType.WHITE_SPACE ? end : textNode.getTextRange().getEndOffset();
                end = textNode.getTextRange().getEndOffset();
            }
            TextRange textRange = new TextRange(start, endBeforeSpace);
            CucumberStepReference reference = new CucumberStepReference(element, textRange.shiftRight(-element.getTextOffset()));
            return new PsiReference[]{reference};
        }
        return PsiReference.EMPTY_ARRAY;
    }
}

