/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.inspections.CucumberAddExamplesColonFix;
import org.jetbrains.plugins.cucumber.inspections.GherkinInspection;
import org.jetbrains.plugins.cucumber.psi.GherkinElementVisitor;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinExamplesBlockImpl;

public final class CucumberExamplesColonInspection
extends GherkinInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        return "CucumberExamplesColon";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            CucumberExamplesColonInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CucumberExamplesColonInspection.$$$reportNull$$$0(1);
        }
        return new GherkinElementVisitor(this){

            @Override
            public void visitExamplesBlock(GherkinExamplesBlockImpl block) {
                String text;
                PsiElement examples = block.getFirstChild();
                assert (examples != null);
                PsiElement next = examples.getNextSibling();
                String string = text = next != null ? next.getText() : null;
                if (text == null || !text.contains(":")) {
                    holder.registerProblem(examples, new TextRange(0, examples.getTextRange().getEndOffset() - examples.getTextOffset()), CucumberBundle.message("inspection.missed.colon.example.name", new Object[0]), new LocalQuickFix[]{new CucumberAddExamplesColonFix()});
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/inspections/CucumberExamplesColonInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/inspections/CucumberExamplesColonInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

