/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.javascript.reference;

import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpressionKind;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.CucumberUtil;
import org.jetbrains.plugins.cucumber.MapParameterTypeManager;
import org.jetbrains.plugins.cucumber.javascript.CucumberJavaScriptFrameworkHandler;
import org.jetbrains.plugins.cucumber.javascript.CucumberJavaScriptParameterTypesProvider;
import org.jetbrains.plugins.cucumber.javascript.reference.CucumberJavaScriptParameterTypeReference;

public class CucumberJavaScriptReferenceProvider
extends PsiReferenceProvider {
    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        JSLiteralExpression literalExpression;
        if (element == null) {
            CucumberJavaScriptReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            CucumberJavaScriptReferenceProvider.$$$reportNull$$$0(1);
        }
        if ((literalExpression = (JSLiteralExpression)ObjectUtils.tryCast((Object)element, JSLiteralExpression.class)) == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                CucumberJavaScriptReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        JSLiteralExpressionKind kind = literalExpression.getExpressionKind(false);
        if (kind != JSLiteralExpressionKind.QUOTED && kind != JSLiteralExpressionKind.TEMPLATE_NO_ARGS) {
            if (PsiReference.EMPTY_ARRAY == null) {
                CucumberJavaScriptReferenceProvider.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String text = literalExpression.getText();
        if (StringUtil.isEmpty((String)text)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                CucumberJavaScriptReferenceProvider.$$$reportNull$$$0(4);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (!CucumberJavaScriptFrameworkHandler.hasSignificantValueForStepDefinition(literalExpression.getNode())) {
            if (PsiReference.EMPTY_ARRAY == null) {
                CucumberJavaScriptReferenceProvider.$$$reportNull$$$0(5);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        MapParameterTypeManager defaultParameterTypeManager = CucumberJavaScriptParameterTypesProvider.getDefaultParameterTypeManager();
        ArrayList result = new ArrayList();
        CucumberUtil.processParameterTypesInCucumberExpression((String)text, range -> {
            if (range.getLength() <= 2) {
                return true;
            }
            if (StringUtil.isChar((CharSequence)text, (int)(range.getStartOffset() - 1), (char)'\\')) {
                return true;
            }
            String param = (range = TextRange.create((int)(range.getStartOffset() + 1), (int)(range.getEndOffset() - 1))).substring(text);
            if (defaultParameterTypeManager.getParameterTypeValue(param) == null) {
                result.add(new CucumberJavaScriptParameterTypeReference(element, (TextRange)range));
            }
            return true;
        });
        PsiReference[] psiReferenceArray = (PsiReference[])result.toArray(new CucumberJavaScriptParameterTypeReference[0]);
        if (psiReferenceArray == null) {
            CucumberJavaScriptReferenceProvider.$$$reportNull$$$0(6);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/javascript/reference/CucumberJavaScriptReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/javascript/reference/CucumberJavaScriptReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

