/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.javascript;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.impl.JSStringTemplateExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSCallExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSPropertyImpl;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.javascript.CucumberJavaScriptUtil;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.psi.i18n.JsonGherkinKeywordProvider;

public final class CucumberJavaScriptFrameworkHandler
extends FrameworkIndexingHandler {
    public boolean shouldCreateStubForCallExpression(@NotNull ASTNode node) {
        if (node == null) {
            CucumberJavaScriptFrameworkHandler.$$$reportNull$$$0(0);
        }
        return CucumberJavaScriptFrameworkHandler.isCucumberRelatedCallExpression(node);
    }

    private static boolean isCucumberRelatedCallExpression(ASTNode node) {
        ASTNode methodExpression = JSCallExpressionImpl.getMethodExpression((ASTNode)node);
        if (methodExpression != null && methodExpression.getElementType() == JSElementTypes.REFERENCE_EXPRESSION) {
            String name = StringUtil.toLowerCase((String)JSReferenceExpressionImpl.getReferenceName((ASTNode)methodExpression));
            if (name == null) {
                return false;
            }
            return Lazy.STEP_KEYWORDS.contains(name) || Lazy.DEFINE_CUSTOM_PARAMETER.equals(name);
        }
        return false;
    }

    public void processCallExpression(@NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outData) {
        if (callExpression == null) {
            CucumberJavaScriptFrameworkHandler.$$$reportNull$$$0(1);
        }
        if (outData == null) {
            CucumberJavaScriptFrameworkHandler.$$$reportNull$$$0(2);
        }
        if (callExpression.getContainingFile() == null) {
            return;
        }
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (!(methodExpression instanceof JSReferenceExpression)) {
            return;
        }
        String methodName = StringUtil.toLowerCase((String)((JSReferenceExpression)methodExpression).getReferenceName());
        if (methodName == null) {
            return;
        }
        this.processStepDefinition(callExpression, outData, methodName);
        this.processCustomParameterDefinition(callExpression, outData, methodName);
    }

    private void processStepDefinition(@NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outData, @NotNull String methodName) {
        if (callExpression == null) {
            CucumberJavaScriptFrameworkHandler.$$$reportNull$$$0(3);
        }
        if (outData == null) {
            CucumberJavaScriptFrameworkHandler.$$$reportNull$$$0(4);
        }
        if (methodName == null) {
            CucumberJavaScriptFrameworkHandler.$$$reportNull$$$0(5);
        }
        if (!Lazy.STEP_KEYWORDS.contains(methodName)) {
            return;
        }
        JSExpression stepDefinition = (JSExpression)ArrayUtil.getFirstElement((Object[])callExpression.getArguments());
        if (!(stepDefinition instanceof JSLiteralExpression) && !(stepDefinition instanceof JSCallExpression)) {
            return;
        }
        String stepText = CucumberJavaScriptUtil.getCucumberStepTextFromElement((PsiElement)stepDefinition);
        if (StringUtil.isEmpty((String)stepText)) {
            return;
        }
        outData.addImplicitElement((JSImplicitElement)new JSImplicitElementImpl.Builder("$cucumberJSSteps", (PsiElement)callExpression).setUserStringWithData((FrameworkIndexingHandler)this, "cucs", stepText).toImplicitElement());
    }

    @NotNull
    protected @NotNull Set<@NotNull String> computeJSImplicitElementUserStringKeys() {
        Set<String> set = Set.of("cucs");
        if (set == null) {
            CucumberJavaScriptFrameworkHandler.$$$reportNull$$$0(6);
        }
        return set;
    }

    private void processCustomParameterDefinition(@NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outData, @NotNull String methodName) {
        if (callExpression == null) {
            CucumberJavaScriptFrameworkHandler.$$$reportNull$$$0(7);
        }
        if (outData == null) {
            CucumberJavaScriptFrameworkHandler.$$$reportNull$$$0(8);
        }
        if (methodName == null) {
            CucumberJavaScriptFrameworkHandler.$$$reportNull$$$0(9);
        }
        if (!Lazy.DEFINE_CUSTOM_PARAMETER.equals(methodName)) {
            return;
        }
        JSObjectLiteralExpression parameterDefinition = (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)ArrayUtil.getFirstElement((Object[])callExpression.getArguments()), JSObjectLiteralExpression.class);
        if (parameterDefinition == null) {
            return;
        }
        JSProperty nameProp = parameterDefinition.findProperty("name");
        if (nameProp == null) {
            return;
        }
        JSExpression nameExpression = nameProp.getValue();
        if (nameExpression == null) {
            return;
        }
        String name = CucumberJavaScriptUtil.getContentFromLiteralText(CucumberJavaScriptUtil.getCucumberStepTextFromElement((PsiElement)nameExpression));
        if (StringUtil.isEmpty((String)name)) {
            return;
        }
        outData.addImplicitElement((JSImplicitElement)new JSImplicitElementImpl.Builder("$cucumberJSCustomParameters", (PsiElement)callExpression).setUserStringWithData((FrameworkIndexingHandler)this, "cucs", name).toImplicitElement());
    }

    public boolean hasSignificantValue(@NotNull JSLiteralExpression expression) {
        if (expression == null) {
            CucumberJavaScriptFrameworkHandler.$$$reportNull$$$0(10);
        }
        return this.hasSignificantValue(expression.getNode());
    }

    private boolean hasSignificantValue(@NotNull ASTNode node) {
        if (node == null) {
            CucumberJavaScriptFrameworkHandler.$$$reportNull$$$0(11);
        }
        if (!CucumberJavaScriptFrameworkHandler.isIndexedLiteralKind(node)) {
            return false;
        }
        return this.hasSignificantValueForParameterDefinition(node) || CucumberJavaScriptFrameworkHandler.hasSignificantValueForStepDefinition(node);
    }

    private static boolean isIndexedLiteralKind(@NotNull ASTNode node) {
        ASTNode firstChild;
        if (node == null) {
            CucumberJavaScriptFrameworkHandler.$$$reportNull$$$0(12);
        }
        if ((firstChild = node.getFirstChildNode()) == null) {
            return false;
        }
        return JSLiteralExpressionImpl.isQuotedLiteral((ASTNode)node) || node.getElementType() == JSElementTypes.LITERAL_EXPRESSION && firstChild.getElementType() == JSTokenTypes.REGEXP_LITERAL || JSStringTemplateExpressionImpl.isStringTemplateExpressionWithoutArguments((ASTNode)node);
    }

    public static boolean hasSignificantValueForStepDefinition(@NotNull ASTNode literalExpression) {
        ASTNode argumentList;
        if (literalExpression == null) {
            CucumberJavaScriptFrameworkHandler.$$$reportNull$$$0(13);
        }
        if ((argumentList = literalExpression.getTreeParent()) == null || !JSExtendedLanguagesTokenSetProvider.ARGUMENT_LISTS.contains(argumentList.getElementType())) {
            return false;
        }
        ASTNode callExpression = argumentList.getTreeParent();
        if (callExpression == null || callExpression.getElementType() != JSElementTypes.CALL_EXPRESSION) {
            return false;
        }
        return CucumberJavaScriptFrameworkHandler.isCucumberRelatedCallExpression(callExpression);
    }

    private boolean hasSignificantValueForParameterDefinition(@NotNull ASTNode literalExpression) {
        ASTNode treeParent;
        if (literalExpression == null) {
            CucumberJavaScriptFrameworkHandler.$$$reportNull$$$0(14);
        }
        if ((treeParent = literalExpression.getTreeParent()).getElementType() == JSElementTypes.ARRAY_LITERAL_EXPRESSION) {
            treeParent = treeParent.getTreeParent();
        }
        if (treeParent.getElementType() != JSElementTypes.PROPERTY) {
            return false;
        }
        ASTNode identifier = JSPropertyImpl.findNameIdentifier((ASTNode)treeParent);
        if (identifier == null) {
            return false;
        }
        String name = JSStringUtil.unquoteWithoutUnescapingStringLiteralValue((String)identifier.getText());
        if (!Objects.equals(name, "regexp") && !Objects.equals(name, "name")) {
            return false;
        }
        if ((treeParent = treeParent.getTreeParent()).getElementType() != JSElementTypes.OBJECT_LITERAL_EXPRESSION) {
            return false;
        }
        if ((treeParent = treeParent.getTreeParent()).getElementType() != JSElementTypes.ARGUMENT_LIST) {
            return false;
        }
        if ((treeParent = treeParent.getTreeParent()).getElementType() != JSElementTypes.CALL_EXPRESSION) {
            return false;
        }
        return this.shouldCreateStubForCallExpression(treeParent);
    }

    public boolean shouldCreateStubForLiteral(@NotNull ASTNode node) {
        if (node == null) {
            CucumberJavaScriptFrameworkHandler.$$$reportNull$$$0(15);
        }
        return this.hasSignificantValue(node);
    }

    public boolean shouldCreateStubForArrayLiteral(@NotNull ASTNode node) {
        ASTNode[] expressions;
        if (node == null) {
            CucumberJavaScriptFrameworkHandler.$$$reportNull$$$0(16);
        }
        if ((expressions = node.getChildren(JSExtendedLanguagesTokenSetProvider.EXPRESSIONS)).length == 0) {
            return false;
        }
        ASTNode firstExpression = expressions[0];
        if (firstExpression.getElementType() != JSElementTypes.LITERAL_EXPRESSION) {
            return false;
        }
        ASTNode firstChild = firstExpression.getFirstChildNode();
        if (firstChild == null || firstChild.getElementType() != JSTokenTypes.REGEXP_LITERAL) {
            return false;
        }
        return this.hasSignificantValueForParameterDefinition(firstExpression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outData";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptFrameworkHandler";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptFrameworkHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "computeJSImplicitElementUserStringKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shouldCreateStubForCallExpression";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processCallExpression";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processStepDefinition";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processCustomParameterDefinition";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasSignificantValue";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isIndexedLiteralKind";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasSignificantValueForStepDefinition";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasSignificantValueForParameterDefinition";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "shouldCreateStubForLiteral";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "shouldCreateStubForArrayLiteral";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    private static final class Lazy {
        @NotNull
        static final Set<String> STEP_KEYWORDS = new HashSet<String>();
        @NotNull
        static final String DEFINE_CUSTOM_PARAMETER = StringUtil.toLowerCase((String)"defineParameterType");
        @NotNull
        static final String IMPLICIT_ELEMENT_STEP_KEY = "cucs";

        private Lazy() {
        }

        static {
            GherkinKeywordProvider provider = JsonGherkinKeywordProvider.getKeywordProvider((boolean)true);
            provider.getKeywordsTable("en").getStepKeywords().stream().map(s -> StringUtil.toLowerCase((String)s)).forEach(STEP_KEYWORDS::add);
        }
    }
}

