/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webstorm.typeEngineWidget;

import com.intellij.icons.AllIcons;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptEngineWidgetPopupService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.ClickListener;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.IntelliJSpacingConfiguration;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.gridLayout.UnscaledGaps;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.webstorm.typeEngineWidget.SettingsModel;
import com.intellij.webstorm.typeEngineWidget.TypeScriptEngineWidgetKt;
import icons.JavaScriptLanguageIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010\u001d\u001a\u00020\u00152\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006%"}, d2={"Lcom/intellij/webstorm/typeEngineWidget/TypeScriptEngineWidget;", "Lcom/intellij/openapi/wm/CustomStatusBarWidget;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "ID", "", "statusBarLabel", "Ljavax/swing/JLabel;", "getStatusBarLabel$annotations", "()V", "getStatusBarLabel", "()Ljavax/swing/JLabel;", "statusBarLabel$delegate", "Lkotlin/Lazy;", "getComponent", "Ljavax/swing/JComponent;", "updateIcon", "", "createAndShowOnStatusBar", "Lcom/intellij/openapi/ui/popup/JBPopup;", "popupBuilder", "Lcom/intellij/openapi/ui/popup/ComponentPopupBuilder;", "destroyTooltip", "tooltip", "Lcom/intellij/ui/GotItTooltip;", "showPopup", "showTooltip", "", "createPopupContent", "Lcom/intellij/openapi/ui/DialogPanel;", "state", "Lcom/intellij/webstorm/typeEngineWidget/SettingsModel;", "isTypeScriptServiceBasedEngineEnabled", "intellij.webstorm.typeEngineWidget"})
public final class TypeScriptEngineWidget
implements CustomStatusBarWidget {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Lazy statusBarLabel$delegate;

    public TypeScriptEngineWidget(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        this.scope = scope;
        this.statusBarLabel$delegate = LazyKt.lazy(() -> TypeScriptEngineWidget.statusBarLabel_delegate$lambda$0(this));
    }

    @NotNull
    public String ID() {
        return "TypeScriptEngineStatusBarWidget";
    }

    private final JLabel getStatusBarLabel() {
        Lazy lazy = this.statusBarLabel$delegate;
        return (JLabel)lazy.getValue();
    }

    private static /* synthetic */ void getStatusBarLabel$annotations() {
    }

    @NotNull
    public JComponent getComponent() {
        this.updateIcon();
        return this.getStatusBarLabel();
    }

    private final void updateIcon() {
        this.getStatusBarLabel().setIcon(this.isTypeScriptServiceBasedEngineEnabled(this.project) ? JavaScriptLanguageIcons.Typescript.TypeScriptServiceBasedTypeEngine : JavaScriptLanguageIcons.Typescript.TypeScriptServiceBasedTypeEngineOff);
    }

    private final JBPopup createAndShowOnStatusBar(ComponentPopupBuilder popupBuilder) {
        JBPopup jBPopup = popupBuilder.createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        JBPopup popup = jBPopup;
        Dimension dimension = popup.getContent().getPreferredSize();
        Point at = new Point(0, -dimension.height);
        popup.show(new RelativePoint((Component)this.getStatusBarLabel(), at));
        return popup;
    }

    private final void destroyTooltip(GotItTooltip tooltip) {
        tooltip.gotIt();
        Disposer.dispose((Disposable)((Disposable)tooltip));
    }

    private final void showPopup(boolean showTooltip) {
        SettingsModel state = new SettingsModel(this.project);
        DialogPanel popupContent = this.createPopupContent(state);
        ComponentPopupBuilder componentPopupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)popupContent, null).setRequestFocus(true).setCancelOnClickOutside(true).setCancelOnWindowDeactivation(true).setResizable(false).setMovable(false);
        Intrinsics.checkNotNullExpressionValue((Object)componentPopupBuilder, (String)"setMovable(...)");
        ComponentPopupBuilder popupBuilder = componentPopupBuilder;
        if (!showTooltip) {
            this.createAndShowOnStatusBar(popupBuilder);
            return;
        }
        JFrame window = WindowManager.getInstance().getFrame(this.project);
        if (window == null || !(window instanceof IdeFrame)) {
            this.createAndShowOnStatusBar(popupBuilder);
            return;
        }
        GotItTooltip tooltip = new GotItTooltip("typescript.engine.widget.TSandTSX.tooltip", TypeScriptEngineWidgetKt.access$msg("typescript.engine.widget.TSandTSX.gotIt.text"), (Disposable)this).withHeader(TypeScriptEngineWidgetKt.access$msg("typescript.engine.widget.TSandTSX.gotIt.header")).withShowCount(1).withPosition(Balloon.Position.atLeft);
        if (!tooltip.canShow()) {
            this.createAndShowOnStatusBar(popupBuilder);
            this.destroyTooltip(tooltip);
            return;
        }
        Ref.ObjectRef tooltipBalloon = new Ref.ObjectRef();
        popupBuilder.setCancelCallback(() -> TypeScriptEngineWidget.showPopup$lambda$0(tooltip, window, tooltipBalloon, this));
        JBPopup popup = this.createAndShowOnStatusBar(popupBuilder);
        JComponent jComponent = ((IdeFrame)window).getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        tooltip.show(jComponent, (arg_0, arg_1) -> TypeScriptEngineWidget.showPopup$lambda$1(popup, window, tooltipBalloon, arg_0, arg_1));
        popup.addListener(new JBPopupListener(this, tooltip){
            final /* synthetic */ TypeScriptEngineWidget this$0;
            final /* synthetic */ GotItTooltip $tooltip;
            {
                this.this$0 = $receiver;
                this.$tooltip = $tooltip;
            }

            public void onClosed(LightweightWindowEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                TypeScriptEngineWidget.access$destroyTooltip(this.this$0, this.$tooltip);
            }
        });
    }

    static /* synthetic */ void showPopup$default(TypeScriptEngineWidget typeScriptEngineWidget, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        typeScriptEngineWidget.showPopup(bl);
    }

    private final DialogPanel createPopupContent(SettingsModel state) {
        DialogPanel dialogPanel;
        DialogPanel $this$createPopupContent_u24lambda_u241 = dialogPanel = BuilderKt.panel(arg_0 -> TypeScriptEngineWidget.createPopupContent$lambda$0(state, this, arg_0));
        boolean bl = false;
        $this$createPopupContent_u24lambda_u241.setBorder((Border)UnscaledGapsKt.toJBEmptyBorder((UnscaledGaps)new IntelliJSpacingConfiguration().getDialogUnscaledGaps()));
        return dialogPanel;
    }

    private final boolean isTypeScriptServiceBasedEngineEnabled(Project project) {
        return TypeScriptCompilerSettings.Companion.getSettings(project).getUseTypesFromServer();
    }

    private static final JLabel statusBarLabel_delegate$lambda$0(TypeScriptEngineWidget this$0) {
        JLabel jLabel;
        JLabel $this$statusBarLabel_delegate_u24lambda_u240_u240 = jLabel = new JLabel();
        boolean bl = false;
        $this$statusBarLabel_delegate_u24lambda_u240_u240.setToolTipText(TypeScriptEngineWidgetKt.access$msg("typescript.engine.widget.title"));
        BuildersKt.launch$default((CoroutineScope)this$0.scope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            final /* synthetic */ TypeScriptEngineWidget this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        ComponentManager $this$service$iv = (ComponentManager)TypeScriptEngineWidget.access$getProject$p(this.this$0);
                        boolean $i$f$service = false;
                        Class<TypeScriptEngineWidgetPopupService> serviceClass$iv = TypeScriptEngineWidgetPopupService.class;
                        Object object2 = $this$service$iv.getService(serviceClass$iv);
                        if (object2 == null) {
                            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                        }
                        this.label = 1;
                        Object object3 = FlowKt.debounce-HG0u8IE((Flow)((TypeScriptEngineWidgetPopupService)object2).getShowTooltipFlow(), (long)DurationKt.toDuration((int)100, (DurationUnit)DurationUnit.MILLISECONDS)).collect(new FlowCollector(this.this$0){
                            final /* synthetic */ TypeScriptEngineWidget this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            public final Object emit(Unit it, Continuation<? super Unit> $completion) {
                                TypeScriptEngineWidget.access$showPopup(this.this$0, true);
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        new ClickListener(this$0){
            final /* synthetic */ TypeScriptEngineWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean onClick(MouseEvent event, int clickCount) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (SwingUtilities.isLeftMouseButton(event)) {
                    TypeScriptEngineWidget.showPopup$default(this.this$0, false, 1, null);
                }
                return true;
            }
        }.installOn((Component)$this$statusBarLabel_delegate_u24lambda_u240_u240);
        return jLabel;
    }

    private static final Boolean showPopup$lambda$0(GotItTooltip $tooltip, JFrame $window, Ref.ObjectRef $tooltipBalloon, TypeScriptEngineWidget this$0) {
        if (!$tooltip.canShow()) {
            return true;
        }
        Point mousePos = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(mousePos, $window);
        Object object = $tooltipBalloon.element;
        Object object2 = object instanceof BalloonImpl ? (BalloonImpl)object : null;
        if (object2 != null && (object2 = object2.getComponent()) != null && (object2 = ((Component)object2).getBounds()) != null ? ((Rectangle)object2).contains(mousePos) : false) {
            return !((Window)$window).isFocused();
        }
        this$0.destroyTooltip($tooltip);
        return true;
    }

    private static final Point showPopup$lambda$1(JBPopup $popup, JFrame $window, Ref.ObjectRef $tooltipBalloon, Component component, Balloon balloon) {
        Point point;
        Intrinsics.checkNotNullParameter((Object)component, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)balloon, (String)"balloon");
        Point $this$showPopup_u24lambda_u241_u240 = point = SwingUtilities.convertPoint($popup.getContent().getParent(), $popup.getContent().getLocation(), ((IdeFrame)$window).getComponent());
        boolean bl = false;
        $tooltipBalloon.element = balloon;
        $this$showPopup_u24lambda_u241_u240.translate(0, $popup.getContent().getPreferredSize().height / 8);
        Point point2 = point;
        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"apply(...)");
        return point2;
    }

    private static final Unit createPopupContent$lambda$0(SettingsModel $state, TypeScriptEngineWidget this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, TypeScriptEngineWidget::createPopupContent$lambda$0$0, (int)1, null).bottomGap(BottomGap.SMALL);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> TypeScriptEngineWidget.createPopupContent$lambda$0$1($state, this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPopupContent$lambda$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(TypeScriptEngineWidgetKt.access$msg("typescript.engine.widget.title")).gap(RightGap.SMALL).bold();
        Icon icon = AllIcons.General.ContextHelp;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ContextHelp");
        $this$row.icon(icon).applyToComponent(TypeScriptEngineWidget::createPopupContent$lambda$0$0$0);
        return Unit.INSTANCE;
    }

    private static final Unit createPopupContent$lambda$0$0$0(JLabel $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setToolTipText(TypeScriptEngineWidgetKt.access$msg("typescript.engine.widget.hint"));
        return Unit.INSTANCE;
    }

    private static final Unit createPopupContent$lambda$0$1(SettingsModel $state, TypeScriptEngineWidget this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.panel(arg_0 -> TypeScriptEngineWidget.createPopupContent$lambda$0$1$0($state, this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPopupContent$lambda$0$1$0(SettingsModel $state, TypeScriptEngineWidget this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> TypeScriptEngineWidget.createPopupContent$lambda$0$1$0$0($state, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> TypeScriptEngineWidget.createPopupContent$lambda$0$1$0$1($state, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> TypeScriptEngineWidget.createPopupContent$lambda$0$1$0$2($state, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> TypeScriptEngineWidget.createPopupContent$lambda$0$1$0$3(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPopupContent$lambda$0$1$0$0(SettingsModel $state, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(TypeScriptEngineWidgetKt.access$msg("typescript.engine.widget.TSandTSX.label")), (ObservableMutableProperty)((ObservableMutableProperty)$state.getTsandtsx()));
        return Unit.INSTANCE;
    }

    private static final Unit createPopupContent$lambda$0$1$0$1(SettingsModel $state, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(TypeScriptEngineWidgetKt.access$msg("typescript.engine.widget.angular.label")), (ObservableMutableProperty)((ObservableMutableProperty)$state.getAngular())).enabled($state.getAngularServiceEnabled()).applyToComponent(arg_0 -> TypeScriptEngineWidget.createPopupContent$lambda$0$1$0$1$0($state, arg_0)).customize(UnscaledGapsKt.UnscaledGaps$default((int)0, (int)0, (int)0, (int)new IntelliJSpacingConfiguration().getHorizontalSmallGap(), (int)7, null));
        Icon icon = AllIcons.General.Beta;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Beta");
        $this$row.icon(icon);
        return Unit.INSTANCE;
    }

    private static final Unit createPopupContent$lambda$0$1$0$1$0(SettingsModel $state, JBCheckBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        if (!$state.getAngularServiceEnabled()) {
            $this$applyToComponent.setToolTipText(TypeScriptEngineWidgetKt.access$msg("typescript.engine.widget.angular.disabled"));
        }
        return Unit.INSTANCE;
    }

    private static final Unit createPopupContent$lambda$0$1$0$2(SettingsModel $state, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(TypeScriptEngineWidgetKt.access$msg("typescript.engine.widget.vue.label")), (ObservableMutableProperty)((ObservableMutableProperty)$state.getVue())).enabled($state.getVueServiceEnabled()).customize(UnscaledGapsKt.UnscaledGaps$default((int)0, (int)0, (int)0, (int)new IntelliJSpacingConfiguration().getHorizontalSmallGap(), (int)7, null)).applyToComponent(arg_0 -> TypeScriptEngineWidget.createPopupContent$lambda$0$1$0$2$0($state, arg_0));
        Icon icon = AllIcons.General.Alpha;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Alpha");
        $this$row.icon(icon);
        return Unit.INSTANCE;
    }

    private static final Unit createPopupContent$lambda$0$1$0$2$0(SettingsModel $state, JBCheckBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        if (!$state.getVueServiceEnabled()) {
            $this$applyToComponent.setToolTipText(TypeScriptEngineWidgetKt.access$msg("typescript.engine.widget.vue.disabled"));
        }
        return Unit.INSTANCE;
    }

    private static final Unit createPopupContent$lambda$0$1$0$3(TypeScriptEngineWidget this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.link(TypeScriptEngineWidgetKt.access$msg("typescript.engine.widget.bug.report"), arg_0 -> TypeScriptEngineWidget.createPopupContent$lambda$0$1$0$3$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPopupContent$lambda$0$1$0$3$0(TypeScriptEngineWidget this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        AnAction action = ActionManager.getInstance().getAction("TypeScriptEngineBugReportAction");
        AnActionEvent anActionEvent = AnActionEvent.createEvent((AnAction)action, (DataContext)SimpleDataContext.builder().add(CommonDataKeys.PROJECT, (Object)this$0.project).build(), null, (String)"toolbar", (ActionUiKind)((ActionUiKind)ActionUiKind.TOOLBAR), null);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createEvent(...)");
        AnActionEvent event = anActionEvent;
        action.actionPerformed(event);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$destroyTooltip(TypeScriptEngineWidget $this, GotItTooltip tooltip) {
        $this.destroyTooltip(tooltip);
    }

    public static final /* synthetic */ Project access$getProject$p(TypeScriptEngineWidget $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$showPopup(TypeScriptEngineWidget $this, boolean showTooltip) {
        $this.showPopup(showTooltip);
    }
}

