/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webstorm.typeEngineWidget;

import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.ui.TypeScriptServiceRestartService;
import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.observable.properties.PropertyGraph;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.angular2.options.AngularServiceSettings;
import org.angular2.options.AngularSettings;
import org.angular2.options.AngularSettingsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.options.VueServiceSettings;
import org.jetbrains.vuejs.options.VueSettings;
import org.jetbrains.vuejs.options.VueSettingsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\b\u0010\u0019\u001a\u00020\u0017H\u0002J\b\u0010\u001a\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/intellij/webstorm/typeEngineWidget/SettingsModel;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "propertyGraph", "Lcom/intellij/openapi/observable/properties/PropertyGraph;", "angularServiceEnabled", "", "getAngularServiceEnabled", "()Z", "vueServiceEnabled", "getVueServiceEnabled", "tsandtsx", "Lcom/intellij/openapi/observable/properties/GraphProperty;", "getTsandtsx", "()Lcom/intellij/openapi/observable/properties/GraphProperty;", "angular", "getAngular", "vue", "getVue", "updateTypeScriptSettings", "", "updateAngularSettings", "updateVueSettings", "restartServices", "intellij.webstorm.typeEngineWidget"})
@SourceDebugExtension(value={"SMAP\nTypeScriptEngineWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptEngineWidget.kt\ncom/intellij/webstorm/typeEngineWidget/SettingsModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,299:1\n1#2:300\n*E\n"})
final class SettingsModel {
    @NotNull
    private final Project project;
    @NotNull
    private final PropertyGraph propertyGraph;
    private final boolean angularServiceEnabled;
    private final boolean vueServiceEnabled;
    @NotNull
    private final GraphProperty<Boolean> tsandtsx;
    @NotNull
    private final GraphProperty<Boolean> angular;
    @NotNull
    private final GraphProperty<Boolean> vue;

    public SettingsModel(@NotNull Project project) {
        GraphProperty it;
        GraphProperty graphProperty;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.propertyGraph = new PropertyGraph(null, false, 3, null);
        this.angularServiceEnabled = AngularSettingsKt.getAngularSettings((Project)this.project).getServiceType() == AngularServiceSettings.AUTO;
        this.vueServiceEnabled = VueSettingsKt.getVueSettings((Project)this.project).getServiceType() == VueServiceSettings.AUTO;
        GraphProperty graphProperty2 = graphProperty = this.propertyGraph.property((Object)TypeScriptCompilerSettings.Companion.getSettings(this.project).getUseTypesFromServer());
        SettingsModel settingsModel = this;
        boolean bl = false;
        it.afterChange(arg_0 -> SettingsModel.tsandtsx$lambda$0$0(this, arg_0));
        settingsModel.tsandtsx = graphProperty;
        it = graphProperty = this.propertyGraph.property((Object)AngularSettingsKt.getAngularSettings((Project)this.project).getUseTypesFromServer());
        settingsModel = this;
        boolean bl2 = false;
        it.afterChange(arg_0 -> SettingsModel.angular$lambda$0$0(this, arg_0));
        settingsModel.angular = graphProperty;
        it = graphProperty = this.propertyGraph.property((Object)VueSettingsKt.getVueSettings((Project)this.project).getUseTypesFromServer());
        settingsModel = this;
        boolean bl3 = false;
        it.afterChange(arg_0 -> SettingsModel.vue$lambda$0$0(this, arg_0));
        settingsModel.vue = graphProperty;
    }

    public final boolean getAngularServiceEnabled() {
        return this.angularServiceEnabled;
    }

    public final boolean getVueServiceEnabled() {
        return this.vueServiceEnabled;
    }

    @NotNull
    public final GraphProperty<Boolean> getTsandtsx() {
        return this.tsandtsx;
    }

    @NotNull
    public final GraphProperty<Boolean> getAngular() {
        return this.angular;
    }

    @NotNull
    public final GraphProperty<Boolean> getVue() {
        return this.vue;
    }

    private final void updateTypeScriptSettings() {
        boolean newValue;
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.Companion.getSettings(this.project);
        boolean oldValue = TypeScriptCompilerConfigUtil.isEffectiveUseTypesFromServer((boolean)settings.getUseService(), (boolean)settings.getUseTypesFromServer());
        if (oldValue != (newValue = TypeScriptCompilerConfigUtil.isEffectiveUseTypesFromServer((boolean)settings.getUseService(), (boolean)((Boolean)this.tsandtsx.get())))) {
            settings.setUseServicePoweredTypesManually(((Boolean)this.tsandtsx.get()).booleanValue());
            this.restartServices();
        }
    }

    private final void updateAngularSettings() {
        AngularSettings settings = AngularSettingsKt.getAngularSettings((Project)this.project);
        boolean bl = false;
        if (settings.getUseTypesFromServer() != ((Boolean)this.angular.get()).booleanValue()) {
            settings.setUseTypesFromServer(((Boolean)this.angular.get()).booleanValue());
            this.restartServices();
        }
    }

    private final void updateVueSettings() {
        VueSettings settings = VueSettingsKt.getVueSettings((Project)this.project);
        boolean bl = false;
        if (settings.getUseTypesFromServer() != ((Boolean)this.vue.get()).booleanValue()) {
            settings.setUseTypesFromServer(((Boolean)this.vue.get()).booleanValue());
            this.restartServices();
        }
    }

    private final void restartServices() {
        ((TypeScriptServiceRestartService)this.project.getService(TypeScriptServiceRestartService.class)).restartServices(true);
    }

    private static final Unit tsandtsx$lambda$0$0(SettingsModel this$0, boolean it) {
        this$0.updateTypeScriptSettings();
        return Unit.INSTANCE;
    }

    private static final Unit angular$lambda$0$0(SettingsModel this$0, boolean it) {
        this$0.updateAngularSettings();
        return Unit.INSTANCE;
    }

    private static final Unit vue$lambda$0$0(SettingsModel this$0, boolean it) {
        this$0.updateVueSettings();
        return Unit.INSTANCE;
    }
}

