/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 79590750677608L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-711710100 - -14156, 711710100 + 1186, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-711710100 - -14157, 711710100 - 17482, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 139507776142709L;
                thread = Thread.currentThread();
                boolean bl2 = SshAgentIpcService.n();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (!bl2) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl3 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(1351593840 - 30921, -1351593840 - -((char)-20752), (int)l2) + string + WindowsNamedPipeAgentIpc.b(1351593840 - 30922, -1351593840 - -22087, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(1351593840 - 30927, 1351593840 - 30299, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        block17: {
            boolean bl;
            block19: {
                block18: {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
                    boolean bl2;
                    long l2;
                    block15: {
                        block16: {
                            l2 = 103580909357598L;
                            Object object = this.lock;
                            synchronized (object) {
                                boolean bl3;
                                bl2 = SshAgentIpcService.W();
                                boolean bl4 = false;
                                try {
                                    bl3 = this.connectionThread == null;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl3) {
                                    boolean bl5 = false;
                                    String string = WindowsNamedPipeAgentIpc.b(816959310 - (char)-29309, -816959310 - -20498, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(816959310 - (char)-29306, 816959310 - 31670, (int)l2) + this.state;
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.connectionThread = Thread.currentThread();
                                Unit unit = Unit.INSTANCE;
                            }
                            try {
                                try {
                                    WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                                    Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(816959310 - (char)-29307, -816959310 - -((char)-25050), (int)l2));
                                    this.hPipe = hANDLE;
                                    windowsNamedPipeAgentIpc = this;
                                    if (bl2) break block15;
                                    if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                                    }
                                    break block16;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                throw new RuntimeException(WindowsNamedPipeAgentIpc.b(816959310 - (char)-29304, -816959310 - -((char)-20090), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(816959310 - (char)-29305, 816959310 - (char)-28271, (int)l2) + ErrorToolsKt.kernel32LastError());
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        this.state = NamedPipeState.Open;
                        windowsNamedPipeAgentIpc = this;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
                    boolean bl6 = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(816959310 - (char)-29302, 816959310 - (char)-19473, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(816959310 - (char)-29304, -816959310 - -((char)-20090), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(816959310 - (char)-29303, -816959310 - -((char)-22344), (int)l2));
                            if (ActionTimestamp.n() == null) break block17;
                            if (!bl2) break block18;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block19;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            SshAgentIpcService.n(bl);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                boolean bl;
                block6: {
                    long l2 = 47677422394275L;
                    bl = SshAgentIpcService.n();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (!bl) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (!bl) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        boolean bl;
        long l2;
        block27: {
            block28: {
                l2 = 1025946877301L;
                boolean bl2 = SshAgentIpcService.n();
                this.assertConnectionThread();
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl3;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            bl = bl2;
                            boolean bl4 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (!bl) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl5 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(550362930 - 26761, -550362930 - -((char)-23031), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(550362930 - 26757, -550362930 - -((char)-19323), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(550362930 - 26762, -550362930 - -30946, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl3 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl3) {
                        boolean bl6 = false;
                        String string = WindowsNamedPipeAgentIpc.b(550362930 - 26757, -550362930 - -((char)-19323), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(550362930 - 26759, 550362930 - (char)-8567, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl7 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(550362930 - 26761, -550362930 - -((char)-23031), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(550362930 - 26757, -550362930 - -((char)-19323), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(550362930 - 26760, 550362930 - (char)-26537, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (!bl) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl8 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(550362930 - 26761, -550362930 - -((char)-23031), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(550362930 - 26757, -550362930 - -((char)-19323), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(550362930 - 26749, 550362930 - 30546, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(550362930 - 26757, -550362930 - -((char)-19323), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(550362930 - 26750, -550362930 - -((char)-20402), (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl9;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl10 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (!bl) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl9 = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl9) {
                boolean bl11 = false;
                String string = WindowsNamedPipeAgentIpc.b(550362930 - 26757, -550362930 - -((char)-19323), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(550362930 - 26759, 550362930 - (char)-8567, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl12 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(550362930 - 26761, -550362930 - -((char)-23031), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(550362930 - 26757, -550362930 - -((char)-19323), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(550362930 - 26747, 550362930 - 31206, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 76470001651058L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(1891077960 - 29583, -1891077960 - -25044, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 88416921768826L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-725079240 - -((char)-9608), 725079240 - (char)-1642, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u00bd\u009a\u001b>p\u00d2\u000e'\u00bd\u0012\u00119zU]\u00b0\u00d0><\u0014\u0093\u0015\u00de\u00c9\u00d3\u00ee\u0007%\u001eT\u00a0%\u008e/\u0002t\u00d6`\u00fb\u00cb";
                        var4_3 = "\u00bd\u009a\u001b>p\u00d2\u000e'\u00bd\u0012\u00119zU]\u00b0\u00d0><\u0014\u0093\u0015\u00de\u00c9\u00d3\u00ee\u0007%\u001eT\u00a0%\u008e/\u0002t\u00d6`\u00fb\u00cb".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 17;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 106;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 39;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 6;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 58;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 23;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 113;
                                        break;
                                    }
                                    default: {
                                        v11 = 7;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xFFFFD6CB) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 165;
                            case 1 -> 162;
                            case 2 -> 230;
                            case 3 -> 161;
                            case 4 -> 209;
                            case 5 -> 133;
                            case 6 -> 142;
                            case 7 -> 71;
                            case 8 -> 135;
                            case 9 -> 228;
                            case 10 -> 1;
                            case 11 -> 93;
                            case 12 -> 180;
                            case 13 -> 134;
                            case 14 -> 211;
                            case 15 -> 105;
                            case 16 -> 78;
                            case 17 -> 91;
                            case 18 -> 66;
                            case 19 -> 247;
                            case 20 -> 149;
                            case 21 -> 202;
                            case 22 -> 11;
                            case 23 -> 36;
                            case 24 -> 204;
                            case 25 -> 187;
                            case 26 -> 181;
                            case 27 -> 45;
                            case 28 -> 140;
                            case 29 -> 97;
                            case 30 -> 182;
                            case 31 -> 72;
                            case 32 -> 175;
                            case 33 -> 147;
                            case 34 -> 166;
                            case 35 -> 30;
                            case 36 -> 215;
                            case 37 -> 153;
                            case 38 -> 43;
                            case 39 -> 186;
                            case 40 -> 206;
                            case 41 -> 99;
                            case 42 -> 63;
                            case 43 -> 136;
                            case 44 -> 17;
                            case 45 -> 44;
                            case 46 -> 210;
                            case 47 -> 199;
                            case 48 -> 18;
                            case 49 -> 205;
                            case 50 -> 68;
                            case 51 -> 168;
                            case 52 -> 117;
                            case 53 -> 243;
                            case 54 -> 129;
                            case 55 -> 109;
                            case 56 -> 237;
                            case 57 -> 42;
                            case 58 -> 151;
                            case 59 -> 144;
                            case 60 -> 61;
                            case 61 -> 138;
                            case 62 -> 245;
                            case 63 -> 20;
                            case 64 -> 176;
                            case 65 -> 26;
                            case 66 -> 188;
                            case 67 -> 87;
                            case 68 -> 190;
                            case 69 -> 90;
                            case 70 -> 252;
                            case 71 -> 58;
                            case 72 -> 229;
                            case 73 -> 103;
                            case 74 -> 120;
                            case 75 -> 77;
                            case 76 -> 9;
                            case 77 -> 238;
                            case 78 -> 156;
                            case 79 -> 39;
                            case 80 -> 128;
                            case 81 -> 167;
                            case 82 -> 250;
                            case 83 -> 189;
                            case 84 -> 64;
                            case 85 -> 234;
                            case 86 -> 80;
                            case 87 -> 89;
                            case 88 -> 116;
                            case 89 -> 75;
                            case 90 -> 7;
                            case 91 -> 16;
                            case 92 -> 231;
                            case 93 -> 212;
                            case 94 -> 113;
                            case 95 -> 218;
                            case 96 -> 52;
                            case 97 -> 223;
                            case 98 -> 82;
                            case 99 -> 160;
                            case 100 -> 79;
                            case 101 -> 48;
                            case 102 -> 24;
                            case 103 -> 69;
                            case 104 -> 150;
                            case 105 -> 130;
                            case 106 -> 235;
                            case 107 -> 236;
                            case 108 -> 184;
                            case 109 -> 240;
                            case 110 -> 81;
                            case 111 -> 106;
                            case 112 -> 222;
                            case 113 -> 95;
                            case 114 -> 54;
                            case 115 -> 196;
                            case 116 -> 137;
                            case 117 -> 146;
                            case 118 -> 163;
                            case 119 -> 148;
                            case 120 -> 174;
                            case 121 -> 12;
                            case 122 -> 23;
                            case 123 -> 94;
                            case 124 -> 127;
                            case 125 -> 216;
                            case 126 -> 201;
                            case 127 -> 74;
                            case 128 -> 15;
                            case 129 -> 251;
                            case 130 -> 3;
                            case 131 -> 164;
                            case 132 -> 226;
                            case 133 -> 25;
                            case 134 -> 214;
                            case 135 -> 8;
                            case 136 -> 185;
                            case 137 -> 249;
                            case 138 -> 124;
                            case 139 -> 22;
                            case 140 -> 59;
                            case 141 -> 227;
                            case 142 -> 121;
                            case 143 -> 83;
                            case 144 -> 208;
                            case 145 -> 169;
                            case 146 -> 67;
                            case 147 -> 29;
                            case 148 -> 171;
                            case 149 -> 62;
                            case 150 -> 254;
                            case 151 -> 73;
                            case 152 -> 224;
                            case 153 -> 191;
                            case 154 -> 200;
                            case 155 -> 37;
                            case 156 -> 122;
                            case 157 -> 6;
                            case 158 -> 131;
                            case 159 -> 157;
                            case 160 -> 5;
                            case 161 -> 107;
                            case 162 -> 221;
                            case 163 -> 241;
                            case 164 -> 207;
                            case 165 -> 4;
                            case 166 -> 139;
                            case 167 -> 96;
                            case 168 -> 123;
                            case 169 -> 132;
                            case 170 -> 192;
                            case 171 -> 195;
                            case 172 -> 158;
                            case 173 -> 170;
                            case 174 -> 141;
                            case 175 -> 32;
                            case 176 -> 193;
                            case 177 -> 19;
                            case 178 -> 55;
                            case 179 -> 53;
                            case 180 -> 40;
                            case 181 -> 154;
                            case 182 -> 100;
                            case 183 -> 57;
                            case 184 -> 27;
                            case 185 -> 51;
                            case 186 -> 197;
                            case 187 -> 118;
                            case 188 -> 0;
                            case 189 -> 21;
                            case 190 -> 10;
                            case 191 -> 220;
                            case 192 -> 56;
                            case 193 -> 85;
                            case 194 -> 213;
                            case 195 -> 35;
                            case 196 -> 84;
                            case 197 -> 119;
                            case 198 -> 86;
                            case 199 -> 31;
                            case 200 -> 2;
                            case 201 -> 65;
                            case 202 -> 198;
                            case 203 -> 143;
                            case 204 -> 70;
                            case 205 -> 38;
                            case 206 -> 145;
                            case 207 -> 248;
                            case 208 -> 172;
                            case 209 -> 98;
                            case 210 -> 101;
                            case 211 -> 112;
                            case 212 -> 232;
                            case 213 -> 255;
                            case 214 -> 219;
                            case 215 -> 14;
                            case 216 -> 225;
                            case 217 -> 60;
                            case 218 -> 203;
                            case 219 -> 125;
                            case 220 -> 233;
                            case 221 -> 33;
                            case 222 -> 13;
                            case 223 -> 108;
                            case 224 -> 88;
                            case 225 -> 111;
                            case 226 -> 28;
                            case 227 -> 155;
                            case 228 -> 242;
                            case 229 -> 152;
                            case 230 -> 239;
                            case 231 -> 178;
                            case 232 -> 194;
                            case 233 -> 102;
                            case 234 -> 183;
                            case 235 -> 115;
                            case 236 -> 126;
                            case 237 -> 244;
                            case 238 -> 177;
                            case 239 -> 34;
                            case 240 -> 46;
                            case 241 -> 47;
                            case 242 -> 49;
                            case 243 -> 173;
                            case 244 -> 50;
                            case 245 -> 159;
                            case 246 -> 246;
                            case 247 -> 110;
                            case 248 -> 92;
                            case 249 -> 41;
                            case 250 -> 253;
                            case 251 -> 217;
                            case 252 -> 114;
                            case 253 -> 76;
                            case 254 -> 179;
                            default -> 104;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (!bl) {
                ActionTimestamp.n(new int[5]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 51587694814034L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    boolean bl2 = SshAgentIpcService.n();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (!bl2) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-842649030 - -((char)-18860), 842649030 - 29910, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-842649030 - -((char)-18864), 842649030 - (char)-32174, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-842649030 - -((char)-18857), 842649030 - (char)-20860, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-842649030 - -((char)-18860), 842649030 - 29910, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-842649030 - -((char)-18864), 842649030 - (char)-32174, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-842649030 - -((char)-18852), 842649030 - 25131, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    boolean bl2;
                    block13: {
                        long l2 = 114703396584565L;
                        boolean bl3 = SshAgentIpcService.n();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-1999997130 - -16506, -1999997130 - -6815, (int)l2));
                        bl2 = bl3;
                        try {
                            try {
                                try {
                                    try {
                                        if (!bl2 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (!bl2) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-1999997130 - -16509, 1999997130 - 10017, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (!bl2) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        boolean bl;
        long l2;
        block25: {
            block26: {
                l2 = 52228855125706L;
                boolean bl2 = SshAgentIpcService.W();
                this.assertConnectionThread();
                bl = bl2;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl3;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl4 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (bl) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (bl) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl5 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2052818340 - -25274, 2052818340 - 6204, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-2052818340 - -25270, 2052818340 - 1720, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2052818340 - -25265, 2052818340 - 6562, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl3 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl3) {
                        boolean bl6 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-2052818340 - -25270, 2052818340 - 1720, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2052818340 - -25272, -2052818340 - -12474, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl7 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2052818340 - -25274, 2052818340 - 6204, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-2052818340 - -25270, 2052818340 - 1720, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2052818340 - -25254, -2052818340 - -30190, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (bl) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl7 = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2052818340 - -25274, 2052818340 - 6204, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-2052818340 - -25270, 2052818340 - 1720, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2052818340 - -25255, 2052818340 - 2249, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl8 = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (bl) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl9 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2052818340 - -25274, 2052818340 - 6204, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-2052818340 - -25270, 2052818340 - 1720, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2052818340 - -25252, -2052818340 - -5537, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                boolean bl2;
                block16: {
                    l2 = 103301768916432L;
                    Object object = this.lock;
                    bl2 = SshAgentIpcService.n();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl3 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (!bl2) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl4 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(784453950 + 21710, -784453950 + -((char)-26544), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(784453950 + 21706, -784453950 + -((char)-22324), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(784453950 + 21725, 784453950 + 15584, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(784453950 + 21726, 784453950 + (char)-26139, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(784453950 + 21710, -784453950 + -((char)-26544), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(784453950 + 21706, -784453950 + -((char)-22324), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(784453950 + 21727, -784453950 + -27591, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (!bl2) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (!bl2) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl5 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(784453950 + 21710, -784453950 + -((char)-26544), (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(784453950 + 21706, -784453950 + -((char)-22324), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(784453950 + 21728, 784453950 + 28833, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(784453950 + 21710, -784453950 + -((char)-26544), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(784453950 + 21706, -784453950 + -((char)-22324), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(784453950 + 21729, -784453950 + -22770, (int)l2));
                    if (!bl2) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(784453950 + 21710, -784453950 + -((char)-26544), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(784453950 + 21706, -784453950 + -((char)-22324), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(784453950 + 21730, 784453950 + 12120, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(784453950 + 21731, 784453950 + 27378, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "U\u008c\u0012\u0092\"(\"\u00c0\u0014%\u00ed$Y\u001a\u00d9\u008a\u00e4d\u00df\u00a1\u0098-\u00d2\u00dfP\u00b8\u00f8eM\u0006\u00e9U\u0085\u00a9\u00ba\u000e\u0018~\u00a6/\u0000\u00f97\u00f4\u00f9c\u0001N3\u00b6X\u00fe\u00835\u00eb\u00fa\u00b2\u00aa\u00dcz\u00d9\t\u009c\u00da\u00ed>\u00cao\u008a\u00ba\u0090\u0005J\u00d5\u00f1\u00b9.\b\u0017\u000eZ\u00b3y*Ob\u0014\u0083f\u0088\u00b3\u00e2\u008c\u00a0\u00d9O\u00a5oc\u00be\u000e\u0016&\u0093\u00e5\u00f9\u00ac\u0005IH\u0091\n\"\u001eZ\u00ba\u00e60Q\u00f5C\u00db0Qo\u00be\u00de\u00c9Q\u00d5!\u00b0\u00aa-\f\u0000\u00a2\u008f.7\u0088\u00fd\u00bf\u00b1\u0010R\u00f6\u0003|\u00baN\u00c8U<2c/Y\u00ae\u000e\u00a6\t\u00dc\u007f3\u009bB\u00fc\u00bdW\u0098\u0010\u0083>9e\u00fdm 1!\u00be\u00c0\u00be-\u009c\u0080\u00e0?\u00c6i}J/\u00b3\t\u007f\b\u0014-\u00ed)U\u0092\u007f\u009c\u0080`\u00ee\u00db*#\u00ac\u000e\u00bb\u0081\u00d8\u00a9C\u0004\u001cl\u000e\u008dA\u0092u\u0003\u00c3=\u009b\u008d\u0087f\u00f1N;#\u001c\u0092\u001b\u001aR,R\u00bfc\u00112\u00e2\u00bc\u00d3\b\u00b7\u00dcN\u00e9\u00fba\u001f\u000b\fTU\"\u00c3kF\u00e3\u00e8p\u00cd\u00b8\u00d4F\u00a8\u00d9\u00bdR\u0098t\u009d\u00ae\u00bf\tK\u0088s\u00f1\u00c6\u00cd\u00ea\u00b1\u00aeg\u0010IY\u00f2w[]\u00cf\u008d\u0088\u00baY\u0087\u00102\u00a3\u00bfd\r%oRLE\u0080,\u00c6\u00fd\u00d5<*\u00b5\u00e2\u0011%!\u0001yP\u00cd\u00f9*\u00ecO\u0004\u00fb;\u00b0\u009f\u007f\u001f\u00f8\u00b7\u00b2\u0091\u00db\u00c1\u0012]\u001a\u0081*\u00a4v\u0097O\u00af\u0099\u0017\u00c0\u0013\u008aG\u00a5\u00cc\u00af\u008f\u00af&F;\u00c1\u000b\u001au\u00eb\u00c7R\u00c6\u00c4\u00f8\u0094\u00c3.\u0015\u0093\u00eb\u00da\u0017s\u00b4\f\u00cb\u00b3E\u0002\u00f7\u00cdQ%!/R\u00cb\u00c2\u00dd)u\u00b8\u0003p\u00ed\u00fd\u00d4\u00da\u00c2q1\u00ba\u0011^=\u0093\u0088\u00189UE\u00f7\u009a\u00c2'\u0007iO\u00b1\u00e2\u00bd*\u0099\u00db\u0097W\u0015\u00e7\u00d3\u00fc\u0017\u0007[X\u00ccv0`\u00f4\u0007W\u00c0)\tk`\u0089(T\u009dk\u00f5P'\u0095\u00a6\u009a)\u0010\u0087\u0016x\u009f\u00d4\u00db]\u00fd\u00be\u00bc\u00b4\u00caa\u00bd\u00cf\u008c-:\u00ce\u0017\u00b67#\u00dc\u00e5\u00c6\u00cc:j\u000f\u00c1\u00e3\u0097\u0013'\u0097\u00des\u0086\u001e20\u00f2\u00da\u009d\"%R\t-\u00acV\u00fc\u00af\u00c7\u00df\u0091o\u0006\u00e8\u00bb\u008b\u00b32\u00d4R\u0012\u0017\u00d0\u008e\u00fd\u00da\u00ff*G|\u00c1\u00fe8\u00b2\u000e0\u00de\u00a9\u00b4\u00e0c&\u00ed\u0099\u00cd\u00d1J\u0082\u009f\u001b\u00e6\u00dft\u0091\u00a0r\u00bb\u0093}\u0085\u00c0B\u00f0\u00a8C\u0095\u0004[\u009f\u00e3@\u0015\u00e9h\u0091k'\n\u00d9\u00b6W\u00bb\u00d0\u00d3f\u008dm$\u0018\u00af\u00e7]\u009b\u0084\u008f\u001er\u00d7pWc\u00bb\u00df\u00d6Z\u00c1\u00a3\u00f0\u0085\u00d5\u0092\u0000\u00cb)\u00a1\u008a\u00996\u00be5\u00be\u00c3\u008fR\u0098\u00de \u00db\u0084X\u00c1\u0014\u00cf\u0011\u00a1oO\u00dd\u00e8v\r\u008dn\u00e6\u00fd;\u00b4'\u00e7\\\u00c5\u00a2\u00c9TT\t\u00db_\u00d3\u0081Tp)\u009d\u00b7";
                var4_3 = "U\u008c\u0012\u0092\"(\"\u00c0\u0014%\u00ed$Y\u001a\u00d9\u008a\u00e4d\u00df\u00a1\u0098-\u00d2\u00dfP\u00b8\u00f8eM\u0006\u00e9U\u0085\u00a9\u00ba\u000e\u0018~\u00a6/\u0000\u00f97\u00f4\u00f9c\u0001N3\u00b6X\u00fe\u00835\u00eb\u00fa\u00b2\u00aa\u00dcz\u00d9\t\u009c\u00da\u00ed>\u00cao\u008a\u00ba\u0090\u0005J\u00d5\u00f1\u00b9.\b\u0017\u000eZ\u00b3y*Ob\u0014\u0083f\u0088\u00b3\u00e2\u008c\u00a0\u00d9O\u00a5oc\u00be\u000e\u0016&\u0093\u00e5\u00f9\u00ac\u0005IH\u0091\n\"\u001eZ\u00ba\u00e60Q\u00f5C\u00db0Qo\u00be\u00de\u00c9Q\u00d5!\u00b0\u00aa-\f\u0000\u00a2\u008f.7\u0088\u00fd\u00bf\u00b1\u0010R\u00f6\u0003|\u00baN\u00c8U<2c/Y\u00ae\u000e\u00a6\t\u00dc\u007f3\u009bB\u00fc\u00bdW\u0098\u0010\u0083>9e\u00fdm 1!\u00be\u00c0\u00be-\u009c\u0080\u00e0?\u00c6i}J/\u00b3\t\u007f\b\u0014-\u00ed)U\u0092\u007f\u009c\u0080`\u00ee\u00db*#\u00ac\u000e\u00bb\u0081\u00d8\u00a9C\u0004\u001cl\u000e\u008dA\u0092u\u0003\u00c3=\u009b\u008d\u0087f\u00f1N;#\u001c\u0092\u001b\u001aR,R\u00bfc\u00112\u00e2\u00bc\u00d3\b\u00b7\u00dcN\u00e9\u00fba\u001f\u000b\fTU\"\u00c3kF\u00e3\u00e8p\u00cd\u00b8\u00d4F\u00a8\u00d9\u00bdR\u0098t\u009d\u00ae\u00bf\tK\u0088s\u00f1\u00c6\u00cd\u00ea\u00b1\u00aeg\u0010IY\u00f2w[]\u00cf\u008d\u0088\u00baY\u0087\u00102\u00a3\u00bfd\r%oRLE\u0080,\u00c6\u00fd\u00d5<*\u00b5\u00e2\u0011%!\u0001yP\u00cd\u00f9*\u00ecO\u0004\u00fb;\u00b0\u009f\u007f\u001f\u00f8\u00b7\u00b2\u0091\u00db\u00c1\u0012]\u001a\u0081*\u00a4v\u0097O\u00af\u0099\u0017\u00c0\u0013\u008aG\u00a5\u00cc\u00af\u008f\u00af&F;\u00c1\u000b\u001au\u00eb\u00c7R\u00c6\u00c4\u00f8\u0094\u00c3.\u0015\u0093\u00eb\u00da\u0017s\u00b4\f\u00cb\u00b3E\u0002\u00f7\u00cdQ%!/R\u00cb\u00c2\u00dd)u\u00b8\u0003p\u00ed\u00fd\u00d4\u00da\u00c2q1\u00ba\u0011^=\u0093\u0088\u00189UE\u00f7\u009a\u00c2'\u0007iO\u00b1\u00e2\u00bd*\u0099\u00db\u0097W\u0015\u00e7\u00d3\u00fc\u0017\u0007[X\u00ccv0`\u00f4\u0007W\u00c0)\tk`\u0089(T\u009dk\u00f5P'\u0095\u00a6\u009a)\u0010\u0087\u0016x\u009f\u00d4\u00db]\u00fd\u00be\u00bc\u00b4\u00caa\u00bd\u00cf\u008c-:\u00ce\u0017\u00b67#\u00dc\u00e5\u00c6\u00cc:j\u000f\u00c1\u00e3\u0097\u0013'\u0097\u00des\u0086\u001e20\u00f2\u00da\u009d\"%R\t-\u00acV\u00fc\u00af\u00c7\u00df\u0091o\u0006\u00e8\u00bb\u008b\u00b32\u00d4R\u0012\u0017\u00d0\u008e\u00fd\u00da\u00ff*G|\u00c1\u00fe8\u00b2\u000e0\u00de\u00a9\u00b4\u00e0c&\u00ed\u0099\u00cd\u00d1J\u0082\u009f\u001b\u00e6\u00dft\u0091\u00a0r\u00bb\u0093}\u0085\u00c0B\u00f0\u00a8C\u0095\u0004[\u009f\u00e3@\u0015\u00e9h\u0091k'\n\u00d9\u00b6W\u00bb\u00d0\u00d3f\u008dm$\u0018\u00af\u00e7]\u009b\u0084\u008f\u001er\u00d7pWc\u00bb\u00df\u00d6Z\u00c1\u00a3\u00f0\u0085\u00d5\u0092\u0000\u00cb)\u00a1\u008a\u00996\u00be5\u00be\u00c3\u008fR\u0098\u00de \u00db\u0084X\u00c1\u0014\u00cf\u0011\u00a1oO\u00dd\u00e8v\r\u008dn\u00e6\u00fd;\u00b4'\u00e7\\\u00c5\u00a2\u00c9TT\t\u00db_\u00d3\u0081Tp)\u009d\u00b7".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 81;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00a3\bd\u00db\u00bc5C~\u008dXe\"\"\u00f9y\u00a1\u00c3\u009ab\u00f9\u00fc\u00f0\u00aaMB\u00c5t\u0003l\u0014<\u009c\u00ba\u00cat\u0016\u00fa\u00a0\u00d7\u00eaj\u0083\u00e9\f\u00fa6\u00a1\u0089\u00fb\u00de";
                    var4_3 = "\u00a3\bd\u00db\u00bc5C~\u008dXe\"\"\u00f9y\u00a1\u00c3\u009ab\u00f9\u00fc\u00f0\u00aaMB\u00c5t\u0003l\u0014<\u009c\u00ba\u00cat\u0016\u00fa\u00a0\u00d7\u00eaj\u0083\u00e9\f\u00fa6\u00a1\u0089\u00fb\u00de".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 6;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 127;
                            break;
                        }
                        case 1: {
                            v15 = 105;
                            break;
                        }
                        case 2: {
                            v15 = 34;
                            break;
                        }
                        case 3: {
                            v15 = 116;
                            break;
                        }
                        case 4: {
                            v15 = 113;
                            break;
                        }
                        case 5: {
                            v15 = 39;
                            break;
                        }
                        default: {
                            v15 = 29;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFF8BD0) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 41;
                case 1 -> 48;
                case 2 -> 211;
                case 3 -> 129;
                case 4 -> 156;
                case 5 -> 53;
                case 6 -> 196;
                case 7 -> 9;
                case 8 -> 201;
                case 9 -> 106;
                case 10 -> 51;
                case 11 -> 224;
                case 12 -> 3;
                case 13 -> 183;
                case 14 -> 78;
                case 15 -> 17;
                case 16 -> 26;
                case 17 -> 174;
                case 18 -> 46;
                case 19 -> 127;
                case 20 -> 245;
                case 21 -> 242;
                case 22 -> 89;
                case 23 -> 11;
                case 24 -> 32;
                case 25 -> 2;
                case 26 -> 44;
                case 27 -> 30;
                case 28 -> 189;
                case 29 -> 206;
                case 30 -> 19;
                case 31 -> 13;
                case 32 -> 213;
                case 33 -> 154;
                case 34 -> 128;
                case 35 -> 18;
                case 36 -> 10;
                case 37 -> 64;
                case 38 -> 63;
                case 39 -> 170;
                case 40 -> 159;
                case 41 -> 122;
                case 42 -> 134;
                case 43 -> 202;
                case 44 -> 253;
                case 45 -> 249;
                case 46 -> 56;
                case 47 -> 33;
                case 48 -> 36;
                case 49 -> 180;
                case 50 -> 173;
                case 51 -> 254;
                case 52 -> 43;
                case 53 -> 101;
                case 54 -> 20;
                case 55 -> 237;
                case 56 -> 61;
                case 57 -> 131;
                case 58 -> 214;
                case 59 -> 55;
                case 60 -> 255;
                case 61 -> 223;
                case 62 -> 95;
                case 63 -> 148;
                case 64 -> 1;
                case 65 -> 124;
                case 66 -> 139;
                case 67 -> 143;
                case 68 -> 169;
                case 69 -> 212;
                case 70 -> 219;
                case 71 -> 149;
                case 72 -> 16;
                case 73 -> 108;
                case 74 -> 65;
                case 75 -> 179;
                case 76 -> 116;
                case 77 -> 185;
                case 78 -> 120;
                case 79 -> 161;
                case 80 -> 50;
                case 81 -> 239;
                case 82 -> 28;
                case 83 -> 27;
                case 84 -> 222;
                case 85 -> 203;
                case 86 -> 115;
                case 87 -> 5;
                case 88 -> 163;
                case 89 -> 126;
                case 90 -> 117;
                case 91 -> 104;
                case 92 -> 8;
                case 93 -> 140;
                case 94 -> 35;
                case 95 -> 100;
                case 96 -> 187;
                case 97 -> 193;
                case 98 -> 25;
                case 99 -> 21;
                case 100 -> 198;
                case 101 -> 218;
                case 102 -> 136;
                case 103 -> 15;
                case 104 -> 195;
                case 105 -> 146;
                case 106 -> 97;
                case 107 -> 39;
                case 108 -> 119;
                case 109 -> 79;
                case 110 -> 232;
                case 111 -> 230;
                case 112 -> 93;
                case 113 -> 235;
                case 114 -> 0;
                case 115 -> 12;
                case 116 -> 85;
                case 117 -> 155;
                case 118 -> 75;
                case 119 -> 153;
                case 120 -> 251;
                case 121 -> 210;
                case 122 -> 110;
                case 123 -> 83;
                case 124 -> 38;
                case 125 -> 34;
                case 126 -> 80;
                case 127 -> 66;
                case 128 -> 88;
                case 129 -> 112;
                case 130 -> 178;
                case 131 -> 208;
                case 132 -> 31;
                case 133 -> 240;
                case 134 -> 217;
                case 135 -> 166;
                case 136 -> 22;
                case 137 -> 74;
                case 138 -> 60;
                case 139 -> 111;
                case 140 -> 68;
                case 141 -> 77;
                case 142 -> 165;
                case 143 -> 90;
                case 144 -> 236;
                case 145 -> 133;
                case 146 -> 103;
                case 147 -> 98;
                case 148 -> 70;
                case 149 -> 188;
                case 150 -> 54;
                case 151 -> 14;
                case 152 -> 168;
                case 153 -> 57;
                case 154 -> 151;
                case 155 -> 40;
                case 156 -> 72;
                case 157 -> 246;
                case 158 -> 82;
                case 159 -> 176;
                case 160 -> 52;
                case 161 -> 238;
                case 162 -> 184;
                case 163 -> 7;
                case 164 -> 130;
                case 165 -> 109;
                case 166 -> 157;
                case 167 -> 225;
                case 168 -> 92;
                case 169 -> 113;
                case 170 -> 164;
                case 171 -> 135;
                case 172 -> 84;
                case 173 -> 216;
                case 174 -> 87;
                case 175 -> 114;
                case 176 -> 73;
                case 177 -> 107;
                case 178 -> 194;
                case 179 -> 160;
                case 180 -> 241;
                case 181 -> 42;
                case 182 -> 248;
                case 183 -> 207;
                case 184 -> 147;
                case 185 -> 123;
                case 186 -> 81;
                case 187 -> 247;
                case 188 -> 94;
                case 189 -> 137;
                case 190 -> 29;
                case 191 -> 167;
                case 192 -> 191;
                case 193 -> 145;
                case 194 -> 234;
                case 195 -> 182;
                case 196 -> 45;
                case 197 -> 86;
                case 198 -> 91;
                case 199 -> 62;
                case 200 -> 220;
                case 201 -> 231;
                case 202 -> 69;
                case 203 -> 197;
                case 204 -> 200;
                case 205 -> 226;
                case 206 -> 177;
                case 207 -> 105;
                case 208 -> 67;
                case 209 -> 252;
                case 210 -> 96;
                case 211 -> 150;
                case 212 -> 221;
                case 213 -> 138;
                case 214 -> 125;
                case 215 -> 250;
                case 216 -> 181;
                case 217 -> 132;
                case 218 -> 102;
                case 219 -> 23;
                case 220 -> 228;
                case 221 -> 141;
                case 222 -> 244;
                case 223 -> 58;
                case 224 -> 144;
                case 225 -> 4;
                case 226 -> 215;
                case 227 -> 227;
                case 228 -> 175;
                case 229 -> 76;
                case 230 -> 192;
                case 231 -> 152;
                case 232 -> 243;
                case 233 -> 162;
                case 234 -> 121;
                case 235 -> 37;
                case 236 -> 205;
                case 237 -> 59;
                case 238 -> 99;
                case 239 -> 171;
                case 240 -> 118;
                case 241 -> 204;
                case 242 -> 172;
                case 243 -> 229;
                case 244 -> 186;
                case 245 -> 49;
                case 246 -> 199;
                case 247 -> 24;
                case 248 -> 190;
                case 249 -> 47;
                case 250 -> 158;
                case 251 -> 209;
                case 252 -> 142;
                case 253 -> 6;
                case 254 -> 233;
                default -> 71;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 65821234061846L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(860212410 + (char)-24724, -860212410 + -28965, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        boolean bl2;
                        block4: {
                            l2 = 83437697654460L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            bl2 = SshAgentIpcService.W();
                            try {
                                hANDLE2 = hANDLE;
                                if (bl2) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (bl2) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl3 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-632019540 - -10977, -632019540 - -3350, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-632019540 - -10978, -632019540 + -5455, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-632019540 - -10979, -632019540 - -13024, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u009b'\u0092\u00fdd\u00e6\u00ef\u00b9\u0010\u0089\u00a9!\u008d\u00a8S\u008fV\u00ca\u000b\u00a7^\u00e2\u0085\u00d9\u00dd";
                    var4_3 = "\u009b'\u0092\u00fdd\u00e6\u00ef\u00b9\u0010\u0089\u00a9!\u008d\u00a8S\u008fV\u00ca\u000b\u00a7^\u00e2\u0085\u00d9\u00dd".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 112;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00a2\u009au\u008a(5\u0017k\u00d4\u00d8\u00ce\u0000\u009bW\u00ffPS5K\u00c2)\u007fl\u0093\u007f\u00fe\u00e1\u00cd\u0016\u009d\u0013\u00a4\u00de\u00d4\u00b2,/lc_\u00adJ\u008d\u00a7~d\u00c1\u0085\u00e5r\u00a7~\u0012\u00bb\u00d9\u009a\u0000w\u00d7";
                        var4_3 = "\u00a2\u009au\u008a(5\u0017k\u00d4\u00d8\u00ce\u0000\u009bW\u00ffPS5K\u00c2)\u007fl\u0093\u007f\u00fe\u00e1\u00cd\u0016\u009d\u0013\u00a4\u00de\u00d4\u00b2,/lc_\u00adJ\u008d\u00a7~d\u00c1\u0085\u00e5r\u00a7~\u0012\u00bb\u00d9\u009a\u0000w\u00d7".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 29;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 95;
                                break;
                            }
                            case 1: {
                                v15 = 19;
                                break;
                            }
                            case 2: {
                                v15 = 122;
                                break;
                            }
                            case 3: {
                                v15 = 36;
                                break;
                            }
                            case 4: {
                                v15 = 41;
                                break;
                            }
                            case 5: {
                                v15 = 11;
                                break;
                            }
                            default: {
                                v15 = 22;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xE30) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 215;
                    case 1 -> 98;
                    case 2 -> 176;
                    case 3 -> 167;
                    case 4 -> 246;
                    case 5 -> 70;
                    case 6 -> 101;
                    case 7 -> 18;
                    case 8 -> 43;
                    case 9 -> 233;
                    case 10 -> 192;
                    case 11 -> 10;
                    case 12 -> 38;
                    case 13 -> 244;
                    case 14 -> 202;
                    case 15 -> 59;
                    case 16 -> 72;
                    case 17 -> 40;
                    case 18 -> 93;
                    case 19 -> 126;
                    case 20 -> 60;
                    case 21 -> 232;
                    case 22 -> 138;
                    case 23 -> 130;
                    case 24 -> 1;
                    case 25 -> 16;
                    case 26 -> 17;
                    case 27 -> 247;
                    case 28 -> 61;
                    case 29 -> 147;
                    case 30 -> 116;
                    case 31 -> 45;
                    case 32 -> 73;
                    case 33 -> 22;
                    case 34 -> 34;
                    case 35 -> 90;
                    case 36 -> 199;
                    case 37 -> 36;
                    case 38 -> 223;
                    case 39 -> 41;
                    case 40 -> 114;
                    case 41 -> 8;
                    case 42 -> 139;
                    case 43 -> 79;
                    case 44 -> 99;
                    case 45 -> 96;
                    case 46 -> 209;
                    case 47 -> 121;
                    case 48 -> 28;
                    case 49 -> 219;
                    case 50 -> 211;
                    case 51 -> 125;
                    case 52 -> 253;
                    case 53 -> 196;
                    case 54 -> 171;
                    case 55 -> 78;
                    case 56 -> 234;
                    case 57 -> 14;
                    case 58 -> 68;
                    case 59 -> 24;
                    case 60 -> 134;
                    case 61 -> 25;
                    case 62 -> 151;
                    case 63 -> 119;
                    case 64 -> 159;
                    case 65 -> 100;
                    case 66 -> 112;
                    case 67 -> 178;
                    case 68 -> 160;
                    case 69 -> 135;
                    case 70 -> 136;
                    case 71 -> 53;
                    case 72 -> 9;
                    case 73 -> 156;
                    case 74 -> 187;
                    case 75 -> 77;
                    case 76 -> 26;
                    case 77 -> 218;
                    case 78 -> 164;
                    case 79 -> 206;
                    case 80 -> 111;
                    case 81 -> 235;
                    case 82 -> 52;
                    case 83 -> 85;
                    case 84 -> 227;
                    case 85 -> 193;
                    case 86 -> 212;
                    case 87 -> 195;
                    case 88 -> 31;
                    case 89 -> 229;
                    case 90 -> 44;
                    case 91 -> 249;
                    case 92 -> 190;
                    case 93 -> 162;
                    case 94 -> 3;
                    case 95 -> 39;
                    case 96 -> 108;
                    case 97 -> 103;
                    case 98 -> 210;
                    case 99 -> 208;
                    case 100 -> 216;
                    case 101 -> 165;
                    case 102 -> 231;
                    case 103 -> 35;
                    case 104 -> 241;
                    case 105 -> 243;
                    case 106 -> 174;
                    case 107 -> 179;
                    case 108 -> 127;
                    case 109 -> 76;
                    case 110 -> 62;
                    case 111 -> 240;
                    case 112 -> 217;
                    case 113 -> 203;
                    case 114 -> 13;
                    case 115 -> 186;
                    case 116 -> 141;
                    case 117 -> 140;
                    case 118 -> 21;
                    case 119 -> 142;
                    case 120 -> 254;
                    case 121 -> 58;
                    case 122 -> 207;
                    case 123 -> 71;
                    case 124 -> 6;
                    case 125 -> 191;
                    case 126 -> 23;
                    case 127 -> 80;
                    case 128 -> 27;
                    case 129 -> 113;
                    case 130 -> 97;
                    case 131 -> 87;
                    case 132 -> 204;
                    case 133 -> 12;
                    case 134 -> 88;
                    case 135 -> 30;
                    case 136 -> 104;
                    case 137 -> 2;
                    case 138 -> 67;
                    case 139 -> 194;
                    case 140 -> 154;
                    case 141 -> 51;
                    case 142 -> 172;
                    case 143 -> 56;
                    case 144 -> 205;
                    case 145 -> 237;
                    case 146 -> 50;
                    case 147 -> 7;
                    case 148 -> 252;
                    case 149 -> 117;
                    case 150 -> 250;
                    case 151 -> 69;
                    case 152 -> 230;
                    case 153 -> 132;
                    case 154 -> 107;
                    case 155 -> 20;
                    case 156 -> 120;
                    case 157 -> 175;
                    case 158 -> 95;
                    case 159 -> 169;
                    case 160 -> 222;
                    case 161 -> 15;
                    case 162 -> 166;
                    case 163 -> 110;
                    case 164 -> 48;
                    case 165 -> 255;
                    case 166 -> 189;
                    case 167 -> 65;
                    case 168 -> 29;
                    case 169 -> 182;
                    case 170 -> 37;
                    case 171 -> 152;
                    case 172 -> 144;
                    case 173 -> 75;
                    case 174 -> 220;
                    case 175 -> 183;
                    case 176 -> 238;
                    case 177 -> 251;
                    case 178 -> 102;
                    case 179 -> 181;
                    case 180 -> 115;
                    case 181 -> 200;
                    case 182 -> 92;
                    case 183 -> 129;
                    case 184 -> 84;
                    case 185 -> 225;
                    case 186 -> 146;
                    case 187 -> 180;
                    case 188 -> 109;
                    case 189 -> 228;
                    case 190 -> 157;
                    case 191 -> 131;
                    case 192 -> 137;
                    case 193 -> 236;
                    case 194 -> 89;
                    case 195 -> 155;
                    case 196 -> 94;
                    case 197 -> 118;
                    case 198 -> 214;
                    case 199 -> 122;
                    case 200 -> 49;
                    case 201 -> 170;
                    case 202 -> 133;
                    case 203 -> 224;
                    case 204 -> 32;
                    case 205 -> 221;
                    case 206 -> 83;
                    case 207 -> 177;
                    case 208 -> 106;
                    case 209 -> 128;
                    case 210 -> 4;
                    case 211 -> 197;
                    case 212 -> 19;
                    case 213 -> 213;
                    case 214 -> 184;
                    case 215 -> 201;
                    case 216 -> 239;
                    case 217 -> 42;
                    case 218 -> 226;
                    case 219 -> 33;
                    case 220 -> 168;
                    case 221 -> 158;
                    case 222 -> 82;
                    case 223 -> 153;
                    case 224 -> 81;
                    case 225 -> 242;
                    case 226 -> 63;
                    case 227 -> 188;
                    case 228 -> 11;
                    case 229 -> 47;
                    case 230 -> 91;
                    case 231 -> 245;
                    case 232 -> 185;
                    case 233 -> 105;
                    case 234 -> 145;
                    case 235 -> 161;
                    case 236 -> 46;
                    case 237 -> 148;
                    case 238 -> 57;
                    case 239 -> 86;
                    case 240 -> 149;
                    case 241 -> 64;
                    case 242 -> 143;
                    case 243 -> 54;
                    case 244 -> 66;
                    case 245 -> 123;
                    case 246 -> 173;
                    case 247 -> 55;
                    case 248 -> 0;
                    case 249 -> 198;
                    case 250 -> 74;
                    case 251 -> 163;
                    case 252 -> 248;
                    case 253 -> 5;
                    case 254 -> 150;
                    default -> 124;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 127976669970038L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "WW?^\u007f\u0012'\u000e\tP],T2P:\u0012\u001b";
                    var5_4 = "WW?^\u007f\u0012'\u000e\tP],T2P:\u0012\u001b".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 84;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 104;
                                    break;
                                }
                                case 1: {
                                    v11 = 102;
                                    break;
                                }
                                case 2: {
                                    v11 = 25;
                                    break;
                                }
                                case 3: {
                                    v11 = 100;
                                    break;
                                }
                                case 4: {
                                    v11 = 78;
                                    break;
                                }
                                case 5: {
                                    v11 = 42;
                                    break;
                                }
                                default: {
                                    v11 = 64;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 52359777691404L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "}X\u000b\u0004,d\f\u0004{F\u0007\u001e\nwY\f\u001e f\u0014]X\u0005\twY\f\u001e f\u0014QR\rp_\u0011\u0013*k\u000eQU\u0016\u0019+b";
                    var5_4 = "}X\u000b\u0004,d\f\u0004{F\u0007\u001e\nwY\f\u001e f\u0014]X\u0005\twY\f\u001e f\u0014QR\rp_\u0011\u0013*k\u000eQU\u0016\u0019+b".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 41;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "Gj=3\u001c[7\u0006Gj=3\u0010Q";
                        var5_4 = "Gj=3\u001c[7\u0006Gj=3\u0010Q".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 25;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 29;
                                break;
                            }
                            case 1: {
                                v15 = 31;
                                break;
                            }
                            case 2: {
                                v15 = 75;
                                break;
                            }
                            case 3: {
                                v15 = 89;
                                break;
                            }
                            case 4: {
                                v15 = 108;
                                break;
                            }
                            case 5: {
                                v15 = 44;
                                break;
                            }
                            default: {
                                v15 = 73;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 15496202885051L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(39058860 + (char)-28238, 39058860 + (char)-3752, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 31795327503861L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u001bD\u007fO+\u00039\u0017\u008f\u0005\u00d2\u008f`\u00f2+\rj\u00f8AV\u00fa\u00f5B\u0018\u00a0\u009d\u0013\u00a0\u00da\u0010\u00fb\u000f\u00b4C{\u00c2Y\u00c3\nb\u00a5\u0012\u00ea\u00a0\u007fc\u0005\u00b4F\u00ac\u00cb\u00b23\u00c1r\u0013:Z\u00a9M\u00ba\u00f5\u00b0\u00d1a\u00a2\u009fZ\u009b)\u00ce\u0001\u00dd\u00e5\u00c8*\u00ae\u0085\u00fcm\u00e5\u001dd\u00fe\u00e29\u00a0j\u00b9U\u0080\u000f+\u00faZ\u00f4a\u00ef\u00b4\u00d4@\u00e4\u00b2\u008d";
                    var4_3 = "\u001bD\u007fO+\u00039\u0017\u008f\u0005\u00d2\u008f`\u00f2+\rj\u00f8AV\u00fa\u00f5B\u0018\u00a0\u009d\u0013\u00a0\u00da\u0010\u00fb\u000f\u00b4C{\u00c2Y\u00c3\nb\u00a5\u0012\u00ea\u00a0\u007fc\u0005\u00b4F\u00ac\u00cb\u00b23\u00c1r\u0013:Z\u00a9M\u00ba\u00f5\u00b0\u00d1a\u00a2\u009fZ\u009b)\u00ce\u0001\u00dd\u00e5\u00c8*\u00ae\u0085\u00fcm\u00e5\u001dd\u00fe\u00e29\u00a0j\u00b9U\u0080\u000f+\u00faZ\u00f4a\u00ef\u00b4\u00d4@\u00e4\u00b2\u008d".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 45;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "_\u0092a\u00b1\u0080\u00ddga\u008cw4\u00f1\u0099\u009dP\u0085L\u0001,]\u00ac-\u00b6\u00bcb~\u0084\u00c66\u00c9\u00eb\u00c92\u001fky\u00de\u00c3\u008d\u0085\u00e5\u0012?\u00fb\u001at\u0093}2\u0018\u0015~R\u00a4bJP%\u0089\u0081'\u0015\u00e3\u0001\u00d3\u00ed\u00b5\u0005\\\u0086\u0015j\u00a05\u00acL\u00b3\u000b\u00de\u00ae\u00e2|\u008d\u008fi\u008a\u00fb\u00f7\u00e07\u000eq\u00e5";
                        var4_3 = "_\u0092a\u00b1\u0080\u00ddga\u008cw4\u00f1\u0099\u009dP\u0085L\u0001,]\u00ac-\u00b6\u00bcb~\u0084\u00c66\u00c9\u00eb\u00c92\u001fky\u00de\u00c3\u008d\u0085\u00e5\u0012?\u00fb\u001at\u0093}2\u0018\u0015~R\u00a4bJP%\u0089\u0081'\u0015\u00e3\u0001\u00d3\u00ed\u00b5\u0005\\\u0086\u0015j\u00a05\u00acL\u00b3\u000b\u00de\u00ae\u00e2|\u008d\u008fi\u008a\u00fb\u00f7\u00e07\u000eq\u00e5".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 101;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 77;
                                break;
                            }
                            case 1: {
                                v15 = 93;
                                break;
                            }
                            case 2: {
                                v15 = 21;
                                break;
                            }
                            case 3: {
                                v15 = 1;
                                break;
                            }
                            case 4: {
                                v15 = 83;
                                break;
                            }
                            case 5: {
                                v15 = 17;
                                break;
                            }
                            default: {
                                v15 = 3;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF98E5) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 118;
                    case 1 -> 108;
                    case 2 -> 249;
                    case 3 -> 83;
                    case 4 -> 103;
                    case 5 -> 140;
                    case 6 -> 129;
                    case 7 -> 33;
                    case 8 -> 87;
                    case 9 -> 188;
                    case 10 -> 25;
                    case 11 -> 58;
                    case 12 -> 23;
                    case 13 -> 215;
                    case 14 -> 142;
                    case 15 -> 110;
                    case 16 -> 174;
                    case 17 -> 185;
                    case 18 -> 122;
                    case 19 -> 200;
                    case 20 -> 243;
                    case 21 -> 132;
                    case 22 -> 245;
                    case 23 -> 34;
                    case 24 -> 69;
                    case 25 -> 15;
                    case 26 -> 76;
                    case 27 -> 213;
                    case 28 -> 186;
                    case 29 -> 105;
                    case 30 -> 60;
                    case 31 -> 201;
                    case 32 -> 113;
                    case 33 -> 190;
                    case 34 -> 40;
                    case 35 -> 153;
                    case 36 -> 235;
                    case 37 -> 99;
                    case 38 -> 232;
                    case 39 -> 46;
                    case 40 -> 135;
                    case 41 -> 242;
                    case 42 -> 255;
                    case 43 -> 168;
                    case 44 -> 175;
                    case 45 -> 104;
                    case 46 -> 73;
                    case 47 -> 150;
                    case 48 -> 17;
                    case 49 -> 187;
                    case 50 -> 183;
                    case 51 -> 194;
                    case 52 -> 53;
                    case 53 -> 239;
                    case 54 -> 236;
                    case 55 -> 225;
                    case 56 -> 179;
                    case 57 -> 181;
                    case 58 -> 47;
                    case 59 -> 211;
                    case 60 -> 98;
                    case 61 -> 0;
                    case 62 -> 8;
                    case 63 -> 141;
                    case 64 -> 166;
                    case 65 -> 206;
                    case 66 -> 251;
                    case 67 -> 184;
                    case 68 -> 27;
                    case 69 -> 66;
                    case 70 -> 128;
                    case 71 -> 88;
                    case 72 -> 90;
                    case 73 -> 9;
                    case 74 -> 202;
                    case 75 -> 196;
                    case 76 -> 133;
                    case 77 -> 59;
                    case 78 -> 55;
                    case 79 -> 253;
                    case 80 -> 227;
                    case 81 -> 220;
                    case 82 -> 240;
                    case 83 -> 114;
                    case 84 -> 244;
                    case 85 -> 44;
                    case 86 -> 123;
                    case 87 -> 209;
                    case 88 -> 18;
                    case 89 -> 203;
                    case 90 -> 107;
                    case 91 -> 214;
                    case 92 -> 71;
                    case 93 -> 216;
                    case 94 -> 37;
                    case 95 -> 155;
                    case 96 -> 137;
                    case 97 -> 198;
                    case 98 -> 127;
                    case 99 -> 95;
                    case 100 -> 36;
                    case 101 -> 145;
                    case 102 -> 234;
                    case 103 -> 1;
                    case 104 -> 30;
                    case 105 -> 207;
                    case 106 -> 230;
                    case 107 -> 28;
                    case 108 -> 248;
                    case 109 -> 102;
                    case 110 -> 124;
                    case 111 -> 21;
                    case 112 -> 171;
                    case 113 -> 169;
                    case 114 -> 81;
                    case 115 -> 146;
                    case 116 -> 119;
                    case 117 -> 42;
                    case 118 -> 161;
                    case 119 -> 210;
                    case 120 -> 247;
                    case 121 -> 237;
                    case 122 -> 57;
                    case 123 -> 165;
                    case 124 -> 112;
                    case 125 -> 162;
                    case 126 -> 131;
                    case 127 -> 5;
                    case 128 -> 224;
                    case 129 -> 31;
                    case 130 -> 228;
                    case 131 -> 50;
                    case 132 -> 7;
                    case 133 -> 35;
                    case 134 -> 158;
                    case 135 -> 241;
                    case 136 -> 116;
                    case 137 -> 79;
                    case 138 -> 24;
                    case 139 -> 134;
                    case 140 -> 12;
                    case 141 -> 121;
                    case 142 -> 10;
                    case 143 -> 96;
                    case 144 -> 144;
                    case 145 -> 252;
                    case 146 -> 77;
                    case 147 -> 11;
                    case 148 -> 2;
                    case 149 -> 86;
                    case 150 -> 64;
                    case 151 -> 170;
                    case 152 -> 143;
                    case 153 -> 254;
                    case 154 -> 109;
                    case 155 -> 167;
                    case 156 -> 138;
                    case 157 -> 193;
                    case 158 -> 80;
                    case 159 -> 160;
                    case 160 -> 125;
                    case 161 -> 159;
                    case 162 -> 75;
                    case 163 -> 26;
                    case 164 -> 197;
                    case 165 -> 199;
                    case 166 -> 41;
                    case 167 -> 82;
                    case 168 -> 91;
                    case 169 -> 92;
                    case 170 -> 120;
                    case 171 -> 180;
                    case 172 -> 22;
                    case 173 -> 176;
                    case 174 -> 126;
                    case 175 -> 101;
                    case 176 -> 219;
                    case 177 -> 32;
                    case 178 -> 250;
                    case 179 -> 152;
                    case 180 -> 68;
                    case 181 -> 89;
                    case 182 -> 208;
                    case 183 -> 63;
                    case 184 -> 85;
                    case 185 -> 189;
                    case 186 -> 222;
                    case 187 -> 74;
                    case 188 -> 51;
                    case 189 -> 173;
                    case 190 -> 164;
                    case 191 -> 115;
                    case 192 -> 62;
                    case 193 -> 39;
                    case 194 -> 182;
                    case 195 -> 191;
                    case 196 -> 205;
                    case 197 -> 94;
                    case 198 -> 163;
                    case 199 -> 238;
                    case 200 -> 52;
                    case 201 -> 156;
                    case 202 -> 204;
                    case 203 -> 14;
                    case 204 -> 43;
                    case 205 -> 45;
                    case 206 -> 136;
                    case 207 -> 111;
                    case 208 -> 217;
                    case 209 -> 93;
                    case 210 -> 78;
                    case 211 -> 147;
                    case 212 -> 212;
                    case 213 -> 65;
                    case 214 -> 172;
                    case 215 -> 151;
                    case 216 -> 19;
                    case 217 -> 29;
                    case 218 -> 61;
                    case 219 -> 221;
                    case 220 -> 13;
                    case 221 -> 48;
                    case 222 -> 178;
                    case 223 -> 4;
                    case 224 -> 149;
                    case 225 -> 84;
                    case 226 -> 49;
                    case 227 -> 246;
                    case 228 -> 38;
                    case 229 -> 20;
                    case 230 -> 139;
                    case 231 -> 195;
                    case 232 -> 6;
                    case 233 -> 231;
                    case 234 -> 229;
                    case 235 -> 223;
                    case 236 -> 54;
                    case 237 -> 192;
                    case 238 -> 67;
                    case 239 -> 106;
                    case 240 -> 16;
                    case 241 -> 130;
                    case 242 -> 117;
                    case 243 -> 218;
                    case 244 -> 72;
                    case 245 -> 97;
                    case 246 -> 148;
                    case 247 -> 154;
                    case 248 -> 177;
                    case 249 -> 233;
                    case 250 -> 56;
                    case 251 -> 100;
                    case 252 -> 157;
                    case 253 -> 70;
                    case 254 -> 226;
                    default -> 3;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 12661898164738L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(334621710 - 29586, 334621710 - (char)-23481, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 19503448884456L;
                    boolean bl = SshAgentIpcService.n();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(2359260 + (char)-14661, -2359260 + -((char)-2494), (int)l2));
                    boolean bl2 = bl;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (!bl2) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 59959403372219L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u0087au\tL\u0003\u00aa\u000e\u0086";
                var4_3 = "\u0087au\tL\u0003\u00aa\u000e\u0086".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 101;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 1;
                                break;
                            }
                            case 1: {
                                v11 = 89;
                                break;
                            }
                            case 2: {
                                v11 = 68;
                                break;
                            }
                            case 3: {
                                v11 = 34;
                                break;
                            }
                            case 4: {
                                v11 = 30;
                                break;
                            }
                            case 5: {
                                v11 = 111;
                                break;
                            }
                            default: {
                                v11 = 117;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x427E) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 95;
                    case 1 -> 6;
                    case 2 -> 76;
                    case 3 -> 49;
                    case 4 -> 105;
                    case 5 -> 101;
                    case 6 -> 138;
                    case 7 -> 246;
                    case 8 -> 164;
                    case 9 -> 81;
                    case 10 -> 194;
                    case 11 -> 224;
                    case 12 -> 205;
                    case 13 -> 98;
                    case 14 -> 36;
                    case 15 -> 79;
                    case 16 -> 90;
                    case 17 -> 85;
                    case 18 -> 27;
                    case 19 -> 58;
                    case 20 -> 28;
                    case 21 -> 197;
                    case 22 -> 34;
                    case 23 -> 43;
                    case 24 -> 187;
                    case 25 -> 86;
                    case 26 -> 1;
                    case 27 -> 3;
                    case 28 -> 127;
                    case 29 -> 171;
                    case 30 -> 80;
                    case 31 -> 132;
                    case 32 -> 50;
                    case 33 -> 201;
                    case 34 -> 42;
                    case 35 -> 116;
                    case 36 -> 129;
                    case 37 -> 23;
                    case 38 -> 10;
                    case 39 -> 93;
                    case 40 -> 78;
                    case 41 -> 149;
                    case 42 -> 104;
                    case 43 -> 239;
                    case 44 -> 19;
                    case 45 -> 109;
                    case 46 -> 22;
                    case 47 -> 4;
                    case 48 -> 137;
                    case 49 -> 234;
                    case 50 -> 219;
                    case 51 -> 238;
                    case 52 -> 107;
                    case 53 -> 166;
                    case 54 -> 161;
                    case 55 -> 121;
                    case 56 -> 91;
                    case 57 -> 200;
                    case 58 -> 177;
                    case 59 -> 133;
                    case 60 -> 157;
                    case 61 -> 173;
                    case 62 -> 241;
                    case 63 -> 182;
                    case 64 -> 35;
                    case 65 -> 2;
                    case 66 -> 83;
                    case 67 -> 140;
                    case 68 -> 222;
                    case 69 -> 64;
                    case 70 -> 94;
                    case 71 -> 41;
                    case 72 -> 122;
                    case 73 -> 242;
                    case 74 -> 240;
                    case 75 -> 47;
                    case 76 -> 181;
                    case 77 -> 146;
                    case 78 -> 112;
                    case 79 -> 113;
                    case 80 -> 148;
                    case 81 -> 203;
                    case 82 -> 131;
                    case 83 -> 62;
                    case 84 -> 251;
                    case 85 -> 69;
                    case 86 -> 183;
                    case 87 -> 213;
                    case 88 -> 68;
                    case 89 -> 152;
                    case 90 -> 97;
                    case 91 -> 160;
                    case 92 -> 249;
                    case 93 -> 7;
                    case 94 -> 141;
                    case 95 -> 192;
                    case 96 -> 226;
                    case 97 -> 170;
                    case 98 -> 151;
                    case 99 -> 123;
                    case 100 -> 168;
                    case 101 -> 215;
                    case 102 -> 145;
                    case 103 -> 59;
                    case 104 -> 88;
                    case 105 -> 111;
                    case 106 -> 25;
                    case 107 -> 99;
                    case 108 -> 214;
                    case 109 -> 56;
                    case 110 -> 188;
                    case 111 -> 244;
                    case 112 -> 120;
                    case 113 -> 229;
                    case 114 -> 115;
                    case 115 -> 144;
                    case 116 -> 33;
                    case 117 -> 233;
                    case 118 -> 255;
                    case 119 -> 29;
                    case 120 -> 103;
                    case 121 -> 176;
                    case 122 -> 74;
                    case 123 -> 51;
                    case 124 -> 14;
                    case 125 -> 48;
                    case 126 -> 45;
                    case 127 -> 167;
                    case 128 -> 193;
                    case 129 -> 163;
                    case 130 -> 53;
                    case 131 -> 207;
                    case 132 -> 220;
                    case 133 -> 179;
                    case 134 -> 180;
                    case 135 -> 230;
                    case 136 -> 117;
                    case 137 -> 189;
                    case 138 -> 119;
                    case 139 -> 21;
                    case 140 -> 172;
                    case 141 -> 208;
                    case 142 -> 236;
                    case 143 -> 218;
                    case 144 -> 87;
                    case 145 -> 184;
                    case 146 -> 52;
                    case 147 -> 223;
                    case 148 -> 231;
                    case 149 -> 211;
                    case 150 -> 0;
                    case 151 -> 125;
                    case 152 -> 196;
                    case 153 -> 75;
                    case 154 -> 156;
                    case 155 -> 46;
                    case 156 -> 18;
                    case 157 -> 61;
                    case 158 -> 232;
                    case 159 -> 158;
                    case 160 -> 165;
                    case 161 -> 225;
                    case 162 -> 38;
                    case 163 -> 245;
                    case 164 -> 17;
                    case 165 -> 16;
                    case 166 -> 135;
                    case 167 -> 150;
                    case 168 -> 185;
                    case 169 -> 206;
                    case 170 -> 169;
                    case 171 -> 39;
                    case 172 -> 186;
                    case 173 -> 30;
                    case 174 -> 63;
                    case 175 -> 24;
                    case 176 -> 31;
                    case 177 -> 190;
                    case 178 -> 204;
                    case 179 -> 212;
                    case 180 -> 37;
                    case 181 -> 174;
                    case 182 -> 191;
                    case 183 -> 147;
                    case 184 -> 142;
                    case 185 -> 66;
                    case 186 -> 11;
                    case 187 -> 202;
                    case 188 -> 162;
                    case 189 -> 130;
                    case 190 -> 250;
                    case 191 -> 124;
                    case 192 -> 118;
                    case 193 -> 82;
                    case 194 -> 70;
                    case 195 -> 15;
                    case 196 -> 217;
                    case 197 -> 40;
                    case 198 -> 54;
                    case 199 -> 198;
                    case 200 -> 100;
                    case 201 -> 26;
                    case 202 -> 175;
                    case 203 -> 143;
                    case 204 -> 126;
                    case 205 -> 9;
                    case 206 -> 77;
                    case 207 -> 254;
                    case 208 -> 237;
                    case 209 -> 199;
                    case 210 -> 227;
                    case 211 -> 235;
                    case 212 -> 102;
                    case 213 -> 228;
                    case 214 -> 44;
                    case 215 -> 248;
                    case 216 -> 20;
                    case 217 -> 13;
                    case 218 -> 139;
                    case 219 -> 216;
                    case 220 -> 73;
                    case 221 -> 221;
                    case 222 -> 65;
                    case 223 -> 136;
                    case 224 -> 210;
                    case 225 -> 243;
                    case 226 -> 89;
                    case 227 -> 67;
                    case 228 -> 55;
                    case 229 -> 253;
                    case 230 -> 32;
                    case 231 -> 247;
                    case 232 -> 84;
                    case 233 -> 154;
                    case 234 -> 195;
                    case 235 -> 128;
                    case 236 -> 108;
                    case 237 -> 114;
                    case 238 -> 134;
                    case 239 -> 178;
                    case 240 -> 8;
                    case 241 -> 71;
                    case 242 -> 72;
                    case 243 -> 110;
                    case 244 -> 57;
                    case 245 -> 252;
                    case 246 -> 96;
                    case 247 -> 159;
                    case 248 -> 106;
                    case 249 -> 155;
                    case 250 -> 153;
                    case 251 -> 60;
                    case 252 -> 92;
                    case 253 -> 5;
                    case 254 -> 12;
                    default -> 209;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

