/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StubTreeUtil {
    @Nullable
    public static StubElement<?> getNextSibling(StubElement<?> stub) {
        return StubTreeUtil.getNextSibling(stub, null);
    }

    @Nullable
    public static StubElement<?> getNextSibling(StubElement<?> stub, @Nullable TokenSet filter) {
        ListIterator<StubElement<?>> iterator2 = StubTreeUtil.getIteratorBeforeElement(stub);
        iterator2.next();
        while (iterator2.hasNext()) {
            StubElement<?> next = iterator2.next();
            if (!StubTreeUtil.isAcceptable(filter, next)) continue;
            return next;
        }
        return null;
    }

    @NotNull
    private static ListIterator<StubElement<?>> getIteratorBeforeElement(@NotNull StubElement<?> stub) {
        StubElement parentStub;
        List children;
        if (stub == null) {
            StubTreeUtil.$$$reportNull$$$0(0);
        }
        if (StubTreeUtil.areTooManyChildren(children = (parentStub = stub.getParentStub()).getChildrenStubs())) {
            int indexOfStub = Collections.binarySearch(children, stub, Comparator.comparing(stubElement -> ((StubBase)stubElement).getStubId()));
            assert (indexOfStub >= 0) : "Can't find stub in it's parent children";
            ListIterator<StubElement<?>> listIterator = children.listIterator(indexOfStub);
            if (listIterator == null) {
                StubTreeUtil.$$$reportNull$$$0(1);
            }
            return listIterator;
        }
        ListIterator<StubElement<?>> listIterator = children.listIterator();
        while (listIterator.hasNext()) {
            StubElement next = (StubElement)listIterator.next();
            if (next != stub) continue;
            listIterator.previous();
            ListIterator<StubElement<?>> listIterator2 = listIterator;
            if (listIterator2 == null) {
                StubTreeUtil.$$$reportNull$$$0(2);
            }
            return listIterator2;
        }
        throw new AssertionError((Object)"Can't find stub in it's parent children");
    }

    private static boolean areTooManyChildren(List<StubElement<?>> children) {
        return children.size() > 10;
    }

    private static boolean isAcceptable(@Nullable TokenSet filter, @NotNull StubElement<?> child) {
        if (child == null) {
            StubTreeUtil.$$$reportNull$$$0(3);
        }
        return filter == null || filter.contains(child.getElementType());
    }

    @Nullable
    public static StubElement<?> getPrevSibling(StubElement<?> stub) {
        ListIterator<StubElement<?>> iterator2 = StubTreeUtil.getIteratorBeforeElement(stub);
        return iterator2.hasPrevious() ? iterator2.previous() : null;
    }

    @Nullable
    public static StubElement<?> findChildStubByType(@NotNull StubElement<?> parent, @NotNull TokenSet types, boolean isDirectOnly) {
        if (parent == null) {
            StubTreeUtil.$$$reportNull$$$0(4);
        }
        if (types == null) {
            StubTreeUtil.$$$reportNull$$$0(5);
        }
        if (isDirectOnly) {
            return StubTreeUtil.findDirectChild(parent, child -> types.contains(child.getElementType()));
        }
        return (StubElement)ContainerUtil.find((Iterable)parent.getChildrenStubs(), child -> types.contains(child.getElementType()));
    }

    @Nullable
    public static StubElement<?> findDirectChild(@NotNull StubElement<?> stub, @NotNull Predicate<StubElement<?>> filter) {
        if (stub == null) {
            StubTreeUtil.$$$reportNull$$$0(6);
        }
        if (filter == null) {
            StubTreeUtil.$$$reportNull$$$0(7);
        }
        for (StubElement child : stub.getChildrenStubs()) {
            ObjectStubBase objectStubBase;
            if (!(child instanceof ObjectStubBase) || (objectStubBase = (ObjectStubBase)child).isDangling() || !filter.test(child)) continue;
            return child;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/StubTreeUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/StubTreeUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIteratorBeforeElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIteratorBeforeElement";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findChildStubByType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findDirectChild";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

