/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.ui.unified;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.ui.RemoteSdkEditorContainer;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.ui.unified.SshCredentialsEditorEx;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.GridBag;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SshExtendedCredentialsForm {
    private final JPanel myMainPanel;
    private final JBCheckBox myVisibilityCheckBox;
    private final SshCredentialsEditorEx credentialsForm;
    private final SshUiData myItem;

    public SshExtendedCredentialsForm(@NotNull SshUiData item, boolean showOnlyAppLevel, @Nullable Runnable updateTree, final @NotNull Disposable parent) {
        if (item == null) {
            SshExtendedCredentialsForm.n(0);
        }
        if (parent == null) {
            SshExtendedCredentialsForm.n(1);
        }
        GridBag gridBag = new GridBag().setDefaultWeightX(1, 1.0).setDefaultAnchor(10).setDefaultFill(2).setDefaultInsets(0, 4, 10, 0, 10);
        this.myMainPanel = new JPanel(new GridBagLayout());
        this.myVisibilityCheckBox = new JBCheckBox(SshBundle.message("ssh.credentials.form.visible.only.for.this.project", new Object[0]));
        this.myMainPanel.add((Component)this.myVisibilityCheckBox, gridBag.nextLine().next());
        this.myMainPanel.add(Box.createHorizontalGlue(), gridBag.next().weightx(1.0).fillCell().coverLine());
        this.credentialsForm = new SshCredentialsEditorEx(parent);
        Disposer.register((Disposable)parent, (Disposable)this.credentialsForm);
        if (updateTree != null) {
            this.credentialsForm.addListenerForNameDefiningFields(updateTree);
        }
        this.myMainPanel.add((Component)this.credentialsForm.getComponent(), gridBag.nextLine().next().coverLine(2));
        this.myMainPanel.add(Box.createVerticalGlue(), gridBag.nextLine().next().weighty(1.0).fillCell().coverLine());
        this.myItem = item;
        this.credentialsForm.setContainer(new RemoteSdkEditorContainer(){

            public void updateSize() {
            }

            @NotNull
            public Disposable getDisposable() {
                Disposable disposable = parent;
                if (disposable == null) {
                    1.n(0);
                }
                return disposable;
            }

            private static /* synthetic */ void n(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ssh/ui/unified/SshExtendedCredentialsForm$1", "getDisposable"));
            }
        });
        if (showOnlyAppLevel) {
            this.myVisibilityCheckBox.setVisible(false);
        }
    }

    @NotNull
    public JComponent getPanel() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            SshExtendedCredentialsForm.n(2);
        }
        return jPanel;
    }

    public void reset() {
        this.myVisibilityCheckBox.setSelected(this.myItem.getConfig().isProjectLevel());
        this.credentialsForm.resetEditorFrom(this.myItem);
    }

    public void apply() {
        this.applyTo(this.myItem);
    }

    void applyTo(@NotNull SshUiData item) {
        if (item == null) {
            SshExtendedCredentialsForm.n(3);
        }
        item.getConfig().setProjectLevel(this.myVisibilityCheckBox.isSelected());
        this.credentialsForm.applyEditorTo(item);
        if (item.getAuthType() == AuthType.PASSWORD && !item.isStorePassword() && StringUtil.isEmpty((String)item.getPassword())) {
            item.setPassword(null);
        } else if (item.getAuthType() == AuthType.KEY_PAIR && !item.isStorePassphrase() && StringUtil.isEmpty((String)item.getPassphrase())) {
            item.setPassphrase(null);
        }
    }

    public boolean isModified() {
        if (this.myItem.getConfig().isProjectLevel() != this.myVisibilityCheckBox.isSelected()) {
            return true;
        }
        return this.credentialsForm.isModified(this.myItem);
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.credentialsForm.getPreferredFocusedComponent();
        if (jComponent == null) {
            SshExtendedCredentialsForm.n(4);
        }
        return jComponent;
    }

    private static /* synthetic */ void n(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/ui/unified/SshExtendedCredentialsForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/ui/unified/SshExtendedCredentialsForm";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }
}

