/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.rsync;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ssh.RSyncUtil;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.rsync.RsyncService;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RsyncStatusService
implements Disposable {
    private static final Logger LOG = Logger.getInstance(RsyncStatusService.class);
    private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    private final EventDispatcher<Listener> myDispatcher = EventDispatcher.create(Listener.class);
    private volatile Status myRsyncStatus = Status.UNKNOWN;

    @NotNull
    public static RsyncStatusService getInstance() {
        RsyncStatusService rsyncStatusService = (RsyncStatusService)ApplicationManager.getApplication().getService(RsyncStatusService.class);
        if (rsyncStatusService == null) {
            RsyncStatusService.n(0);
        }
        return rsyncStatusService;
    }

    public Status getCachedRsyncStatus() {
        this.W();
        return this.myRsyncStatus;
    }

    private void W() {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> this.checkIfRSyncCommandExists(), this.myRsyncStatus == Status.UNKNOWN ? 0 : 2000);
    }

    public boolean checkIfRSyncCommandExists() {
        this.myAlarm.cancelAllRequests();
        boolean bl = RsyncStatusService.n();
        this.myRsyncStatus = bl ? Status.INSTALLED_AND_CONFIGURED : Status.NOT_INSTALLED_OR_CONFIGURED;
        ((Listener)this.myDispatcher.getMulticaster()).statusChanged();
        return bl;
    }

    private static boolean n() {
        return RsyncStatusService.validateRsyncCommand() == null;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    public static String validateRsyncCommand(@NlsSafe String rsync, @NlsSafe String rsyncOptions, @NlsSafe String shell, boolean validateSsh) {
        String string;
        String string2 = RsyncStatusService.n(rsync, StringUtil.split((String)rsyncOptions, (String)","), "--version", "Rsync");
        if (string2 != null) {
            return string2;
        }
        if (validateSsh && (string = RsyncStatusService.n(shell, Collections.emptyList(), "-V", "SSH")) != null) {
            return string;
        }
        return null;
    }

    @Nullable
    @Nls
    private static String n(String string, List<String> list, String string2, String string3) {
        if (StringUtil.isEmptyOrSpaces((String)string)) {
            return SshBundle.message("path.validation.rsync.command.is.not.provided", string3);
        }
        File file = new File(string);
        if (!file.exists() && (file = PathEnvironmentVariableUtil.findExecutableInPathOnAnyOS((String)string)) == null) {
            LOG.debug(string + " not found in Path");
            return SshBundle.message("path.validation.rsync.not.found.in.path", string, string3);
        }
        PtyCommandLine ptyCommandLine = new PtyCommandLine(new GeneralCommandLine(new String[]{file.getAbsolutePath()}));
        ptyCommandLine.withConsoleMode(false);
        ArrayList<String> arrayList = new ArrayList<String>(list);
        arrayList.add(string2);
        ptyCommandLine.addParameters(arrayList);
        try {
            RSyncUtil.updateCommandLineIfWSL(ptyCommandLine, file);
            String string4 = ApplicationManager.getApplication().isDispatchThread() ? (String)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ScriptRunnerUtil.getProcessOutput((GeneralCommandLine)ptyCommandLine), SshBundle.message("progress.title.version", string3), true, null) : ScriptRunnerUtil.getProcessOutput((GeneralCommandLine)ptyCommandLine);
            if (string4 == null) {
                return SshBundle.message("path.validation.failed.to.execute.rsync.command.0", string, string3);
            }
            String string5 = string4.split("\n")[0];
            if (string5.matches(".*command not found.*")) {
                LOG.info("Tool not found for " + String.valueOf(file));
                return SshBundle.message("path.validation.rsync.command.0.was.not.found", string, string3);
            }
            if (string5.matches(".*unknown option.*")) {
                LOG.info("Incorrect options for " + String.valueOf(file));
                return SshBundle.message("options.validation.rsync.command.0.are.not.correct", list);
            }
            LOG.info("Tool version: " + string5);
        }
        catch (ExecutionException executionException) {
            LOG.error("Error during execution of command " + string, (Throwable)executionException);
            return SshBundle.message("path.validation.failed.to.execute.rsync.command.0", string, string3);
        }
        return null;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    public static String validateRsyncCommand() {
        return RsyncStatusService.validateRsyncCommand(false);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    public static String validateRsyncCommand(boolean validateSSh) {
        return RsyncStatusService.validateRsyncCommand(RsyncService.getInstance().getRsyncPath(), RsyncService.getInstance().getOptions(), RsyncService.getInstance().getShellPath(), validateSSh);
    }

    public void addListener(@NotNull Listener listener, @NotNull Disposable disposable) {
        if (listener == null) {
            RsyncStatusService.n(1);
        }
        if (disposable == null) {
            RsyncStatusService.n(2);
        }
        this.myDispatcher.addListener((EventListener)listener, disposable);
    }

    public void dispose() {
    }

    private static /* synthetic */ void n(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/rsync/RsyncStatusService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/rsync/RsyncStatusService";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    public static interface Listener
    extends EventListener {
        public void statusChanged();
    }

    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status INSTALLED_AND_CONFIGURED = new Status();
        public static final /* enum */ Status NOT_INSTALLED_OR_CONFIGURED = new Status();
        public static final /* enum */ Status UNKNOWN = new Status();
        private static final /* synthetic */ Status[] $VALUES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String name) {
            return Enum.valueOf(Status.class, name);
        }

        private static /* synthetic */ Status[] n() {
            return new Status[]{INSTALLED_AND_CONFIGURED, NOT_INSTALLED_OR_CONFIGURED, UNKNOWN};
        }

        static {
            $VALUES = Status.n();
        }
    }
}

