/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.types.DasType;
import com.intellij.database.util.DasUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.completion.SqlCompletionUtil;
import com.intellij.sql.completion.providers.SqlBinaryExpressionCompletionProvider;
import com.intellij.sql.completion.providers.SqlColumnListCompletionProvider;
import com.intellij.sql.completion.providers.SqlExperimentalNameCompletionProvider;
import com.intellij.sql.completion.providers.SqlJoinSmartCompletionProvider;
import com.intellij.sql.completion.providers.SqlParameterNamesCompletionProvider;
import com.intellij.sql.completion.providers.SqlReferenceExpressionCompletionProvider;
import com.intellij.sql.completion.providers.SqlValuesCompletionProvider;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlIdentifierKeywordTokenType;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlPrefixedElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlCompletionContributor
extends CompletionContributor
implements DumbAware {
    private static final Collection<CompletionProvider<CompletionParameters>> BASIC_PROVIDERS = Arrays.asList(new CompletionProvider[]{new SqlColumnListCompletionProvider(), new SqlValuesCompletionProvider(), new SqlParameterNamesCompletionProvider(), new SqlBinaryExpressionCompletionProvider(), new SqlExperimentalNameCompletionProvider(), new SqlReferenceExpressionCompletionProvider()});
    private static final Collection<CompletionProvider<CompletionParameters>> SMART_PROVIDERS = Collections.singletonList(new SqlJoinSmartCompletionProvider());

    public SqlCompletionContributor() {
        for (CompletionProvider<CompletionParameters> provider : BASIC_PROVIDERS) {
            this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inFile((ElementPattern)StandardPatterns.instanceOf(SqlFile.class)), provider);
        }
        for (CompletionProvider<CompletionParameters> provider : SMART_PROVIDERS) {
            this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().inFile((ElementPattern)StandardPatterns.instanceOf(SqlFile.class)), provider);
        }
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        String prevElementText;
        if (context == null) {
            SqlCompletionContributor.$$$reportNull$$$0(0);
        }
        if (context.getCompletionType() == CompletionType.SMART) {
            return;
        }
        PsiFile file = context.getFile();
        if (!(file instanceof SqlFile)) {
            return;
        }
        int offset = context.getStartOffset();
        PsiElement element = file.findElementAt(offset);
        SqlLanguageDialectEx language = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        NamingService service = NamingServices.getNamingService((Dbms)SqlImplUtil.getDbms((PsiElement)file));
        PsiElement prevElement = offset > 0 ? file.findElementAt(offset - 1) : null;
        IElementType prevLeafType = prevElement instanceof LeafPsiElement ? ((LeafPsiElement)prevElement).getElementType() : null;
        PsiElement psiElement = prevElement = prevElement instanceof PsiWhiteSpace || prevLeafType == SqlTokens.SQL_IDENT || prevLeafType instanceof SqlIdentifierKeywordTokenType ? PsiTreeUtil.prevLeaf((PsiElement)prevElement) : prevElement;
        if (prevLeafType == SqlTokens.SQL_UNCLOSED_TOKEN || prevElement != null && (prevElementText = prevElement.getText()) != null && prevElementText.length() == 1 && service.getOpeningQuotes().contains(prevElementText)) {
            char currentQuote = prevElement == null ? service.getOpeningQuote() : prevElement.getText().charAt(0);
            char closingQuote = ((Character)ObjectUtils.notNull((Object)service.closingQuoteFor(currentQuote), (Object)Character.valueOf(currentQuote))).charValue();
            context.setDummyIdentifier(String.valueOf(closingQuote));
        } else if (element != null) {
            ASTNode node = element.getNode();
            IElementType type = node != null ? node.getElementType() : null;
            boolean doNotPatch = type instanceof SqlKeywordTokenType && ((SqlFile)file).getSqlLanguage().isReservedKeyword(type);
            doNotPatch = doNotPatch || (element.getTextRange().getStartOffset() != offset || element.getParent() instanceof SqlIdentifier) && type != SqlTokens.SQL_IDENT_DELIMITED && file.findReferenceAt(offset) != null;
            SqlPrefixedElement prefixed = (SqlPrefixedElement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlPrefixedElement.class, (boolean)false);
            if (doNotPatch || prefixed != null && prefixed.getNamePrefix() != null) {
                context.setDummyIdentifier("");
            }
            SqlCompletionContributor.tuneReplacementOffset(context, element);
        }
    }

    private static void tuneReplacementOffset(@NotNull CompletionInitializationContext context, @NotNull PsiElement element) {
        if (context == null) {
            SqlCompletionContributor.$$$reportNull$$$0(1);
        }
        if (element == null) {
            SqlCompletionContributor.$$$reportNull$$$0(2);
        }
        ASTNode node = element.getNode();
        int offset = context.getStartOffset();
        IElementType type = node != null ? node.getElementType() : null;
        TextRange elementRange = element.getTextRange();
        if (type == SqlTokens.SQL_IDENT_DELIMITED && offset == elementRange.getStartOffset()) {
            context.setReplacementOffset(elementRange.getEndOffset());
        }
        if (type == SqlTokens.SQL_IDENT_DELIMITED && offset != elementRange.getStartOffset()) {
            context.getOffsetMap().addOffset(CompletionInitializationContext.SELECTION_END_OFFSET, elementRange.getEndOffset() - 1);
            context.getOffsetMap().addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, elementRange.getEndOffset() - 1);
        }
    }

    public static SqlTableType retrieveTableTypeForVariable(@Nullable PsiElement e) {
        if (!(e instanceof SqlReferenceExpression)) {
            return null;
        }
        ObjectKind kind = ((SqlReferenceExpression)e).getReferenceElementType().getTargetKind();
        if (kind == ObjectKind.VARIABLE) {
            for (ResolveResult result : ((SqlReferenceExpression)e).multiResolve(true)) {
                DasType type;
                if (!result.isValidResult() || !(result.getElement() instanceof SqlVariableDefinition) || !((type = ((SqlVariableDefinition)result.getElement()).getDasType()) instanceof SqlTableType)) continue;
                SqlTableType tableType2 = (SqlTableType)type;
                return tableType2;
            }
        }
        return null;
    }

    @Nullable
    public static DasTable retrieveTable(@Nullable PsiElement e) {
        if (!(e instanceof SqlReferenceExpression)) {
            return null;
        }
        ObjectKind kind = ((SqlReferenceExpression)e).getReferenceElementType().getTargetKind();
        if (kind != ObjectKind.TABLE) {
            return null;
        }
        for (ResolveResult result : ((SqlReferenceExpression)e).multiResolve(true)) {
            if (!result.isValidResult()) continue;
            PsiElement target = result.getElement();
            if (target instanceof DasSynonym) {
                target = DasUtil.resolveFinalTarget((DasSynonym)((DasSynonym)target));
            }
            if (!(target instanceof DasTable)) continue;
            return (DasTable)target;
        }
        return null;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            SqlCompletionContributor.$$$reportNull$$$0(3);
        }
        if (result == null) {
            SqlCompletionContributor.$$$reportNull$$$0(4);
        }
        if (!SqlCompletionUtil.isCompletionAllowed(parameters)) {
            return;
        }
        SqlPrefixedElement prefixed = (SqlPrefixedElement)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), SqlPrefixedElement.class, (boolean)false);
        String prefix = StringUtil.notNullize((String)(prefixed == null ? null : prefixed.getNamePrefix()));
        String searchPrefix = result.getPrefixMatcher().getPrefix();
        if (searchPrefix.length() > prefix.length()) {
            char quote = searchPrefix.charAt(prefix.length());
            if (NamingServices.getNamingService((Dbms)SqlImplUtil.getDbms(parameters.getPosition())).getOpeningQuotes().indexOf(quote) != -1) {
                result = result.withPrefixMatcher(prefix + result.getPrefixMatcher().getPrefix().substring(prefix.length() + 1));
            }
        }
        super.fillCompletionVariants(parameters, result);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/completion/SqlCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCompletion";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "tuneReplacementOffset";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

