/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.ejs.lexer;

import com.intellij.ide.highlighter.custom.AbstractCustomLexer;
import com.intellij.ide.highlighter.custom.tokens.BraceTokenParser;
import com.intellij.ide.highlighter.custom.tokens.TokenParser;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class EjsSimpleLexer
extends AbstractCustomLexer {
    private static final int DEFAULT_STATE = 0;
    private static final int INSIDE_BRACES_STATE = 1;
    private static final int INSIDE_FILTER_STATE = 2;
    private final Set<IElementType> myOpenBraces;
    private final Set<IElementType> myCloseBraces;
    private final IElementType myFilterBrace;
    private final IElementType myCommentBrace;
    private final IElementType myOuterElementType;
    private final IElementType myInnerElementType;
    private final IElementType myFilterElementType;
    private int myState;

    public static EjsSimpleLexer buildFromDescriptions(@NotNull IElementType outerElementType, @NotNull IElementType innerElementType, @NotNull IElementType filterElementType, List<? extends Pair<String, IElementType>> openBracesList, Pair<String, IElementType> filterBraceInfo, List<? extends Pair<String, IElementType>> closeBraceList, Pair<String, IElementType> commentBraceInfo) {
        if (outerElementType == null) {
            EjsSimpleLexer.$$$reportNull$$$0(0);
        }
        if (innerElementType == null) {
            EjsSimpleLexer.$$$reportNull$$$0(1);
        }
        if (filterElementType == null) {
            EjsSimpleLexer.$$$reportNull$$$0(2);
        }
        ArrayList<TokenParser> tokenParsers = new ArrayList<TokenParser>(openBracesList.size() + 1);
        HashSet<IElementType> openBraces = new HashSet<IElementType>(openBracesList.size());
        HashSet<IElementType> closeBraces = new HashSet<IElementType>(openBracesList.size());
        tokenParsers.add((TokenParser)new BraceTokenParser((String)commentBraceInfo.first, (IElementType)commentBraceInfo.second));
        tokenParsers.add((TokenParser)new BraceTokenParser((String)filterBraceInfo.first, (IElementType)filterBraceInfo.second));
        for (Pair<String, IElementType> pair : openBracesList) {
            tokenParsers.add((TokenParser)new BraceTokenParser((String)pair.first, (IElementType)pair.second));
            openBraces.add((IElementType)pair.getSecond());
        }
        for (Pair<String, IElementType> pair : closeBraceList) {
            tokenParsers.add((TokenParser)new BraceTokenParser((String)pair.first, (IElementType)pair.second));
            closeBraces.add((IElementType)pair.getSecond());
        }
        return new EjsSimpleLexer(outerElementType, innerElementType, filterElementType, tokenParsers, openBraces, (IElementType)filterBraceInfo.second, closeBraces, (IElementType)commentBraceInfo.second);
    }

    private EjsSimpleLexer(@NotNull IElementType outerElementType, @NotNull IElementType innerElementType, @NotNull IElementType filterElementType, List<TokenParser> parsers, Set<IElementType> openBraces, @NotNull IElementType filterBrace, @NotNull Set<IElementType> closeBraces, @NotNull IElementType commentBrace) {
        if (outerElementType == null) {
            EjsSimpleLexer.$$$reportNull$$$0(3);
        }
        if (innerElementType == null) {
            EjsSimpleLexer.$$$reportNull$$$0(4);
        }
        if (filterElementType == null) {
            EjsSimpleLexer.$$$reportNull$$$0(5);
        }
        if (filterBrace == null) {
            EjsSimpleLexer.$$$reportNull$$$0(6);
        }
        if (closeBraces == null) {
            EjsSimpleLexer.$$$reportNull$$$0(7);
        }
        if (commentBrace == null) {
            EjsSimpleLexer.$$$reportNull$$$0(8);
        }
        super(parsers);
        this.myState = 0;
        this.myOuterElementType = outerElementType;
        this.myInnerElementType = innerElementType;
        this.myFilterElementType = filterElementType;
        this.myOpenBraces = openBraces;
        this.myFilterBrace = filterBrace;
        this.myCloseBraces = closeBraces;
        this.myCommentBrace = commentBrace;
    }

    public void advance() {
        IElementType elementType = this.getTokenType();
        if (elementType != null && this.myCloseBraces.contains(elementType)) {
            this.myState = 0;
        }
        super.advance();
        elementType = this.getTokenType();
        if (elementType != null && this.myOpenBraces.contains(elementType)) {
            this.myState = 1;
        }
        if (elementType != null && elementType == this.myFilterBrace) {
            this.myState = 2;
        }
        if (this.myCommentBrace == elementType) {
            int start = this.getTokenStart();
            do {
                super.advance();
            } while (this.getTokenType() != null && !this.myCloseBraces.contains(this.getTokenType()));
            this.myCurrentToken.updateData(start, this.myCurrentToken.getEnd(), this.myCommentBrace);
        }
    }

    protected void handleTokenNotFound() {
        IElementType elementType = switch (this.myState) {
            case 1 -> this.myInnerElementType;
            case 2 -> this.myFilterElementType;
            default -> this.myOuterElementType;
        };
        this.myCurrentToken.updateData(this.myPosition, this.myPosition + 1, elementType);
    }

    public int getState() {
        return this.myState;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            EjsSimpleLexer.$$$reportNull$$$0(9);
        }
        this.myState = initialState;
        super.start(buffer, startOffset, endOffset, initialState);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerElementType";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerElementType";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterElementType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterBrace";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closeBraces";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentBrace";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/ejs/lexer/EjsSimpleLexer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildFromDescriptions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "start";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

