/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.model.source;

import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.codeInsight.VueUtilKt;
import org.jetbrains.vuejs.model.VueDirective;
import org.jetbrains.vuejs.model.VueDirectiveModifier;
import org.jetbrains.vuejs.model.VueEntitiesContainer;
import org.jetbrains.vuejs.model.VueMode;
import org.jetbrains.vuejs.model.typed.VueTypedDirectives;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00000\u001cH\u0016J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0096\u0002J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0003H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0013\u00a8\u0006$"}, d2={"Lorg/jetbrains/vuejs/model/source/VueScriptSetupLocalDirective;", "Lorg/jetbrains/vuejs/model/VueDirective;", "name", "", "rawSource", "Lcom/intellij/lang/javascript/psi/JSPsiNamedElementBase;", "mode", "Lorg/jetbrains/vuejs/model/VueMode;", "<init>", "(Ljava/lang/String;Lcom/intellij/lang/javascript/psi/JSPsiNamedElementBase;Lorg/jetbrains/vuejs/model/VueMode;)V", "getRawSource", "()Lcom/intellij/lang/javascript/psi/JSPsiNamedElementBase;", "defaultName", "getDefaultName", "()Ljava/lang/String;", "parents", "", "Lorg/jetbrains/vuejs/model/VueEntitiesContainer;", "getParents", "()Ljava/util/List;", "source", "Lcom/intellij/psi/PsiElement;", "getSource", "()Lcom/intellij/psi/PsiElement;", "modifiers", "Lorg/jetbrains/vuejs/model/VueDirectiveModifier;", "getModifiers", "createPointer", "Lcom/intellij/model/Pointer;", "equals", "", "other", "", "hashCode", "", "toString", "intellij.vuejs.backend"})
public final class VueScriptSetupLocalDirective
implements VueDirective {
    @NotNull
    private final JSPsiNamedElementBase rawSource;
    @NotNull
    private final VueMode mode;
    @NotNull
    private final String defaultName;
    @NotNull
    private final List<VueEntitiesContainer> parents;

    public VueScriptSetupLocalDirective(@NotNull String name, @NotNull JSPsiNamedElementBase rawSource, @NotNull VueMode mode) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)rawSource, (String)"rawSource");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.rawSource = rawSource;
        this.mode = mode;
        this.defaultName = name;
        this.parents = CollectionsKt.emptyList();
    }

    @NotNull
    public JSPsiNamedElementBase getRawSource() {
        return this.rawSource;
    }

    @Override
    @NotNull
    public String getDefaultName() {
        return this.defaultName;
    }

    @Override
    @NotNull
    public List<VueEntitiesContainer> getParents() {
        return this.parents;
    }

    @Override
    @NotNull
    public PsiElement getSource() {
        return (PsiElement)VueUtilKt.resolveIfImportSpecifier(this.getRawSource());
    }

    @Override
    @NotNull
    public List<VueDirectiveModifier> getModifiers() {
        Object object = CachedValuesManager.getCachedValue((PsiElement)this.getSource(), () -> VueScriptSetupLocalDirective._get_modifiers_$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    @NotNull
    public Pointer<VueScriptSetupLocalDirective> createPointer() {
        String name = this.getDefaultName();
        SmartPsiElementPointer source = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)this.getRawSource()));
        VueMode mode = this.mode;
        return () -> VueScriptSetupLocalDirective.createPointer$lambda$0(source, name, mode);
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof VueScriptSetupLocalDirective && Intrinsics.areEqual((Object)((VueScriptSetupLocalDirective)other).getDefaultName(), (Object)this.getDefaultName()) && Intrinsics.areEqual((Object)((VueScriptSetupLocalDirective)other).getSource(), (Object)this.getSource());
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getDefaultName(), this.getSource()};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        return "VueScriptSetupLocalDirective(" + this.getDefaultName() + ")";
    }

    private static final CachedValueProvider.Result _get_modifiers_$lambda$0(VueScriptSetupLocalDirective this$0) {
        List<VueDirectiveModifier> list = VueTypedDirectives.INSTANCE.getDirectiveModifiers(this$0.getSource(), this$0.mode);
        Object[] objectArray = new Object[2];
        Project project = this$0.getSource().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        objectArray[0] = DumbService.Companion.getInstance(project).getModificationTracker();
        objectArray[1] = PsiModificationTracker.MODIFICATION_COUNT;
        return CachedValueProvider.Result.create(list, (Object[])objectArray);
    }

    private static final VueScriptSetupLocalDirective createPointer$lambda$0(SmartPsiElementPointer $source, String $name, VueMode $mode) {
        JSPsiNamedElementBase jSPsiNamedElementBase = (JSPsiNamedElementBase)$source.dereference();
        if (jSPsiNamedElementBase == null) {
            return null;
        }
        JSPsiNamedElementBase newSource = jSPsiNamedElementBase;
        return new VueScriptSetupLocalDirective($name, newSource, $mode);
    }
}

