/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.codeInsight.documentation.DocumentationManagerUtil;
import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.documentation.mdn.MdnSymbolDocumentation;
import com.intellij.lang.ASTNode;
import com.intellij.lang.documentation.CodeDocumentationProvider;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedExportedDefaultBinding;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.documentation.JSDocSimpleInfoPrinter;
import com.intellij.lang.javascript.documentation.JSDocumentationBuilder;
import com.intellij.lang.javascript.documentation.JSDocumentationCommentGenerator;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.documentation.JSQuickNavigateBuilder;
import com.intellij.lang.javascript.documentation.JavaScriptDocumentationCommentGenerator;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.library.JSLibraryExtDocProviderFactory;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSPredefinedLibraryManager;
import com.intellij.lang.javascript.navigation.JSDeclarationEvaluator;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSPsiReferenceElement;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocCommentVisitor;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagType;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReference;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReferenceSet;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSReferenceExpressionResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptMergedTypeImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.typescript.TSSymbolDeclaration;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.impl.util.CssDocumentationProvider;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDocumentationProvider
implements CodeDocumentationProvider,
ExternalDocumentationProvider {
    public static final String DEFAULT_CLASS_NAME = "default";
    @NlsSafe
    protected static final String OBJECT_NAME = "Object";
    protected static final String SEE_PLAIN_TEXT_CHARS = "\t \"-\\/<>*";
    @NlsSafe
    private static final String P_TAG = "<p>";
    private final JSLibraryExtDocProviderFactory myLibraryDocProviderFactory = new JSLibraryExtDocProviderFactory();

    @NotNull
    protected JSQuickNavigateBuilder createQuickNavigateBuilder() {
        return new JSQuickNavigateBuilder();
    }

    @Nullable
    @Nls
    public String getQuickNavigateInfo(@Nullable PsiElement element2, @Nullable PsiElement originalElement) {
        return QuickDocUtil.inferLinkFromFullDocumentation((DocumentationProvider)this, (PsiElement)element2, (PsiElement)originalElement, (String)this.createQuickNavigateBuilder().getQuickNavigateInfo(element2, originalElement));
    }

    @Nls
    public String fetchExternalDocumentation(Project project, PsiElement element2, List<String> docUrls, boolean onHover) {
        for (String docUrl : docUrls) {
            String result2;
            ExternalDocumentationProvider provider;
            if (docUrl == null || (provider = this.myLibraryDocProviderFactory.getProvider(docUrl)) == null || (result2 = provider.fetchExternalDocumentation(project, element2, Collections.singletonList(docUrl), onHover)) == null) continue;
            return result2;
        }
        return null;
    }

    public boolean hasDocumentationFor(PsiElement element2, PsiElement originalElement) {
        return CompositeDocumentationProvider.hasUrlsFor((DocumentationProvider)this, (PsiElement)element2, (PsiElement)originalElement);
    }

    public boolean canPromptToConfigureDocumentation(PsiElement element2) {
        return false;
    }

    public void promptToConfigureDocumentation(PsiElement element2) {
    }

    public List<String> getUrlFor(PsiElement element2, PsiElement originalElement) {
        String possibleCssName = JSDocumentationProvider.findPossibleCssName(element2);
        List<String> cssUrls = possibleCssName != null ? Arrays.asList(CssDocumentationProvider.getUrlsFor((String)possibleCssName, (PsiElement)element2)) : Collections.emptyList();
        return cssUrls.isEmpty() ? JSDocumentationProvider.collectExternalUrls(element2, originalElement) : cssUrls;
    }

    @Nullable
    private static List<String> collectExternalUrls(PsiElement element2, PsiElement originalElement) {
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)element2);
        if (dialect == null || dialect.isECMA4 || element2 instanceof JSReferenceExpression) {
            return null;
        }
        SmartList urls = new SmartList();
        Project project = element2.getProject();
        if (JSDocumentationUtils.isFromCoreLibFile((PsiElement)element2)) {
            MdnSymbolDocumentation documentation = JSDocumentationUtils.getJsMdnDocumentation((PsiElement)element2, (PsiElement)originalElement);
            if (documentation != null) {
                ObjectUtils.doIfNotNull((Object)documentation.getUrl(), ((List)urls)::add);
            }
        } else {
            JSLibraryManager libManager = JSLibraryManager.getInstance(project);
            VirtualFile file = element2.getContainingFile().getVirtualFile();
            if (file == null) {
                return null;
            }
            for (String baseUrl : libManager.getDocUrlsFor(file)) {
                JSDocumentationProvider.addBaseUrl((List<String>)urls, element2, file, baseUrl);
            }
        }
        return urls.isEmpty() ? null : urls;
    }

    private static void addBaseUrl(@NotNull List<String> urls, @NotNull PsiElement docElement, VirtualFile libFile, String baseUrl) {
        if (urls == null) {
            JSDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (docElement == null) {
            JSDocumentationProvider.$$$reportNull$$$0(1);
        }
        if (!(docElement instanceof JSPsiElementBase)) {
            return;
        }
        Object elementFQN = ((JSPsiElementBase)docElement).getQualifiedName();
        if (elementFQN != null) {
            if (libFile.getPath().contains("nodejs")) {
                elementFQN = JSDocumentationProvider.patchNodejsFQN((String)elementFQN, libFile);
                String parameterSignature = JSDocumentationProvider.getParameterSignature(docElement);
                elementFQN = (String)elementFQN + parameterSignature;
            }
            String relativeUrl = JSDocumentationUtils.getLibDocRelativeUrl((String)baseUrl, (String)elementFQN);
            urls.add(baseUrl + (baseUrl.endsWith("/") || StringUtil.isEmpty((String)relativeUrl) ? "" : "/") + relativeUrl);
        }
    }

    private static String patchNodejsFQN(@NotNull String fqn, @NotNull VirtualFile libFile) {
        if (fqn == null) {
            JSDocumentationProvider.$$$reportNull$$$0(2);
        }
        if (libFile == null) {
            JSDocumentationProvider.$$$reportNull$$$0(3);
        }
        String fileName = libFile.getName();
        fileName = StringUtil.trimEnd((String)fileName, (String)".js");
        if (fqn.startsWith("exports.")) {
            return fqn.replaceAll("^exports", fileName);
        }
        if (fqn.startsWith(fileName)) {
            return fqn;
        }
        return fileName + "." + fqn;
    }

    private static String getParameterSignature(PsiElement element2) {
        StringBuilder parameterBuf = new StringBuilder();
        if (element2 instanceof JSFunction) {
            JSFunction function = (JSFunction)element2;
            for (JSParameter parameter : function.getParameterVariables()) {
                parameterBuf.append('%').append(parameter.getName());
            }
        }
        return parameterBuf.toString();
    }

    @Nullable
    protected PsiElement getEffectiveElement(@NotNull PsiElement _element, @Nullable PsiElement originalElement) {
        ES6ImportExportSpecifier element2;
        if (_element == null) {
            JSDocumentationProvider.$$$reportNull$$$0(4);
        }
        if (_element instanceof JSExpression && !(_element instanceof JSQualifiedNamedElement)) {
            PsiElement candidate;
            PsiElement bindingCandidate = candidate = JSDocumentationUtils.getOriginalElementOrParentIfLeaf((PsiElement)originalElement);
            if (candidate instanceof JSReferenceExpression) {
                bindingCandidate = ((JSReferenceExpression)candidate).resolve();
            }
            if (bindingCandidate instanceof ES6ImportedExportedDefaultBinding) {
                return bindingCandidate;
            }
        }
        if (_element instanceof ES6ImportExportSpecifierAlias && (element2 = ((ES6ImportExportSpecifierAlias)_element).findSpecifierElement()) != null) {
            PsiElement resolve2 = element2.resolve();
            return resolve2 == null ? element2 : resolve2;
        }
        return (PsiElement)JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)(originalElement != null ? originalElement : _element), () -> JSDocumentationProvider.adjustAliasedCall(_element, originalElement));
    }

    @Nls
    public final String generateDoc(PsiElement _element, @Nullable PsiElement originalElement) {
        return this.generateDoc(_element, originalElement, null);
    }

    @Nullable
    @Nls
    protected String generateDoc(PsiElement _element, @Nullable PsiElement originalElement, @Nullable Ref<String> definitionDetails) {
        return (String)JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)originalElement, () -> this.doGenerateDoc(_element, originalElement, definitionDetails));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    @Nls
    private String doGenerateDoc(PsiElement _element, @Nullable PsiElement originalElement, @Nullable Ref<String> definitionDetails) {
        String cssDoc;
        String possibleCssName;
        JSParameter parameterDoc;
        PsiElement originalTarget;
        PsiElement psiElement;
        if (LookupManager.getInstance((Project)_element.getProject()).getActiveLookup() != null) {
            originalElement = null;
        }
        if (originalElement != null && (psiElement = originalElement.getParent()) instanceof JSReferenceExpression) {
            JSReferenceExpression parent = (JSReferenceExpression)psiElement;
            v0 = parent.resolve();
        } else {
            v0 = originalTarget = null;
        }
        if (_element instanceof JSReferenceExpression) {
            boolean isMergedTypeMember;
            JSReferenceExpression referenceExpression = (JSReferenceExpression)_element;
            ResolveResult[] results = referenceExpression.multiResolve(false);
            boolean bl = isMergedTypeMember = results.length > 0 && Stream.of(results).map(result2 -> result2.getElement()).allMatch(element2 -> element2 instanceof TypeScriptMergedTypeImplicitElement);
            if (isMergedTypeMember) {
                return this.processMergedTypeMember(referenceExpression, originalElement);
            }
        }
        if (_element instanceof TypeScriptMergedTypeImplicitElement) {
            PsiElement isMergedTypeMember;
            TypeScriptMergedTypeImplicitElement implicitElement = (TypeScriptMergedTypeImplicitElement)_element;
            if (originalElement != null && (isMergedTypeMember = originalElement.getContext()) instanceof JSExpression) {
                JSExpression jsExpression = (JSExpression)isMergedTypeMember;
                JSDocumentationBuilder docBuilder = this.buildDocumentationForImplicitElement((JSImplicitElement)implicitElement);
                if (docBuilder.hasDescription()) {
                    return docBuilder.getDoc(true);
                }
                return this.processMergedTypeElement(jsExpression, originalElement, implicitElement);
            }
        }
        if ((_element = this.getEffectiveElement(_element, originalElement)) == null) {
            return null;
        }
        if (_element instanceof JSImplicitElement && !(_element instanceof TypeScriptProxyImplicitElement)) {
            return this.getDocumentationForImplicitElement((JSImplicitElement)_element);
        }
        if (_element.getParent() instanceof PsiComment) {
            _element = _element.getParent();
        }
        if (_element instanceof PsiComment) {
            return this.doGetCommentTextFromComment((PsiComment)_element, originalElement);
        }
        PsiElement element3 = JSDocumentationProvider.findElementForWhichPreviousCommentWillBeSearched(_element = _element.getNavigationElement(), originalElement);
        JSParameter jSParameter = parameterDoc = element3 instanceof JSParameter ? (JSParameter)element3 : null;
        if (element3 != null) {
            PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)element3, (PsiElement)(_element instanceof JSAttributeNameValuePair ? originalElement : null), null);
            if (docComment == null) {
                PsiComment scopeComment;
                String name;
                PsiElement meaningfulElement = JSDocumentationProvider.getPossibleMeaningfulElement(element3);
                docComment = JSDocumentationUtils.findDocComment((PsiElement)meaningfulElement);
                if (docComment != null) {
                    element3 = meaningfulElement;
                }
                if (_element instanceof JSPsiNamedElementBase && (name = ((JSPsiNamedElementBase)_element).getName()) != null && (scopeComment = JSDocumentationUtils.findScopeComment((JSElement)((JSPsiNamedElementBase)_element))) instanceof JSDocComment) {
                    @Nls Ref result3 = Ref.create();
                    JSClassResolver.processImplicitElements((String)name, e -> {
                        result3.set((Object)this.getDocumentationForImplicitElement((JSImplicitElement)e));
                        return false;
                    }, (JSImplicitElementProvider)((JSDocComment)scopeComment));
                    if (!result3.isNull()) {
                        return (String)result3.get();
                    }
                }
            }
            element3 = JSDocumentationProvider.findTargetElement(_element, element3, originalTarget);
            if (docComment != null) {
                PsiComment typeofComment;
                JSType elementType;
                PsiElement typeofResolvedElement = JSDocumentationProvider.getTypeofResolvedElement(docComment = JSDocumentationProvider.findFirstDocComment(docComment), elementType = JSTypeUtils.getTypeOfElement((PsiElement)element3));
                if (typeofResolvedElement != null && (typeofComment = JSDocumentationUtils.findDocComment((PsiElement)typeofResolvedElement)) != null) {
                    docComment = typeofComment;
                    element3 = typeofResolvedElement;
                }
                boolean isTypeOnlyComment = elementType != null && elementType.isEquivalentTo(JSDocumentationUtils.tryCreateTypeFromComment((PsiComment)docComment, (boolean)true, (boolean)true, (boolean)false), null);
                JSDocumentationBuilder builder2 = this.forwardingCreateDocumentationBuilder(element3, originalElement);
                if (!isTypeOnlyComment) {
                    JSDocumentationUtils.processDocumentationTextFromComment((PsiElement)docComment, (ASTNode)docComment.getNode(), (JSDocCommentVisitor)builder2);
                }
                builder2.fillEvaluatedType();
                return parameterDoc != null ? builder2.getParameterDoc(parameterDoc, (PsiElement)docComment, this, originalElement) : builder2.getDoc(false, definitionDetails);
            }
            if (element3 instanceof JSFunction) {
                ASTNode initialComment = JSDocumentationUtils.findLeadingCommentInFunctionBody((PsiElement)element3);
                JSDocumentationBuilder builder3 = this.forwardingCreateDocumentationBuilder(element3, originalElement);
                if (initialComment != null) {
                    JSDocumentationUtils.processDocumentationTextFromComment((PsiElement)element3, (ASTNode)initialComment, (JSDocCommentVisitor)builder3);
                } else {
                    builder3.processOverriddenMembers();
                }
                builder3.fillEvaluatedType();
                return parameterDoc != null ? builder3.getParameterDoc(parameterDoc, null, this, originalElement) : builder3.getDoc();
            }
        }
        if ((possibleCssName = JSDocumentationProvider.findPossibleCssName(_element)) != null && (cssDoc = CssDocumentationProvider.generateDoc((String)possibleCssName, (PsiElement)_element, null)) != null) {
            return cssDoc;
        }
        if (element3 == null) {
            return null;
        }
        JSDocumentationBuilder builder4 = this.createDocumentationBuilder(element3, originalElement);
        builder4.fillEvaluatedType();
        return builder4.showDoc() ? builder4.getDoc(false, definitionDetails) : null;
    }

    @Nullable
    public DocumentationProvider.DocumentationParts getDocumentationParts(@NotNull PsiElement element2, PsiElement originalElement) {
        Ref definitionDetails;
        String doc;
        if (element2 == null) {
            JSDocumentationProvider.$$$reportNull$$$0(5);
        }
        return (doc = this.generateDoc(element2, originalElement, (Ref<String>)(definitionDetails = Ref.create()))) == null ? null : new DocumentationProvider.DocumentationParts(doc, (String)definitionDetails.get());
    }

    @Nullable
    private static PsiElement getTypeofResolvedElement(@NotNull PsiComment comment, @Nullable JSType type2) {
        JSDocComment docComment;
        JSNamedType namedType;
        if (comment == null) {
            JSDocumentationProvider.$$$reportNull$$$0(6);
        }
        if (!(type2 instanceof JSNamedType) || (namedType = (JSNamedType)type2).getJSContext() != JSContext.STATIC) {
            return null;
        }
        if (!(comment instanceof JSDocComment) || (docComment = (JSDocComment)comment).getTags().length != 1 || docComment.getDescription() != null) {
            return null;
        }
        JSDocTagType value = docComment.getTags()[0].getType();
        if (value == null) {
            return null;
        }
        PsiReference reference = value.getReference();
        if (!(reference instanceof JSDocReference)) {
            return null;
        }
        return reference.resolve();
    }

    @NotNull
    private static PsiElement getPossibleMeaningfulElement(@NotNull PsiElement element2) {
        JSClass containingClass;
        if (element2 == null) {
            JSDocumentationProvider.$$$reportNull$$$0(7);
        }
        if (element2 instanceof JSFunction && ((JSFunction)element2).isConstructor() && (containingClass = JSUtils.getMemberContainingClass((PsiElement)element2)) != null) {
            JSClass jSClass = containingClass;
            if (jSClass == null) {
                JSDocumentationProvider.$$$reportNull$$$0(8);
            }
            return jSClass;
        }
        PsiElement psiElement = DumbService.isDumb((Project)element2.getProject()) ? element2 : JSStubBasedPsiTreeUtil.calculateMeaningfulElement((PsiElement)element2);
        if (psiElement == null) {
            JSDocumentationProvider.$$$reportNull$$$0(9);
        }
        return psiElement;
    }

    @NotNull
    @Nls
    private String processMergedTypeElement(@NotNull JSExpression _element, @Nullable PsiElement originalElement, @NotNull TypeScriptMergedTypeImplicitElement implicitElement) {
        if (_element == null) {
            JSDocumentationProvider.$$$reportNull$$$0(10);
        }
        if (implicitElement == null) {
            JSDocumentationProvider.$$$reportNull$$$0(11);
        }
        @Nls StringBuilder doc = new StringBuilder("<div class='definition'><pre>");
        PsiElement coalesced = (PsiElement)ObjectUtils.coalesce((Object)originalElement, (Object)_element);
        doc.append(this.createQuickNavigateBuilder().getQuickNavigateInfoForNavigationElement((PsiElement)implicitElement, coalesced, true));
        doc.append("</pre></div>");
        String string = doc.toString();
        if (string == null) {
            JSDocumentationProvider.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    @Nls
    private String processMergedTypeMember(@NotNull JSReferenceExpression _element, @Nullable PsiElement originalElement) {
        if (_element == null) {
            JSDocumentationProvider.$$$reportNull$$$0(13);
        }
        ResolveResult[] results = _element.multiResolve(false);
        TypeScriptMergedTypeImplicitElement implicitElement = (TypeScriptMergedTypeImplicitElement)results[0].getElement();
        @Nls StringBuilder doc = new StringBuilder(this.processMergedTypeElement((JSExpression)_element, originalElement, implicitElement));
        doc.append("<div class='content'>");
        JSDocSimpleInfoPrinter.addDescription(JavaScriptBundle.message((String)"typescript.types.type.member", (Object[])new Object[]{JSDocumentationProvider.getMergedKindDescription(results)}), doc);
        doc.append(P_TAG);
        doc.append(JavaScriptBundle.message((String)"typescript.types.merged.parts", (Object[])new Object[0]));
        doc.append("<br>");
        LinkedDocCollector collector = new LinkedDocCollector(results);
        String links = collector.getLinks();
        if (links != null) {
            doc.append(links);
        }
        doc.append("</div>");
        String string = doc.toString();
        if (string == null) {
            JSDocumentationProvider.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    private static String getMergedKindDescription(ResolveResult @NotNull [] results) {
        if (results == null) {
            JSDocumentationProvider.$$$reportNull$$$0(15);
        }
        String commonDesc = null;
        for (ResolveResult r : results) {
            TypeScriptMergedTypeImplicitElement element2 = (TypeScriptMergedTypeImplicitElement)r.getElement();
            if (element2 == null) continue;
            if (commonDesc == null) {
                commonDesc = element2.getSourceKind().getDescription();
                continue;
            }
            if (commonDesc.equals(element2.getSourceKind().getDescription())) continue;
            String string = JavaScriptBundle.message((String)"typescript.types.merged", (Object[])new Object[0]);
            if (string == null) {
                JSDocumentationProvider.$$$reportNull$$$0(16);
            }
            return string;
        }
        String string = commonDesc == null ? JavaScriptBundle.message((String)"typescript.types.merged", (Object[])new Object[0]) : commonDesc;
        if (string == null) {
            JSDocumentationProvider.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    protected JSDocumentationBuilder createDocumentationBuilder(@NotNull PsiElement element2, PsiElement contextElement) {
        if (element2 == null) {
            JSDocumentationProvider.$$$reportNull$$$0(18);
        }
        return new JSDocumentationBuilder(element2, contextElement, this);
    }

    @NotNull
    protected JSDocumentationBuilder forwardingCreateDocumentationBuilder(@NotNull PsiElement element2, PsiElement contextElement) {
        if (element2 == null) {
            JSDocumentationProvider.$$$reportNull$$$0(19);
        }
        return new JSDocumentationBuilder(element2, contextElement, this);
    }

    @Nullable
    @Nls
    protected String doGetCommentTextFromComment(@NotNull PsiComment _element, PsiElement originalElement) {
        if (_element == null) {
            JSDocumentationProvider.$$$reportNull$$$0(20);
        }
        JSDocumentationBuilder builder2 = this.forwardingCreateDocumentationBuilder((PsiElement)_element, originalElement);
        JSDocumentationUtils.processDocumentationTextFromComment((PsiElement)_element, (ASTNode)_element.getNode(), (JSDocCommentVisitor)builder2);
        return builder2.getDoc();
    }

    @Nullable
    @Nls
    private String getDocumentationForImplicitElement(@NotNull JSImplicitElement element2) {
        if (element2 == null) {
            JSDocumentationProvider.$$$reportNull$$$0(21);
        }
        return this.buildDocumentationForImplicitElement(element2).getDoc(true);
    }

    @NotNull
    private JSDocumentationBuilder buildDocumentationForImplicitElement(@NotNull JSImplicitElement element2) {
        PsiElement comment;
        if (element2 == null) {
            JSDocumentationProvider.$$$reportNull$$$0(22);
        }
        JSDocumentationBuilder builder2 = this.forwardingCreateDocumentationBuilder((PsiElement)element2, (PsiElement)element2);
        if (element2 instanceof TSSymbolDeclaration) {
            TSSymbolDeclaration symbolDeclaration = (TSSymbolDeclaration)element2;
            v0 = JSDocumentationUtils.findDocComment((PsiElement)symbolDeclaration.getExplicitElement());
        } else {
            v0 = comment = JSDocumentationUtils.findCommentForImplicitElement((PsiElement)element2);
        }
        if (comment != null) {
            JSDocumentationUtils.processDocumentationTextFromComment((PsiElement)comment, (ASTNode)comment.getNode(), (JSDocCommentVisitor)builder2);
        }
        builder2.fillEvaluatedType();
        JSDocumentationBuilder jSDocumentationBuilder = builder2;
        if (jSDocumentationBuilder == null) {
            JSDocumentationProvider.$$$reportNull$$$0(23);
        }
        return jSDocumentationBuilder;
    }

    @NotNull
    private static PsiElement findTargetElement(@NotNull PsiElement _element, @NotNull PsiElement element2, @Nullable PsiElement originalTarget) {
        PsiElement parent;
        if (_element == null) {
            JSDocumentationProvider.$$$reportNull$$$0(24);
        }
        if (element2 == null) {
            JSDocumentationProvider.$$$reportNull$$$0(25);
        }
        if (element2 instanceof JSExpression && (parent = element2.getParent()) instanceof JSInitializerOwner && ((JSInitializerOwner)parent).getInitializer() == element2) {
            element2 = parent;
        }
        if (_element instanceof JSDefinitionExpression) {
            PsiElement parentElement = _element.getParent();
            if (parentElement instanceof JSAssignmentExpression) {
                JSExpression rOperand = ((JSAssignmentExpression)parentElement).getROperand();
                element2 = rOperand instanceof JSFunctionExpression ? rOperand : _element;
            }
        } else if (_element instanceof JSFunctionExpression) {
            element2 = _element;
        } else if (_element instanceof JSProperty) {
            JSExpression expression = ((JSProperty)_element).getValue();
            if (expression instanceof JSFunction && !(originalTarget instanceof TypeScriptMergedTypeImplicitElement)) {
                element2 = expression;
            }
        } else if (_element instanceof JSVariable) {
            JSFunction function;
            if (_element instanceof JSParameter && (function = ((JSParameter)_element).getDeclaringFunction()) != null) {
                JSFunction jSFunction = function;
                if (jSFunction == null) {
                    JSDocumentationProvider.$$$reportNull$$$0(26);
                }
                return jSFunction;
            }
            element2 = _element;
        } else {
            if (_element instanceof JSAttributeNameValuePair) {
                PsiElement psiElement = _element;
                if (psiElement == null) {
                    JSDocumentationProvider.$$$reportNull$$$0(27);
                }
                return psiElement;
            }
            if (_element instanceof JSFunction) {
                boolean isGet = ((JSFunction)_element).isGetProperty();
                boolean isSet = ((JSFunction)_element).isSetProperty();
                if (element2 instanceof JSFunction && (isGet || isSet)) {
                    boolean isGetEl = ((JSFunction)element2).isGetProperty();
                    boolean isSetEl = ((JSFunction)element2).isSetProperty();
                    if (isGet == isSetEl && isSet == isGetEl) {
                        PsiElement psiElement = _element;
                        if (psiElement == null) {
                            JSDocumentationProvider.$$$reportNull$$$0(28);
                        }
                        return psiElement;
                    }
                }
            }
        }
        PsiElement psiElement = element2;
        if (psiElement == null) {
            JSDocumentationProvider.$$$reportNull$$$0(29);
        }
        return psiElement;
    }

    @NotNull
    private static PsiElement adjustAliasedCall(@NotNull PsiElement _element, @Nullable PsiElement originalElement) {
        PsiElement source;
        List<PsiElement> targets;
        if (_element == null) {
            JSDocumentationProvider.$$$reportNull$$$0(30);
        }
        if (!DialectDetector.isTypeScript((PsiElement)_element) || _element instanceof JSFunctionItem) {
            PsiElement psiElement = _element;
            if (psiElement == null) {
                JSDocumentationProvider.$$$reportNull$$$0(31);
            }
            return psiElement;
        }
        JSReferenceExpression referenceExpression = JSDocumentationProvider.getReferenceExpressionIfMethodCallIdentifier(originalElement);
        if (!(referenceExpression == null || (targets = JSDeclarationEvaluator.GO_TO_DECLARATION.getDeclarations((JSPsiReferenceElement)referenceExpression)) == null || targets.isEmpty() || !((source = targets.get(0)) instanceof JSFunctionItem) || source instanceof JSFunction && ((JSFunction)source).isConstructor() || !TypeScriptSignatureChooser.isCallSignatureOf((JSFunctionItem)((JSFunctionItem)source), (PsiElement)_element))) {
            PsiElement psiElement = source;
            if (psiElement == null) {
                JSDocumentationProvider.$$$reportNull$$$0(32);
            }
            return psiElement;
        }
        PsiElement psiElement = _element;
        if (psiElement == null) {
            JSDocumentationProvider.$$$reportNull$$$0(33);
        }
        return psiElement;
    }

    @NotNull
    private static PsiComment findFirstDocComment(@NotNull PsiComment docComment) {
        if (docComment == null) {
            JSDocumentationProvider.$$$reportNull$$$0(34);
        }
        if (docComment.getNode().getElementType() == JSTokenTypes.END_OF_LINE_COMMENT) {
            while (true) {
                PsiElement prev;
                if ((prev = docComment.getPrevSibling()) instanceof PsiWhiteSpace) {
                    prev = prev.getPrevSibling();
                }
                if (prev == null || prev.getNode().getElementType() != JSTokenTypes.END_OF_LINE_COMMENT) break;
                docComment = (PsiComment)prev;
            }
        }
        PsiComment psiComment = docComment;
        if (psiComment == null) {
            JSDocumentationProvider.$$$reportNull$$$0(35);
        }
        return psiComment;
    }

    @Nullable
    private static String findPossibleCssName(PsiElement _element) {
        JSExpression expression;
        if (_element instanceof JSDefinitionExpression && (expression = ((JSDefinitionExpression)_element).getExpression()) instanceof JSReferenceExpression) {
            String text = ((JSReferenceExpression)expression).getReferenceName();
            if (text == null) {
                return null;
            }
            if (!text.isEmpty() && Character.isUpperCase(text.charAt(0))) {
                return null;
            }
            StringBuilder buf = new StringBuilder(text.length());
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                if (Character.isUpperCase(ch)) {
                    buf.append('-').append(Character.toLowerCase(ch));
                    continue;
                }
                buf.append(ch);
            }
            return buf.toString();
        }
        return null;
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element2) {
        if (object instanceof LookupElement) {
            object = ((LookupElement)object).getPsiElement();
        }
        if (object instanceof PsiElement) {
            return (PsiElement)object;
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(@NotNull PsiManager psiManager, @NotNull String link, @Nullable PsiElement context2) {
        int delimiterIndex;
        if (psiManager == null) {
            JSDocumentationProvider.$$$reportNull$$$0(36);
        }
        if (link == null) {
            JSDocumentationProvider.$$$reportNull$$$0(37);
        }
        if ((delimiterIndex = link.lastIndexOf("%")) != -1) {
            return JSDocumentationProvider.resolveDocumentLink(psiManager, link, delimiterIndex);
        }
        if (context2 == null) {
            return null;
        }
        PsiReference[] references = new JSDocReferenceSet(context2, link, 0, false).getReferences();
        if (references.length == 0) {
            return null;
        }
        JSDocReference reference = (JSDocReference)references[references.length - 1];
        return Arrays.stream(reference.multiResolve(false)).map(result2 -> result2.getElement()).filter(Objects::nonNull).max(Comparator.comparingInt(JSDocumentationProvider::getElementForLinkPriority)).orElse(null);
    }

    private static int getElementForLinkPriority(@NotNull PsiElement element2) {
        if (element2 == null) {
            JSDocumentationProvider.$$$reportNull$$$0(38);
        }
        if (element2 instanceof TypeScriptEnum) {
            return 5;
        }
        if (element2 instanceof TypeScriptClass) {
            return 4;
        }
        if (element2 instanceof TypeScriptInterface) {
            return 3;
        }
        if (element2 instanceof TypeScriptTypeAlias) {
            return 2;
        }
        return 0;
    }

    @Nullable
    protected static PsiElement resolveDocumentLink(@NotNull PsiManager psiManager, @NotNull String link, int namespaceDelimiterIndex) {
        VirtualFile relativeFile;
        int elementId;
        if (psiManager == null) {
            JSDocumentationProvider.$$$reportNull$$$0(39);
        }
        if (link == null) {
            JSDocumentationProvider.$$$reportNull$$$0(40);
        }
        Project project = psiManager.getProject();
        int filenameDelimiterIndex = link.lastIndexOf("%", namespaceDelimiterIndex - 1);
        int symbolOffsetStart = link.lastIndexOf(":");
        if (filenameDelimiterIndex == -1) {
            return null;
        }
        if (symbolOffsetStart > filenameDelimiterIndex) {
            elementId = StringUtil.parseInt((String)link.substring(symbolOffsetStart + 1), (int)-1);
            link = link.substring(0, symbolOffsetStart);
        } else {
            elementId = 0;
        }
        String fileName = link.substring(0, filenameDelimiterIndex).replace('\\', '/');
        String name = link.substring(filenameDelimiterIndex + 1, namespaceDelimiterIndex);
        String qualifier = link.substring(namespaceDelimiterIndex + 1);
        boolean isGlobal = "null".equals(qualifier);
        VirtualFile virtualFile = relativeFile = ApplicationManager.getApplication().isUnitTestMode() ? TempFileSystem.getInstance().findFileByPath(fileName) : VfsUtilCore.findRelativeFile((String)fileName, null);
        if (relativeFile == null) {
            relativeFile = JSDocumentationProvider.findPredefinedOrLibraryFile(project, fileName);
        }
        Ref result2 = new Ref();
        if (relativeFile != null) {
            GlobalSearchScope fileScope = GlobalSearchScope.fileScope((Project)project, (VirtualFile)relativeFile);
            String qName = isGlobal ? name : qualifier + "." + name;
            AtomicInteger index = new AtomicInteger(0);
            JSClassResolver.getInstance().processElementsByQNameIncludingImplicit(qName, fileScope, base -> {
                result2.set(base);
                index.incrementAndGet();
                return elementId > 0 && index.get() != elementId;
            });
        }
        return (PsiElement)result2.get();
    }

    @Nullable
    private static VirtualFile findPredefinedOrLibraryFile(Project project, String fileName) {
        JSPredefinedLibraryManager manager = JSPredefinedLibraryManager.getPredefinedLibraryManager(project);
        VirtualFile vf = manager.findPredefinedFileByName(fileName);
        if (vf != null) {
            return vf;
        }
        JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
        return libraryManager.getMatchingFile(fileName);
    }

    public static PsiElement findElementForWhichPreviousCommentWillBeSearched(@Nullable PsiElement object, @Nullable PsiElement context2) {
        JSFunctionItem relatedFunction;
        if (object instanceof JSFunction) {
            JSFunction function = (JSFunction)object;
            PsiElement psiElement = object;
            PsiElement parent = psiElement.getParent();
            if (parent instanceof JSNewExpression) {
                parent = parent.getParent();
            }
            if (parent instanceof JSProperty) {
                psiElement = parent;
            } else if (parent instanceof JSAssignmentExpression) {
                psiElement = parent.getParent();
            }
            if (function.isSetProperty() || function.isGetProperty()) {
                PsiComment doc = JSDocumentationUtils.findDocComment((PsiElement)function);
                if (doc != null) {
                    return function;
                }
                for (PsiElement el = function.getPrevSibling(); el != null; el = el.getPrevSibling()) {
                    JSFunction prevFunction;
                    String name;
                    if (el instanceof PsiWhiteSpace || el instanceof PsiComment) continue;
                    if (!(el instanceof JSFunction) || (name = (prevFunction = (JSFunction)el).getName()) == null || !name.equals(function.getName()) || (!prevFunction.isGetProperty() || !function.isSetProperty()) && (!prevFunction.isSetProperty() || !function.isGetProperty()) || (doc = JSDocumentationUtils.findDocComment((PsiElement)prevFunction)) == null) break;
                    return prevFunction;
                }
            }
            return psiElement;
        }
        if (context2 != null && (relatedFunction = TypeScriptSignatureChooser.resolveAnyFunction((PsiElement)object, (PsiElement)context2)) != null && relatedFunction.getName() != null) {
            return relatedFunction;
        }
        if (object instanceof JSProperty || object instanceof JSStatement || object instanceof JSClass) {
            return object;
        }
        if (object != null) {
            PsiElement parent = object.getParent();
            if (parent instanceof JSAssignmentExpression) {
                return SharedImplUtil.getParent((ASTNode)parent.getNode());
            }
            if (parent instanceof JSAttribute) {
                PsiElement grandParent = parent.getParent();
                if (grandParent.getFirstChild() == parent) {
                    PsiElement element2 = grandParent.getParent();
                    if (element2 instanceof JSFile) {
                        return grandParent;
                    }
                    return element2;
                }
                return parent;
            }
            return object;
        }
        return null;
    }

    @Nullable
    public PsiComment findExistingDocComment(PsiComment contextElement) {
        return contextElement;
    }

    @Nullable
    public Pair<PsiElement, PsiComment> parseContext(@NotNull PsiElement startPoint) {
        JSElement context2;
        if (startPoint == null) {
            JSDocumentationProvider.$$$reportNull$$$0(41);
        }
        if ((context2 = (JSElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)startPoint, (Class[])new Class[]{JSProperty.class, JSFunction.class, JSExpressionStatement.class, JSVarStatement.class})) != null) {
            return Pair.create((Object)context2, (Object)JSDocumentationUtils.findDocComment((PsiElement)context2));
        }
        return null;
    }

    @NotNull
    protected JSDocumentationCommentGenerator getCommentGenerator() {
        return new JavaScriptDocumentationCommentGenerator();
    }

    @Nullable
    public String generateDocumentationContentStub(@NotNull PsiComment contextComment) {
        if (contextComment == null) {
            JSDocumentationProvider.$$$reportNull$$$0(42);
        }
        throw new UnsupportedOperationException("Use insertDocumentationContentStub");
    }

    public boolean insertDocumentationContentStub(@NotNull PsiComment contextComment, @NotNull Document document, int offset) {
        if (contextComment == null) {
            JSDocumentationProvider.$$$reportNull$$$0(43);
        }
        if (document == null) {
            JSDocumentationProvider.$$$reportNull$$$0(44);
        }
        this.getCommentGenerator().insertDocumentationContentStub(contextComment, document, offset);
        return true;
    }

    protected boolean appendSeeAlsoLink(@NotNull String linkPart, @NotNull String displayText, @NotNull String seeAlsoValue, @NotNull PsiElement element2, @NotNull StringBuilder result2) {
        if (linkPart == null) {
            JSDocumentationProvider.$$$reportNull$$$0(45);
        }
        if (displayText == null) {
            JSDocumentationProvider.$$$reportNull$$$0(46);
        }
        if (seeAlsoValue == null) {
            JSDocumentationProvider.$$$reportNull$$$0(47);
        }
        if (element2 == null) {
            JSDocumentationProvider.$$$reportNull$$$0(48);
        }
        if (result2 == null) {
            JSDocumentationProvider.$$$reportNull$$$0(49);
        }
        if (!JSDocumentationUtils.NAMEPATH_PATTERN.matcher(seeAlsoValue).matches()) {
            return false;
        }
        DocumentationManagerUtil.createHyperlink((StringBuilder)result2, (String)seeAlsoValue, (String)seeAlsoValue, (boolean)true);
        return true;
    }

    @Nullable
    private static NavigationItem getNavigationItemForLinks(@NotNull PsiElement element2) {
        PsiElement candidate;
        if (element2 == null) {
            JSDocumentationProvider.$$$reportNull$$$0(50);
        }
        if (!((candidate = element2.getNavigationElement()) instanceof NavigationItem)) {
            return null;
        }
        NavigationItem navigationItem = (NavigationItem)candidate;
        if (navigationItem.getPresentation() == null && element2 instanceof NavigationItem) {
            navigationItem = (NavigationItem)element2;
        }
        return navigationItem;
    }

    @NotNull
    Collection<? extends JSFunctionItem> getOverloads(@NotNull JSFunctionItem mainElement) {
        if (mainElement == null) {
            JSDocumentationProvider.$$$reportNull$$$0(51);
        }
        Collection collection = TypeScriptPsiUtil.getAllOverloadSignatures((JSFunctionItem)mainElement);
        if (collection == null) {
            JSDocumentationProvider.$$$reportNull$$$0(52);
        }
        return collection;
    }

    public void collectDocComments(@NotNull PsiFile file, final @NotNull @NotNull Consumer<? super @NotNull PsiDocCommentBase> sink) {
        if (file == null) {
            JSDocumentationProvider.$$$reportNull$$$0(53);
        }
        if (sink == null) {
            JSDocumentationProvider.$$$reportNull$$$0(54);
        }
        if (!(file instanceof JSFile) || ((JSFile)file).isMinified() || file instanceof PsiCompiledFile) {
            return;
        }
        new JSRecursiveWalkingElementVisitor(this){

            public boolean visitAsFunction(@NotNull JSFunction function) {
                if (function == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.accept((PsiElement)function);
                return true;
            }

            public void visitJSVariable(@NotNull JSVariable node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!(node instanceof JSParameter)) {
                    this.accept((PsiElement)node);
                    super.visitJSVariable(node);
                }
            }

            public void visitES6ExportDeclaration(@NotNull ES6ExportDeclaration exportDeclaration) {
                if (exportDeclaration == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.accept((PsiElement)exportDeclaration);
            }

            public void visitTypeScriptImportStatement(@NotNull TypeScriptImportStatement importStatement) {
                if (importStatement == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.accept((PsiElement)importStatement);
            }

            public void visitES6ImportDeclaration(@NotNull ES6ImportDeclaration importDeclaration) {
                if (importDeclaration == null) {
                    1.$$$reportNull$$$0(4);
                }
                this.accept((PsiElement)importDeclaration);
            }

            public void visitJSClass(@NotNull JSClass node) {
                if (node == null) {
                    1.$$$reportNull$$$0(5);
                }
                this.accept((PsiElement)node);
                super.visitJSClass(node);
            }

            public void visitTypeScriptTypeMember(@NotNull TypeScriptTypeMember node) {
                if (node == null) {
                    1.$$$reportNull$$$0(6);
                }
                this.accept((PsiElement)node);
            }

            public void accept(@NotNull PsiElement element2) {
                PsiComment comment;
                if (element2 == null) {
                    1.$$$reportNull$$$0(7);
                }
                if ((comment = JSDocumentationUtils.findDocComment((PsiElement)element2)) instanceof JSDocComment) {
                    sink.accept((PsiDocCommentBase)comment);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "function";
                        break;
                    }
                    case 1: 
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "exportDeclaration";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "importStatement";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "importDeclaration";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/documentation/JSDocumentationProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAsFunction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSVariable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitES6ExportDeclaration";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTypeScriptImportStatement";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitES6ImportDeclaration";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSClass";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTypeScriptTypeMember";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "accept";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.visitFile(file);
    }

    @Nls
    @Nullable
    public String generateRenderedDoc(@NotNull PsiDocCommentBase comment) {
        JSExpression initializer;
        ASTNode commentNode;
        if (comment == null) {
            JSDocumentationProvider.$$$reportNull$$$0(55);
        }
        if ((commentNode = comment.getNode()) == null) {
            return null;
        }
        PsiElement owner = JSDocumentationUtils.findAssociatedElement((PsiComment)comment);
        if (owner == null) {
            owner = comment.getOwner();
        }
        if (owner == null) {
            return null;
        }
        if (owner instanceof JSInitializerOwner && (initializer = ((JSInitializerOwner)owner).getInitializer()) instanceof JSFunction) {
            owner = initializer;
        }
        JSDocumentationBuilder builder2 = this.createDocumentationBuilder(owner, owner);
        return (String)JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)comment, () -> {
            JSDocumentationUtils.processDocumentationTextFromComment((PsiElement)comment, (ASTNode)commentNode, (JSDocCommentVisitor)builder2);
            return builder2.getRenderedDoc();
        });
    }

    @Nullable
    private static JSReferenceExpression getReferenceExpressionIfMethodCallIdentifier(@Nullable PsiElement element2) {
        JSCallExpression callExpression;
        JSReferenceExpression ref2;
        PsiElement psiElement;
        LeafPsiElement leaf;
        if (element2 instanceof LeafPsiElement && (leaf = (LeafPsiElement)element2).getElementType() == JSTokenTypes.IDENTIFIER && (psiElement = leaf.getParent()) instanceof JSReferenceExpression && (psiElement = (ref2 = (JSReferenceExpression)psiElement).getParent()) instanceof JSCallExpression && !(callExpression = (JSCallExpression)psiElement).isNewExpression()) {
            return ref2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 12, 14, 16, 17, 23, 26, 27, 28, 29, 31, 32, 33, 35, 52 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libFile";
                break;
            }
            case 4: 
            case 10: 
            case 13: 
            case 20: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_element";
                break;
            }
            case 5: 
            case 7: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 38: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/documentation/JSDocumentationProvider";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implicitElement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docComment";
                break;
            }
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPoint";
                break;
            }
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextComment";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkPart";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayText";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seeAlsoValue";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainElement";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/documentation/JSDocumentationProvider";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleMeaningfulElement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "processMergedTypeElement";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "processMergedTypeMember";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergedKindDescription";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDocumentationForImplicitElement";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "findTargetElement";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustAliasedCall";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "findFirstDocComment";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverloads";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addBaseUrl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "patchNodejsFQN";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentationParts";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTypeofResolvedElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleMeaningfulElement";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 52: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processMergedTypeElement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processMergedTypeMember";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getMergedKindDescription";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createDocumentationBuilder";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "forwardingCreateDocumentationBuilder";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doGetCommentTextFromComment";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentationForImplicitElement";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "buildDocumentationForImplicitElement";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findTargetElement";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "adjustAliasedCall";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findFirstDocComment";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentationElementForLink";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getElementForLinkPriority";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "resolveDocumentLink";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "parseContext";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "generateDocumentationContentStub";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "insertDocumentationContentStub";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "appendSeeAlsoLink";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationItemForLinks";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getOverloads";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "collectDocComments";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "generateRenderedDoc";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 12, 14, 16, 17, 23, 26, 27, 28, 29, 31, 32, 33, 35, 52 -> new IllegalStateException(string);
        };
    }

    static class LinkedDocCollector {
        @NotNull
        private final List<PsiElement> myResults;
        private final boolean myStrict;

        LinkedDocCollector(@NotNull @NotNull ResolveResult @NotNull [] results) {
            if (results == null) {
                LinkedDocCollector.$$$reportNull$$$0(0);
            }
            this.myStrict = JSResolveUtil.areResolveResultsStrict((ResolveResult[])results);
            this.myResults = ContainerUtil.mapNotNull((Object[])results, el -> {
                PsiElement element2 = el.getElement();
                if (element2 instanceof TypeScriptMergedTypeImplicitElement) {
                    element2 = ((TypeScriptMergedTypeImplicitElement)element2).getExplicitElement();
                }
                return element2;
            });
        }

        @Nullable
        @Nls
        public String getLinks() {
            MultiMap gatheredDocs = MultiMap.createLinked();
            for (int i = 0; i < this.myResults.size() && i <= JSReferenceExpressionResolver.MAX_RESULTS_COUNT_TO_KEEP; ++i) {
                PsiElement element2 = this.myResults.get(i);
                gatheredDocs.putValue((Object)element2.getContainingFile().getName(), (Object)element2);
            }
            if (!gatheredDocs.isEmpty()) {
                @Nls StringBuilder builder2 = new StringBuilder();
                int length = 0;
                for (Map.Entry entry : gatheredDocs.entrySet()) {
                    if (builder2.length() > length) {
                        builder2.append(", <br />");
                        length = builder2.length();
                    }
                    this.addElementLinks(builder2, (Collection)entry.getValue(), true);
                }
                return builder2.toString();
            }
            return null;
        }

        @NotNull
        private static Object2IntMap<PsiElement> getIndices(@NotNull Collection<? extends PsiElement> elements, boolean addFilename) {
            if (elements == null) {
                LinkedDocCollector.$$$reportNull$$$0(1);
            }
            MultiMap qNames = new MultiMap();
            Object2IntOpenHashMap map2 = new Object2IntOpenHashMap();
            for (PsiElement psiElement : elements) {
                PsiFile file;
                NavigationItem nav = JSDocumentationProvider.getNavigationItemForLinks(psiElement);
                String name = nav != null ? nav.getName() : null;
                if (name == null) continue;
                JSQualifiedName namespace = psiElement instanceof JSElementBase ? ((JSElementBase)psiElement).getNamespace() : null;
                String qName = (String)(namespace == null ? "" : namespace.getQualifiedName() + ".") + name;
                qNames.putValue((Object)qName, (Object)psiElement);
                Collection withQName = qNames.get((Object)qName);
                if (addFilename && withQName.size() != 2 || !addFilename && withQName.size() != 1 || (file = psiElement.getContainingFile()) == null) continue;
                List implicit = JSClassResolver.getInstance().findElementsByQNameIncludingImplicit(qName, file);
                int index = 1;
                for (JSPsiElementBase base : implicit) {
                    map2.put((Object)base, index++);
                }
            }
            Object2IntOpenHashMap object2IntOpenHashMap = map2;
            if (object2IntOpenHashMap == null) {
                LinkedDocCollector.$$$reportNull$$$0(2);
            }
            return object2IntOpenHashMap;
        }

        private void addElementLinks(@NotNull StringBuilder builder2, @NotNull Collection<PsiElement> elements, boolean addFilename) {
            if (builder2 == null) {
                LinkedDocCollector.$$$reportNull$$$0(3);
            }
            if (elements == null) {
                LinkedDocCollector.$$$reportNull$$$0(4);
            }
            HashSet<NavigationItem> seenOverloads = new HashSet<NavigationItem>();
            int i = -1;
            Object2IntMap<PsiElement> indices = LinkedDocCollector.getIndices(elements, addFilename);
            for (PsiElement element2 : elements) {
                PsiElement module;
                ItemPresentation presentation;
                String name;
                ++i;
                NavigationItem nav = JSDocumentationProvider.getNavigationItemForLinks(element2);
                if (nav == null || (name = nav.getName()) == null || (presentation = nav.getPresentation()) == null) continue;
                Object presentableName = name;
                if (nav instanceof JSQualifiedNamedElement && !this.myStrict && !((module = ES6PsiUtil.findExternalModule((PsiElement)element2)) instanceof TypeScriptModule)) {
                    presentableName = ((JSQualifiedNamedElement)nav).getQualifiedName();
                }
                if (nav instanceof JSFunctionItem && !addFilename) {
                    presentableName = (String)presentableName + JSFormatUtil.buildFunctionSignaturePresentation((JSFunctionItem)((JSFunctionItem)nav));
                }
                if (!seenOverloads.add(nav)) continue;
                if (i != 0) {
                    builder2.append(", <br>");
                }
                int elementId = indices.getInt((Object)element2);
                JSDocumentationUtils.appendHyperLinkToElement((PsiElement)((PsiElement)nav), (String)name, (StringBuilder)builder2, (String)presentableName, (boolean)true, (boolean)addFilename, (int)elementId);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "results";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/documentation/JSDocumentationProvider$LinkedDocCollector";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/documentation/JSDocumentationProvider$LinkedDocCollector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndices";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getIndices";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addElementLinks";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    static final class OptionalJsDocumentationProvider
    extends JSDocumentationProvider {
        private OptionalJsDocumentationProvider() {
            for (FileType registeredFileType : FileTypeManager.getInstance().getRegisteredFileTypes()) {
                if (!(registeredFileType instanceof JavaScriptFileType)) continue;
                return;
            }
            throw ExtensionNotApplicableException.create();
        }
    }
}

