/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge.svg12;

import java.util.Set;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.anim.dom.XBLEventSupport;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.URIResolver;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.svg12.SVG12URIResolver;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.events.EventSupport;
import org.apache.batik.dom.events.NodeEventTarget;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGDocument;

public final class SVG12BridgeContext
extends BridgeContext {
    EventTarget mouseCaptureTarget;
    boolean mouseCaptureSendAll;
    boolean mouseCaptureAutoRelease;

    public SVG12BridgeContext(UserAgent userAgent) {
        super(userAgent);
    }

    public SVG12BridgeContext(UserAgent userAgent, DocumentLoader loader) {
        super(userAgent, loader);
    }

    @Override
    public URIResolver createURIResolver(SVGDocument doc, DocumentLoader dl) {
        return new SVG12URIResolver(doc, dl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.clearChildContexts();
        Set set = this.eventListenerSet;
        synchronized (set) {
            for (Object anEventListenerSet : this.eventListenerSet) {
                String ns;
                BridgeContext.EventListenerMememto m = (BridgeContext.EventListenerMememto)anEventListenerSet;
                NodeEventTarget et = m.getTarget();
                EventListener el = m.getListener();
                boolean uc = m.getUseCapture();
                String t = m.getEventType();
                boolean in = m.getNamespaced();
                if (et == null || el == null || t == null) continue;
                if (m instanceof ImplementationEventListenerMememto) {
                    ns = m.getNamespaceURI();
                    Node nde = (Node)((Object)et);
                    AbstractNode n = (AbstractNode)((Object)nde.getOwnerDocument());
                    if (n == null) continue;
                    XBLEventSupport es = (XBLEventSupport)n.initializeEventSupport();
                    es.removeImplementationEventListenerNS(ns, t, el, uc);
                    continue;
                }
                if (in) {
                    ns = m.getNamespaceURI();
                    et.removeEventListenerNS(ns, t, el, uc);
                    continue;
                }
                et.removeEventListener(t, el, uc);
            }
        }
        if (this.document != null) {
            this.removeDOMListeners();
        }
        if (this.focusManager != null) {
            this.focusManager.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeImplementationEventListenerNS(EventTarget t, String ns, String s, EventListener l, boolean b) {
        Set set = this.eventListenerSet;
        synchronized (set) {
            ImplementationEventListenerMememto m = new ImplementationEventListenerMememto(t, ns, s, l, b, this);
            this.eventListenerSet.add(m);
        }
    }

    @Override
    public BridgeContext createSubBridgeContext(SVGOMDocument newDoc) {
        CSSEngine eng = newDoc.getCSSEngine();
        if (eng != null) {
            return (BridgeContext)newDoc.getCSSEngine().getCSSContext();
        }
        return super.createSubBridgeContext(newDoc);
    }

    public void stopMouseCapture() {
        this.mouseCaptureTarget = null;
    }

    protected static class EventListenerWrapper
    implements EventListener {
        protected EventListener listener;

        public EventListenerWrapper(EventListener l) {
            this.listener = l;
        }

        @Override
        public void handleEvent(Event evt) {
            this.listener.handleEvent(EventSupport.getUltimateOriginalEvent(evt));
        }

        public String toString() {
            return super.toString() + " [wrapping " + this.listener.toString() + "]";
        }
    }

    protected static class ImplementationEventListenerMememto
    extends BridgeContext.EventListenerMememto {
        public ImplementationEventListenerMememto(EventTarget t, String n, String s, EventListener l, boolean b, BridgeContext c) {
            super(t, n, s, l, b, c);
        }
    }
}

