/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.console.DatabaseServiceViewContributor;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.vfs.DatabaseElementVirtualFileUtils;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.FileColorManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.Topic;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Tag;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseColorManager<T extends SharedColors>
implements PersistentStateComponent<T> {
    public static final Logger LOG = Logger.getInstance(DatabaseColorManager.class);
    private static final Key<CachedColor> COLOR_KEY = Key.create((String)"COLOR_KEY");
    public static final Topic<ColorChangeListener> COLOR_CHANGE_TOPIC = new Topic("Color changed", ColorChangeListener.class);
    private static final SimpleModificationTracker ourModificationTracker = new SimpleModificationTracker();
    private static final Object ourLock = new Object();
    protected T myState;

    public static DatabaseColorManager<LocalColors> getLocalColorManager(@NotNull Project project) {
        if (project == null) {
            DatabaseColorManager.$$$reportNull$$$0(0);
        }
        return (DatabaseColorManager)project.getService(Local.class);
    }

    public static DatabaseColorManager<SharedColors> getSharedColorManager(@NotNull Project project) {
        if (project == null) {
            DatabaseColorManager.$$$reportNull$$$0(1);
        }
        return (DatabaseColorManager)project.getService(Shared.class);
    }

    public static DatabaseColorManager<SharedColors> getGlobalColorManager() {
        return (DatabaseColorManager)ApplicationManager.getApplication().getService(Global.class);
    }

    private static long getModCount() {
        return ourModificationTracker.getModificationCount() + UISettings.getInstance().getState().getModificationCount();
    }

    @NotNull
    public T getState() {
        T t = this.myState;
        if (t == null) {
            DatabaseColorManager.$$$reportNull$$$0(2);
        }
        return t;
    }

    public void loadState(@NotNull T state) {
        if (state == null) {
            DatabaseColorManager.$$$reportNull$$$0(3);
        }
        this.myState = state;
    }

    @Nullable
    public static Color getColor(@NotNull Project project, @Nullable VirtualFile file) {
        Object element;
        if (project == null) {
            DatabaseColorManager.$$$reportNull$$$0(4);
        }
        if (file == null) {
            return null;
        }
        if (DbImplUtil.isDatabaseVirtualFile(file)) {
            DbElement tableOrView = DbImplUtilCore.findElement((Project)project, (VirtualFile)file);
            element = tableOrView != null ? tableOrView : DbImplUtilCore.findDataSource((Project)project, (VirtualFile)file);
        } else {
            boolean isConsoleFile = DbVFSUtils.isConsoleFile((VirtualFile)file);
            JdbcConsole console = JdbcConsoleProvider.getValidConsole(project, file);
            if (console == null) {
                element = isConsoleFile ? DbVFSUtils.getDataSource((Project)project, (VirtualFile)file) : null;
            } else {
                DbElement e;
                DbDataSource dataSource = DbImplUtilCore.getDbDataSource((Project)project, (DasDataSource)console.getDataSource());
                ObjectPath path = console.getCurrentNamespace();
                element = dataSource == null || path == null ? dataSource : ((e = DbSqlUtilCore.findElement((DbDataSource)dataSource, (ObjectPath)path)) != null ? e : dataSource);
            }
        }
        return DatabaseColorManager.getColor(element);
    }

    @Nullable
    public static Color getColor(@Nullable DbElement element) {
        if (element == null) {
            return null;
        }
        CachedColor info2 = (CachedColor)COLOR_KEY.get((UserDataHolder)element);
        long modificationCount = DatabaseColorManager.getModCount();
        if (info2 != null && info2.modCount != modificationCount) {
            info2 = null;
        }
        if (info2 == null) {
            Color c2;
            String colorName = DatabaseColorManager.getColorId(element, null);
            info2 = new CachedColor();
            info2.modCount = modificationCount;
            if (colorName != null && (c2 = FileColorManager.getInstance((Project)element.getProject()).getColor(colorName)) != null) {
                info2.color = c2;
            }
            COLOR_KEY.set((UserDataHolder)element, (Object)info2);
        }
        return info2.color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setColorId(@NotNull DbElement element, @Nullable @NonNls String colorID, boolean recursively, boolean isShared) {
        if (element == null) {
            DatabaseColorManager.$$$reportNull$$$0(5);
        }
        Object object = ourLock;
        synchronized (object) {
            DatabaseColorManager<LocalColors> localColorManager = DatabaseColorManager.getLocalColorManager(element.getProject());
            Object local = localColorManager.getState();
            Object shared = DatabaseColorManager.getSharedColorManager(element.getProject()).getState();
            String elementId = DatabaseColorManager.getElementId(element);
            boolean changed = ((SharedColors)shared).colors.remove(elementId) != null;
            changed |= ((SharedColors)local).colors.remove(elementId) != null;
            if (colorID != null) {
                boolean doNotChange;
                Ref sharedRef = Ref.create(null);
                boolean bl = doNotChange = !changed && colorID.equals(DatabaseColorManager.getColorId(element, (Ref<Boolean>)sharedRef)) && isShared == Boolean.TRUE.equals(sharedRef.get());
                if (!doNotChange) {
                    changed = true;
                    ((SharedColors)(isShared ? shared : local)).colors.put(elementId, colorID);
                }
            }
            if (recursively) {
                changed |= DatabaseColorManager.clearChildren(elementId, ((SharedColors)shared).colors);
                changed |= DatabaseColorManager.clearChildren(elementId, ((SharedColors)local).colors);
            }
            if (changed) {
                ourModificationTracker.incModificationCount();
                DatabaseServiceViewContributor.refreshView(element.getProject());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setColorIdForGlobalDataSource(@NotNull DbElement element, @Nullable @NonNls String colorId, boolean recursively) {
        if (element == null) {
            DatabaseColorManager.$$$reportNull$$$0(6);
        }
        Object object = ourLock;
        synchronized (object) {
            DatabaseColorManager.changeScopeToGlobal(element);
            Object state = DatabaseColorManager.getGlobalColorManager().getState();
            String elementId = DatabaseColorManager.getElementId(element);
            ((SharedColors)state).colors.remove(elementId);
            if (colorId != null && !colorId.equals(DatabaseColorManager.getColorIdForGlobalDataSource(element))) {
                ((SharedColors)state).colors.put(elementId, colorId);
            }
            if (recursively) {
                DatabaseColorManager.clearChildren(elementId, ((SharedColors)state).colors);
            }
            ourModificationTracker.incModificationCount();
        }
    }

    private static boolean clearChildren(String elementId, Map<String, String> colors) {
        int colonIndex = elementId.lastIndexOf(58);
        String trimmedId = colonIndex == -1 ? elementId : elementId.substring(0, colonIndex + 1);
        return colors.keySet().removeIf(item -> DatabaseColorManager.isChild(item, trimmedId));
    }

    private static boolean isChild(String element, String parent) {
        int idx = element.indexOf(parent);
        return idx > 0 && element.charAt(idx - 1) == '/';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Color getColor(@NotNull Project project, @Nullable DasDataSource dataSource) {
        if (project == null) {
            DatabaseColorManager.$$$reportNull$$$0(7);
        }
        Object object = ourLock;
        synchronized (object) {
            if (dataSource == null) {
                return null;
            }
            String id = dataSource.getUniqueId();
            String colorName = null;
            if (DatabaseColorManager.isGlobal(dataSource)) {
                colorName = ((SharedColors)DatabaseColorManager.getGlobalColorManager().getState()).colors.get(id);
            }
            if (colorName == null) {
                colorName = (String)((LocalColors)DatabaseColorManager.getLocalColorManager((Project)project).getState()).colors.get(id);
                colorName = colorName != null ? colorName : ((SharedColors)DatabaseColorManager.getSharedColorManager((Project)project).getState()).colors.get(id);
            }
            return colorName == null ? null : FileColorManager.getInstance((Project)project).getColor(colorName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NonNls
    public static String getColorId(@Nullable DbElement element, @Nullable Ref<Boolean> sharedRef) {
        Object object = ourLock;
        synchronized (object) {
            String colorId;
            if (element == null) {
                return null;
            }
            if (DatabaseColorManager.isGlobal((DasDataSource)element.getDataSource()) && (colorId = DatabaseColorManager.getColorIdForGlobalDataSource(element)) != null) {
                return colorId;
            }
            Project project = element.getProject();
            Object local = DatabaseColorManager.getLocalColorManager(project).getState();
            Object shared = DatabaseColorManager.getSharedColorManager(project).getState();
            if (((SharedColors)shared).colors.isEmpty() && ((SharedColors)local).colors.isEmpty()) {
                return null;
            }
            for (DbElement e = element; e != null; e = e.getParent()) {
                boolean isShared;
                String elementId = DatabaseColorManager.getElementId(e);
                String s = ((SharedColors)local).colors.get(elementId);
                boolean bl = isShared = s == null;
                if (s == null) {
                    s = ((SharedColors)shared).colors.get(elementId);
                    boolean bl2 = isShared = s != null;
                }
                if (s == null) continue;
                if (sharedRef != null) {
                    sharedRef.set((Object)isShared);
                }
                return s;
            }
            return null;
        }
    }

    private static void changeScopeToGlobal(@NotNull DbElement e) {
        if (e == null) {
            DatabaseColorManager.$$$reportNull$$$0(8);
        }
        String globalDsId = e.getDataSource().getUniqueId();
        DatabaseColorManager.changeScopeToGlobal(e.getProject(), id -> DatabaseColorManager.belongsToDs(id, globalDsId));
    }

    private static void changeScopeToGlobal(@NotNull Project p2, @NotNull Predicate<String> pred) {
        if (p2 == null) {
            DatabaseColorManager.$$$reportNull$$$0(9);
        }
        if (pred == null) {
            DatabaseColorManager.$$$reportNull$$$0(10);
        }
        Map local = ((LocalColors)DatabaseColorManager.getLocalColorManager((Project)p2).myState).colors;
        Map<String, String> shared = ((SharedColors)DatabaseColorManager.getSharedColorManager((Project)p2).myState).colors;
        Map<String, String> global = ((SharedColors)DatabaseColorManager.getGlobalColorManager().myState).colors;
        DatabaseColorManager.moveColorEntry(shared, global, pred);
        DatabaseColorManager.moveColorEntry(local, global, pred);
    }

    private static void moveColorEntry(@NotNull Map<String, String> from, @NotNull Map<String, String> to, @NotNull Predicate<String> pred) {
        if (from == null) {
            DatabaseColorManager.$$$reportNull$$$0(11);
        }
        if (to == null) {
            DatabaseColorManager.$$$reportNull$$$0(12);
        }
        if (pred == null) {
            DatabaseColorManager.$$$reportNull$$$0(13);
        }
        Iterator<Map.Entry<String, String>> i = from.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, String> e = i.next();
            if (!pred.test(e.getKey())) continue;
            if (!to.containsKey(e.getKey())) {
                to.put(e.getKey(), e.getValue());
            } else {
                LOG.warn(String.format("Lost color for %s: %s", e.getKey(), e.getValue()));
            }
            i.remove();
        }
    }

    private static boolean belongsToDs(@NotNull String elementId, @NotNull String dsId) {
        int kindSepIdx;
        if (elementId == null) {
            DatabaseColorManager.$$$reportNull$$$0(14);
        }
        if (dsId == null) {
            DatabaseColorManager.$$$reportNull$$$0(15);
        }
        String trimmedId = (kindSepIdx = elementId.indexOf(58)) != -1 ? elementId.substring(0, kindSepIdx) : elementId;
        return trimmedId.endsWith(dsId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changeDsScopeToGlobal(@NotNull Project p2, @NotNull LocalDataSource ds) {
        if (p2 == null) {
            DatabaseColorManager.$$$reportNull$$$0(16);
        }
        if (ds == null) {
            DatabaseColorManager.$$$reportNull$$$0(17);
        }
        Object object = ourLock;
        synchronized (object) {
            String dsId = ds.getUniqueId();
            DatabaseColorManager.changeScopeToGlobal(p2, id -> DatabaseColorManager.belongsToDs(id, dsId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changeDsScopeToProject(@NotNull Project p2, @NotNull LocalDataSource ds) {
        if (p2 == null) {
            DatabaseColorManager.$$$reportNull$$$0(18);
        }
        if (ds == null) {
            DatabaseColorManager.$$$reportNull$$$0(19);
        }
        Object object = ourLock;
        synchronized (object) {
            Map local = ((LocalColors)DatabaseColorManager.getLocalColorManager((Project)p2).myState).colors;
            Map<String, String> global = ((SharedColors)DatabaseColorManager.getGlobalColorManager().myState).colors;
            String dsId = ds.getUniqueId();
            DatabaseColorManager.moveColorEntry(global, local, id -> DatabaseColorManager.belongsToDs(id, dsId));
        }
    }

    private static boolean isGlobal(DasDataSource ds) {
        RawDataSource delegate = DbImplUtilCore.unwrapDS((DasDataSource)ds);
        return delegate.isGlobal();
    }

    @Nullable
    @NonNls
    private static String getColorIdForGlobalDataSource(@NotNull DbElement element) {
        if (element == null) {
            DatabaseColorManager.$$$reportNull$$$0(20);
        }
        Object state = DatabaseColorManager.getGlobalColorManager().getState();
        if (((SharedColors)state).colors.isEmpty()) {
            return null;
        }
        return (String)JBIterable.generate((Object)element, e -> e.getParent()).filterMap(arg_0 -> DatabaseColorManager.lambda$getColorIdForGlobalDataSource$5((SharedColors)state, arg_0)).first();
    }

    @NotNull
    private static String getElementId(@NotNull DbElement element) {
        if (element == null) {
            DatabaseColorManager.$$$reportNull$$$0(21);
        }
        StringBuilder sb = new StringBuilder();
        for (DbElement cur = element; cur != null; cur = cur.getParent()) {
            String string;
            if (!sb.isEmpty()) {
                sb.append("/");
            }
            if (cur instanceof DbDataSource) {
                DbDataSource db = (DbDataSource)cur;
                string = db.getUniqueId();
            } else {
                string = DatabaseElementVirtualFileUtils.escape((String)cur.getName());
            }
            sb.append(string);
        }
        if (!(element instanceof DbDataSource)) {
            sb.append(":").append(element.getKind().name());
        }
        String string = sb.toString();
        if (string == null) {
            DatabaseColorManager.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static void cleanupColors(@NotNull Project project) {
        DatabaseColorManager global;
        DatabaseColorManager shared;
        if (project == null) {
            DatabaseColorManager.$$$reportNull$$$0(23);
        }
        List dataSources = DbPsiFacade.getInstance((Project)project).getDataSources();
        Set existingRoots = JBIterable.from((Iterable)dataSources).map(o -> o.getUniqueId()).toSet();
        DatabaseColorManager local = (DatabaseColorManager)project.getServiceIfCreated(Local.class);
        if (local != null) {
            DatabaseColorManager.cleanupColors(local, (Set<String>)existingRoots);
        }
        if ((shared = (DatabaseColorManager)project.getServiceIfCreated(Shared.class)) != null) {
            DatabaseColorManager.cleanupColors(shared, (Set<String>)existingRoots);
        }
        if ((global = (DatabaseColorManager)ApplicationManager.getApplication().getServiceIfCreated(Global.class)) != null) {
            DatabaseColorManager.cleanupColors(global, (Set<String>)existingRoots);
        }
    }

    private static void cleanupColors(@NotNull DatabaseColorManager<?> manager, @NotNull Set<String> existingRoots) {
        Map<String, String> colors;
        if (manager == null) {
            DatabaseColorManager.$$$reportNull$$$0(24);
        }
        if (existingRoots == null) {
            DatabaseColorManager.$$$reportNull$$$0(25);
        }
        if (!(colors = ((SharedColors)manager.getState()).colors).isEmpty()) {
            DatabaseColorManager.cleanupColors(colors, existingRoots);
        }
    }

    private static void cleanupColors(@NotNull Map<String, String> colors, @NotNull Set<String> roots) {
        if (colors == null) {
            DatabaseColorManager.$$$reportNull$$$0(26);
        }
        if (roots == null) {
            DatabaseColorManager.$$$reportNull$$$0(27);
        }
        block0: for (String s : ArrayUtilRt.toStringArray(colors.keySet())) {
            for (String root : roots) {
                if (!s.contains(root)) continue;
                continue block0;
            }
            colors.remove(s);
        }
    }

    private static /* synthetic */ String lambda$getColorIdForGlobalDataSource$5(SharedColors state, DbElement e) {
        return state.colors.get(DatabaseColorManager.getElementId(e));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DatabaseColorManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 6: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 9: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pred";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementId";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dsId";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingRoots";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colors";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DatabaseColorManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocalColorManager";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSharedColorManager";
                break;
            }
            case 2: 
            case 22: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setColorId";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setColorIdForGlobalDataSource";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "changeScopeToGlobal";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "moveColorEntry";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "belongsToDs";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "changeDsScopeToGlobal";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "changeDsScopeToProject";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getColorIdForGlobalDataSource";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getElementId";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "cleanupColors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 22 -> new IllegalStateException(string);
        };
    }

    @Service(value={Service.Level.PROJECT})
    @State(name="DatabaseLocalColorSettings", storages={@Storage(value="$WORKSPACE_FILE$", roamingType=RoamingType.DISABLED)})
    private static final class Local
    extends DatabaseColorManager<LocalColors>
    implements PersistentStateComponent<LocalColors> {
        Local(final @NotNull Project project, @NotNull CoroutineScope scope2) {
            if (project == null) {
                Local.$$$reportNull$$$0(0);
            }
            if (scope2 == null) {
                Local.$$$reportNull$$$0(1);
            }
            this.myState = new LocalColors();
            project.getMessageBus().connect(scope2).subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

                public void projectClosingBeforeSave(@NotNull Project eventProject) {
                    if (eventProject == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (project == eventProject) {
                        DatabaseColorManager.cleanupColors(project);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventProject", "com/intellij/database/view/DatabaseColorManager$Local$1", "projectClosingBeforeSave"));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "scope";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/view/DatabaseColorManager$Local";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @Service(value={Service.Level.PROJECT})
    @State(name="DatabaseColorSettings", storages={@Storage(value="databaseColors.xml", roamingType=RoamingType.DISABLED)})
    private static final class Shared
    extends DatabaseColorManager<SharedColors>
    implements PersistentStateComponent<SharedColors> {
        Shared() {
            this.myState = new SharedColors();
        }
    }

    @Service(value={Service.Level.APP})
    @State(name="DatabaseGlobalColorSettings", storages={@Storage(value="dataSourceColors.xml", roamingType=RoamingType.DISABLED)})
    private static final class Global
    extends DatabaseColorManager<SharedColors>
    implements PersistentStateComponent<SharedColors> {
        Global() {
            this.myState = new SharedColors();
        }
    }

    public static class SharedColors {
        @Tag(value="colors")
        @MapAnnotation(surroundWithTag=false)
        public Map<String, String> colors = new HashMap<String, String>();
    }

    private static class CachedColor {
        Color color;
        long modCount;

        private CachedColor() {
        }
    }

    public static class LocalColors
    extends SharedColors {
        @OptionTag(value="use-colors")
        public boolean useColors = true;
        @OptionTag(value="in-editor-tabs")
        public boolean inEditorTabs = true;
        @OptionTag(value="in-database-view")
        public boolean inDatabaseView = true;
        @OptionTag(value="in-toolbars")
        public boolean useInToolbars = true;
        @OptionTag(value="in-editor")
        public boolean useInEditor = false;
    }

    public static interface ColorChangeListener {
        public void onChanged();
    }
}

