/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 53767314130152L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(1381477800 - (char)-29927, -1381477800 - -((char)-26935), (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1381477800 - (char)-29926, 1381477800 - (char)-27695, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 119234929415652L;
                thread = Thread.currentThread();
                String string = SshAgentIpcService.Y();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (string != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(1952680860 - 22555, -1952680860 - -25877, (int)l2) + string + WindowsNamedPipeAgentIpc.b(1952680860 - 22556, 1952680860 - 24049, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(1952680860 - 22549, 1952680860 - 10279, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                String string;
                l2 = 29180735428964L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    string = SshAgentIpcService.Y();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(-727569570 + -((char)-21416), 727700640 - (char)-10747, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-727569570 + -((char)-21415), -727569570 + -((char)-7349), (int)l2) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-727569570 + -((char)-21414), 727700640 - (char)-4075, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (string != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-727569570 + -((char)-21421), -727700640 - -((char)-2414), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-727569570 + -((char)-21420), 727700640 - (char)-1485, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-727569570 + -((char)-21419), -727700640 - -((char)-2244), (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-727569570 + -((char)-21421), -727700640 - -((char)-2414), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-727569570 + -((char)-21418), 727700640 - (char)-8428, (int)l2));
            if (ActionTimestamp.Y() == null) {
                SshAgentIpcService.Y("nr3fHc");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                String string;
                block6: {
                    long l2 = 81879248096696L;
                    string = SshAgentIpcService.Y();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (string != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (string != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        String string;
        long l2;
        block27: {
            block28: {
                l2 = 98162749683229L;
                String string2 = SshAgentIpcService.Y();
                this.assertConnectionThread();
                string = string2;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (string != null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1272165420 - -((char)-31582), -1272165420 - -((char)-26073), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1272165420 - -((char)-31586), -1272165420 - -17079, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1272165420 - -((char)-31581), 1272165420 - 32294, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string3 = WindowsNamedPipeAgentIpc.b(-1272165420 - -((char)-31586), -1272165420 - -17079, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1272165420 - -((char)-31584), -1272165420 - -26160, (int)l2) + this.state;
                        throw new IllegalArgumentException(string3.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1272165420 - -((char)-31582), -1272165420 - -((char)-26073), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1272165420 - -((char)-31586), -1272165420 - -17079, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1272165420 - -((char)-31583), 1272165420 - (char)-19514, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (string != null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1272165420 - -((char)-31582), -1272165420 - -((char)-26073), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1272165420 - -((char)-31586), -1272165420 - -17079, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1272165420 - -((char)-31594), -1272165420 - -22784, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-1272165420 - -((char)-31586), -1272165420 - -17079, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1272165420 - -((char)-31593), -1272165420 - -32120, (int)l2) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (string != null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string4 = WindowsNamedPipeAgentIpc.b(-1272165420 - -((char)-31586), -1272165420 - -17079, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1272165420 - -((char)-31584), -1272165420 - -26160, (int)l2) + this.state;
                throw new IllegalArgumentException(string4.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1272165420 - -((char)-31582), -1272165420 - -((char)-26073), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-1272165420 - -((char)-31586), -1272165420 - -17079, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1272165420 - -((char)-31596), 1272165420 - 26984, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 69052259686619L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-2070512790 - -((char)-31136), 2070512790 - (char)-6495, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 60752220508327L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(91880070 + 3889, -91880070 + -4486, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u0001T\u00bd\u00f1\u009f`\u00f1\u00d3\u00f7\u00bdN\u00f7\u00da\u008e\u00eb~7\u00f1\u00fb\u0014/cx\u0011<\u00be\u00f8\u008dTp\u00ff\u009a.\u00da\u00b4\u007f1\u0017<n";
                        var4_3 = "\u0001T\u00bd\u00f1\u009f`\u00f1\u00d3\u00f7\u00bdN\u00f7\u00da\u008e\u00eb~7\u00f1\u00fb\u0014/cx\u0011<\u00be\u00f8\u008dTp\u00ff\u009a.\u00da\u00b4\u007f1\u0017<n".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 14;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 126;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 9;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 73;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 21;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 57;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 35;
                                        break;
                                    }
                                    default: {
                                        v11 = 60;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xFFFFD911) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 209;
                            case 1 -> 184;
                            case 2 -> 0;
                            case 3 -> 179;
                            case 4 -> 147;
                            case 5 -> 82;
                            case 6 -> 19;
                            case 7 -> 193;
                            case 8 -> 120;
                            case 9 -> 52;
                            case 10 -> 137;
                            case 11 -> 67;
                            case 12 -> 81;
                            case 13 -> 162;
                            case 14 -> 119;
                            case 15 -> 20;
                            case 16 -> 6;
                            case 17 -> 17;
                            case 18 -> 36;
                            case 19 -> 26;
                            case 20 -> 107;
                            case 21 -> 111;
                            case 22 -> 174;
                            case 23 -> 222;
                            case 24 -> 71;
                            case 25 -> 21;
                            case 26 -> 98;
                            case 27 -> 227;
                            case 28 -> 12;
                            case 29 -> 161;
                            case 30 -> 58;
                            case 31 -> 23;
                            case 32 -> 136;
                            case 33 -> 210;
                            case 34 -> 165;
                            case 35 -> 205;
                            case 36 -> 62;
                            case 37 -> 231;
                            case 38 -> 7;
                            case 39 -> 50;
                            case 40 -> 24;
                            case 41 -> 198;
                            case 42 -> 37;
                            case 43 -> 117;
                            case 44 -> 228;
                            case 45 -> 213;
                            case 46 -> 76;
                            case 47 -> 78;
                            case 48 -> 87;
                            case 49 -> 99;
                            case 50 -> 80;
                            case 51 -> 44;
                            case 52 -> 30;
                            case 53 -> 154;
                            case 54 -> 148;
                            case 55 -> 29;
                            case 56 -> 241;
                            case 57 -> 100;
                            case 58 -> 159;
                            case 59 -> 46;
                            case 60 -> 248;
                            case 61 -> 245;
                            case 62 -> 225;
                            case 63 -> 200;
                            case 64 -> 194;
                            case 65 -> 211;
                            case 66 -> 127;
                            case 67 -> 164;
                            case 68 -> 246;
                            case 69 -> 55;
                            case 70 -> 177;
                            case 71 -> 243;
                            case 72 -> 49;
                            case 73 -> 236;
                            case 74 -> 47;
                            case 75 -> 94;
                            case 76 -> 102;
                            case 77 -> 90;
                            case 78 -> 97;
                            case 79 -> 250;
                            case 80 -> 239;
                            case 81 -> 218;
                            case 82 -> 199;
                            case 83 -> 244;
                            case 84 -> 28;
                            case 85 -> 114;
                            case 86 -> 254;
                            case 87 -> 192;
                            case 88 -> 121;
                            case 89 -> 33;
                            case 90 -> 92;
                            case 91 -> 128;
                            case 92 -> 219;
                            case 93 -> 183;
                            case 94 -> 10;
                            case 95 -> 34;
                            case 96 -> 208;
                            case 97 -> 45;
                            case 98 -> 63;
                            case 99 -> 169;
                            case 100 -> 57;
                            case 101 -> 54;
                            case 102 -> 156;
                            case 103 -> 125;
                            case 104 -> 255;
                            case 105 -> 182;
                            case 106 -> 171;
                            case 107 -> 22;
                            case 108 -> 233;
                            case 109 -> 73;
                            case 110 -> 72;
                            case 111 -> 3;
                            case 112 -> 89;
                            case 113 -> 15;
                            case 114 -> 142;
                            case 115 -> 91;
                            case 116 -> 158;
                            case 117 -> 13;
                            case 118 -> 130;
                            case 119 -> 143;
                            case 120 -> 86;
                            case 121 -> 188;
                            case 122 -> 61;
                            case 123 -> 85;
                            case 124 -> 108;
                            case 125 -> 84;
                            case 126 -> 101;
                            case 127 -> 144;
                            case 128 -> 126;
                            case 129 -> 40;
                            case 130 -> 138;
                            case 131 -> 212;
                            case 132 -> 95;
                            case 133 -> 185;
                            case 134 -> 18;
                            case 135 -> 116;
                            case 136 -> 43;
                            case 137 -> 75;
                            case 138 -> 235;
                            case 139 -> 140;
                            case 140 -> 96;
                            case 141 -> 131;
                            case 142 -> 152;
                            case 143 -> 197;
                            case 144 -> 157;
                            case 145 -> 118;
                            case 146 -> 64;
                            case 147 -> 180;
                            case 148 -> 83;
                            case 149 -> 151;
                            case 150 -> 206;
                            case 151 -> 166;
                            case 152 -> 141;
                            case 153 -> 224;
                            case 154 -> 150;
                            case 155 -> 69;
                            case 156 -> 216;
                            case 157 -> 1;
                            case 158 -> 242;
                            case 159 -> 51;
                            case 160 -> 175;
                            case 161 -> 202;
                            case 162 -> 207;
                            case 163 -> 201;
                            case 164 -> 214;
                            case 165 -> 123;
                            case 166 -> 217;
                            case 167 -> 41;
                            case 168 -> 113;
                            case 169 -> 133;
                            case 170 -> 88;
                            case 171 -> 172;
                            case 172 -> 65;
                            case 173 -> 251;
                            case 174 -> 229;
                            case 175 -> 25;
                            case 176 -> 16;
                            case 177 -> 27;
                            case 178 -> 59;
                            case 179 -> 32;
                            case 180 -> 149;
                            case 181 -> 170;
                            case 182 -> 53;
                            case 183 -> 115;
                            case 184 -> 39;
                            case 185 -> 74;
                            case 186 -> 189;
                            case 187 -> 173;
                            case 188 -> 195;
                            case 189 -> 105;
                            case 190 -> 163;
                            case 191 -> 247;
                            case 192 -> 110;
                            case 193 -> 253;
                            case 194 -> 31;
                            case 195 -> 167;
                            case 196 -> 240;
                            case 197 -> 14;
                            case 198 -> 132;
                            case 199 -> 79;
                            case 200 -> 221;
                            case 201 -> 104;
                            case 202 -> 5;
                            case 203 -> 168;
                            case 204 -> 135;
                            case 205 -> 9;
                            case 206 -> 230;
                            case 207 -> 112;
                            case 208 -> 48;
                            case 209 -> 77;
                            case 210 -> 238;
                            case 211 -> 106;
                            case 212 -> 145;
                            case 213 -> 56;
                            case 214 -> 2;
                            case 215 -> 66;
                            case 216 -> 155;
                            case 217 -> 178;
                            case 218 -> 234;
                            case 219 -> 146;
                            case 220 -> 191;
                            case 221 -> 70;
                            case 222 -> 35;
                            case 223 -> 124;
                            case 224 -> 109;
                            case 225 -> 68;
                            case 226 -> 8;
                            case 227 -> 196;
                            case 228 -> 134;
                            case 229 -> 139;
                            case 230 -> 226;
                            case 231 -> 186;
                            case 232 -> 232;
                            case 233 -> 204;
                            case 234 -> 249;
                            case 235 -> 93;
                            case 236 -> 252;
                            case 237 -> 181;
                            case 238 -> 38;
                            case 239 -> 223;
                            case 240 -> 176;
                            case 241 -> 60;
                            case 242 -> 190;
                            case 243 -> 122;
                            case 244 -> 237;
                            case 245 -> 42;
                            case 246 -> 203;
                            case 247 -> 220;
                            case 248 -> 153;
                            case 249 -> 215;
                            case 250 -> 103;
                            case 251 -> 11;
                            case 252 -> 4;
                            case 253 -> 160;
                            case 254 -> 129;
                            default -> 187;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (string != null) {
                ActionTimestamp.Y(new ActionTimestamp[4]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 34253302238911L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    String string = SshAgentIpcService.Y();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (string != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-938067990 - -12522, -938067990 - -9583, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-938067990 - -12518, -938067990 + -449, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-938067990 - -12513, -938067990 + -1553, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-938067990 - -12522, -938067990 - -9583, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-938067990 - -12518, -938067990 + -449, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-938067990 - -12514, 938067990 + 7286, (int)l3) + ErrorToolsKt.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    String string2;
                    block13: {
                        long l2 = 103215212879758L;
                        String string3 = SshAgentIpcService.Y();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(1441245720 - (char)-4068, 1441245720 - (char)-10163, (int)l2));
                        string2 = string3;
                        try {
                            try {
                                try {
                                    try {
                                        if (string2 != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string4 = object.toString();
                                string = string4;
                                object = string4;
                                if (string2 != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(1441245720 - (char)-4071, 1441114650 + (char)-6000, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (string2 != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        String string;
        long l2;
        block25: {
            block26: {
                l2 = 86178359346910L;
                String string2 = SshAgentIpcService.Y();
                this.assertConnectionThread();
                string = string2;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (string != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (string != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(159381120 + (char)-5579, 159381120 + (char)-8520, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(159381120 + (char)-5583, 159381120 + (char)-14392, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(159381120 + (char)-5586, 159381120 + (char)-696, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string3 = WindowsNamedPipeAgentIpc.b(159381120 + (char)-5583, 159381120 + (char)-14392, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(159381120 + (char)-5577, 159381120 + (char)-29625, (int)l2) + this.state;
                        throw new IllegalArgumentException(string3.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(159381120 + (char)-5579, 159381120 + (char)-8520, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(159381120 + (char)-5583, 159381120 + (char)-14392, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(159381120 + (char)-5599, 159381120 + (char)-10804, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (string != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(159381120 + (char)-5579, 159381120 + (char)-8520, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(159381120 + (char)-5583, 159381120 + (char)-14392, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(159381120 + (char)-5600, 159381120 + (char)-29888, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (string != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(159381120 + (char)-5579, 159381120 + (char)-8520, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(159381120 + (char)-5583, 159381120 + (char)-14392, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(159381120 + (char)-5597, -159512190 - -((char)-1037), (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                String string;
                block16: {
                    l2 = 108092209008717L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                string = SshAgentIpcService.Y();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (string != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-767021640 + -((char)-18542), -767021640 + -((char)-5619), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-767021640 + -((char)-18538), -767152710 - -((char)-1247), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-767021640 + -((char)-18553), 767021640 + (char)-6932, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-767021640 + -((char)-18558), 767152710 - (char)-9578, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-767021640 + -((char)-18542), -767021640 + -((char)-5619), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-767021640 + -((char)-18538), -767152710 - -((char)-1247), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-767021640 + -((char)-18559), -767021640 + -((char)-20135), (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (string != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (string != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-767021640 + -((char)-18542), -767021640 + -((char)-5619), (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-767021640 + -((char)-18538), -767152710 - -((char)-1247), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-767021640 + -((char)-18556), -767021640 + -((char)-13734), (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-767021640 + -((char)-18542), -767021640 + -((char)-5619), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-767021640 + -((char)-18538), -767152710 - -((char)-1247), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-767021640 + -((char)-18557), 767021640 + (char)-3634, (int)l2));
                    if (string != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-767021640 + -((char)-18542), -767021640 + -((char)-5619), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-767021640 + -((char)-18538), -767152710 - -((char)-1247), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-767021640 + -((char)-18514), -767021640 + -((char)-2040), (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-767021640 + -((char)-18515), -767152710 - -((char)-6115), (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00a8_\u00f5m\u00ff#:\u00e1\u0014h\u008b\u00d5\u0010\u0005\u0004\u00ca\u001f\u0093\u00f8\u00da]\u00b6\u00c9\u00ec\u00cc\u0086\u00ee\u0083{\u0006/\u00e7\u0005z\u008b\u0080\u0018<B?\u0019\u00da\u00e03Cd\u000e+\u00f3\u00ee\u00e3\u00b5\u000b\u0004\u007f\u00fd\u00d4\u00e9P\u00ed\u0010\t\u00c3\u00a8^\u00f5\u009d\u00e2\u00c3KF\u0005<\u00cfg\u007f\u00dd\bN|)x6\u00a7\u0005\u0093\u0014\u0001\u00e0\u0080\u00e6\u00c2\u00d2\u0007RD\u008c\u008bg\u00d6-[\u00bdb\u0013\u00e6\u0086\u0005\tp\u00c1\u0088\t\u001eS1\u009f\u00c4_\u009f!\u00d6\u0083\u00a8\u009c\u00a0T\u00a9@&[K\u00c4\u00a6b1\u0090\u00f1\u00ed\u00d9\u0004\u0083n\u0081\u0010\u0003\u0086q\u00f7\u00d5\u00cb\u0086\u00a5\nt \u00c6\u00c50\u00dd\u008a\t\u0013\u00c7\u0092\tWZ\u00bc\u00c3G\u0010Ar9i\u00dc\u0018\u00a7\u00df.;\u00a4/U\r\u00cf-?\u0090\u00a3\u00ef\u0096\\\u00dc\u00c4\u00d2N\u00f9`qtey\u0086\u00b9:\u00e5M\u00c8\u001e\u00ber8A\u00b3$\u00af#\u009c\u0095^\u00cbh\u00b9\u00d12\u00ee\nt\u0001\u00e4+\u0013\u00e1\u00c1\u00cdq\u0082'\u0090)\u0002\u00be\u00fb\u00ad\u00a9\u000b\u00ee\u0080\u00d3<\b\u00d4\u00e1z\u00cb\\\u00d1H]\f\u009c\u0089c\u00ddbqaN\u00dfA\u00c8dF\u00bd\u00bcG{\u00e6\u00a5\u00f1\u00d4\u00cd\u001e\u0080K\u00fe*7I\u008c\u00a4C1\u000e\u00c3e\u00fbu[\u00e9l[\u00038\u00ad\u00f6z\u00bf\u00ae\u00f1\u009dA;\u00122\u00a3\u00b6%\u00d7Sv\u00c4\r\u00f7\u00cb\u00dc\u00ff\u0016_'I\u00ccNK\u00ae\u0019\u009fE\u00b9\u0096\u00d9\u00de\u00f1\u001f\u009at\u00a6lx\u008a\u00c5t\u001f\u00fc\u000f*&\u00e5\u0005\u001e\u0088\u00a4\u00c3\u0091IW\"\u0096\u00da\u00e5\u00f5\u00c8M\u0019\u00f8\u000b\u00f2G\u00ae\u0004\u00dbJV)9\u00a1\u001e\u0015qp\u00de\u00e1\u00d2\u009e\u009b\u00ce\u00be\u00bd&\u00c9\u00bd5kR\u00be\u00b9\u00d8K\u001c)m~X-\u00a7\u00a2>q`\\\u00e0>\u00dfm\u00a4\n\u00e3\u00aeuwo\u00f3 \u001a\u00f5=\u00c7\u00ab$\u0081W\u00c3\u00e5\u0012\u00bb.o\u0090\u00193\u00ba\u0007\u0012\u0005\u00bdX?Q\u00b6\u0007 \u00bb\u009f\u00e3\u009c\u00c9\u00d4(\u0097\u00ffK<u\u00ea\u0092_\u0085NvJ.b\u00d8hkO\u00ca\b\u00f9\"\u009d\u00eb\u00d2\u00bf\u0095\u0080Y\u0084#z\u0090N\u008b\b\u00d3)\u001d\u00f7\u000f&\u00a63>\u0092\u00c6\u00cb\u0019\u00db\u000b\u001c\u00b3\u00c3\t\u00fb\"\u0015\u00a4WvF\u00c9\u0002\u001c\u00e7\u00f1\u0010\u008b\u00c2\u00d7c\u0093\u00f0\u00b4\u009dv\u0098\u00d3~N\u00ad\u00e3\u0001\u00ae\u00d8\u0013j\u0096lK\u000eww\u0019\u0004\u00d7\u0081c\u00f1\u00ce\u0016\u00be\u0010\u009bw\u001bM\u00c7Y\u0017$V\u0088W\u00e4Ev{\u00d2,G\u00fa\u00dc3\u00a5\u001a\u00a4j\u008a\u00dfx\u00bc\u00ee\n\u00a8\\!c?<80Y\u00cb\u0018\r;Q\u0085$\u00b8\u00a9\u00d4\u00de\u00fc\u00f3\u00d3\u00dbj\u009a\u0013\u0010\u000f\u00eb\u00e4\u0015\u00fe\u00e7\u001e)\u00a8\u00d0\u00e0\u00f8\u00b0\u0018\u00dc&<\u00b6kc\u00aa\u00cf\u0095%\u00bb>\u00a1\u00a0\u00cf\u0019}K+\u0085\u0081P\u00bf\u00a2\u009f6\u00d9r\u00e9\u00b6\u00fb\u00a7\u008b\u00d5\u00e8\t\u00c2\u0081\u00a8\u00df\u001aOC:\u0005";
                var4_3 = "\u00a8_\u00f5m\u00ff#:\u00e1\u0014h\u008b\u00d5\u0010\u0005\u0004\u00ca\u001f\u0093\u00f8\u00da]\u00b6\u00c9\u00ec\u00cc\u0086\u00ee\u0083{\u0006/\u00e7\u0005z\u008b\u0080\u0018<B?\u0019\u00da\u00e03Cd\u000e+\u00f3\u00ee\u00e3\u00b5\u000b\u0004\u007f\u00fd\u00d4\u00e9P\u00ed\u0010\t\u00c3\u00a8^\u00f5\u009d\u00e2\u00c3KF\u0005<\u00cfg\u007f\u00dd\bN|)x6\u00a7\u0005\u0093\u0014\u0001\u00e0\u0080\u00e6\u00c2\u00d2\u0007RD\u008c\u008bg\u00d6-[\u00bdb\u0013\u00e6\u0086\u0005\tp\u00c1\u0088\t\u001eS1\u009f\u00c4_\u009f!\u00d6\u0083\u00a8\u009c\u00a0T\u00a9@&[K\u00c4\u00a6b1\u0090\u00f1\u00ed\u00d9\u0004\u0083n\u0081\u0010\u0003\u0086q\u00f7\u00d5\u00cb\u0086\u00a5\nt \u00c6\u00c50\u00dd\u008a\t\u0013\u00c7\u0092\tWZ\u00bc\u00c3G\u0010Ar9i\u00dc\u0018\u00a7\u00df.;\u00a4/U\r\u00cf-?\u0090\u00a3\u00ef\u0096\\\u00dc\u00c4\u00d2N\u00f9`qtey\u0086\u00b9:\u00e5M\u00c8\u001e\u00ber8A\u00b3$\u00af#\u009c\u0095^\u00cbh\u00b9\u00d12\u00ee\nt\u0001\u00e4+\u0013\u00e1\u00c1\u00cdq\u0082'\u0090)\u0002\u00be\u00fb\u00ad\u00a9\u000b\u00ee\u0080\u00d3<\b\u00d4\u00e1z\u00cb\\\u00d1H]\f\u009c\u0089c\u00ddbqaN\u00dfA\u00c8dF\u00bd\u00bcG{\u00e6\u00a5\u00f1\u00d4\u00cd\u001e\u0080K\u00fe*7I\u008c\u00a4C1\u000e\u00c3e\u00fbu[\u00e9l[\u00038\u00ad\u00f6z\u00bf\u00ae\u00f1\u009dA;\u00122\u00a3\u00b6%\u00d7Sv\u00c4\r\u00f7\u00cb\u00dc\u00ff\u0016_'I\u00ccNK\u00ae\u0019\u009fE\u00b9\u0096\u00d9\u00de\u00f1\u001f\u009at\u00a6lx\u008a\u00c5t\u001f\u00fc\u000f*&\u00e5\u0005\u001e\u0088\u00a4\u00c3\u0091IW\"\u0096\u00da\u00e5\u00f5\u00c8M\u0019\u00f8\u000b\u00f2G\u00ae\u0004\u00dbJV)9\u00a1\u001e\u0015qp\u00de\u00e1\u00d2\u009e\u009b\u00ce\u00be\u00bd&\u00c9\u00bd5kR\u00be\u00b9\u00d8K\u001c)m~X-\u00a7\u00a2>q`\\\u00e0>\u00dfm\u00a4\n\u00e3\u00aeuwo\u00f3 \u001a\u00f5=\u00c7\u00ab$\u0081W\u00c3\u00e5\u0012\u00bb.o\u0090\u00193\u00ba\u0007\u0012\u0005\u00bdX?Q\u00b6\u0007 \u00bb\u009f\u00e3\u009c\u00c9\u00d4(\u0097\u00ffK<u\u00ea\u0092_\u0085NvJ.b\u00d8hkO\u00ca\b\u00f9\"\u009d\u00eb\u00d2\u00bf\u0095\u0080Y\u0084#z\u0090N\u008b\b\u00d3)\u001d\u00f7\u000f&\u00a63>\u0092\u00c6\u00cb\u0019\u00db\u000b\u001c\u00b3\u00c3\t\u00fb\"\u0015\u00a4WvF\u00c9\u0002\u001c\u00e7\u00f1\u0010\u008b\u00c2\u00d7c\u0093\u00f0\u00b4\u009dv\u0098\u00d3~N\u00ad\u00e3\u0001\u00ae\u00d8\u0013j\u0096lK\u000eww\u0019\u0004\u00d7\u0081c\u00f1\u00ce\u0016\u00be\u0010\u009bw\u001bM\u00c7Y\u0017$V\u0088W\u00e4Ev{\u00d2,G\u00fa\u00dc3\u00a5\u001a\u00a4j\u008a\u00dfx\u00bc\u00ee\n\u00a8\\!c?<80Y\u00cb\u0018\r;Q\u0085$\u00b8\u00a9\u00d4\u00de\u00fc\u00f3\u00d3\u00dbj\u009a\u0013\u0010\u000f\u00eb\u00e4\u0015\u00fe\u00e7\u001e)\u00a8\u00d0\u00e0\u00f8\u00b0\u0018\u00dc&<\u00b6kc\u00aa\u00cf\u0095%\u00bb>\u00a1\u00a0\u00cf\u0019}K+\u0085\u0081P\u00bf\u00a2\u009f6\u00d9r\u00e9\u00b6\u00fb\u00a7\u008b\u00d5\u00e8\t\u00c2\u0081\u00a8\u00df\u001aOC:\u0005".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 36;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u009cl\u00ca\u00c3Y\u00d3M\u00f3\u00a2\u00a0\u0014\r\u00e9\u00aeQ\u00a5\u008f\u008e\u00db\u009eyM\u00f4\u00b3\u001d*zL\u00fc\u0014/\u009d\u0091~!e\u00e2\u009f:DCf)\u0002\u00b3\u0019\u00c1\u00f8\u00c7\u0015";
                    var4_3 = "\u009cl\u00ca\u00c3Y\u00d3M\u00f3\u00a2\u00a0\u0014\r\u00e9\u00aeQ\u00a5\u008f\u008e\u00db\u009eyM\u00f4\u00b3\u001d*zL\u00fc\u0014/\u009d\u0091~!e\u00e2\u009f:DCf)\u0002\u00b3\u0019\u00c1\u00f8\u00c7\u0015".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 41;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 73;
                            break;
                        }
                        case 1: {
                            v15 = 11;
                            break;
                        }
                        case 2: {
                            v15 = 103;
                            break;
                        }
                        case 3: {
                            v15 = 102;
                            break;
                        }
                        case 4: {
                            v15 = 35;
                            break;
                        }
                        case 5: {
                            v15 = 74;
                            break;
                        }
                        default: {
                            v15 = 47;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFE667) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 249;
                case 1 -> 30;
                case 2 -> 211;
                case 3 -> 47;
                case 4 -> 237;
                case 5 -> 243;
                case 6 -> 117;
                case 7 -> 231;
                case 8 -> 200;
                case 9 -> 173;
                case 10 -> 91;
                case 11 -> 112;
                case 12 -> 245;
                case 13 -> 86;
                case 14 -> 75;
                case 15 -> 203;
                case 16 -> 244;
                case 17 -> 26;
                case 18 -> 39;
                case 19 -> 157;
                case 20 -> 242;
                case 21 -> 44;
                case 22 -> 2;
                case 23 -> 189;
                case 24 -> 218;
                case 25 -> 144;
                case 26 -> 139;
                case 27 -> 59;
                case 28 -> 64;
                case 29 -> 227;
                case 30 -> 168;
                case 31 -> 72;
                case 32 -> 95;
                case 33 -> 134;
                case 34 -> 187;
                case 35 -> 94;
                case 36 -> 105;
                case 37 -> 53;
                case 38 -> 232;
                case 39 -> 80;
                case 40 -> 1;
                case 41 -> 96;
                case 42 -> 178;
                case 43 -> 138;
                case 44 -> 155;
                case 45 -> 29;
                case 46 -> 37;
                case 47 -> 221;
                case 48 -> 166;
                case 49 -> 99;
                case 50 -> 111;
                case 51 -> 66;
                case 52 -> 85;
                case 53 -> 62;
                case 54 -> 73;
                case 55 -> 202;
                case 56 -> 14;
                case 57 -> 162;
                case 58 -> 217;
                case 59 -> 169;
                case 60 -> 182;
                case 61 -> 24;
                case 62 -> 5;
                case 63 -> 0;
                case 64 -> 121;
                case 65 -> 191;
                case 66 -> 107;
                case 67 -> 141;
                case 68 -> 69;
                case 69 -> 234;
                case 70 -> 143;
                case 71 -> 82;
                case 72 -> 68;
                case 73 -> 9;
                case 74 -> 175;
                case 75 -> 33;
                case 76 -> 101;
                case 77 -> 230;
                case 78 -> 156;
                case 79 -> 148;
                case 80 -> 65;
                case 81 -> 222;
                case 82 -> 195;
                case 83 -> 106;
                case 84 -> 7;
                case 85 -> 213;
                case 86 -> 147;
                case 87 -> 83;
                case 88 -> 126;
                case 89 -> 151;
                case 90 -> 140;
                case 91 -> 21;
                case 92 -> 158;
                case 93 -> 49;
                case 94 -> 109;
                case 95 -> 89;
                case 96 -> 184;
                case 97 -> 103;
                case 98 -> 74;
                case 99 -> 246;
                case 100 -> 130;
                case 101 -> 174;
                case 102 -> 172;
                case 103 -> 159;
                case 104 -> 61;
                case 105 -> 4;
                case 106 -> 193;
                case 107 -> 146;
                case 108 -> 192;
                case 109 -> 34;
                case 110 -> 239;
                case 111 -> 79;
                case 112 -> 104;
                case 113 -> 128;
                case 114 -> 67;
                case 115 -> 129;
                case 116 -> 10;
                case 117 -> 171;
                case 118 -> 194;
                case 119 -> 236;
                case 120 -> 220;
                case 121 -> 161;
                case 122 -> 28;
                case 123 -> 88;
                case 124 -> 45;
                case 125 -> 153;
                case 126 -> 164;
                case 127 -> 54;
                case 128 -> 250;
                case 129 -> 102;
                case 130 -> 180;
                case 131 -> 238;
                case 132 -> 42;
                case 133 -> 127;
                case 134 -> 254;
                case 135 -> 71;
                case 136 -> 38;
                case 137 -> 253;
                case 138 -> 204;
                case 139 -> 215;
                case 140 -> 224;
                case 141 -> 25;
                case 142 -> 183;
                case 143 -> 113;
                case 144 -> 240;
                case 145 -> 31;
                case 146 -> 3;
                case 147 -> 118;
                case 148 -> 6;
                case 149 -> 208;
                case 150 -> 32;
                case 151 -> 210;
                case 152 -> 252;
                case 153 -> 18;
                case 154 -> 97;
                case 155 -> 19;
                case 156 -> 92;
                case 157 -> 226;
                case 158 -> 43;
                case 159 -> 52;
                case 160 -> 165;
                case 161 -> 185;
                case 162 -> 160;
                case 163 -> 205;
                case 164 -> 137;
                case 165 -> 199;
                case 166 -> 17;
                case 167 -> 136;
                case 168 -> 125;
                case 169 -> 50;
                case 170 -> 77;
                case 171 -> 229;
                case 172 -> 76;
                case 173 -> 98;
                case 174 -> 15;
                case 175 -> 198;
                case 176 -> 225;
                case 177 -> 142;
                case 178 -> 116;
                case 179 -> 27;
                case 180 -> 63;
                case 181 -> 108;
                case 182 -> 196;
                case 183 -> 131;
                case 184 -> 207;
                case 185 -> 150;
                case 186 -> 214;
                case 187 -> 216;
                case 188 -> 201;
                case 189 -> 120;
                case 190 -> 167;
                case 191 -> 8;
                case 192 -> 154;
                case 193 -> 135;
                case 194 -> 212;
                case 195 -> 188;
                case 196 -> 186;
                case 197 -> 20;
                case 198 -> 152;
                case 199 -> 163;
                case 200 -> 36;
                case 201 -> 81;
                case 202 -> 90;
                case 203 -> 197;
                case 204 -> 110;
                case 205 -> 114;
                case 206 -> 145;
                case 207 -> 251;
                case 208 -> 223;
                case 209 -> 181;
                case 210 -> 16;
                case 211 -> 12;
                case 212 -> 206;
                case 213 -> 40;
                case 214 -> 41;
                case 215 -> 70;
                case 216 -> 228;
                case 217 -> 170;
                case 218 -> 93;
                case 219 -> 51;
                case 220 -> 56;
                case 221 -> 247;
                case 222 -> 179;
                case 223 -> 123;
                case 224 -> 100;
                case 225 -> 124;
                case 226 -> 209;
                case 227 -> 219;
                case 228 -> 177;
                case 229 -> 190;
                case 230 -> 57;
                case 231 -> 13;
                case 232 -> 241;
                case 233 -> 149;
                case 234 -> 46;
                case 235 -> 233;
                case 236 -> 255;
                case 237 -> 119;
                case 238 -> 11;
                case 239 -> 133;
                case 240 -> 248;
                case 241 -> 176;
                case 242 -> 115;
                case 243 -> 78;
                case 244 -> 22;
                case 245 -> 235;
                case 246 -> 87;
                case 247 -> 132;
                case 248 -> 23;
                case 249 -> 35;
                case 250 -> 60;
                case 251 -> 48;
                case 252 -> 55;
                case 253 -> 84;
                case 254 -> 122;
                default -> 58;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 37058523700525L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1545839580 + (char)-13450, 1545839580 + (char)-11643, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        String string;
                        block4: {
                            l2 = 116804580472917L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            string = SshAgentIpcService.Y();
                            try {
                                hANDLE2 = hANDLE;
                                if (string != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (string != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1350152070 - -14769, -1350152070 - -16104, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1350152070 - -14766, 1350152070 - 15773, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1350152070 - -14767, -1350152070 - -((char)-23784), (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00bd\u00e5\u00e2\u0011\u00f4\\\u00ad\u0090\u0010\u00f6\u0012zN]\fa\u00c3d\r\u00c6\u0000\u00e9\u001e\u00c6\u00dd";
                    var4_3 = "\u00bd\u00e5\u00e2\u0011\u00f4\\\u00ad\u0090\u0010\u00f6\u0012zN]\fa\u00c3d\r\u00c6\u0000\u00e9\u001e\u00c6\u00dd".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 23;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00de\u001c(\u0088{5\u009b\u00eb\u0097\u001a^\u0019\u00bfln\u00e5\u00b3{\u0016=\u009a\u0095\u00c8\u001c\u0013NZ\u00c3t\u008e\u008d>L\u00b1\u00f8\u0095\u00b4\u0089\u00e8\u00a2\u00ea\u00edp\u0081\u0013X-4`Q\u00c5\u00c8\u00a6,yp\u0001\u00f8%";
                        var4_3 = "\u00de\u001c(\u0088{5\u009b\u00eb\u0097\u001a^\u0019\u00bfln\u00e5\u00b3{\u0016=\u009a\u0095\u00c8\u001c\u0013NZ\u00c3t\u008e\u008d>L\u00b1\u00f8\u0095\u00b4\u0089\u00e8\u00a2\u00ea\u00edp\u0081\u0013X-4`Q\u00c5\u00c8\u00a6,yp\u0001\u00f8%".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 88;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 110;
                                break;
                            }
                            case 1: {
                                v15 = 72;
                                break;
                            }
                            case 2: {
                                v15 = 99;
                                break;
                            }
                            case 3: {
                                v15 = 112;
                                break;
                            }
                            case 4: {
                                v15 = 31;
                                break;
                            }
                            case 5: {
                                v15 = 45;
                                break;
                            }
                            default: {
                                v15 = 11;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x727F) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 144;
                    case 1 -> 240;
                    case 2 -> 180;
                    case 3 -> 46;
                    case 4 -> 117;
                    case 5 -> 147;
                    case 6 -> 167;
                    case 7 -> 95;
                    case 8 -> 66;
                    case 9 -> 96;
                    case 10 -> 97;
                    case 11 -> 234;
                    case 12 -> 0;
                    case 13 -> 50;
                    case 14 -> 52;
                    case 15 -> 70;
                    case 16 -> 166;
                    case 17 -> 60;
                    case 18 -> 183;
                    case 19 -> 115;
                    case 20 -> 108;
                    case 21 -> 92;
                    case 22 -> 64;
                    case 23 -> 85;
                    case 24 -> 125;
                    case 25 -> 33;
                    case 26 -> 195;
                    case 27 -> 229;
                    case 28 -> 131;
                    case 29 -> 105;
                    case 30 -> 199;
                    case 31 -> 135;
                    case 32 -> 254;
                    case 33 -> 4;
                    case 34 -> 179;
                    case 35 -> 138;
                    case 36 -> 3;
                    case 37 -> 74;
                    case 38 -> 15;
                    case 39 -> 58;
                    case 40 -> 42;
                    case 41 -> 82;
                    case 42 -> 141;
                    case 43 -> 81;
                    case 44 -> 156;
                    case 45 -> 250;
                    case 46 -> 84;
                    case 47 -> 34;
                    case 48 -> 178;
                    case 49 -> 251;
                    case 50 -> 5;
                    case 51 -> 68;
                    case 52 -> 143;
                    case 53 -> 41;
                    case 54 -> 112;
                    case 55 -> 83;
                    case 56 -> 185;
                    case 57 -> 116;
                    case 58 -> 221;
                    case 59 -> 56;
                    case 60 -> 93;
                    case 61 -> 29;
                    case 62 -> 2;
                    case 63 -> 87;
                    case 64 -> 241;
                    case 65 -> 215;
                    case 66 -> 191;
                    case 67 -> 242;
                    case 68 -> 231;
                    case 69 -> 101;
                    case 70 -> 202;
                    case 71 -> 40;
                    case 72 -> 171;
                    case 73 -> 189;
                    case 74 -> 14;
                    case 75 -> 200;
                    case 76 -> 218;
                    case 77 -> 228;
                    case 78 -> 61;
                    case 79 -> 204;
                    case 80 -> 188;
                    case 81 -> 123;
                    case 82 -> 169;
                    case 83 -> 159;
                    case 84 -> 102;
                    case 85 -> 26;
                    case 86 -> 54;
                    case 87 -> 182;
                    case 88 -> 23;
                    case 89 -> 31;
                    case 90 -> 80;
                    case 91 -> 55;
                    case 92 -> 24;
                    case 93 -> 90;
                    case 94 -> 252;
                    case 95 -> 28;
                    case 96 -> 177;
                    case 97 -> 174;
                    case 98 -> 193;
                    case 99 -> 57;
                    case 100 -> 132;
                    case 101 -> 27;
                    case 102 -> 20;
                    case 103 -> 253;
                    case 104 -> 106;
                    case 105 -> 201;
                    case 106 -> 130;
                    case 107 -> 239;
                    case 108 -> 203;
                    case 109 -> 21;
                    case 110 -> 122;
                    case 111 -> 224;
                    case 112 -> 110;
                    case 113 -> 145;
                    case 114 -> 9;
                    case 115 -> 151;
                    case 116 -> 237;
                    case 117 -> 146;
                    case 118 -> 150;
                    case 119 -> 196;
                    case 120 -> 129;
                    case 121 -> 59;
                    case 122 -> 255;
                    case 123 -> 114;
                    case 124 -> 157;
                    case 125 -> 13;
                    case 126 -> 37;
                    case 127 -> 30;
                    case 128 -> 62;
                    case 129 -> 88;
                    case 130 -> 194;
                    case 131 -> 186;
                    case 132 -> 77;
                    case 133 -> 209;
                    case 134 -> 243;
                    case 135 -> 44;
                    case 136 -> 162;
                    case 137 -> 134;
                    case 138 -> 103;
                    case 139 -> 38;
                    case 140 -> 18;
                    case 141 -> 192;
                    case 142 -> 213;
                    case 143 -> 79;
                    case 144 -> 25;
                    case 145 -> 176;
                    case 146 -> 118;
                    case 147 -> 16;
                    case 148 -> 217;
                    case 149 -> 137;
                    case 150 -> 206;
                    case 151 -> 53;
                    case 152 -> 227;
                    case 153 -> 43;
                    case 154 -> 208;
                    case 155 -> 249;
                    case 156 -> 236;
                    case 157 -> 187;
                    case 158 -> 198;
                    case 159 -> 139;
                    case 160 -> 232;
                    case 161 -> 158;
                    case 162 -> 246;
                    case 163 -> 107;
                    case 164 -> 190;
                    case 165 -> 222;
                    case 166 -> 65;
                    case 167 -> 212;
                    case 168 -> 1;
                    case 169 -> 104;
                    case 170 -> 113;
                    case 171 -> 223;
                    case 172 -> 226;
                    case 173 -> 48;
                    case 174 -> 238;
                    case 175 -> 128;
                    case 176 -> 63;
                    case 177 -> 47;
                    case 178 -> 219;
                    case 179 -> 136;
                    case 180 -> 163;
                    case 181 -> 51;
                    case 182 -> 94;
                    case 183 -> 32;
                    case 184 -> 173;
                    case 185 -> 75;
                    case 186 -> 133;
                    case 187 -> 172;
                    case 188 -> 248;
                    case 189 -> 109;
                    case 190 -> 119;
                    case 191 -> 164;
                    case 192 -> 89;
                    case 193 -> 245;
                    case 194 -> 170;
                    case 195 -> 124;
                    case 196 -> 152;
                    case 197 -> 67;
                    case 198 -> 35;
                    case 199 -> 17;
                    case 200 -> 49;
                    case 201 -> 11;
                    case 202 -> 126;
                    case 203 -> 225;
                    case 204 -> 205;
                    case 205 -> 160;
                    case 206 -> 181;
                    case 207 -> 247;
                    case 208 -> 72;
                    case 209 -> 73;
                    case 210 -> 161;
                    case 211 -> 22;
                    case 212 -> 127;
                    case 213 -> 154;
                    case 214 -> 210;
                    case 215 -> 120;
                    case 216 -> 91;
                    case 217 -> 220;
                    case 218 -> 19;
                    case 219 -> 244;
                    case 220 -> 214;
                    case 221 -> 7;
                    case 222 -> 142;
                    case 223 -> 184;
                    case 224 -> 111;
                    case 225 -> 71;
                    case 226 -> 86;
                    case 227 -> 148;
                    case 228 -> 45;
                    case 229 -> 12;
                    case 230 -> 211;
                    case 231 -> 197;
                    case 232 -> 36;
                    case 233 -> 207;
                    case 234 -> 99;
                    case 235 -> 216;
                    case 236 -> 78;
                    case 237 -> 233;
                    case 238 -> 153;
                    case 239 -> 39;
                    case 240 -> 6;
                    case 241 -> 165;
                    case 242 -> 8;
                    case 243 -> 235;
                    case 244 -> 155;
                    case 245 -> 149;
                    case 246 -> 168;
                    case 247 -> 175;
                    case 248 -> 140;
                    case 249 -> 230;
                    case 250 -> 100;
                    case 251 -> 69;
                    case 252 -> 76;
                    case 253 -> 10;
                    case 254 -> 98;
                    default -> 121;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 95382755207376L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "!\u000fO\u0000;$\u0002x\t&\u0005\\\nvf\u001fdC";
                    var5_4 = "!\u000fO\u0000;$\u0002x\t&\u0005\\\nvf\u001fdC".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 18;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 88;
                                    break;
                                }
                                case 1: {
                                    v11 = 120;
                                    break;
                                }
                                case 2: {
                                    v11 = 47;
                                    break;
                                }
                                case 3: {
                                    v11 = 124;
                                    break;
                                }
                                case 4: {
                                    v11 = 76;
                                    break;
                                }
                                case 5: {
                                    v11 = 90;
                                    break;
                                }
                                default: {
                                    v11 = 35;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 5365051187396L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "y\nR'?C\u0002\u0004\u007f\u0014^=\ns\u000bU=3A\u001aY\n\\\ts\u000bU=3A\u001aU\u0000\rt\rH09L\u0000U\u0007O:8E";
                    var5_4 = "y\nR'?C\u0002\u0004\u007f\u0014^=\ns\u000bU=3A\u001aY\n\\\ts\u000bU=3A\u001aU\u0000\rt\rH09L\u0000U\u0007O:8E".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 40;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "N5i\u001d\u0002q4\u0006N5i\u001d\u000e{";
                        var5_4 = "N5i\u001d\u0002q4\u0006N5i\u001d\u000e{".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 21;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 24;
                                break;
                            }
                            case 1: {
                                v15 = 76;
                                break;
                            }
                            case 2: {
                                v15 = 19;
                                break;
                            }
                            case 3: {
                                v15 = 123;
                                break;
                            }
                            case 4: {
                                v15 = 126;
                                break;
                            }
                            case 5: {
                                v15 = 10;
                                break;
                            }
                            default: {
                                v15 = 70;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 83557838562952L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-750113610 + -((char)-10937), -750113610 + -((char)-18361), (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 60169673311306L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = ")\u00b6\"\u008e\u008e\u0003\nE\u00f2\u0005\u00c6O\u00f9u\u0016\rX\u0014\u001cT_\u00f3\u00dc\u008aI\u00d4\u00b1\u0087\u00c8\u0010\u00dd\u00dfk\u00c6\u008e4\u00cdO\u00a2\u00e8/M\u00fda\u00cfa\u0005;\u00a1F\u00a8\u00e13\u00ca\u00bai\u00bc\u001b?O:\u008f\u00bb\u0001\u000e\u00feX\u0083Y\t\t\u000bc\u008eM}\u0005\u00f0\u0087\u0085\u00a0R\u00f6\f/i_J\u0014k.W\u00f0\u00b7\u000b\u000fq\u008b)V\u00b5\u009e^\u00f8";
                    var4_3 = ")\u00b6\"\u008e\u008e\u0003\nE\u00f2\u0005\u00c6O\u00f9u\u0016\rX\u0014\u001cT_\u00f3\u00dc\u008aI\u00d4\u00b1\u0087\u00c8\u0010\u00dd\u00dfk\u00c6\u008e4\u00cdO\u00a2\u00e8/M\u00fda\u00cfa\u0005;\u00a1F\u00a8\u00e13\u00ca\u00bai\u00bc\u001b?O:\u008f\u00bb\u0001\u000e\u00feX\u0083Y\t\t\u000bc\u008eM}\u0005\u00f0\u0087\u0085\u00a0R\u00f6\f/i_J\u0014k.W\u00f0\u00b7\u000b\u000fq\u008b)V\u00b5\u009e^\u00f8".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 36;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u008dj\u0013\u0002\u00f3\u00de\u0010`k\u007fd\u00cd\u00e6\u0003\u00de_L\u0004\u00e2\u00d5\u00d9\u0001m x\u00e4\u00ef9fC\u00f8\u00f9Y1\u00aa\u0081\u0093\u00c5EL\u00d4\u0087$<`\u00ed\u00d5fVF\u00ec\u00ac\f\u00f7\u0081\u008c\u0011\u0088\u00b8U\b\u00a7\u00aaj\u008f\u0099_\u0082)\u00da\u0086\u0094\u00cb\u008b\u00c8\u00b3\u0093\u00c9\u00af\u00ef\u00ad]L\u0007l\u00eeB\u001a\u00de\u00a2e\u00fe\u00fd";
                        var4_3 = "\u008dj\u0013\u0002\u00f3\u00de\u0010`k\u007fd\u00cd\u00e6\u0003\u00de_L\u0004\u00e2\u00d5\u00d9\u0001m x\u00e4\u00ef9fC\u00f8\u00f9Y1\u00aa\u0081\u0093\u00c5EL\u00d4\u0087$<`\u00ed\u00d5fVF\u00ec\u00ac\f\u00f7\u0081\u008c\u0011\u0088\u00b8U\b\u00a7\u00aaj\u008f\u0099_\u0082)\u00da\u0086\u0094\u00cb\u008b\u00c8\u00b3\u0093\u00c9\u00af\u00ef\u00ad]L\u0007l\u00eeB\u001a\u00de\u00a2e\u00fe\u00fd".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 125;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 31;
                                break;
                            }
                            case 1: {
                                v15 = 43;
                                break;
                            }
                            case 2: {
                                v15 = 108;
                                break;
                            }
                            case 3: {
                                v15 = 120;
                                break;
                            }
                            case 4: {
                                v15 = 90;
                                break;
                            }
                            case 5: {
                                v15 = 80;
                                break;
                            }
                            default: {
                                v15 = 32;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x71E7) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 123;
                    case 1 -> 122;
                    case 2 -> 172;
                    case 3 -> 137;
                    case 4 -> 59;
                    case 5 -> 144;
                    case 6 -> 215;
                    case 7 -> 224;
                    case 8 -> 159;
                    case 9 -> 145;
                    case 10 -> 206;
                    case 11 -> 166;
                    case 12 -> 111;
                    case 13 -> 154;
                    case 14 -> 222;
                    case 15 -> 67;
                    case 16 -> 102;
                    case 17 -> 119;
                    case 18 -> 116;
                    case 19 -> 9;
                    case 20 -> 251;
                    case 21 -> 202;
                    case 22 -> 196;
                    case 23 -> 7;
                    case 24 -> 53;
                    case 25 -> 51;
                    case 26 -> 78;
                    case 27 -> 128;
                    case 28 -> 250;
                    case 29 -> 204;
                    case 30 -> 10;
                    case 31 -> 245;
                    case 32 -> 162;
                    case 33 -> 41;
                    case 34 -> 218;
                    case 35 -> 66;
                    case 36 -> 49;
                    case 37 -> 231;
                    case 38 -> 176;
                    case 39 -> 117;
                    case 40 -> 19;
                    case 41 -> 42;
                    case 42 -> 158;
                    case 43 -> 127;
                    case 44 -> 247;
                    case 45 -> 44;
                    case 46 -> 141;
                    case 47 -> 46;
                    case 48 -> 45;
                    case 49 -> 232;
                    case 50 -> 182;
                    case 51 -> 71;
                    case 52 -> 125;
                    case 53 -> 220;
                    case 54 -> 152;
                    case 55 -> 234;
                    case 56 -> 14;
                    case 57 -> 191;
                    case 58 -> 197;
                    case 59 -> 230;
                    case 60 -> 29;
                    case 61 -> 104;
                    case 62 -> 201;
                    case 63 -> 138;
                    case 64 -> 133;
                    case 65 -> 192;
                    case 66 -> 80;
                    case 67 -> 131;
                    case 68 -> 83;
                    case 69 -> 114;
                    case 70 -> 69;
                    case 71 -> 109;
                    case 72 -> 155;
                    case 73 -> 167;
                    case 74 -> 248;
                    case 75 -> 105;
                    case 76 -> 189;
                    case 77 -> 170;
                    case 78 -> 91;
                    case 79 -> 225;
                    case 80 -> 84;
                    case 81 -> 36;
                    case 82 -> 112;
                    case 83 -> 99;
                    case 84 -> 8;
                    case 85 -> 242;
                    case 86 -> 254;
                    case 87 -> 16;
                    case 88 -> 50;
                    case 89 -> 68;
                    case 90 -> 107;
                    case 91 -> 95;
                    case 92 -> 40;
                    case 93 -> 161;
                    case 94 -> 147;
                    case 95 -> 23;
                    case 96 -> 18;
                    case 97 -> 63;
                    case 98 -> 236;
                    case 99 -> 168;
                    case 100 -> 207;
                    case 101 -> 86;
                    case 102 -> 82;
                    case 103 -> 217;
                    case 104 -> 195;
                    case 105 -> 21;
                    case 106 -> 181;
                    case 107 -> 238;
                    case 108 -> 136;
                    case 109 -> 135;
                    case 110 -> 134;
                    case 111 -> 246;
                    case 112 -> 164;
                    case 113 -> 185;
                    case 114 -> 243;
                    case 115 -> 17;
                    case 116 -> 11;
                    case 117 -> 216;
                    case 118 -> 13;
                    case 119 -> 64;
                    case 120 -> 190;
                    case 121 -> 208;
                    case 122 -> 229;
                    case 123 -> 203;
                    case 124 -> 253;
                    case 125 -> 73;
                    case 126 -> 15;
                    case 127 -> 129;
                    case 128 -> 221;
                    case 129 -> 233;
                    case 130 -> 89;
                    case 131 -> 174;
                    case 132 -> 108;
                    case 133 -> 126;
                    case 134 -> 101;
                    case 135 -> 199;
                    case 136 -> 62;
                    case 137 -> 96;
                    case 138 -> 85;
                    case 139 -> 200;
                    case 140 -> 77;
                    case 141 -> 33;
                    case 142 -> 27;
                    case 143 -> 240;
                    case 144 -> 110;
                    case 145 -> 130;
                    case 146 -> 139;
                    case 147 -> 65;
                    case 148 -> 156;
                    case 149 -> 150;
                    case 150 -> 209;
                    case 151 -> 76;
                    case 152 -> 241;
                    case 153 -> 30;
                    case 154 -> 223;
                    case 155 -> 177;
                    case 156 -> 186;
                    case 157 -> 163;
                    case 158 -> 157;
                    case 159 -> 2;
                    case 160 -> 175;
                    case 161 -> 132;
                    case 162 -> 88;
                    case 163 -> 32;
                    case 164 -> 235;
                    case 165 -> 121;
                    case 166 -> 188;
                    case 167 -> 178;
                    case 168 -> 90;
                    case 169 -> 60;
                    case 170 -> 55;
                    case 171 -> 239;
                    case 172 -> 184;
                    case 173 -> 4;
                    case 174 -> 212;
                    case 175 -> 214;
                    case 176 -> 61;
                    case 177 -> 5;
                    case 178 -> 169;
                    case 179 -> 93;
                    case 180 -> 12;
                    case 181 -> 194;
                    case 182 -> 183;
                    case 183 -> 81;
                    case 184 -> 118;
                    case 185 -> 151;
                    case 186 -> 98;
                    case 187 -> 115;
                    case 188 -> 56;
                    case 189 -> 120;
                    case 190 -> 37;
                    case 191 -> 58;
                    case 192 -> 160;
                    case 193 -> 28;
                    case 194 -> 103;
                    case 195 -> 0;
                    case 196 -> 43;
                    case 197 -> 124;
                    case 198 -> 165;
                    case 199 -> 79;
                    case 200 -> 205;
                    case 201 -> 149;
                    case 202 -> 143;
                    case 203 -> 20;
                    case 204 -> 74;
                    case 205 -> 54;
                    case 206 -> 34;
                    case 207 -> 228;
                    case 208 -> 25;
                    case 209 -> 22;
                    case 210 -> 180;
                    case 211 -> 252;
                    case 212 -> 210;
                    case 213 -> 70;
                    case 214 -> 52;
                    case 215 -> 106;
                    case 216 -> 39;
                    case 217 -> 100;
                    case 218 -> 94;
                    case 219 -> 48;
                    case 220 -> 148;
                    case 221 -> 249;
                    case 222 -> 171;
                    case 223 -> 140;
                    case 224 -> 97;
                    case 225 -> 187;
                    case 226 -> 179;
                    case 227 -> 3;
                    case 228 -> 213;
                    case 229 -> 47;
                    case 230 -> 255;
                    case 231 -> 244;
                    case 232 -> 24;
                    case 233 -> 57;
                    case 234 -> 198;
                    case 235 -> 26;
                    case 236 -> 237;
                    case 237 -> 211;
                    case 238 -> 227;
                    case 239 -> 193;
                    case 240 -> 219;
                    case 241 -> 87;
                    case 242 -> 38;
                    case 243 -> 6;
                    case 244 -> 173;
                    case 245 -> 72;
                    case 246 -> 153;
                    case 247 -> 92;
                    case 248 -> 142;
                    case 249 -> 31;
                    case 250 -> 113;
                    case 251 -> 1;
                    case 252 -> 35;
                    case 253 -> 75;
                    case 254 -> 146;
                    default -> 226;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 24813399377476L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(1373351460 - 21944, -1373351460 - -((char)-23294), (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 73068710148657L;
                    String string = SshAgentIpcService.Y();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-1568383620 + -((char)-1692), 1568514690 - (char)-9318, (int)l2));
                    String string2 = string;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (string2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 64985370767128L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00c6\r\u00e10\u00e0\u0003\n\u001d.";
                var4_3 = "\u00c6\r\u00e10\u00e0\u0003\n\u001d.".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 63;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 109;
                                break;
                            }
                            case 1: {
                                v11 = 30;
                                break;
                            }
                            case 2: {
                                v11 = 100;
                                break;
                            }
                            case 3: {
                                v11 = 111;
                                break;
                            }
                            case 4: {
                                v11 = 53;
                                break;
                            }
                            case 5: {
                                v11 = 57;
                                break;
                            }
                            default: {
                                v11 = 95;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x5E28) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 220;
                    case 1 -> 239;
                    case 2 -> 101;
                    case 3 -> 55;
                    case 4 -> 250;
                    case 5 -> 177;
                    case 6 -> 86;
                    case 7 -> 197;
                    case 8 -> 68;
                    case 9 -> 225;
                    case 10 -> 87;
                    case 11 -> 143;
                    case 12 -> 206;
                    case 13 -> 13;
                    case 14 -> 9;
                    case 15 -> 115;
                    case 16 -> 126;
                    case 17 -> 217;
                    case 18 -> 1;
                    case 19 -> 36;
                    case 20 -> 100;
                    case 21 -> 79;
                    case 22 -> 159;
                    case 23 -> 43;
                    case 24 -> 120;
                    case 25 -> 89;
                    case 26 -> 21;
                    case 27 -> 186;
                    case 28 -> 70;
                    case 29 -> 255;
                    case 30 -> 209;
                    case 31 -> 49;
                    case 32 -> 3;
                    case 33 -> 62;
                    case 34 -> 213;
                    case 35 -> 51;
                    case 36 -> 128;
                    case 37 -> 24;
                    case 38 -> 119;
                    case 39 -> 125;
                    case 40 -> 139;
                    case 41 -> 99;
                    case 42 -> 221;
                    case 43 -> 97;
                    case 44 -> 237;
                    case 45 -> 134;
                    case 46 -> 88;
                    case 47 -> 180;
                    case 48 -> 166;
                    case 49 -> 105;
                    case 50 -> 200;
                    case 51 -> 5;
                    case 52 -> 42;
                    case 53 -> 149;
                    case 54 -> 254;
                    case 55 -> 227;
                    case 56 -> 95;
                    case 57 -> 111;
                    case 58 -> 161;
                    case 59 -> 181;
                    case 60 -> 238;
                    case 61 -> 240;
                    case 62 -> 83;
                    case 63 -> 226;
                    case 64 -> 85;
                    case 65 -> 187;
                    case 66 -> 160;
                    case 67 -> 248;
                    case 68 -> 196;
                    case 69 -> 207;
                    case 70 -> 37;
                    case 71 -> 184;
                    case 72 -> 80;
                    case 73 -> 241;
                    case 74 -> 56;
                    case 75 -> 34;
                    case 76 -> 32;
                    case 77 -> 223;
                    case 78 -> 78;
                    case 79 -> 54;
                    case 80 -> 7;
                    case 81 -> 133;
                    case 82 -> 12;
                    case 83 -> 202;
                    case 84 -> 249;
                    case 85 -> 247;
                    case 86 -> 29;
                    case 87 -> 106;
                    case 88 -> 174;
                    case 89 -> 60;
                    case 90 -> 150;
                    case 91 -> 20;
                    case 92 -> 162;
                    case 93 -> 44;
                    case 94 -> 158;
                    case 95 -> 211;
                    case 96 -> 163;
                    case 97 -> 195;
                    case 98 -> 90;
                    case 99 -> 25;
                    case 100 -> 64;
                    case 101 -> 116;
                    case 102 -> 0;
                    case 103 -> 81;
                    case 104 -> 117;
                    case 105 -> 229;
                    case 106 -> 122;
                    case 107 -> 41;
                    case 108 -> 155;
                    case 109 -> 118;
                    case 110 -> 131;
                    case 111 -> 35;
                    case 112 -> 47;
                    case 113 -> 38;
                    case 114 -> 242;
                    case 115 -> 170;
                    case 116 -> 224;
                    case 117 -> 109;
                    case 118 -> 28;
                    case 119 -> 71;
                    case 120 -> 135;
                    case 121 -> 127;
                    case 122 -> 14;
                    case 123 -> 52;
                    case 124 -> 50;
                    case 125 -> 8;
                    case 126 -> 183;
                    case 127 -> 205;
                    case 128 -> 172;
                    case 129 -> 168;
                    case 130 -> 185;
                    case 131 -> 4;
                    case 132 -> 246;
                    case 133 -> 145;
                    case 134 -> 84;
                    case 135 -> 146;
                    case 136 -> 233;
                    case 137 -> 65;
                    case 138 -> 212;
                    case 139 -> 198;
                    case 140 -> 69;
                    case 141 -> 76;
                    case 142 -> 201;
                    case 143 -> 193;
                    case 144 -> 102;
                    case 145 -> 194;
                    case 146 -> 74;
                    case 147 -> 179;
                    case 148 -> 165;
                    case 149 -> 19;
                    case 150 -> 93;
                    case 151 -> 39;
                    case 152 -> 203;
                    case 153 -> 6;
                    case 154 -> 98;
                    case 155 -> 208;
                    case 156 -> 75;
                    case 157 -> 192;
                    case 158 -> 167;
                    case 159 -> 156;
                    case 160 -> 230;
                    case 161 -> 112;
                    case 162 -> 33;
                    case 163 -> 190;
                    case 164 -> 152;
                    case 165 -> 45;
                    case 166 -> 147;
                    case 167 -> 58;
                    case 168 -> 222;
                    case 169 -> 244;
                    case 170 -> 121;
                    case 171 -> 40;
                    case 172 -> 104;
                    case 173 -> 182;
                    case 174 -> 26;
                    case 175 -> 157;
                    case 176 -> 10;
                    case 177 -> 154;
                    case 178 -> 30;
                    case 179 -> 110;
                    case 180 -> 46;
                    case 181 -> 11;
                    case 182 -> 216;
                    case 183 -> 148;
                    case 184 -> 243;
                    case 185 -> 169;
                    case 186 -> 94;
                    case 187 -> 210;
                    case 188 -> 73;
                    case 189 -> 137;
                    case 190 -> 114;
                    case 191 -> 48;
                    case 192 -> 236;
                    case 193 -> 66;
                    case 194 -> 232;
                    case 195 -> 91;
                    case 196 -> 17;
                    case 197 -> 215;
                    case 198 -> 204;
                    case 199 -> 123;
                    case 200 -> 189;
                    case 201 -> 72;
                    case 202 -> 175;
                    case 203 -> 188;
                    case 204 -> 130;
                    case 205 -> 178;
                    case 206 -> 132;
                    case 207 -> 235;
                    case 208 -> 140;
                    case 209 -> 15;
                    case 210 -> 219;
                    case 211 -> 138;
                    case 212 -> 136;
                    case 213 -> 234;
                    case 214 -> 96;
                    case 215 -> 245;
                    case 216 -> 176;
                    case 217 -> 173;
                    case 218 -> 31;
                    case 219 -> 228;
                    case 220 -> 108;
                    case 221 -> 124;
                    case 222 -> 23;
                    case 223 -> 92;
                    case 224 -> 18;
                    case 225 -> 61;
                    case 226 -> 53;
                    case 227 -> 214;
                    case 228 -> 191;
                    case 229 -> 144;
                    case 230 -> 151;
                    case 231 -> 171;
                    case 232 -> 164;
                    case 233 -> 142;
                    case 234 -> 59;
                    case 235 -> 113;
                    case 236 -> 16;
                    case 237 -> 57;
                    case 238 -> 63;
                    case 239 -> 27;
                    case 240 -> 199;
                    case 241 -> 253;
                    case 242 -> 103;
                    case 243 -> 107;
                    case 244 -> 252;
                    case 245 -> 153;
                    case 246 -> 218;
                    case 247 -> 82;
                    case 248 -> 231;
                    case 249 -> 22;
                    case 250 -> 251;
                    case 251 -> 141;
                    case 252 -> 67;
                    case 253 -> 77;
                    case 254 -> 2;
                    default -> 129;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

