/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.target.ssh.target.wizard;

import com.intellij.execution.Platform;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.ExecBuilder;
import com.intellij.ssh.process.SshExecProcess;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0005\u0018\u0000 !2\u00020\u0001:\u0002 !B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0002J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000e2\u0006\u0010\u001a\u001a\u00020\tH\u0016J\u001e\u0010\u001b\u001a\u00020\u000b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u001d2\u0006\u0010\u001e\u001a\u00020\u0010H\u0002J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\""}, d2={"Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/SshTargetIntrospectable;", "Lcom/intellij/execution/target/LanguageRuntimeType$Introspectable;", "connectionBuilder", "Lcom/intellij/ssh/ConnectionBuilder;", "textProvider", "Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/SshTargetIntrospectable$TextProvider;", "<init>", "(Lcom/intellij/ssh/ConnectionBuilder;Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/SshTargetIntrospectable$TextProvider;)V", "pwd", "", "pwdProcessOutput", "Lcom/intellij/execution/process/ProcessOutput;", "shell", "getPwd", "Ljava/util/concurrent/CompletableFuture;", "isUnixPlatform", "", "wrapCommandAsLoginShell", "script", "ensureShellInitialized", "", "targetPlatform", "Lcom/intellij/execution/target/TargetPlatform;", "getTargetPlatform", "()Ljava/util/concurrent/CompletableFuture;", "promiseEnvironmentVariable", "varName", "executeCommand", "command", "", "wrapCommand", "promiseExecuteScript", "TextProvider", "Companion", "intellij.remoteRun"})
@SourceDebugExtension(value={"SMAP\nSshTargetIntrospectable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshTargetIntrospectable.kt\ncom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/SshTargetIntrospectable\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,119:1\n14#2:120\n*S KotlinDebug\n*F\n+ 1 SshTargetIntrospectable.kt\ncom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/SshTargetIntrospectable\n*L\n117#1:120\n*E\n"})
public final class SshTargetIntrospectable
extends LanguageRuntimeType.Introspectable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConnectionBuilder connectionBuilder;
    @Nullable
    private final TextProvider textProvider;
    private String pwd;
    private ProcessOutput pwdProcessOutput;
    private String shell;
    @NotNull
    private final CompletableFuture<TargetPlatform> targetPlatform;
    @NotNull
    private static final Logger LOG;

    public SshTargetIntrospectable(@NotNull ConnectionBuilder connectionBuilder, @Nullable TextProvider textProvider2) {
        Intrinsics.checkNotNullParameter((Object)connectionBuilder, (String)"connectionBuilder");
        this.connectionBuilder = connectionBuilder;
        this.textProvider = textProvider2;
        CompletionStage completionStage = this.isUnixPlatform().thenApply(arg_0 -> SshTargetIntrospectable.targetPlatform$lambda$3(SshTargetIntrospectable::targetPlatform$lambda$2, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        this.targetPlatform = completionStage;
    }

    public /* synthetic */ SshTargetIntrospectable(ConnectionBuilder connectionBuilder, TextProvider textProvider2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            textProvider2 = null;
        }
        this(connectionBuilder, textProvider2);
    }

    private final CompletableFuture<ProcessOutput> getPwd() {
        if (this.pwd != null) {
            ProcessOutput processOutput = this.pwdProcessOutput;
            if (processOutput == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pwdProcessOutput");
                processOutput = null;
            }
            CompletableFuture<ProcessOutput> completableFuture = CompletableFuture.completedFuture(processOutput);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        try {
            this.pwdProcessOutput = this.executeCommand(CollectionsKt.listOf((Object)"pwd"), false);
            ProcessOutput processOutput = this.pwdProcessOutput;
            if (processOutput == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pwdProcessOutput");
                processOutput = null;
            }
            CompletableFuture<ProcessOutput> completableFuture = CompletableFuture.completedFuture(processOutput);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        catch (Throwable t) {
            CompletableFuture<ProcessOutput> completableFuture = CompletableFuture.failedFuture(t);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"failedFuture(...)");
            return completableFuture;
        }
    }

    private final CompletableFuture<Boolean> isUnixPlatform() {
        CompletionStage completionStage = this.getPwd().thenApply(arg_0 -> SshTargetIntrospectable.isUnixPlatform$lambda$1(SshTargetIntrospectable::isUnixPlatform$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    private final String wrapCommandAsLoginShell(String script) {
        this.ensureShellInitialized();
        String string = this.shell;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
            string = null;
        }
        return string + " -l -c '" + script + "'";
    }

    private final void ensureShellInitialized() {
        if (this.shell == null) {
            Object[] objectArray = new String[]{"echo", "${SHELL}"};
            String string = StringUtil.trim((String)this.executeCommand(CollectionsKt.listOf((Object[])objectArray), false).getStdout(), (CharFilter)CharFilter.NOT_WHITESPACE_FILTER);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trim(...)");
            this.shell = string;
        }
    }

    @NotNull
    public CompletableFuture<TargetPlatform> getTargetPlatform() {
        return this.targetPlatform;
    }

    @NotNull
    public CompletableFuture<String> promiseEnvironmentVariable(@NotNull String varName) {
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        CompletionStage completionStage = this.isUnixPlatform().thenApply(arg_0 -> SshTargetIntrospectable.promiseEnvironmentVariable$lambda$5(arg_0 -> SshTargetIntrospectable.promiseEnvironmentVariable$lambda$4(this, varName, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    private final ProcessOutput executeCommand(List<String> command, boolean wrapCommand) {
        String string = ParametersListUtil.join(command);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
        String cmd = string;
        String cmdToExecute = wrapCommand ? this.wrapCommandAsLoginShell(cmd) : cmd;
        TextProvider textProvider2 = this.textProvider;
        if (textProvider2 != null) {
            textProvider2.printlnSystemText("> " + cmd);
        }
        try {
            SshExecProcess sshExecProcess = ExecBuilder.execute$default((ExecBuilder)this.connectionBuilder.execBuilder(cmdToExecute), (int)0, (boolean)true, (int)1, null);
            long timeoutMs = 10000L;
            boolean exited = sshExecProcess.waitFor(timeoutMs, TimeUnit.MILLISECONDS);
            sshExecProcess.destroyForcibly();
            InputStream inputStream = sshExecProcess.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            InputStream inputStream2 = inputStream;
            Object object = Charsets.UTF_8;
            Object object2 = new InputStreamReader(inputStream2, (Charset)object);
            int n = 8192;
            String string2 = StringUtil.trimEnd((String)TextStreamsKt.readText((Reader)(object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n))), (char)'\n');
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"trimEnd(...)");
            String stdout = string2;
            InputStream inputStream3 = sshExecProcess.getErrorStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream3, (String)"getErrorStream(...)");
            object = inputStream3;
            object2 = Charsets.UTF_8;
            Object[] objectArray = (Object[])new InputStreamReader((InputStream)object, (Charset)object2);
            int n2 = 8192;
            String string3 = StringUtil.trimEnd((String)TextStreamsKt.readText((Reader)(objectArray instanceof BufferedReader ? (BufferedReader)objectArray : new BufferedReader((Reader)objectArray, n2))), (char)'\n');
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"trimEnd(...)");
            String stderr = string3;
            if (((CharSequence)stdout).length() > 0) {
                TextProvider textProvider3 = this.textProvider;
                if (textProvider3 != null) {
                    textProvider3.printlnText(stdout);
                }
            }
            if (((CharSequence)stderr).length() > 0) {
                TextProvider textProvider4 = this.textProvider;
                if (textProvider4 != null) {
                    textProvider4.printlnError(stderr);
                }
            }
            LOG.debug("Command output: " + stdout);
            int exitValue = sshExecProcess.exitValue();
            TextProvider textProvider5 = this.textProvider;
            if (textProvider5 != null) {
                objectArray = new Object[]{exitValue};
                String string4 = RemoteSdkBundle.message("sst.target.introspectable.message.command.finished.with.exit.code.0", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                textProvider5.printlnSystemText(string4);
            }
            if (!exited) {
                TextProvider textProvider6 = this.textProvider;
                if (textProvider6 != null) {
                    String string5 = RemoteSdkBundle.message("sst.target.introspectable.message.execution.was.killed.due.to.timeout", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
                    textProvider6.printlnError(string5);
                }
                LOG.warn("Execution for '" + cmdToExecute + "' was killed due to timeout of " + timeoutMs + " ms");
                return new ProcessOutput(stdout, stderr, exitValue, true, false);
            }
            LOG.info("Execution for '" + cmdToExecute + "' exited normally with code " + sshExecProcess.exitValue());
            return new ProcessOutput(stdout, stderr, exitValue, false, false);
        }
        catch (Exception e) {
            block10: {
                LOG.warn("Failed to execute '" + cmdToExecute + "'", (Throwable)e);
                TextProvider textProvider7 = this.textProvider;
                if (textProvider7 == null) break block10;
                String string6 = RemoteSdkBundle.message("sst.target.introspectable.message.failed.to.execute.command", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
                textProvider7.printlnError(string6);
            }
            throw e;
        }
    }

    @NotNull
    public CompletableFuture<ProcessOutput> promiseExecuteScript(@NotNull List<String> script) {
        Intrinsics.checkNotNullParameter(script, (String)"script");
        if (Intrinsics.areEqual((Object)CollectionsKt.listOf((Object)"pwd"), script)) {
            CompletionStage completionStage = this.getPwd().thenApply(arg_0 -> SshTargetIntrospectable.promiseExecuteScript$lambda$7(SshTargetIntrospectable::promiseExecuteScript$lambda$6, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
            return completionStage;
        }
        CompletionStage completionStage = this.isUnixPlatform().thenApply(arg_0 -> SshTargetIntrospectable.promiseExecuteScript$lambda$9(arg_0 -> SshTargetIntrospectable.promiseExecuteScript$lambda$8(this, script, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    private static final Boolean isUnixPlatform$lambda$0(ProcessOutput it) {
        String string = it.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        return StringsKt.startsWith$default((CharSequence)string, (char)'/', (boolean)false, (int)2, null);
    }

    private static final Boolean isUnixPlatform$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final TargetPlatform targetPlatform$lambda$2(Boolean it) {
        return new TargetPlatform(it != false ? Platform.UNIX : Platform.WINDOWS);
    }

    private static final TargetPlatform targetPlatform$lambda$3(Function1 $tmp0, Object p0) {
        return (TargetPlatform)$tmp0.invoke(p0);
    }

    private static final String promiseEnvironmentVariable$lambda$4(SshTargetIntrospectable this$0, String $varName, boolean isUnix) {
        Object[] objectArray = new String[]{"echo", "${" + $varName + "}"};
        return this$0.executeCommand(CollectionsKt.listOf((Object[])objectArray), isUnix).getStdout();
    }

    private static final String promiseEnvironmentVariable$lambda$5(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final ProcessOutput promiseExecuteScript$lambda$6(ProcessOutput it) {
        return it;
    }

    private static final ProcessOutput promiseExecuteScript$lambda$7(Function1 $tmp0, Object p0) {
        return (ProcessOutput)$tmp0.invoke(p0);
    }

    private static final ProcessOutput promiseExecuteScript$lambda$8(SshTargetIntrospectable this$0, List $script, Boolean isUnix) {
        Intrinsics.checkNotNull((Object)isUnix);
        return this$0.executeCommand($script, isUnix);
    }

    private static final ProcessOutput promiseExecuteScript$lambda$9(Function1 $tmp0, Object p0) {
        return (ProcessOutput)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SshTargetIntrospectable.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/SshTargetIntrospectable$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.remoteRun"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u0005H&J\u0012\u0010\u0006\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u0005H&J\u0012\u0010\u0007\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/SshTargetIntrospectable$TextProvider;", "", "printlnText", "", "text", "", "printlnSystemText", "printlnError", "intellij.remoteRun"})
    public static interface TextProvider {
        public void printlnText(@Nls @NotNull String var1);

        public void printlnSystemText(@Nls @NotNull String var1);

        public void printlnError(@Nls @NotNull String var1);
    }
}

