/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.datum;

import java.io.Serializable;
import org.locationtech.proj4j.ProjCoordinate;

public final class AxisOrder
implements Serializable {
    public static final AxisOrder ENU = new AxisOrder(Axis.Easting, Axis.Northing, Axis.Up);
    private final Axis x;
    private final Axis y;
    private final Axis z;

    private AxisOrder(Axis x, Axis y, Axis z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static AxisOrder fromString(String spec) {
        if (spec.length() != 3) {
            throw new Error();
        }
        Axis x = Axis.fromChar(spec.charAt(0));
        Axis y = Axis.fromChar(spec.charAt(1));
        Axis z = Axis.fromChar(spec.charAt(2));
        return new AxisOrder(x, y, z);
    }

    public void fromENU(ProjCoordinate coord) {
        double x = this.x.fromENU(coord);
        double y = this.y.fromENU(coord);
        double z = this.z.fromENU(coord);
        coord.x = x;
        coord.y = y;
        coord.z = z;
    }

    public void toENU(ProjCoordinate coord) {
        double x = coord.x;
        double y = coord.y;
        double z = coord.z;
        this.x.toENU(x, coord);
        this.y.toENU(y, coord);
        this.z.toENU(z, coord);
    }

    public int hashCode() {
        return this.x.hashCode() | 17 * this.y.hashCode() | 37 * this.z.hashCode();
    }

    public boolean equals(Object that) {
        if (that instanceof AxisOrder) {
            AxisOrder a = (AxisOrder)that;
            return this.x == a.x && this.y == a.y && this.z == a.z;
        }
        return false;
    }

    public static enum Axis {
        Easting{

            @Override
            public double fromENU(ProjCoordinate c2) {
                return c2.x;
            }

            @Override
            public void toENU(double x, ProjCoordinate c2) {
                c2.x = x;
            }
        }
        ,
        Westing{

            @Override
            public double fromENU(ProjCoordinate c2) {
                return -c2.x;
            }

            @Override
            public void toENU(double x, ProjCoordinate c2) {
                c2.x = -x;
            }
        }
        ,
        Northing{

            @Override
            public double fromENU(ProjCoordinate c2) {
                return c2.y;
            }

            @Override
            public void toENU(double y, ProjCoordinate c2) {
                c2.y = y;
            }
        }
        ,
        Southing{

            @Override
            public double fromENU(ProjCoordinate c2) {
                return -c2.y;
            }

            @Override
            public void toENU(double y, ProjCoordinate c2) {
                c2.y = -y;
            }
        }
        ,
        Up{

            @Override
            public double fromENU(ProjCoordinate c2) {
                return c2.z;
            }

            @Override
            public void toENU(double z, ProjCoordinate c2) {
                c2.z = z;
            }
        }
        ,
        Down{

            @Override
            public double fromENU(ProjCoordinate c2) {
                return c2.z;
            }

            @Override
            public void toENU(double z, ProjCoordinate c2) {
                c2.z = -z;
            }
        };


        static Axis fromChar(char c2) {
            switch (c2) {
                case 'e': {
                    return Easting;
                }
                case 'n': {
                    return Northing;
                }
                case 'u': {
                    return Up;
                }
                case 'w': {
                    return Westing;
                }
                case 's': {
                    return Southing;
                }
                case 'd': {
                    return Down;
                }
            }
            throw new IllegalArgumentException();
        }

        public abstract double fromENU(ProjCoordinate var1);

        public abstract void toENU(double var1, ProjCoordinate var3);
    }
}

