/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph.index;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Quadrant;
import org.locationtech.jts.util.IntArrayList;

public class MonotoneChainIndexer {
    public static int[] toIntArray(List list) {
        int[] array = new int[list.size()];
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = (Integer)list.get(i2);
        }
        return array;
    }

    public int[] getChainStartIndices(Coordinate[] pts) {
        int last;
        int start2 = 0;
        IntArrayList startIndexList = new IntArrayList(pts.length / 2);
        startIndexList.add(start2);
        do {
            last = this.findChainEnd(pts, start2);
            startIndexList.add(last);
        } while ((start2 = last) < pts.length - 1);
        return startIndexList.toArray();
    }

    public int[] OLDgetChainStartIndices(Coordinate[] pts) {
        int last;
        int start2 = 0;
        ArrayList<Integer> startIndexList = new ArrayList<Integer>();
        startIndexList.add(start2);
        do {
            last = this.findChainEnd(pts, start2);
            startIndexList.add(last);
        } while ((start2 = last) < pts.length - 1);
        int[] startIndex = MonotoneChainIndexer.toIntArray(startIndexList);
        return startIndex;
    }

    private int findChainEnd(Coordinate[] pts, int start2) {
        int quad;
        int last;
        int chainQuad = Quadrant.quadrant(pts[start2], pts[start2 + 1]);
        for (last = start2 + 1; last < pts.length && (quad = Quadrant.quadrant(pts[last - 1], pts[last])) == chainQuad; ++last) {
        }
        return last - 1;
    }
}

