/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.lang.ASTNode;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.FlowPatternKt;
import com.intellij.sql.formatter.model.NodeMatcher;
import com.intellij.sql.formatter.model.NodeMatcherKt;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u00a2\u0006\u0004\b\b\u0010\tJ(\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/formatter/model/NodeWithLineCommentPattern;", "Lcom/intellij/sql/formatter/model/FlowPattern;", "matcher", "Lcom/intellij/sql/formatter/model/NodeMatcher;", "producer", "Lkotlin/Function0;", "Lcom/intellij/sql/formatter/model/SqlBlock;", "Lcom/intellij/sql/formatter/model/SqlBlockProducer;", "<init>", "(Lcom/intellij/sql/formatter/model/NodeMatcher;Lkotlin/jvm/functions/Function0;)V", "process", "Lkotlin/ranges/IntRange;", "context", "Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "nodes", "", "Lcom/intellij/lang/ASTNode;", "since", "", "intellij.database.sql.core.impl"})
public final class NodeWithLineCommentPattern
extends FlowPattern {
    @NotNull
    private final NodeMatcher matcher;

    public NodeWithLineCommentPattern(@NotNull NodeMatcher matcher, @NotNull Function0<? extends SqlBlock> producer) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        super(producer, null);
        this.matcher = matcher;
    }

    @Override
    @Nullable
    public IntRange process(@NotNull SqlFormattingContext context, @NotNull List<? extends ASTNode> nodes, int since) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        int n = nodes.size();
        if (since >= n) {
            return null;
        }
        ASTNode node = nodes.get(since);
        if (NodeMatcherKt.doesntMatch(node, this.matcher)) {
            return null;
        }
        int i2 = FlowPatternKt.access$skipSpaces(since + 1, nodes);
        if (i2 >= n) {
            return new IntRange(since, since);
        }
        ASTNode nextNode = nodes.get(i2);
        if (CollectionsKt.contains((Iterable)SqlFormattingFunKt.getLINE_COMMENT_TYPES(), (Object)nextNode.getElementType()) && context.onSameLine(node, nextNode)) {
            return new IntRange(since, i2);
        }
        return new IntRange(since, since);
    }
}

