/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.util.Casing;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.impl.SqlFileImpl;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlImportState {
    public final SqlImportState prevState;
    public final Shared shared;
    public final PsiElement element;
    public final boolean isEnclosing;
    public final TreePattern state;
    private static final TreePatternNode FAKE_NODE = new TreePatternNode(TreePatternNode.NegativeNaming.WILDCARD, TreePatternNode.NO_GROUPS);

    public SqlImportState(@Nullable PsiElement element, boolean isEnclosing, @NotNull Shared shared, @NotNull TreePattern state, @Nullable SqlImportState prevState) {
        if (shared == null) {
            SqlImportState.$$$reportNull$$$0(0);
        }
        if (state == null) {
            SqlImportState.$$$reportNull$$$0(1);
        }
        this.element = element;
        this.isEnclosing = isEnclosing;
        this.shared = shared;
        this.state = state;
        this.prevState = prevState;
    }

    public boolean isImported(@Nullable DasDataSource dataSource, @Nullable DasObject obj2) {
        return this.isImported(dataSource == null ? null : SqlImportUtil.getDataSourceName(dataSource), dataSource != null ? dataSource.getModel() : ((SqlFileImpl)this.shared.file).getCasingProvider(), obj2);
    }

    public boolean isImported(@Nullable ObjectName dsName, @NotNull CasingProvider casingProvider, @Nullable DasObject obj2) {
        if (casingProvider == null) {
            SqlImportState.$$$reportNull$$$0(2);
        }
        return this.shared.overlay != null && SqlImportState.isImported(this.shared.overlay, dsName, obj2, casingProvider) || SqlImportState.isImported(this.state, dsName, obj2, casingProvider);
    }

    public static boolean isImported(@NotNull TreePattern state, @Nullable ObjectName dsName, @Nullable DasObject obj2, @NotNull CasingProvider casingProvider) {
        if (state == null) {
            SqlImportState.$$$reportNull$$$0(3);
        }
        if (casingProvider == null) {
            SqlImportState.$$$reportNull$$$0(4);
        }
        if (dsName == null && obj2 == null) {
            return true;
        }
        HashSet<TreePatternNode> nodes = new HashSet<TreePatternNode>();
        state.root.matchedChildren(dsName, Casing.EXACT, SqlImportUtil.DATA_SOURCE, nodes);
        if (obj2 == null) {
            return !nodes.isEmpty();
        }
        if (dsName == null && nodes.isEmpty()) {
            nodes.add(FAKE_NODE);
        }
        return !SqlImportState.match(nodes, obj2, casingProvider).isEmpty();
    }

    private static Set<TreePatternNode> match(@NotNull Set<TreePatternNode> roots2, @NotNull DasObject obj2, @NotNull CasingProvider casingProvider) {
        DasObject parent;
        Set<TreePatternNode> parentNodes;
        if (roots2 == null) {
            SqlImportState.$$$reportNull$$$0(5);
        }
        if (obj2 == null) {
            SqlImportState.$$$reportNull$$$0(6);
        }
        if (casingProvider == null) {
            SqlImportState.$$$reportNull$$$0(7);
        }
        Set<TreePatternNode> set = parentNodes = (parent = obj2.getDasParent()) == null || parent.getKind() == ObjectKind.ROOT ? roots2 : SqlImportState.match(roots2, parent, casingProvider);
        if (parentNodes.isEmpty()) {
            return parentNodes;
        }
        HashSet<TreePatternNode> res = new HashSet<TreePatternNode>();
        ObjectKind kind = obj2.getKind();
        if (kind == ObjectKind.EXTERNAL_SCHEMA) {
            kind = ObjectKind.SCHEMA;
        }
        Casing casing = casingProvider.getCasing(kind, obj2);
        ObjectName name2 = TreePatternUtils.nameOf(obj2, true);
        for (TreePatternNode node : parentNodes) {
            node.matchedChildren(name2, casing, kind, res);
        }
        if (name2 == null && res.isEmpty()) {
            res.add(FAKE_NODE);
        }
        return res;
    }

    public static void getPartialTrace(@Nullable SqlDialectImplUtilCore.ObjectTracer<?> tracer, @NotNull List<ObjectKind> kinds, @NotNull List names, @Nullable List<DasObject> contexts) {
        if (kinds == null) {
            SqlImportState.$$$reportNull$$$0(8);
        }
        if (names == null) {
            SqlImportState.$$$reportNull$$$0(9);
        }
        if (tracer != null) {
            SqlDialectImplUtilCore.ObjectTracer.ObjectTraceIt<?> it = tracer.trace();
            while (it.hasNext()) {
                Object obj2 = it.next();
                ObjectKind kind = it.getKind();
                kinds.add(kind == ObjectKind.EXTERNAL_SCHEMA ? ObjectKind.SCHEMA : kind);
                names.add(new ObjectName(it.getName(), it.isQuoted()));
                if (contexts == null || !(obj2 instanceof DasObject)) continue;
                contexts.add((DasObject)obj2);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shared";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casingProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/dialects/SqlImportState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isImported";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "match";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getPartialTrace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Shared {
        public final SqlFile file;
        public final TreePattern overlay;

        public Shared(@NotNull SqlFile file, @Nullable TreePattern overlay) {
            if (file == null) {
                Shared.$$$reportNull$$$0(0);
            }
            this.file = file;
            this.overlay = overlay;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/dialects/SqlImportState$Shared", "<init>"));
        }
    }
}

